/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.javaxcache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaxCacheLevel2Cache
extends AbstractLevel2Cache {
    private final Cache cache;

    public JavaxCacheLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        try {
            Cache tmpcache = CacheManager.getInstance().getCache(this.cacheName);
            if (tmpcache == null) {
                HashMap<Integer, Long> props = new HashMap<Integer, Long>();
                if (this.timeout > 0L) {
                    props.put(1, this.timeout);
                }
                this.cache = CacheManager.getInstance().getCacheFactory().createCache(props);
                CacheManager.getInstance().registerCache(this.cacheName, this.cache);
            } else {
                this.cache = tmpcache;
            }
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", (Throwable)e);
        }
    }

    public void close() {
        if (this.clearAtClose) {
            this.evictAll();
        }
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public CachedPC get(Object oid) {
        return (CachedPC)this.cache.get(oid);
    }

    public Map<Object, CachedPC> getAll(Collection oids) {
        return this.cache.getAll(oids);
    }

    public int getSize() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public synchronized CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        this.cache.put(oid, (Object)pc);
        return pc;
    }

    public void putAll(Map<Object, CachedPC> objs) {
        if (objs == null) {
            return;
        }
        this.cache.putAll(objs);
    }

    public synchronized void evict(Object oid) {
        this.cache.remove(oid);
    }

    public synchronized void evictAll() {
        this.cache.evict();
    }

    public synchronized void evictAll(Class pcClass, boolean subclasses) {
        String[] subclassNames;
        if (!this.nucleusCtx.getApiAdapter().isPersistable(pcClass)) {
            return;
        }
        this.evictAllOfClass(pcClass.getName());
        if (subclasses && (subclassNames = this.nucleusCtx.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                this.evictAllOfClass(subclassNames[i]);
            }
        }
    }

    void evictAllOfClass(String className) {
        AbstractClassMetaData cmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(className, this.nucleusCtx.getClassLoaderResolver(null));
        Iterator keyIter = this.cache.keySet().iterator();
        while (keyIter.hasNext()) {
            OID oid;
            Object key = keyIter.next();
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                String targetClassName = this.nucleusCtx.getApiAdapter().getTargetClassNameForSingleFieldIdentity(key);
                if (!className.equals(targetClassName)) continue;
                keyIter.remove();
                continue;
            }
            if (cmd.getIdentityType() != IdentityType.DATASTORE || !(key instanceof OID) || !className.equals((oid = (OID)key).getPcClass())) continue;
            keyIter.remove();
        }
    }

    public synchronized void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public synchronized void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }
}

