/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.ehcache;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.OID;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class EhcacheClassBasedLevel2Cache
extends AbstractLevel2Cache {
    private static final Localiser LOCALISER_EHCACHE = Localiser.getInstance((String)"org.datanucleus.cache.ehcache.Localisation_ehcache", (ClassLoader)EhcacheClassBasedLevel2Cache.class.getClassLoader());
    private final CacheManager cacheManager;
    private final Cache defaultCache;
    private final HashMap caches = new HashMap();
    NucleusContext nucleusCtx = null;

    public EhcacheClassBasedLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        this.nucleusCtx = nucleusCtx;
        PersistenceConfiguration conf = nucleusCtx.getPersistenceConfiguration();
        String configFile = conf.getStringProperty("datanucleus.cache.level2.configurationFile");
        try {
            this.cacheManager = configFile == null ? CacheManager.create() : CacheManager.create((URL)CacheManager.class.getResource(configFile));
        }
        catch (CacheException e) {
            throw new NucleusException(LOCALISER_EHCACHE.msg("Cache.EHCache.CacheManagerInitialiseFails", (Object)e));
        }
        if (!this.cacheManager.cacheExists(this.cacheName)) {
            try {
                this.cacheManager.addCache(this.cacheName);
            }
            catch (IllegalStateException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException(LOCALISER_EHCACHE.msg("Cache.EHCache.CreateDefaultFails", (Object)e));
            }
            catch (ObjectExistsException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException(LOCALISER_EHCACHE.msg("Cache.EHCache.CreateDefaultFails", (Object)e));
            }
            catch (CacheException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException(LOCALISER_EHCACHE.msg("Cache.EHCache.CreateDefaultFails", (Object)e));
            }
        }
        this.defaultCache = this.cacheManager.getCache(this.cacheName);
    }

    public void close() {
        if (this.clearAtClose) {
            this.evictAll();
        }
        this.cacheManager.shutdown();
    }

    public boolean containsOid(Object oid) {
        try {
            return this.get(oid) != null;
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.containsOid : " + e.getMessage()));
            return false;
        }
    }

    public CachedPC get(Object oid) {
        try {
            Element element = this.getCacheForId(oid).get((Serializable)oid);
            if (element == null) {
                return null;
            }
            return this.toPC(element);
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.get : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.get : " + e.getMessage()));
        }
        return null;
    }

    private CachedPC toPC(Element object) {
        return (CachedPC)object.getValue();
    }

    private Element toElement(Object oid, CachedPC object) {
        return new Element((Serializable)oid, (Serializable)object);
    }

    public int getSize() {
        try {
            int size = this.defaultCache.getSize();
            Iterator i = this.caches.values().iterator();
            while (i.hasNext()) {
                size += ((Cache)i.next()).getSize();
            }
            return size;
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.getSize : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.getSIze : " + e.getMessage()));
        }
        return 0;
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        if (this.nucleusCtx.getApiAdapter().isManaged(pc.getPersistableObject())) {
            NucleusLogger.CACHE.error((Object)LOCALISER.msg("004012", oid));
            return null;
        }
        this.getCacheForId(oid).put(this.toElement(oid, pc));
        return pc;
    }

    public void evict(Object oid) {
        CachedPC pc = this.get(oid);
        if (pc != null) {
            this.getCacheForId(oid).remove((Serializable)oid);
        }
    }

    public void evictAll() {
        try {
            Iterator i = this.caches.values().iterator();
            while (i.hasNext()) {
                ((Cache)i.next()).removeAll();
            }
            this.defaultCache.removeAll();
        }
        catch (Exception e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.clear : " + e.getMessage()));
        }
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("evict(Class, boolean) method not yet supported by EHCache plugin");
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    private Cache getCacheForClass(String pcClassName) {
        Cache cache = (Cache)this.caches.get(pcClassName);
        if (cache == null) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug((Object)LOCALISER_EHCACHE.msg("Cache.EHCache.Initialising", (Object)pcClassName));
            }
            if (this.cacheManager.cacheExists(pcClassName)) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug((Object)LOCALISER_EHCACHE.msg("Cache.EHCache.Exists", (Object)pcClassName));
                }
                cache = this.cacheManager.getCache(pcClassName);
            } else {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug((Object)LOCALISER_EHCACHE.msg("Cache.EHCache.CacheDoesntExist"));
                }
                if (this.defaultCache == null) {
                    NucleusLogger.CACHE.error((Object)LOCALISER_EHCACHE.msg("Cache.EHCache.CacheDoestExistNoDefault", (Object)pcClassName));
                }
                cache = this.defaultCache;
            }
            this.caches.put(pcClassName, cache);
        }
        return cache;
    }

    private Cache getCacheForId(Object id) {
        if (this.nucleusCtx.getApiAdapter().isSingleFieldIdentity(id)) {
            String targetClassName = this.nucleusCtx.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id);
            return this.getCacheForClass(targetClassName);
        }
        if (id instanceof OID) {
            return this.getCacheForClass(((OID)id).getPcClass());
        }
        return this.defaultCache;
    }
}

