/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.memcache;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.NucleusException;

public class MemcacheLevel2Cache
implements Level2Cache {
    private MemcachedClient client;
    private String keyPrefix = "datanucleus:";
    private int expireSeconds = 0;

    public MemcacheLevel2Cache(NucleusContext nucleusCtx) {
        PersistenceConfiguration conf = nucleusCtx.getPersistenceConfiguration();
        String keyPrefix = conf.getStringProperty("datanucleus.cache.level2.memcache.keyprefix");
        String servers = conf.getStringProperty("datanucleus.cache.level2.memcache.servers");
        String expireStr = conf.getStringProperty("datanucleus.cache.level2.memcache.expireSeconds");
        if (keyPrefix != null) {
            this.keyPrefix = keyPrefix;
        }
        try {
            this.client = new MemcachedClient(AddrUtil.getAddresses((String)servers));
            if (expireStr != null && !"".equals(expireStr)) {
                this.expireSeconds = Integer.parseInt(expireStr);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NucleusException("Cant create cache", (Throwable)e);
        }
        catch (NumberFormatException ex) {
            throw new NucleusException("Cant create cache: Bad expireSeconds value:" + expireStr, (Throwable)ex);
        }
    }

    public void close() {
        this.client.flush();
        this.client.shutdown();
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public synchronized void evict(Object oid) {
        this.client.delete(this.keyPrefix + oid.toString());
    }

    public synchronized void evictAll() {
        this.client.flush();
    }

    public synchronized void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public synchronized void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public synchronized void evictAll(Class arg0, boolean arg1) {
        throw new UnsupportedOperationException("evictAll(Class,Boolean) method not supported by Memcache plugin");
    }

    public CachedPC get(Object oid) {
        return (CachedPC)this.client.get(this.keyPrefix + oid.toString());
    }

    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not supported by Memcache plugin");
    }

    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not supported by Memcache plugin");
    }

    public int getSize() {
        throw new UnsupportedOperationException("getSize() method not supported by Memcache plugin");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty() method not supported by Memcache plugin");
    }

    public void pin(Object arg0) {
        throw new UnsupportedOperationException("pin(Object) method not supported by Memcache plugin");
    }

    public void pinAll(Collection arg0) {
        throw new UnsupportedOperationException("pinAll(Collection) method not supported by Memcache plugin");
    }

    public void pinAll(Object[] arg0) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not supported by Memcache plugin");
    }

    public void pinAll(Class arg0, boolean arg1) {
        throw new UnsupportedOperationException("pinAll(Class,boolean) method not supported by Memcache plugin");
    }

    public synchronized CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        this.client.set(this.keyPrefix + oid.toString(), this.expireSeconds, (Object)pc);
        return pc;
    }

    public void unpin(Object arg0) {
        throw new UnsupportedOperationException("unpin(Object) method not supported by Memcache plugin");
    }

    public void unpinAll(Collection arg0) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not supported by Memcache plugin");
    }

    public void unpinAll(Object[] arg0) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not supported by Memcache plugin");
    }

    public void unpinAll(Class arg0, boolean arg1) {
        throw new UnsupportedOperationException("unpinAll(Class,boolean) method not supported by Memcache plugin");
    }
}

