/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.javaxcache;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.util.NucleusLogger;

public class JavaxCacheLevel2Cache
implements Level2Cache {
    private final Cache cache;
    private String cacheName;
    private int maxSize = -1;
    private final ApiAdapter apiAdapter;

    public JavaxCacheLevel2Cache(OMFContext omfCtx) {
        this.apiAdapter = omfCtx.getApiAdapter();
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        this.cacheName = conf.getStringProperty("datanucleus.cache.level2.cacheName");
        if (this.cacheName == null) {
            NucleusLogger.CACHE.warn((Object)"No 'datanucleus.cache.level2.cacheName' specified so using name of 'DataNucleus'");
            this.cacheName = "DataNucleus";
        }
        try {
            Cache tmpcache = CacheManager.getInstance().getCache(this.cacheName);
            if (tmpcache == null) {
                this.cache = CacheManager.getInstance().getCacheFactory().createCache(Collections.EMPTY_MAP);
                CacheManager.getInstance().registerCache(this.cacheName, this.cache);
            } else {
                this.cache = tmpcache;
            }
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", (Throwable)e);
        }
        this.maxSize = conf.getIntProperty("datanucleus.cache.level2.maxSize");
    }

    public void close() {
        this.clear();
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public CachedPC get(Object oid) {
        return (CachedPC)this.cache.get(oid);
    }

    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not yet supported by javax.cache plugin");
    }

    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not yet supported by javax.cache plugin");
    }

    public int getSize() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public synchronized CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        if (this.apiAdapter.getObjectManager(pc.getPersistableObject()) != null) {
            return null;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            new ObjectOutputStream(os).writeObject(pc);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.cache.put(oid, (Object)pc);
        return pc;
    }

    public synchronized void evict(Object oid) {
        this.cache.remove(oid);
    }

    public synchronized void evictAll() {
        this.cache.evict();
    }

    public synchronized void evictAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("evict(Class, boolean) method not yet supported by javax.cache plugin");
    }

    public synchronized void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public synchronized void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public void pin(Object oid) {
        throw new UnsupportedOperationException("pinAll(Object) method not yet supported by javax.cache plugin");
    }

    public void pinAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("pinAll(Class, boolean) method not yet supported by javax.cache plugin");
    }

    public void pinAll(Collection oids) {
        throw new UnsupportedOperationException("pinAll(Collection) method not yet supported by javax.cache plugin");
    }

    public void pinAll(Object[] oids) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not yet supported by javax.cache plugin");
    }

    public void unpin(Object oid) {
        throw new UnsupportedOperationException("unpin(Object) method not yet supported by javax.cache plugin");
    }

    public void unpinAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("unpinAll(Class, boolean) method not yet supported by javax.cache plugin");
    }

    public void unpinAll(Collection oids) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not yet supported by javax.cache plugin");
    }

    public void unpinAll(Object[] oids) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not yet supported by javax.cache plugin");
    }
}

