/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.memcache;

import java.io.IOException;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.cache.CachedQuery;
import org.datanucleus.store.query.cache.QueryCache;

public class MemcacheQueryCache
implements QueryCache {
    private MemcachedClient client;
    private String keyPrefix = "datanucleus-query:";
    private int expireSeconds = 0;

    public MemcacheQueryCache(OMFContext omfCtx) {
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        String keyPrefix = conf.getStringProperty("datanucleus.cache.query.memcache.keyprefix");
        String servers = conf.getStringProperty("datanucleus.cache.query.memcache.servers");
        String expireStr = conf.getStringProperty("datanucleus.cache.query.memcache.expireSeconds");
        if (keyPrefix != null) {
            this.keyPrefix = keyPrefix;
        }
        try {
            this.client = new MemcachedClient(AddrUtil.getAddresses((String)servers));
            if (expireStr != null && !"".equals(expireStr)) {
                this.expireSeconds = Integer.parseInt(expireStr);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NucleusException("Cant create cache", (Throwable)e);
        }
        catch (NumberFormatException ex) {
            throw new NucleusException("Cant create cache: Bad expireSeconds value:" + expireStr, (Throwable)ex);
        }
    }

    public void clear() {
        this.client.flush();
    }

    public void close() {
        this.client.shutdown();
    }

    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }

    public void evict(String queryKey) {
        this.client.delete(this.keyPrefix + queryKey);
    }

    public void evictAll() {
        throw new UnsupportedOperationException("evictAll() method not yet supported by Memcache plugin");
    }

    public CachedQuery get(String queryKey) {
        return (CachedQuery)this.client.get(this.keyPrefix + queryKey);
    }

    public int size() {
        throw new UnsupportedOperationException("size() method not supported by Memcache plugin");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty() method not supported by Memcache plugin");
    }

    public CachedQuery put(String queryKey, CachedQuery cachedQuery) {
        if (queryKey == null || cachedQuery == null) {
            return null;
        }
        this.client.set(this.keyPrefix + queryKey, this.expireSeconds, (Object)cachedQuery);
        return cachedQuery;
    }
}

