/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.ehcache;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.OID;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class EhcacheClassBasedLevel2Cache
implements Level2Cache {
    private static final Localiser LOCALISER_EHCACHE = Localiser.getInstance((String)"org.datanucleus.cache.ehcache.Localisation_ehcache", (ClassLoader)(class$org$datanucleus$cache$ehcache$EhcacheClassBasedLevel2Cache == null ? (class$org$datanucleus$cache$ehcache$EhcacheClassBasedLevel2Cache = EhcacheClassBasedLevel2Cache.class$("org.datanucleus.cache.ehcache.EhcacheClassBasedLevel2Cache")) : class$org$datanucleus$cache$ehcache$EhcacheClassBasedLevel2Cache).getClassLoader());
    private final CacheManager cacheManager;
    private final Cache defaultCache;
    private final HashMap caches = new HashMap();
    OMFContext omfCtx = null;
    static /* synthetic */ Class class$org$datanucleus$cache$ehcache$EhcacheClassBasedLevel2Cache;
    static /* synthetic */ Class class$net$sf$ehcache$CacheManager;

    public EhcacheClassBasedLevel2Cache(OMFContext omfCtx) {
        this.omfCtx = omfCtx;
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        String configFile = conf.getStringProperty("datanucleus.cache.level2.configurationFile");
        String cacheName = conf.getStringProperty("datanucleus.cache.level2.cacheName");
        if (cacheName == null) {
            NucleusLogger.CACHE.warn((Object)"No 'datanucleus.cache.level2.cacheName' specified so using name of 'DataNucleus'");
            cacheName = "DataNucleus";
        }
        try {
            this.cacheManager = configFile == null ? CacheManager.create() : CacheManager.create((URL)(class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = EhcacheClassBasedLevel2Cache.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager).getResource(configFile));
        }
        catch (CacheException e) {
            throw new NucleusException(LOCALISER_EHCACHE.msg("Cache.EHCache.CacheManagerInitialiseFails", (Object)e));
        }
        if (!this.cacheManager.cacheExists(cacheName)) {
            try {
                this.cacheManager.addCache(cacheName);
            }
            catch (IllegalStateException e) {
                throw new NucleusException(LOCALISER_EHCACHE.msg("Cache.EHCache.CreateDefaultFails", (Object)e));
            }
            catch (ObjectExistsException e) {
                throw new NucleusException(LOCALISER_EHCACHE.msg("Cache.EHCache.CreateDefaultFails", (Object)e));
            }
            catch (CacheException e) {
                throw new NucleusException(LOCALISER_EHCACHE.msg("Cache.EHCache.CreateDefaultFails", (Object)e));
            }
        }
        this.defaultCache = this.cacheManager.getCache(cacheName);
    }

    public void close() {
        this.clear();
        this.cacheManager.shutdown();
    }

    public void clear() {
        try {
            Iterator i = this.caches.values().iterator();
            while (i.hasNext()) {
                ((Cache)i.next()).removeAll();
            }
            this.defaultCache.removeAll();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean containsOid(Object oid) {
        try {
            return this.getCacheForId(oid).getKeys().contains(oid);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
        return false;
    }

    public CachedPC get(Object oid) {
        try {
            Element element = this.getCacheForId(oid).get((Serializable)oid);
            if (element == null) {
                return null;
            }
            return this.toPC(element);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
        return null;
    }

    private CachedPC toPC(Element object) {
        return (CachedPC)((CacheElement)object.getValue()).getValue();
    }

    private Element toElement(Object oid, CachedPC object) {
        return new Element((Serializable)oid, (Serializable)new CacheElement(object));
    }

    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not yet supported by EHCache plugin");
    }

    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not yet supported by EHCache plugin");
    }

    public int getSize() {
        try {
            int size = this.defaultCache.getSize();
            Iterator i = this.caches.values().iterator();
            while (i.hasNext()) {
                size += ((Cache)i.next()).getSize();
            }
            return size;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.omfCtx.getApiAdapter().getObjectManager(pc.getPersistableObject()) != null) {
            return null;
        }
        this.getCacheForId(oid).put(this.toElement(oid, pc));
        return pc;
    }

    public void evict(Object oid) {
        CachedPC pc = this.get(oid);
        if (pc != null) {
            this.getCacheForId(oid).remove((Serializable)this.toElement(oid, pc));
        }
    }

    public void evictAll() {
        this.clear();
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("evict(Class, boolean) method not yet supported by EHCache plugin");
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public void pin(Object oid) {
        throw new UnsupportedOperationException("pinAll(Object) method not yet supported by EHCache plugin");
    }

    public void pinAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("pinAll(Class, boolean) method not yet supported by EHCache plugin");
    }

    public void pinAll(Collection oids) {
        throw new UnsupportedOperationException("pinAll(Collection) method not yet supported by EHCache plugin");
    }

    public void pinAll(Object[] oids) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not yet supported by EHCache plugin");
    }

    public void unpin(Object oid) {
        throw new UnsupportedOperationException("unpin(Object) method not yet supported by EHCache plugin");
    }

    public void unpinAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("unpinAll(Class, boolean) method not yet supported by EHCache plugin");
    }

    public void unpinAll(Collection oids) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not yet supported by EHCache plugin");
    }

    public void unpinAll(Object[] oids) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not yet supported by EHCache plugin");
    }

    private Cache getCacheForClass(String pcClassName) {
        Cache cache = (Cache)this.caches.get(pcClassName);
        if (cache == null) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug((Object)LOCALISER_EHCACHE.msg("Cache.EHCache.Initialising", (Object)pcClassName));
            }
            if (this.cacheManager.cacheExists(pcClassName)) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug((Object)LOCALISER_EHCACHE.msg("Cache.EHCache.Exists", (Object)pcClassName));
                }
                cache = this.cacheManager.getCache(pcClassName);
            } else {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug((Object)LOCALISER_EHCACHE.msg("Cache.EHCache.CacheDoesntExist"));
                }
                if (this.defaultCache == null) {
                    NucleusLogger.CACHE.error((Object)LOCALISER_EHCACHE.msg("Cache.EHCache.CacheDoestExistNoDefault", (Object)pcClassName));
                }
                cache = this.defaultCache;
            }
            this.caches.put(pcClassName, cache);
        }
        return cache;
    }

    private Cache getCacheForId(Object id) {
        if (this.omfCtx.getApiAdapter().isSingleFieldIdentity(id)) {
            String targetClassName = this.omfCtx.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id);
            return this.getCacheForClass(targetClassName);
        }
        if (id instanceof OID) {
            return this.getCacheForClass(((OID)id).getPcClass());
        }
        return this.defaultCache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CacheElement
    implements Serializable {
        private final Object value;

        public CacheElement(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object arg0) {
            if (arg0 == this) {
                return true;
            }
            if (!(arg0 instanceof CacheElement)) {
                return false;
            }
            return ((CacheElement)arg0).value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

