/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.metadata;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.util.StringUtils;

public class JPAXmlMetaDataHelper {
    public String getXMLForMetaData(AbstractClassMetaData cmd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        if (cmd.isMappedSuperclass()) {
            str.append(prefix).append("<mapped-superclass class=\"" + cmd.getFullClassName() + "\"");
        } else if (cmd.isEmbeddedOnly()) {
            str.append(prefix).append("<embeddable class=\"" + cmd.getFullClassName() + "\"");
        } else {
            str.append(prefix).append("<entity name=\"" + cmd.getName() + "\"");
        }
        if (cmd.isMetaDataComplete()) {
            str.append(" metadata-complete=\"true\"");
        }
        str.append(">\n");
        if (cmd.getTable() != null || cmd.getCatalog() != null || cmd.getSchema() != null) {
            str.append(prefix).append(indent).append("<table");
            if (cmd.getTable() != null) {
                str.append(" name=\"").append(cmd.getTable()).append("\"");
            }
            if (cmd.getCatalog() != null) {
                str.append(" catalog=\"").append(cmd.getCatalog()).append("\"");
            }
            if (cmd.getSchema() != null) {
                str.append(" schema=\"").append(cmd.getSchema()).append("\"");
            }
            str.append("/>\n");
        }
        if (!StringUtils.isWhitespace((String)cmd.getObjectidClass()) && !cmd.getObjectidClass().startsWith("org.datanucleus.identity")) {
            str.append(prefix).append(indent).append("<id-class class=\"").append(cmd.getObjectidClass()).append("</id-class>\n");
        }
        if (cmd.getIdentityType() != null && cmd.getIdentityType() == IdentityType.DATASTORE) {
            str.append(prefix).append(indent).append("<datastore-id");
            if (cmd.getIdentityMetaData().getColumnName() != null) {
                str.append(" column=\"").append(cmd.getIdentityMetaData().getColumnName()).append("\"");
            }
            str.append("/>");
        }
        if (cmd.getInheritanceMetaData() != null) {
            str.append(prefix).append(indent).append("<inheritance strategy=\"").append(cmd.getInheritanceMetaData().getStrategy()).append("\"/>\n");
        }
        str.append(prefix).append(indent).append("<attributes>\n");
        int numMembers = cmd.getNoOfMembers();
        for (int i = 0; i < numMembers; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForMemberAtRelativePosition(i);
            str.append(this.getXMLForMetaData(mmd, prefix + indent, indent));
        }
        str.append(prefix).append(indent).append("</attributes>\n");
        this.processExtensions(cmd.getExtensions(), str, prefix, indent);
        if (cmd.isMappedSuperclass()) {
            str.append(prefix).append("</mapped-superclass>");
        } else if (cmd.isEmbeddedOnly()) {
            str.append(prefix).append("</embeddable>");
        } else {
            str.append(prefix).append("</entity>");
        }
        return str.toString();
    }

    public String getXMLForMetaData(AbstractMemberMetaData mmd, String prefix, String indent) {
        if (mmd.isStatic() || mmd.isFinal()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        ClassLoaderResolver clr = mmd.getMetaDataManager().getNucleusContext().getClassLoaderResolver(null);
        RelationType relType = mmd.getRelationType(clr);
        if (relType == RelationType.ONE_TO_ONE_UNI || relType == RelationType.ONE_TO_ONE_BI) {
            str.append(prefix).append("<one-to-one name=\"").append(mmd.getName()).append("\" fetch=").append(mmd.isDefaultFetchGroup() ? "\"EAGER\"" : "\"LAZY\"");
        } else if (relType == RelationType.ONE_TO_MANY_UNI || relType == RelationType.ONE_TO_MANY_BI) {
            str.append(prefix).append("<one-to-many");
        } else if (relType == RelationType.MANY_TO_ONE_UNI || relType == RelationType.MANY_TO_ONE_BI) {
            str.append(prefix).append("<many-to-one");
        } else if (relType == RelationType.MANY_TO_MANY_BI) {
            str.append(prefix).append("<many-to-many");
        }
        return str.toString();
    }

    protected void processExtensions(Map<String, String> extensions, StringBuilder str, String prefix, String indent) {
        if (extensions != null) {
            for (Map.Entry<String, String> entry : extensions.entrySet()) {
                str.append(this.getXMLForMetaData(entry.getKey(), entry.getValue(), prefix + indent, indent)).append("\n");
            }
        }
    }

    public String getXMLForMetaData(String key, String value, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<extension ").append("key=\"").append(key).append("\" ").append("value=\"").append(value).append("\"/>");
        return str.toString();
    }
}

