/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.api.jpa.criteria.JoinImpl;
import org.datanucleus.api.jpa.criteria.PredicateImpl;
import org.datanucleus.api.jpa.criteria.RootImpl;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.query.compiler.JPQLSymbolResolver;
import org.datanucleus.store.query.compiler.PropertySymbol;
import org.datanucleus.store.query.compiler.QueryCompilation;
import org.datanucleus.store.query.compiler.Symbol;
import org.datanucleus.store.query.compiler.SymbolResolver;
import org.datanucleus.store.query.compiler.SymbolTable;
import org.datanucleus.store.query.expression.ClassExpression;

public class CriteriaDeleteImpl<T>
implements CriteriaDelete<T>,
Serializable {
    static final long serialVersionUID = -4037442478473468674L;
    private CriteriaBuilderImpl cb;
    private RootImpl<T> from;
    private PredicateImpl filter;
    String jpqlString = null;
    QueryCompilation compilation = null;

    public CriteriaDeleteImpl(CriteriaBuilderImpl cb) {
        this.cb = cb;
    }

    public Predicate getRestriction() {
        return this.filter;
    }

    public <U> Subquery<U> subquery(Class<U> cls) {
        throw new UnsupportedOperationException("CriteriaDelete.subquery not yet supported");
    }

    public Root<T> from(Class<T> cls) {
        this.discardCompiled();
        EntityType entity = this.cb.getEntityManagerFactory().getMetamodel().entity(cls);
        if (entity == null) {
            throw new IllegalArgumentException("The specified class (" + cls.getName() + ") is not an entity");
        }
        return this.from(entity);
    }

    public Root<T> from(EntityType<T> type) {
        this.discardCompiled();
        this.from = new RootImpl<T>(this.cb, type);
        return this.from;
    }

    public Root<T> getRoot() {
        return this.from;
    }

    public CriteriaDelete<T> where(Expression<Boolean> expr) {
        this.discardCompiled();
        if (expr == null) {
            this.filter = null;
            return this;
        }
        this.filter = (PredicateImpl)expr;
        return this;
    }

    public CriteriaDelete<T> where(Predicate ... exprs) {
        this.discardCompiled();
        if (exprs == null || exprs.length == 0) {
            this.filter = null;
            return this;
        }
        if (this.filter == null) {
            this.filter = new PredicateImpl(this.cb);
        }
        for (int i = 0; i < exprs.length; ++i) {
            this.filter = this.filter.append(exprs[i]);
        }
        return this;
    }

    protected void discardCompiled() {
        this.jpqlString = null;
        this.compilation = null;
    }

    public QueryCompilation getCompilation(MetaDataManager mmgr, ClassLoaderResolver clr) {
        return this.getCompilation(mmgr, clr, null);
    }

    public QueryCompilation getCompilation(MetaDataManager mmgr, ClassLoaderResolver clr, SymbolTable parentSymtbl) {
        if (this.compilation == null) {
            Class candidateClass = this.from.getJavaType();
            String candidateAlias = this.from.getAlias();
            if (candidateAlias == null) {
                candidateAlias = "DN_THIS";
                this.from.alias(candidateAlias);
            }
            SymbolTable symtbl = new SymbolTable();
            symtbl.setSymbolResolver((SymbolResolver)new JPQLSymbolResolver(mmgr, clr, symtbl, candidateClass, candidateAlias));
            symtbl.addSymbol((Symbol)new PropertySymbol(candidateAlias, candidateClass));
            if (parentSymtbl != null) {
                symtbl.setParentSymbolTable(parentSymtbl);
            }
            org.datanucleus.store.query.expression.Expression[] fromExprs = new org.datanucleus.store.query.expression.Expression[1];
            Set frmJoins = this.from.getJoins();
            if (frmJoins != null && !frmJoins.isEmpty()) {
                for (Join frmJoin : frmJoins) {
                    if (frmJoin.getAlias() == null) continue;
                    Class frmJoinCls = ((JoinImpl)frmJoin).getType().getJavaType();
                    symtbl.addSymbol((Symbol)new PropertySymbol(frmJoin.getAlias(), frmJoinCls));
                }
            }
            ClassExpression clsExpr = (ClassExpression)this.from.getQueryExpression(true);
            clsExpr.bind(symtbl);
            fromExprs[0] = clsExpr;
            org.datanucleus.store.query.expression.Expression filterExpr = null;
            if (this.filter != null && (filterExpr = this.filter.getQueryExpression()) != null) {
                filterExpr.bind(symtbl);
            }
            this.compilation = new QueryCompilation(candidateClass, candidateAlias, symtbl, null, fromExprs, filterExpr, null, null, null, null);
            this.compilation.setQueryLanguage("JPQL");
        }
        return this.compilation;
    }

    public String toString() {
        if (this.jpqlString == null) {
            StringBuilder str = new StringBuilder();
            str.append("DELETE ");
            str.append("FROM ");
            str.append(this.from.toString(true));
            str.append(" ");
            if (this.filter != null) {
                str.append("WHERE ").append(this.filter.toString()).append(" ");
            }
            this.jpqlString = str.toString().trim();
        }
        return this.jpqlString;
    }
}

