/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AccessType;
import javax.persistence.AssociationOverride;
import javax.persistence.AttributeConverter;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.ConstraintMode;
import javax.persistence.ConstructorResult;
import javax.persistence.Convert;
import javax.persistence.DiscriminatorType;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.FieldResult;
import javax.persistence.ForeignKey;
import javax.persistence.GenerationType;
import javax.persistence.Index;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.NamedStoredProcedureQuery;
import javax.persistence.NamedSubgraph;
import javax.persistence.ParameterMode;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.QueryHint;
import javax.persistence.SecondaryTable;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.StoredProcedureParameter;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.JPAEntityGraph;
import org.datanucleus.api.jpa.JPASubgraph;
import org.datanucleus.api.jpa.annotations.Extension;
import org.datanucleus.api.jpa.metadata.JPAAnnotationUtils;
import org.datanucleus.api.jpa.metadata.JPAMetaDataManager;
import org.datanucleus.api.jpa.metadata.JPATypeConverter;
import org.datanucleus.api.jpa.metadata.JPATypeConverterUtils;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.StoredProcQueryMetaData;
import org.datanucleus.metadata.StoredProcQueryParameterMetaData;
import org.datanucleus.metadata.StoredProcQueryParameterMode;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.metadata.annotations.AbstractAnnotationReader;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.Member;
import org.datanucleus.store.types.ContainerHandler;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JPAAnnotationReader
extends AbstractAnnotationReader {
    ClassLoaderResolver clr = null;

    public JPAAnnotationReader(MetaDataManager mgr) {
        super(mgr);
        this.setSupportedAnnotationPackages(new String[]{"javax.persistence", "org.datanucleus.api.jpa.annotations"});
    }

    protected AbstractClassMetaData processClassAnnotations(PackageMetaData pmd, Class cls, AnnotationObject[] annotations, ClassLoaderResolver clr) {
        String discriminatorValue;
        DiscriminatorMetaData dismd;
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        this.clr = clr;
        ClassMetaData cmd = null;
        AnnotationObject persistableAnnotation = this.isClassPersistable(annotations);
        if (persistableAnnotation != null) {
            String entName;
            cmd = pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
            cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
            AnnotationObject[] entityName = ClassUtils.getClassNameForClass((Class)cls);
            Map annotationValues = persistableAnnotation.getNameValueMap();
            if (persistableAnnotation.getName().equals(JPAAnnotationUtils.ENTITY) && !StringUtils.isWhitespace((String)(entName = (String)annotationValues.get("name")))) {
                entityName = entName;
            }
            cmd.setEntityName((String)entityName);
        } else if (this.isClassPersistenceAware(annotations)) {
            cmd = pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
            cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_AWARE);
        } else if (this.doesClassHaveNamedQueries(annotations)) {
            cmd = pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
            cmd.setPersistenceModifier(ClassPersistenceModifier.NON_PERSISTENT);
        } else {
            if (this.doesClassHaveConverter(cls, annotations)) {
                return null;
            }
            return null;
        }
        this.processNamedQueries((AbstractClassMetaData)cmd, annotations);
        if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return cmd;
        }
        cmd.setDetachable(true);
        cmd.setRequiresExtent(true);
        cmd.setEmbeddedOnly(false);
        cmd.setIdentityType(IdentityType.APPLICATION);
        for (AnnotationObject annotation : annotations) {
            FieldMetaData fmd;
            AttributeOverride[] overrides;
            Object[] values;
            InheritanceMetaData inhmd;
            Map annotationValues = annotation.getNameValueMap();
            String annName = annotation.getName();
            if (annName.equals(JPAAnnotationUtils.ENTITY)) continue;
            if (annName.equals(JPAAnnotationUtils.MAPPED_SUPERCLASS)) {
                cmd.setMappedSuperclass(true);
                if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) continue;
                inhmd = cmd.getInheritanceMetaData();
                if (inhmd == null) {
                    inhmd = cmd.newInheritanceMetadata();
                }
                inhmd.setStrategy(InheritanceStrategy.SUBCLASS_TABLE);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.DATASTORE_IDENTITY)) {
                cmd.setIdentityType(IdentityType.DATASTORE);
                IdentityMetaData idmd = cmd.newIdentityMetadata();
                idmd.setColumnName((String)annotationValues.get("column"));
                String identityStrategy = JPAAnnotationUtils.getValueGenerationStrategyString((GenerationType)annotationValues.get("generationType"));
                idmd.setValueStrategy(ValueGenerationStrategy.getIdentityStrategy((String)identityStrategy));
                String identityGenerator = (String)annotationValues.get("generator");
                if (identityGenerator == null) continue;
                idmd.setSequence(identityGenerator);
                idmd.setValueGeneratorName(identityGenerator);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.NONDURABLE_IDENTITY)) {
                cmd.setIdentityType(IdentityType.NONDURABLE);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.SURROGATE_VERSION)) {
                String indexed;
                VersionMetaData vermd = cmd.newVersionMetadata();
                vermd.setStrategy(VersionStrategy.VERSION_NUMBER);
                String colName = (String)annotationValues.get("columnName");
                if (!StringUtils.isWhitespace((String)colName)) {
                    vermd.setColumnName(colName);
                }
                if (StringUtils.isWhitespace((String)(indexed = (String)annotationValues.get("indexed")))) continue;
                vermd.setIndexed(IndexedValue.getIndexedValue((String)indexed));
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ACCESS)) {
                AccessType access = (AccessType)annotationValues.get("value");
                cmd.setAccessViaField(access == AccessType.FIELD);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.TABLE)) {
                Index[] indexConstrs;
                cmd.setTable((String)annotationValues.get("name"));
                cmd.setCatalog((String)annotationValues.get("catalog"));
                cmd.setSchema((String)annotationValues.get("schema"));
                UniqueConstraint[] constrs = (UniqueConstraint[])annotationValues.get("uniqueConstraints");
                if (constrs != null && constrs.length > 0) {
                    for (UniqueConstraint constr : constrs) {
                        UniqueMetaData unimd = new UniqueMetaData();
                        String uniName = constr.name();
                        if (!StringUtils.isWhitespace((String)uniName)) {
                            unimd.setName(uniName);
                        }
                        for (int k = 0; k < constr.columnNames().length; ++k) {
                            unimd.addColumn(constr.columnNames()[k]);
                        }
                        cmd.addUniqueConstraint(unimd);
                        unimd.setParent((MetaData)cmd);
                    }
                }
                if ((indexConstrs = (Index[])annotationValues.get("indexes")) == null || indexConstrs.length <= 0) continue;
                for (Index indexConstr : indexConstrs) {
                    String colStr;
                    String[] cols;
                    IndexMetaData idxmd = new IndexMetaData();
                    String idxName = indexConstr.name();
                    if (!StringUtils.isWhitespace((String)idxName)) {
                        idxmd.setName(idxName);
                    }
                    if ((cols = StringUtils.split((String)(colStr = indexConstr.columnList()), (String)",")) != null) {
                        for (int k = 0; k < cols.length; ++k) {
                            idxmd.addColumn(cols[k]);
                        }
                    }
                    if (indexConstr.unique()) {
                        idxmd.setUnique(true);
                    }
                    cmd.addIndex(idxmd);
                    idxmd.setParent((MetaData)cmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ID_CLASS)) {
                cmd.setObjectIdClass(((Class)annotationValues.get("value")).getName());
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.INHERITANCE)) {
                inhmd = cmd.getInheritanceMetaData();
                if (inhmd == null) {
                    inhmd = cmd.newInheritanceMetadata();
                }
                InheritanceType inhType = (InheritanceType)annotationValues.get("strategy");
                String inheritanceStrategy = null;
                if (inhType == InheritanceType.JOINED) {
                    inheritanceStrategy = InheritanceStrategy.NEW_TABLE.toString();
                } else if (inhType == InheritanceType.TABLE_PER_CLASS) {
                    inheritanceStrategy = InheritanceStrategy.COMPLETE_TABLE.toString();
                } else if (inhType == InheritanceType.SINGLE_TABLE) {
                    // empty if block
                }
                inhmd.setStrategy(inheritanceStrategy);
                inhmd.setStrategyForTree(inhType.toString());
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.DISCRIMINATOR_COLUMN)) {
                DiscriminatorMetaData dismd2;
                inhmd = cmd.getInheritanceMetaData();
                if (inhmd == null) {
                    inhmd = cmd.newInheritanceMetadata();
                }
                if ((dismd2 = inhmd.getDiscriminatorMetaData()) == null) {
                    dismd2 = inhmd.newDiscriminatorMetadata();
                }
                String discriminatorColumnName = (String)annotationValues.get("name");
                dismd2.setColumnName(discriminatorColumnName);
                DiscriminatorType type = (DiscriminatorType)annotationValues.get("discriminatorType");
                String discriminatorColumnType = null;
                if (type == DiscriminatorType.CHAR) {
                    discriminatorColumnType = "CHAR";
                } else if (type == DiscriminatorType.INTEGER) {
                    discriminatorColumnType = "INTEGER";
                } else if (type == DiscriminatorType.STRING) {
                    discriminatorColumnType = "VARCHAR";
                }
                Integer discriminatorColumnLength = (Integer)annotationValues.get("length");
                String discriminatorColumnDdl = null;
                String tmp = (String)annotationValues.get("columnDefinition");
                if (!StringUtils.isWhitespace((String)tmp)) {
                    discriminatorColumnDdl = tmp;
                }
                ColumnMetaData discolmd = null;
                if (discriminatorColumnLength == null && discriminatorColumnType == null && discriminatorColumnDdl == null) continue;
                discolmd = new ColumnMetaData();
                discolmd.setName(discriminatorColumnName);
                if (discriminatorColumnType != null) {
                    discolmd.setJdbcType(discriminatorColumnType);
                }
                if (discriminatorColumnLength != null) {
                    discolmd.setLength(discriminatorColumnLength);
                }
                dismd2.setColumnMetaData(discolmd);
                if (discriminatorColumnDdl == null) continue;
                discolmd.setColumnDdl(discriminatorColumnDdl);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.DISCRIMINATOR_VALUE)) {
                DiscriminatorMetaData dismd3;
                inhmd = cmd.getInheritanceMetaData();
                if (inhmd == null) {
                    inhmd = cmd.newInheritanceMetadata();
                }
                if ((dismd3 = inhmd.getDiscriminatorMetaData()) == null) {
                    dismd3 = inhmd.newDiscriminatorMetadata();
                }
                dismd3.setValue((String)annotationValues.get("value"));
                dismd3.setStrategy(DiscriminatorStrategy.VALUE_MAP);
                dismd3.setIndexed("true");
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EMBEDDABLE)) {
                cmd.setEmbeddedOnly(true);
                cmd.setIdentityType(IdentityType.NONDURABLE);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.CACHEABLE)) {
                Boolean cacheableVal = (Boolean)annotationValues.get("value");
                cmd.setCacheable(cacheableVal != null ? cacheableVal : true);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ENTITY_LISTENERS)) {
                Class[] entityListeners = (Class[])annotationValues.get("value");
                if (entityListeners == null) continue;
                for (Class entityListener : entityListeners) {
                    EventListenerMetaData elmd = new EventListenerMetaData(entityListener.getName());
                    cmd.addListener(elmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EXCLUDE_SUPERCLASS_LISTENERS)) {
                cmd.excludeSuperClassListeners();
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EXCLUDE_DEFAULT_LISTENERS)) {
                cmd.excludeDefaultListeners();
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.SEQUENCE_GENERATOR)) {
                this.processSequenceGeneratorAnnotation(pmd, annotationValues);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.TABLE_GENERATOR)) {
                this.processTableGeneratorAnnotation(pmd, annotationValues);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.PRIMARY_KEY_JOIN_COLUMN)) {
                PrimaryKeyMetaData pkmd = cmd.newPrimaryKeyMetadata();
                ColumnMetaData pkcolMd = new ColumnMetaData();
                pkcolMd.setName((String)annotationValues.get("name"));
                pkcolMd.setTarget((String)annotationValues.get("referencedColumnName"));
                pkmd.addColumn(pkcolMd);
                ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                if (fk == null || fk.value() == ConstraintMode.PROVIDER_DEFAULT) continue;
                ForeignKeyMetaData fkmd = cmd.newForeignKeyMetadata();
                fkmd.setName(fk.name());
                fkmd.setFkDefinition(fk.foreignKeyDefinition());
                fkmd.addColumn(pkcolMd);
                if (fk.value() != ConstraintMode.NO_CONSTRAINT) continue;
                fkmd.setFkDefinitionApplies(false);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.PRIMARY_KEY_JOIN_COLUMNS)) {
                values = (PrimaryKeyJoinColumn[])annotationValues.get("value");
                PrimaryKeyMetaData pkmd = cmd.newPrimaryKeyMetadata();
                ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                ForeignKeyMetaData fkmd = null;
                if (fk != null && fk.value() != ConstraintMode.PROVIDER_DEFAULT) {
                    fkmd = cmd.newForeignKeyMetadata();
                    fkmd.setName(fk.name());
                    fkmd.setFkDefinition(fk.foreignKeyDefinition());
                    if (fk.value() == ConstraintMode.NO_CONSTRAINT) {
                        fkmd.setFkDefinitionApplies(false);
                    }
                }
                for (PrimaryKeyJoinColumn pkJoinCol : values) {
                    ColumnMetaData pkcolMD = new ColumnMetaData();
                    pkcolMD.setName(pkJoinCol.name());
                    pkcolMD.setTarget(pkJoinCol.referencedColumnName());
                    if (!StringUtils.isWhitespace((String)pkJoinCol.columnDefinition())) {
                        pkcolMD.setColumnDdl(pkJoinCol.columnDefinition());
                    }
                    pkmd.addColumn(pkcolMD);
                    if (fkmd == null) continue;
                    fkmd.addColumn(pkcolMD);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ATTRIBUTE_OVERRIDES)) {
                overrides = (AttributeOverride[])annotationValues.get("value");
                if (overrides == null) continue;
                for (AttributeOverride override : overrides) {
                    FieldMetaData fmd2 = new FieldMetaData((MetaData)cmd, "#UNKNOWN." + override.name());
                    fmd2.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT);
                    Column col = override.column();
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(col.name());
                    colmd.setLength(Integer.valueOf(col.length()));
                    colmd.setScale(Integer.valueOf(col.scale()));
                    colmd.setAllowsNull(Boolean.valueOf(col.nullable()));
                    colmd.setInsertable(col.insertable());
                    colmd.setUpdateable(col.updatable());
                    colmd.setUnique(col.unique());
                    fmd2.addColumn(colmd);
                    cmd.addMember((AbstractMemberMetaData)fmd2);
                    fmd2.setParent((MetaData)cmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ATTRIBUTE_OVERRIDE)) {
                fmd = new FieldMetaData((MetaData)cmd, "#UNKNOWN." + (String)annotationValues.get("name"));
                Column col = (Column)annotationValues.get("column");
                ColumnMetaData colmd = new ColumnMetaData();
                colmd.setName(col.name());
                colmd.setLength(Integer.valueOf(col.length()));
                colmd.setScale(Integer.valueOf(col.scale()));
                colmd.setAllowsNull(Boolean.valueOf(col.nullable()));
                colmd.setInsertable(col.insertable());
                colmd.setUpdateable(col.updatable());
                colmd.setUnique(col.unique());
                fmd.addColumn(colmd);
                cmd.addMember((AbstractMemberMetaData)fmd);
                fmd.setParent((MetaData)cmd);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ASSOCIATION_OVERRIDES)) {
                overrides = (AssociationOverride[])annotationValues.get("value");
                if (overrides == null) continue;
                for (AttributeOverride override : overrides) {
                    JoinColumn[] cols;
                    FieldMetaData fmd3 = new FieldMetaData((MetaData)cmd, "#UNKNOWN." + override.name());
                    for (JoinColumn col : cols = override.joinColumns()) {
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(col.name());
                        colmd.setTarget(col.referencedColumnName());
                        colmd.setAllowsNull(Boolean.valueOf(col.nullable()));
                        colmd.setInsertable(col.insertable());
                        colmd.setUpdateable(col.updatable());
                        colmd.setUnique(col.unique());
                        fmd3.addColumn(colmd);
                    }
                    cmd.addMember((AbstractMemberMetaData)fmd3);
                    fmd3.setParent((MetaData)cmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ASSOCIATION_OVERRIDE)) {
                JoinColumn[] cols;
                fmd = new FieldMetaData((MetaData)cmd, "#UNKNOWN." + (String)annotationValues.get("name"));
                for (JoinColumn col : cols = (JoinColumn[])annotationValues.get("joinColumns")) {
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(col.name());
                    colmd.setTarget(col.referencedColumnName());
                    colmd.setAllowsNull(Boolean.valueOf(col.nullable()));
                    colmd.setInsertable(col.insertable());
                    colmd.setUpdateable(col.updatable());
                    colmd.setUnique(col.unique());
                    fmd.addColumn(colmd);
                }
                cmd.addMember((AbstractMemberMetaData)fmd);
                fmd.setParent((MetaData)cmd);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.SQL_RESULTSET_MAPPINGS)) {
                SqlResultSetMapping[] mappings;
                for (SqlResultSetMapping mapping : mappings = (SqlResultSetMapping[])annotationValues.get("value")) {
                    ConstructorResult[] ctrResults;
                    ColumnResult[] colResults;
                    QueryResultMetaData qrmd = new QueryResultMetaData(mapping.name());
                    EntityResult[] entityResults = mapping.entities();
                    if (entityResults != null && entityResults.length > 0) {
                        for (EntityResult entityResult : entityResults) {
                            String entityClassName = entityResult.entityClass().getName();
                            qrmd.addPersistentTypeMapping(entityClassName, null, entityResult.discriminatorColumn());
                            FieldResult[] fields = entityResult.fields();
                            if (fields == null) continue;
                            for (int l = 0; l < fields.length; ++l) {
                                qrmd.addMappingForPersistentTypeMapping(entityClassName, fields[l].name(), fields[l].column());
                            }
                        }
                    }
                    if ((colResults = mapping.columns()) != null && colResults.length > 0) {
                        for (ColumnResult colResult : colResults) {
                            qrmd.addScalarColumn(colResult.name());
                        }
                    }
                    if ((ctrResults = mapping.classes()) != null && ctrResults.length > 0) {
                        for (ConstructorResult ctrResult : ctrResults) {
                            String ctrClassName = ctrResult.targetClass().getName();
                            ArrayList<QueryResultMetaData.ConstructorTypeColumn> ctrCols = null;
                            ColumnResult[] cols = ctrResult.columns();
                            if (cols != null && cols.length > 0) {
                                ctrCols = new ArrayList<QueryResultMetaData.ConstructorTypeColumn>();
                                for (int l = 0; l < cols.length; ++l) {
                                    ctrCols.add(new QueryResultMetaData.ConstructorTypeColumn(cols[l].name(), cols[l].type()));
                                }
                            }
                            qrmd.addConstructorTypeMapping(ctrClassName, ctrCols);
                        }
                    }
                    cmd.addQueryResultMetaData(qrmd);
                    qrmd.setParent((MetaData)cmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.SQL_RESULTSET_MAPPING)) {
                ConstructorResult[] ctrResults;
                ColumnResult[] colResults;
                QueryResultMetaData qrmd = new QueryResultMetaData((String)annotationValues.get("name"));
                EntityResult[] entityResults = (EntityResult[])annotationValues.get("entities");
                if (entityResults != null && entityResults.length > 0) {
                    for (int j = 0; j < entityResults.length; ++j) {
                        String entityClassName = entityResults[j].entityClass().getName();
                        qrmd.addPersistentTypeMapping(entityClassName, null, entityResults[j].discriminatorColumn());
                        FieldResult[] fields = entityResults[j].fields();
                        if (fields == null) continue;
                        for (int k = 0; k < fields.length; ++k) {
                            qrmd.addMappingForPersistentTypeMapping(entityClassName, fields[k].name(), fields[k].column());
                        }
                    }
                }
                if ((colResults = (ColumnResult[])annotationValues.get("columns")) != null && colResults.length > 0) {
                    for (int j = 0; j < colResults.length; ++j) {
                        qrmd.addScalarColumn(colResults[j].name());
                    }
                }
                if ((ctrResults = (ConstructorResult[])annotationValues.get("classes")) != null && ctrResults.length > 0) {
                    for (int j = 0; j < ctrResults.length; ++j) {
                        String ctrClassName = ctrResults[j].targetClass().getName();
                        ArrayList<QueryResultMetaData.ConstructorTypeColumn> ctrCols = null;
                        ColumnResult[] cols = ctrResults[j].columns();
                        if (cols != null && cols.length > 0) {
                            ctrCols = new ArrayList<QueryResultMetaData.ConstructorTypeColumn>();
                            for (int k = 0; k < cols.length; ++k) {
                                ctrCols.add(new QueryResultMetaData.ConstructorTypeColumn(cols[k].name(), cols[k].type()));
                            }
                        }
                        qrmd.addConstructorTypeMapping(ctrClassName, ctrCols);
                    }
                }
                cmd.addQueryResultMetaData(qrmd);
                qrmd.setParent((MetaData)cmd);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.NAMED_ENTITY_GRAPHS)) {
                NamedEntityGraph[] graphs = (NamedEntityGraph[])annotationValues.get("value");
                for (int j = 0; j < graphs.length; ++j) {
                    NamedSubgraph[] subclassSubgraphs;
                    NamedSubgraph[] subgraphs;
                    String graphName = graphs[j].name();
                    if (StringUtils.isWhitespace((String)graphName)) {
                        graphName = cmd.getEntityName();
                    }
                    JPAEntityGraph eg = new JPAEntityGraph(this.mmgr, graphName, cls);
                    boolean includeAll = graphs[j].includeAllAttributes();
                    if (includeAll) {
                        eg.setIncludeAll();
                    }
                    HashMap<String, String> attributeNameBySubgraphName = new HashMap<String, String>();
                    NamedAttributeNode[] nodes = graphs[j].attributeNodes();
                    if (nodes != null && nodes.length > 0) {
                        for (int k = 0; k < nodes.length; ++k) {
                            String attributeName = nodes[k].value();
                            String subgraphName = nodes[k].subgraph();
                            eg.addAttributeNodes(attributeName);
                            if (StringUtils.isWhitespace((String)subgraphName)) continue;
                            attributeNameBySubgraphName.put(subgraphName, attributeName);
                        }
                    }
                    if ((subgraphs = graphs[j].subgraphs()) != null && subgraphs.length > 0) {
                        for (int k = 0; k < subgraphs.length; ++k) {
                            String subgraphName = subgraphs[k].name();
                            String attributeName = (String)attributeNameBySubgraphName.get(subgraphName);
                            JPASubgraph subgraph = (JPASubgraph)eg.addSubgraph(attributeName, subgraphs[k].type());
                            NamedAttributeNode[] subnodes = subgraphs[k].attributeNodes();
                            if (subnodes == null || subnodes.length <= 0) continue;
                            for (int l = 0; l < subnodes.length; ++l) {
                                subgraph.addAttributeNodes(subnodes[l].value());
                            }
                        }
                    }
                    if ((subclassSubgraphs = graphs[j].subclassSubgraphs()) != null && subclassSubgraphs.length > 0 && subgraphs != null) {
                        for (int k = 0; k < subgraphs.length; ++k) {
                            JPASubgraph subgraph = (JPASubgraph)eg.addSubclassSubgraph(subgraphs[k].type());
                            NamedAttributeNode[] subnodes = subgraphs[k].attributeNodes();
                            if (subnodes == null || subnodes.length <= 0) continue;
                            for (int l = 0; l < subnodes.length; ++l) {
                                subgraph.addAttributeNodes(subnodes[l].value());
                            }
                        }
                    }
                    ((JPAMetaDataManager)this.mmgr).registerEntityGraph(eg);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.NAMED_ENTITY_GRAPH)) {
                NamedSubgraph[] subclassSubgraphs;
                NamedSubgraph[] subgraphs;
                String graphName = (String)annotationValues.get("name");
                if (StringUtils.isWhitespace((String)graphName)) {
                    graphName = cmd.getEntityName();
                }
                JPAEntityGraph eg = new JPAEntityGraph(this.mmgr, graphName, cls);
                boolean includeAll = (Boolean)annotationValues.get("includeAllAttributes");
                if (includeAll) {
                    eg.setIncludeAll();
                }
                HashMap<String, String> attributeNameBySubgraphName = new HashMap<String, String>();
                NamedAttributeNode[] nodes = (NamedAttributeNode[])annotationValues.get("attributeNodes");
                if (nodes != null && nodes.length > 0) {
                    for (int k = 0; k < nodes.length; ++k) {
                        String attributeName = nodes[k].value();
                        String subgraphName = nodes[k].subgraph();
                        eg.addAttributeNodes(attributeName);
                        if (StringUtils.isWhitespace((String)subgraphName)) continue;
                        attributeNameBySubgraphName.put(subgraphName, attributeName);
                    }
                }
                if ((subgraphs = (NamedSubgraph[])annotationValues.get("subgraphs")) != null && subgraphs.length > 0) {
                    for (int k = 0; k < subgraphs.length; ++k) {
                        String subgraphName = subgraphs[k].name();
                        String attributeName = (String)attributeNameBySubgraphName.get(subgraphName);
                        JPASubgraph subgraph = (JPASubgraph)eg.addSubgraph(attributeName, subgraphs[k].type());
                        NamedAttributeNode[] subnodes = subgraphs[k].attributeNodes();
                        if (subnodes == null || subnodes.length <= 0) continue;
                        for (int l = 0; l < subnodes.length; ++l) {
                            subgraph.addAttributeNodes(subnodes[l].value());
                        }
                    }
                }
                if ((subclassSubgraphs = (NamedSubgraph[])annotationValues.get("subclassSubgraphs")) != null && subclassSubgraphs.length > 0) {
                    for (int k = 0; k < subclassSubgraphs.length; ++k) {
                        JPASubgraph subgraph = (JPASubgraph)eg.addSubclassSubgraph(subclassSubgraphs[k].type());
                        NamedAttributeNode[] subnodes = subclassSubgraphs[k].attributeNodes();
                        if (subnodes == null || subnodes.length <= 0) continue;
                        for (int l = 0; l < subnodes.length; ++l) {
                            subgraph.addAttributeNodes(subnodes[l].value());
                        }
                    }
                }
                ((JPAMetaDataManager)this.mmgr).registerEntityGraph(eg);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.SECONDARY_TABLES)) {
                SecondaryTable[] secTableAnns = (SecondaryTable[])annotationValues.get("value");
                if (secTableAnns == null) continue;
                for (int j = 0; j < secTableAnns.length; ++j) {
                    Index[] indexConstrs;
                    JoinMetaData joinmd = new JoinMetaData();
                    joinmd.setTable(secTableAnns[j].name());
                    joinmd.setCatalog(secTableAnns[j].catalog());
                    joinmd.setSchema(secTableAnns[j].schema());
                    PrimaryKeyJoinColumn[] pkJoinCols = secTableAnns[j].pkJoinColumns();
                    if (pkJoinCols != null) {
                        for (int k = 0; k < pkJoinCols.length; ++k) {
                            ColumnMetaData colmd = new ColumnMetaData();
                            colmd.setName(pkJoinCols[k].name());
                            colmd.setTarget(pkJoinCols[k].referencedColumnName());
                            joinmd.addColumn(colmd);
                        }
                    }
                    cmd.addJoin(joinmd);
                    UniqueConstraint[] constrs = secTableAnns[j].uniqueConstraints();
                    if (constrs != null && constrs.length > 0) {
                        for (int k = 0; k < constrs.length; ++k) {
                            UniqueMetaData unimd = new UniqueMetaData();
                            String uniName = constrs[k].name();
                            if (!StringUtils.isWhitespace((String)uniName)) {
                                unimd.setName(uniName);
                            }
                            for (int l = 0; l < constrs[k].columnNames().length; ++l) {
                                unimd.addColumn(constrs[k].columnNames()[l]);
                            }
                            joinmd.setUniqueMetaData(unimd);
                        }
                    }
                    if ((indexConstrs = secTableAnns[j].indexes()) == null || indexConstrs.length <= 0) continue;
                    for (int k = 0; k < indexConstrs.length; ++k) {
                        String colStr;
                        String[] cols;
                        IndexMetaData idxmd = new IndexMetaData();
                        String idxName = indexConstrs[k].name();
                        if (!StringUtils.isWhitespace((String)idxName)) {
                            idxmd.setName(idxName);
                        }
                        if ((cols = StringUtils.split((String)(colStr = indexConstrs[k].columnList()), (String)",")) != null) {
                            for (int l = 0; l < cols.length; ++l) {
                                idxmd.addColumn(cols[l]);
                            }
                        }
                        if (indexConstrs[k].unique()) {
                            idxmd.setUnique(true);
                        }
                        joinmd.setIndexMetaData(idxmd);
                    }
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.SECONDARY_TABLE)) {
                Index[] indexConstrs;
                UniqueConstraint[] constrs;
                ForeignKey fk;
                JoinMetaData joinmd = new JoinMetaData();
                joinmd.setTable((String)annotationValues.get("name"));
                joinmd.setCatalog((String)annotationValues.get("catalog"));
                joinmd.setSchema((String)annotationValues.get("schema"));
                if (annotationValues.get("pkJoinColumns") != null) {
                    PrimaryKeyJoinColumn[] joinCols = (PrimaryKeyJoinColumn[])annotationValues.get("pkJoinColumns");
                    for (int j = 0; j < joinCols.length; ++j) {
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(joinCols[j].name());
                        colmd.setTarget(joinCols[j].referencedColumnName());
                        joinmd.addColumn(colmd);
                    }
                }
                cmd.addJoin(joinmd);
                if (annotationValues.containsKey("foreignKey") && (fk = (ForeignKey)annotationValues.get("foreignKey")).value() == ConstraintMode.CONSTRAINT) {
                    ForeignKeyMetaData fkmd = joinmd.newForeignKeyMetaData();
                    fkmd.setName(fk.name());
                    fkmd.setFkDefinition(fk.foreignKeyDefinition());
                }
                if ((constrs = (UniqueConstraint[])annotationValues.get("uniqueConstraints")) != null && constrs.length > 0) {
                    for (int j = 0; j < constrs.length; ++j) {
                        UniqueMetaData unimd = new UniqueMetaData();
                        String uniName = constrs[j].name();
                        if (!StringUtils.isWhitespace((String)uniName)) {
                            unimd.setName(uniName);
                        }
                        for (int k = 0; k < constrs[j].columnNames().length; ++k) {
                            unimd.addColumn(constrs[j].columnNames()[k]);
                        }
                        joinmd.setUniqueMetaData(unimd);
                    }
                }
                if ((indexConstrs = (Index[])annotationValues.get("indexes")) == null || indexConstrs.length <= 0) continue;
                for (int j = 0; j < indexConstrs.length; ++j) {
                    String colStr;
                    String[] cols;
                    IndexMetaData idxmd = new IndexMetaData();
                    String idxName = indexConstrs[j].name();
                    if (!StringUtils.isWhitespace((String)idxName)) {
                        idxmd.setName(idxName);
                    }
                    if ((cols = StringUtils.split((String)(colStr = indexConstrs[j].columnList()), (String)",")) != null) {
                        for (int k = 0; k < cols.length; ++k) {
                            idxmd.addColumn(cols[k]);
                        }
                    }
                    if (indexConstrs[j].unique()) {
                        idxmd.setUnique(true);
                    }
                    joinmd.setIndexMetaData(idxmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EXTENSION)) {
                cmd.addExtension((String)annotationValues.get("key"), (String)annotationValues.get("value"));
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EXTENSIONS)) {
                values = (Extension[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                for (int j = 0; j < values.length; ++j) {
                    cmd.addExtension(values[j].key().toString(), values[j].value().toString());
                }
                continue;
            }
            NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044203", (Object[])new Object[]{cls.getName(), annotation.getName()}));
        }
        NucleusLogger.METADATA.debug((Object)Localiser.msg((String)"044200", (Object[])new Object[]{cls.getName(), "JPA"}));
        InheritanceMetaData inhmd = cmd.getInheritanceMetaData();
        if (inhmd != null && (dismd = inhmd.getDiscriminatorMetaData()) != null && (discriminatorValue = dismd.getValue()) == null) {
            if (this.mmgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.metadata.useDiscriminatorClassNameByDefault")) {
                if (!Modifier.isAbstract(cls.getModifiers())) {
                    discriminatorValue = cls.getName();
                    dismd.setValue(discriminatorValue);
                }
                dismd.setStrategy(DiscriminatorStrategy.CLASS_NAME);
            } else {
                dismd.setStrategy(DiscriminatorStrategy.VALUE_MAP_ENTITY_NAME);
            }
            dismd.setIndexed("true");
        }
        return cmd;
    }

    protected void processNamedQueries(AbstractClassMetaData cmd, AnnotationObject[] annotations) {
        for (AnnotationObject annotation : annotations) {
            String[] resultSetMappings;
            StoredProcedureParameter[] params;
            NamedQuery[] queries;
            Map annotationValues = annotation.getNameValueMap();
            String annName = annotation.getName();
            if (annName.equals(JPAAnnotationUtils.NAMED_QUERIES)) {
                queries = (NamedQuery[])annotationValues.get("value");
                for (int j = 0; j < queries.length; ++j) {
                    if (StringUtils.isWhitespace((String)queries[j].name())) {
                        throw new InvalidClassMetaDataException("044154", new Object[]{cmd.getFullClassName()});
                    }
                    QueryMetaData qmd = new QueryMetaData(queries[j].name());
                    qmd.setLanguage(QueryLanguage.JPQL.toString());
                    qmd.setUnmodifiable(true);
                    qmd.setQuery(queries[j].query());
                    QueryHint[] hints = queries[j].hints();
                    if (hints != null) {
                        for (int k = 0; k < hints.length; ++k) {
                            qmd.addExtension(hints[k].name(), hints[k].value());
                        }
                    }
                    cmd.addQuery(qmd);
                    qmd.setParent((MetaData)cmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.NAMED_QUERY)) {
                if (StringUtils.isWhitespace((String)((String)annotationValues.get("name")))) {
                    throw new InvalidClassMetaDataException("044154", new Object[]{cmd.getFullClassName()});
                }
                QueryMetaData qmd = new QueryMetaData((String)annotationValues.get("name"));
                qmd.setLanguage(QueryLanguage.JPQL.toString());
                qmd.setUnmodifiable(true);
                qmd.setQuery((String)annotationValues.get("query"));
                QueryHint[] hints = (QueryHint[])annotationValues.get("hints");
                if (hints != null) {
                    for (int j = 0; j < hints.length; ++j) {
                        qmd.addExtension(hints[j].name(), hints[j].value());
                    }
                }
                cmd.addQuery(qmd);
                qmd.setParent((MetaData)cmd);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.NAMED_NATIVE_QUERIES)) {
                queries = (NamedNativeQuery[])annotationValues.get("value");
                for (int j = 0; j < queries.length; ++j) {
                    String resultClassName = null;
                    if (queries[j].resultClass() != null && queries[j].resultClass() != Void.TYPE) {
                        resultClassName = queries[j].resultClass().getName();
                    }
                    String resultMappingName = null;
                    if (queries[j].resultSetMapping() != null) {
                        resultMappingName = queries[j].resultSetMapping();
                    }
                    QueryMetaData qmd = new QueryMetaData(queries[j].name());
                    qmd.setLanguage(QueryLanguage.SQL.toString());
                    qmd.setUnmodifiable(true);
                    qmd.setResultClass(resultClassName);
                    qmd.setResultMetaDataName(resultMappingName);
                    qmd.setQuery(queries[j].query());
                    QueryHint[] hints = queries[j].hints();
                    if (hints != null) {
                        for (int k = 0; k < hints.length; ++k) {
                            qmd.addExtension(hints[k].name(), hints[k].value());
                        }
                    }
                    cmd.addQuery(qmd);
                    qmd.setParent((MetaData)cmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.NAMED_NATIVE_QUERY)) {
                String resultMappingName;
                Class resultClass = (Class)annotationValues.get("resultClass");
                String resultClassName = null;
                if (resultClass != null && resultClass != Void.TYPE) {
                    resultClassName = resultClass.getName();
                }
                if (StringUtils.isWhitespace((String)(resultMappingName = (String)annotationValues.get("resultSetMapping")))) {
                    resultMappingName = null;
                }
                QueryMetaData qmd = new QueryMetaData((String)annotationValues.get("name"));
                qmd.setLanguage(QueryLanguage.SQL.toString());
                qmd.setUnmodifiable(true);
                qmd.setResultClass(resultClassName);
                qmd.setResultMetaDataName(resultMappingName);
                qmd.setQuery((String)annotationValues.get("query"));
                QueryHint[] hints = (QueryHint[])annotationValues.get("hints");
                if (hints != null) {
                    for (int j = 0; j < hints.length; ++j) {
                        qmd.addExtension(hints[j].name(), hints[j].value());
                    }
                }
                cmd.addQuery(qmd);
                qmd.setParent((MetaData)cmd);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.NAMED_STOREDPROC_QUERIES)) {
                NamedStoredProcedureQuery[] procs = (NamedStoredProcedureQuery[])annotationValues.get("value");
                for (int j = 0; j < procs.length; ++j) {
                    int k;
                    if (StringUtils.isWhitespace((String)procs[j].name())) {
                        throw new InvalidClassMetaDataException("044154", new Object[]{cmd.getFullClassName()});
                    }
                    StoredProcQueryMetaData spqmd = new StoredProcQueryMetaData(procs[j].name());
                    spqmd.setProcedureName(procs[j].procedureName());
                    if (procs[j].resultClasses() != null && procs[j].resultClasses().length > 0) {
                        Class[] resultClasses = procs[j].resultClasses();
                        for (k = 0; k < resultClasses.length; ++k) {
                            spqmd.addResultClass(resultClasses[k].getName());
                        }
                    }
                    if (procs[j].resultSetMappings() != null && procs[j].resultSetMappings().length > 0) {
                        String[] resultSetMappings2 = procs[j].resultSetMappings();
                        for (k = 0; k < resultSetMappings2.length; ++k) {
                            spqmd.addResultSetMapping(resultSetMappings2[k]);
                        }
                    }
                    if (procs[j].parameters() != null && procs[j].parameters().length > 0) {
                        params = procs[j].parameters();
                        for (k = 0; k < params.length; ++k) {
                            StoredProcQueryParameterMetaData parammd = this.getMetaDataForStoredProcParameter(params[k]);
                            spqmd.addParameter(parammd);
                        }
                    }
                    cmd.addStoredProcQuery(spqmd);
                    spqmd.setParent((MetaData)cmd);
                }
                continue;
            }
            if (!annName.equals(JPAAnnotationUtils.NAMED_STOREDPROC_QUERY)) continue;
            if (StringUtils.isWhitespace((String)((String)annotationValues.get("name")))) {
                throw new InvalidClassMetaDataException("044154", new Object[]{cmd.getFullClassName()});
            }
            StoredProcQueryMetaData spqmd = new StoredProcQueryMetaData((String)annotationValues.get("name"));
            spqmd.setProcedureName((String)annotationValues.get("procedureName"));
            Class[] resultClasses = (Class[])annotationValues.get("resultClasses");
            if (resultClasses != null) {
                for (int j = 0; j < resultClasses.length; ++j) {
                    spqmd.addResultClass(resultClasses[j].getName());
                }
            }
            if ((resultSetMappings = (String[])annotationValues.get("resultSetMappings")) != null) {
                for (int j = 0; j < resultSetMappings.length; ++j) {
                    spqmd.addResultSetMapping(resultSetMappings[j]);
                }
            }
            if ((params = (StoredProcedureParameter[])annotationValues.get("parameters")) != null) {
                for (int j = 0; j < params.length; ++j) {
                    StoredProcQueryParameterMetaData parammd = this.getMetaDataForStoredProcParameter(params[j]);
                    spqmd.addParameter(parammd);
                }
            }
            cmd.addStoredProcQuery(spqmd);
            spqmd.setParent((MetaData)cmd);
        }
    }

    protected StoredProcQueryParameterMetaData getMetaDataForStoredProcParameter(StoredProcedureParameter param) {
        StoredProcQueryParameterMetaData pmd = new StoredProcQueryParameterMetaData();
        pmd.setName(param.name());
        pmd.setType(param.type().getName());
        if (param.mode() == ParameterMode.IN) {
            pmd.setMode(StoredProcQueryParameterMode.IN);
        } else if (param.mode() == ParameterMode.OUT) {
            pmd.setMode(StoredProcQueryParameterMode.OUT);
        } else if (param.mode() == ParameterMode.INOUT) {
            pmd.setMode(StoredProcQueryParameterMode.INOUT);
        } else if (param.mode() == ParameterMode.REF_CURSOR) {
            pmd.setMode(StoredProcQueryParameterMode.REF_CURSOR);
        }
        return pmd;
    }

    protected AbstractMemberMetaData processMemberAnnotations(AbstractClassMetaData cmd, Member member, AnnotationObject[] annotations) {
        if (Modifier.isTransient(member.getModifiers())) {
            return null;
        }
        if (member.getName().startsWith(this.mmgr.getEnhancedMethodNamePrefix())) {
            return null;
        }
        if (annotations != null && annotations.length > 0 || this.mmgr.getApiAdapter().isMemberDefaultPersistent(member.getType())) {
            AbstractMemberMetaData mmd = this.newMetaDataForMember(cmd, member, annotations);
            if (annotations != null && annotations.length > 0) {
                ColumnMetaData colmd;
                ColumnMetaData[] columnMetaData = null;
                String columnTable = null;
                JoinMetaData joinmd = null;
                ElementMetaData elemmd = null;
                KeyMetaData keymd = null;
                ValueMetaData valmd = null;
                boolean oneToMany = false;
                boolean manyToMany = false;
                for (AnnotationObject annotation : annotations) {
                    EnumType type;
                    Class keyType;
                    int k;
                    String colStr;
                    String[] cols;
                    IndexMetaData idxmd;
                    Index[] joinIndexConstrs;
                    String uniName;
                    String schemaName;
                    String tableName;
                    ForeignKeyMetaData fkmd;
                    JoinColumn[] cols2;
                    String annName = annotation.getName();
                    Map annotationValues = annotation.getNameValueMap();
                    if (annName.equals(JPAAnnotationUtils.JOIN_COLUMNS)) {
                        cols2 = (JoinColumn[])annotationValues.get("value");
                        ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                        fkmd = null;
                        if (fk != null && fk.value() != ConstraintMode.PROVIDER_DEFAULT) {
                            fkmd = mmd.newForeignKeyMetaData();
                            fkmd.setName(fk.name());
                            fkmd.setFkDefinition(fk.foreignKeyDefinition());
                            if (fk.value() == ConstraintMode.NO_CONSTRAINT) {
                                fkmd.setFkDefinitionApplies(false);
                            }
                        }
                        if (cols2 == null) continue;
                        columnMetaData = new ColumnMetaData[cols2.length];
                        for (int j = 0; j < cols2.length; ++j) {
                            if (annotationValues.get("table") != null) {
                                columnTable = cols2[j].table();
                            }
                            columnMetaData[j] = new ColumnMetaData();
                            columnMetaData[j].setName(cols2[j].name());
                            columnMetaData[j].setTarget(cols2[j].referencedColumnName());
                            columnMetaData[j].setAllowsNull(Boolean.valueOf(cols2[j].nullable()));
                            columnMetaData[j].setInsertable(cols2[j].insertable());
                            columnMetaData[j].setUpdateable(cols2[j].updatable());
                            columnMetaData[j].setUnique(cols2[j].unique());
                            if (fkmd == null) continue;
                            fkmd.addColumn(columnMetaData[j]);
                        }
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.JOIN_COLUMN)) {
                        columnMetaData = new ColumnMetaData[1];
                        String colNullable = null;
                        String colInsertable = null;
                        String colUpdateable = null;
                        String colUnique = null;
                        if (annotationValues.get("table") != null) {
                            columnTable = annotationValues.get("table").toString();
                        }
                        if (annotationValues.get("nullable") != null) {
                            colNullable = annotationValues.get("nullable").toString();
                        }
                        if (annotationValues.get("insertable") != null) {
                            colInsertable = annotationValues.get("insertable").toString();
                        }
                        if (annotationValues.get("updatable") != null) {
                            colUpdateable = annotationValues.get("updatable").toString();
                        }
                        if (annotationValues.get("unique") != null) {
                            colUnique = annotationValues.get("unique").toString();
                        }
                        columnMetaData[0] = new ColumnMetaData();
                        columnMetaData[0].setName((String)annotationValues.get("name"));
                        columnMetaData[0].setTarget((String)annotationValues.get("referencedColumnName"));
                        columnMetaData[0].setAllowsNull(colNullable);
                        columnMetaData[0].setInsertable(colInsertable);
                        columnMetaData[0].setUpdateable(colUpdateable);
                        columnMetaData[0].setUnique(colUnique);
                        ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                        ForeignKeyMetaData fkmd2 = null;
                        if (fk == null || fk.value() == ConstraintMode.PROVIDER_DEFAULT) continue;
                        fkmd2 = mmd.newForeignKeyMetaData();
                        fkmd2.setName(fk.name());
                        fkmd2.setFkDefinition(fk.foreignKeyDefinition());
                        if (fk.value() == ConstraintMode.NO_CONSTRAINT) {
                            fkmd2.setFkDefinitionApplies(false);
                        }
                        fkmd2.addColumn(columnMetaData[0]);
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.PRIMARY_KEY_JOIN_COLUMNS)) {
                        cols2 = (PrimaryKeyJoinColumn[])annotationValues.get("value");
                        if (cols2 == null) continue;
                        ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                        fkmd = null;
                        if (fk != null && fk.value() != ConstraintMode.PROVIDER_DEFAULT) {
                            fkmd = mmd.newForeignKeyMetaData();
                            fkmd.setName(fk.name());
                            fkmd.setFkDefinition(fk.foreignKeyDefinition());
                            if (fk.value() == ConstraintMode.NO_CONSTRAINT) {
                                fkmd.setFkDefinitionApplies(false);
                            }
                        }
                        columnMetaData = new ColumnMetaData[cols2.length];
                        for (int j = 0; j < cols2.length; ++j) {
                            columnMetaData[j] = new ColumnMetaData();
                            columnMetaData[j].setName(cols2[j].name());
                            columnMetaData[j].setTarget(cols2[j].referencedColumnName());
                            if (fkmd == null) continue;
                            fkmd.addColumn(columnMetaData[j]);
                        }
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.PRIMARY_KEY_JOIN_COLUMN)) {
                        columnMetaData = new ColumnMetaData[]{new ColumnMetaData()};
                        columnMetaData[0].setName((String)annotationValues.get("name"));
                        columnMetaData[0].setTarget((String)annotationValues.get("referencedColumnName"));
                        ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                        ForeignKeyMetaData fkmd3 = null;
                        if (fk == null || fk.value() == ConstraintMode.PROVIDER_DEFAULT) continue;
                        fkmd3 = mmd.newForeignKeyMetaData();
                        fkmd3.setName(fk.name());
                        fkmd3.setFkDefinition(fk.foreignKeyDefinition());
                        if (fk.value() == ConstraintMode.NO_CONSTRAINT) {
                            fkmd3.setFkDefinitionApplies(false);
                        }
                        fkmd3.addColumn(columnMetaData[0]);
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.ATTRIBUTE_OVERRIDES)) {
                        mmd.setEmbedded(true);
                        AttributeOverride[] attributeOverride = (AttributeOverride[])annotationValues.get("value");
                        for (int j = 0; j < attributeOverride.length; ++j) {
                            this.processEmbeddedAttributeOverride(mmd, attributeOverride[j].name(), member.getType(), attributeOverride[j].column());
                        }
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.ATTRIBUTE_OVERRIDE)) {
                        mmd.setEmbedded(true);
                        this.processEmbeddedAttributeOverride(mmd, (String)annotationValues.get("name"), member.getType(), (Column)annotationValues.get("column"));
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.ASSOCIATION_OVERRIDES) || annName.equals(JPAAnnotationUtils.ASSOCIATION_OVERRIDE)) continue;
                    if (annName.equals(JPAAnnotationUtils.JOIN_TABLE)) {
                        UniqueConstraint[] joinUniqueConstraints;
                        ForeignKey fk;
                        String catalogName;
                        tableName = (String)annotationValues.get("name");
                        if (!StringUtils.isWhitespace((String)tableName)) {
                            mmd.setTable(tableName);
                        }
                        if (!StringUtils.isWhitespace((String)(catalogName = (String)annotationValues.get("catalog")))) {
                            mmd.setCatalog(catalogName);
                        }
                        if (!StringUtils.isWhitespace((String)(schemaName = (String)annotationValues.get("schema")))) {
                            mmd.setSchema(schemaName);
                        }
                        joinmd = new JoinMetaData();
                        mmd.setJoinMetaData(joinmd);
                        if (annotationValues.get("joinColumns") != null) {
                            ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>();
                            joinColumns.addAll(Arrays.asList((JoinColumn[])annotationValues.get("joinColumns")));
                            for (int j = 0; j < joinColumns.size(); ++j) {
                                ColumnMetaData colmd2 = new ColumnMetaData();
                                colmd2.setName(((JoinColumn)joinColumns.get(j)).name());
                                colmd2.setTarget(((JoinColumn)joinColumns.get(j)).referencedColumnName());
                                colmd2.setAllowsNull(Boolean.valueOf(((JoinColumn)joinColumns.get(j)).nullable()));
                                joinmd.addColumn(colmd2);
                            }
                        }
                        if (annotationValues.containsKey("foreignKey") && (fk = (ForeignKey)annotationValues.get("foreignKey")).value() == ConstraintMode.CONSTRAINT) {
                            ForeignKeyMetaData fkmd4 = joinmd.newForeignKeyMetaData();
                            fkmd4.setName(fk.name());
                            fkmd4.setFkDefinition(fk.foreignKeyDefinition());
                        }
                        if (annotationValues.get("inverseJoinColumns") != null) {
                            ArrayList<JoinColumn> elementColumns = new ArrayList<JoinColumn>();
                            elementColumns.addAll(Arrays.asList((JoinColumn[])annotationValues.get("inverseJoinColumns")));
                            ValueMetaData aemd = null;
                            if (Map.class.isAssignableFrom(member.getType())) {
                                aemd = new ValueMetaData();
                                mmd.setValueMetaData(aemd);
                            } else {
                                aemd = new ElementMetaData();
                                mmd.setElementMetaData((ElementMetaData)aemd);
                            }
                            for (int j = 0; j < elementColumns.size(); ++j) {
                                ColumnMetaData colmd3 = new ColumnMetaData();
                                colmd3.setName(((JoinColumn)elementColumns.get(j)).name());
                                colmd3.setTarget(((JoinColumn)elementColumns.get(j)).referencedColumnName());
                                colmd3.setAllowsNull(Boolean.valueOf(((JoinColumn)elementColumns.get(j)).nullable()));
                                aemd.addColumn(colmd3);
                            }
                        }
                        if (annotationValues.containsKey("inverseForeignKey") && (fk = (ForeignKey)annotationValues.get("inverseForeignKey")).value() == ConstraintMode.CONSTRAINT) {
                            ForeignKeyMetaData fkmd5 = mmd.newForeignKeyMetaData();
                            fkmd5.setName(fk.name());
                            fkmd5.setFkDefinition(fk.foreignKeyDefinition());
                        }
                        if ((joinUniqueConstraints = (UniqueConstraint[])annotationValues.get("uniqueConstraints")) != null && joinUniqueConstraints.length > 0) {
                            for (int j = 0; j < joinUniqueConstraints.length; ++j) {
                                UniqueMetaData unimd = new UniqueMetaData();
                                uniName = joinUniqueConstraints[j].name();
                                if (!StringUtils.isWhitespace((String)uniName)) {
                                    unimd.setName(uniName);
                                }
                                for (int k2 = 0; k2 < joinUniqueConstraints[j].columnNames().length; ++k2) {
                                    unimd.addColumn(joinUniqueConstraints[j].columnNames()[k2]);
                                }
                                joinmd.setUniqueMetaData(unimd);
                            }
                        }
                        if ((joinIndexConstrs = (Index[])annotationValues.get("indexes")) == null || joinIndexConstrs.length <= 0) continue;
                        for (int j = 0; j < joinIndexConstrs.length; ++j) {
                            idxmd = new IndexMetaData();
                            String idxName = joinIndexConstrs[j].name();
                            if (!StringUtils.isWhitespace((String)idxName)) {
                                idxmd.setName(idxName);
                            }
                            if ((cols = StringUtils.split((String)(colStr = joinIndexConstrs[j].columnList()), (String)",")) != null) {
                                for (k = 0; k < cols.length; ++k) {
                                    idxmd.addColumn(cols[k]);
                                }
                            }
                            if (joinIndexConstrs[j].unique()) {
                                idxmd.setUnique(true);
                            }
                            joinmd.setIndexMetaData(idxmd);
                        }
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.COLLECTION_TABLE)) {
                        UniqueConstraint[] joinUniqueConstraints;
                        ForeignKey fk;
                        String catalogName;
                        tableName = (String)annotationValues.get("name");
                        if (!StringUtils.isWhitespace((String)tableName)) {
                            mmd.setTable(tableName);
                        }
                        if (!StringUtils.isWhitespace((String)(catalogName = (String)annotationValues.get("catalog")))) {
                            mmd.setCatalog(catalogName);
                        }
                        if (!StringUtils.isWhitespace((String)(schemaName = (String)annotationValues.get("schema")))) {
                            mmd.setSchema(schemaName);
                        }
                        if ((joinmd = mmd.getJoinMetaData()) == null) {
                            joinmd = new JoinMetaData();
                            mmd.setJoinMetaData(joinmd);
                        }
                        if (annotationValues.get("joinColumns") != null) {
                            ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>();
                            joinColumns.addAll(Arrays.asList((JoinColumn[])annotationValues.get("joinColumns")));
                            for (int j = 0; j < joinColumns.size(); ++j) {
                                ColumnMetaData colmd4 = new ColumnMetaData();
                                colmd4.setName(((JoinColumn)joinColumns.get(j)).name());
                                colmd4.setTarget(((JoinColumn)joinColumns.get(j)).referencedColumnName());
                                colmd4.setAllowsNull(Boolean.valueOf(((JoinColumn)joinColumns.get(j)).nullable()));
                                joinmd.addColumn(colmd4);
                            }
                        }
                        if (annotationValues.containsKey("foreignKey") && (fk = (ForeignKey)annotationValues.get("foreignKey")).value() == ConstraintMode.CONSTRAINT) {
                            ForeignKeyMetaData fkmd6 = joinmd.newForeignKeyMetaData();
                            fkmd6.setName(fk.name());
                            fkmd6.setFkDefinition(fk.foreignKeyDefinition());
                        }
                        if ((joinUniqueConstraints = (UniqueConstraint[])annotationValues.get("uniqueConstraints")) != null && joinUniqueConstraints.length > 0) {
                            for (int j = 0; j < joinUniqueConstraints.length; ++j) {
                                UniqueMetaData unimd = new UniqueMetaData();
                                uniName = joinUniqueConstraints[j].name();
                                if (!StringUtils.isWhitespace((String)uniName)) {
                                    unimd.setName(uniName);
                                }
                                for (int k3 = 0; k3 < joinUniqueConstraints[j].columnNames().length; ++k3) {
                                    unimd.addColumn(joinUniqueConstraints[j].columnNames()[k3]);
                                }
                                joinmd.setUniqueMetaData(unimd);
                            }
                        }
                        if ((joinIndexConstrs = (Index[])annotationValues.get("indexes")) == null || joinIndexConstrs.length <= 0) continue;
                        for (int j = 0; j < joinIndexConstrs.length; ++j) {
                            idxmd = new IndexMetaData();
                            String idxName = joinIndexConstrs[j].name();
                            if (!StringUtils.isWhitespace((String)idxName)) {
                                idxmd.setName(idxName);
                            }
                            if ((cols = StringUtils.split((String)(colStr = joinIndexConstrs[j].columnList()), (String)",")) != null) {
                                for (k = 0; k < cols.length; ++k) {
                                    idxmd.addColumn(cols[k]);
                                }
                            }
                            if (joinIndexConstrs[j].unique()) {
                                idxmd.setUnique(true);
                            }
                            joinmd.setIndexMetaData(idxmd);
                        }
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.MAP_KEY_CLASS)) {
                        MapMetaData mapmd = mmd.getMap();
                        if (mmd.getMap() == null) {
                            mapmd = mmd.newMapMetaData();
                        }
                        mapmd.setKeyType(((Class)annotationValues.get("value")).getName());
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.MAP_KEY_COLUMN)) {
                        if (keymd == null) {
                            keymd = new KeyMetaData();
                            mmd.setKeyMetaData(keymd);
                        }
                        keyType = mmd.getMap() != null && mmd.getMap().getKeyType() != null ? this.clr.classForName(mmd.getMap().getKeyType()) : Object.class;
                        keymd.addColumn(this.newColumnMetaDataForAnnotation((MetaData)keymd, keyType, annotationValues));
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.MAP_KEY_JOIN_COLUMNS)) {
                        NucleusLogger.METADATA.debug((Object)"We do not currently support @MapKeyJoinColumns");
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.MAP_KEY_JOIN_COLUMN)) {
                        if (keymd == null) {
                            keymd = new KeyMetaData();
                            mmd.setKeyMetaData(keymd);
                        }
                        keyType = mmd.getMap() != null && mmd.getMap().getKeyType() != null ? this.clr.classForName(mmd.getMap().getKeyType()) : Object.class;
                        keymd.addColumn(this.newColumnMetaDataForAnnotation((MetaData)keymd, keyType, annotationValues));
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.MAP_KEY)) {
                        String keyMappedBy = (String)annotationValues.get("name");
                        if (keyMappedBy == null) continue;
                        if (keymd == null) {
                            keymd = new KeyMetaData();
                            mmd.setKeyMetaData(keymd);
                        }
                        keymd.setMappedBy(keyMappedBy);
                        if (mmd.getMap() == null || mmd.getMap().getKeyType() != null && !mmd.getMap().getKeyType().equals(Object.class.getName())) continue;
                        String valueType = mmd.getMap().getValueType();
                        try {
                            Class cls = this.clr.classForName(valueType);
                            try {
                                Field fld = cls.getDeclaredField(keyMappedBy);
                                mmd.getMap().setKeyType(fld.getType().getName());
                            }
                            catch (NoSuchFieldException nsfe) {
                                try {
                                    String getterName = ClassUtils.getJavaBeanGetterName((String)keyMappedBy, (boolean)false);
                                    Method mthd = cls.getDeclaredMethod(getterName, null);
                                    mmd.getMap().setKeyType(mthd.getReturnType().getName());
                                }
                                catch (NoSuchMethodException getterName) {
                                }
                            }
                        }
                        catch (Exception cls) {}
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.MAP_KEY_ENUMERATED)) {
                        type = (EnumType)annotationValues.get("value");
                        if (keymd == null) {
                            keymd = new KeyMetaData();
                            mmd.setKeyMetaData(keymd);
                        }
                        ColumnMetaData colmd5 = keymd.newColumnMetaData();
                        colmd5.setJdbcType(type == EnumType.STRING ? "VARCHAR" : "INTEGER");
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.MAP_KEY_TEMPORAL)) {
                        type = (TemporalType)annotationValues.get("value");
                        String jdbcType = null;
                        if (type == TemporalType.DATE) {
                            jdbcType = "DATE";
                        } else if (type == TemporalType.TIME) {
                            jdbcType = "TIME";
                        } else if (type == TemporalType.TIMESTAMP) {
                            jdbcType = "TIMESTAMP";
                        }
                        if (keymd == null) {
                            keymd = new KeyMetaData();
                            mmd.setKeyMetaData(keymd);
                        }
                        ColumnMetaData colmd6 = keymd.newColumnMetaData();
                        colmd6.setJdbcType(jdbcType);
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.ORDER_BY)) {
                        if (mmd.getOrderMetaData() != null) {
                            throw new NucleusException("@OrderBy found yet field=" + cmd.getFullClassName() + "." + member.getName() + " already has ordering information!");
                        }
                        String orderBy = (String)annotationValues.get("value");
                        if (orderBy == null) continue;
                        OrderMetaData ordmd = new OrderMetaData();
                        ordmd.setOrdering(orderBy);
                        mmd.setOrderMetaData(ordmd);
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.ORDER_COLUMN)) {
                        if (mmd.getOrderMetaData() != null) {
                            throw new NucleusException("@OrderColumn found yet field=" + cmd.getFullClassName() + "." + member.getName() + " already has ordering information!");
                        }
                        String columnName = (String)annotationValues.get("name");
                        OrderMetaData ordermd = new OrderMetaData();
                        ordermd.setColumnName(columnName);
                        String colNullable = null;
                        String colInsertable = null;
                        String colUpdateable = null;
                        if (annotationValues.get("nullable") != null) {
                            colNullable = annotationValues.get("nullable").toString();
                        }
                        if (annotationValues.get("insertable") != null) {
                            colInsertable = annotationValues.get("insertable").toString();
                        }
                        if (annotationValues.get("updatable") != null) {
                            colUpdateable = annotationValues.get("updatable").toString();
                        }
                        ColumnMetaData colmd7 = new ColumnMetaData();
                        colmd7.setName(columnName);
                        colmd7.setAllowsNull(colNullable);
                        colmd7.setInsertable(colInsertable);
                        colmd7.setUpdateable(colUpdateable);
                        String tmp = (String)annotationValues.get("columnDefinition");
                        if (!StringUtils.isWhitespace((String)tmp)) {
                            colmd7.setColumnDdl(tmp);
                        }
                        ordermd.addColumn(colmd7);
                        mmd.setOrderMetaData(ordermd);
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.ONE_TO_MANY)) {
                        oneToMany = true;
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.MANY_TO_MANY)) {
                        manyToMany = true;
                        continue;
                    }
                    if (annName.equals(JPAAnnotationUtils.ACCESS)) continue;
                    if (annName.equals(JPAAnnotationUtils.CONVERTS)) {
                        Convert[] converts;
                        if (!this.isPersistenceContext() || (converts = (Convert[])annotationValues.get("value")) == null || converts.length == 0) continue;
                        if (converts.length > 1) {
                            NucleusLogger.METADATA.warn((Object)"Dont currently support @Converts annotation for embedded fields");
                            continue;
                        }
                        if (converts.length != 1) continue;
                        Class converterCls = converts[0].converter();
                        String convAttrName = converts[0].attributeName();
                        boolean disable = converts[0].disableConversion();
                        if (disable) {
                            mmd.setTypeConverterDisabled();
                            continue;
                        }
                        TypeManager typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr.getTypeConverterForName(converterCls.getName()) == null) {
                            AttributeConverter entityConv = JPATypeConverterUtils.createAttributeConverterInstance(this.mmgr.getNucleusContext(), converterCls);
                            Class attrType = member.getType();
                            if ("key".equals(convAttrName)) {
                                attrType = ClassUtils.getMapKeyType((Class)member.getType(), (Type)member.getGenericType());
                            } else if ("value".equals(convAttrName)) {
                                attrType = ClassUtils.getMapValueType((Class)member.getType(), (Type)member.getGenericType());
                            } else if (!StringUtils.isWhitespace((String)convAttrName) && Collection.class.isAssignableFrom(member.getType())) {
                                attrType = ClassUtils.getCollectionElementType((Class)member.getType(), (Type)member.getGenericType());
                            }
                            Class dbType = JPATypeConverterUtils.getDatabaseTypeForAttributeConverter(converterCls, attrType, null);
                            JPATypeConverter conv = new JPATypeConverter(entityConv);
                            typeMgr.registerConverter(converterCls.getName(), conv, attrType, dbType, false, null);
                        }
                        if (StringUtils.isWhitespace((String)convAttrName)) {
                            if (Collection.class.isAssignableFrom(member.getType())) {
                                if (elemmd == null) {
                                    elemmd = new ElementMetaData();
                                    mmd.setElementMetaData(elemmd);
                                }
                                elemmd.addExtension("type-converter-name", converterCls.getName());
                                continue;
                            }
                            mmd.setTypeConverterName(converterCls.getName());
                            continue;
                        }
                        if ("key".equals(convAttrName)) {
                            if (keymd == null) {
                                keymd = new KeyMetaData();
                                mmd.setKeyMetaData(keymd);
                            }
                            keymd.addExtension("type-converter-name", converterCls.getName());
                            continue;
                        }
                        if ("value".equals(convAttrName)) {
                            if (valmd == null) {
                                valmd = new ValueMetaData();
                                mmd.setValueMetaData(valmd);
                            }
                            valmd.addExtension("type-converter-name", converterCls.getName());
                            continue;
                        }
                        NucleusLogger.METADATA.warn((Object)("Field " + mmd.getFullFieldName() + " has @Convert annotation for attribute " + convAttrName + " but this is not yet fully supported. Ignored"));
                        continue;
                    }
                    if (!annName.equals(JPAAnnotationUtils.CONVERT) || !this.isPersistenceContext()) continue;
                    Class converterCls = (Class)annotationValues.get("converter");
                    String convAttrName = (String)annotationValues.get("attributeName");
                    Boolean disable = (Boolean)annotationValues.get("disableConversion");
                    Class attrType = null;
                    Class dbType = null;
                    if (disable == Boolean.TRUE) continue;
                    TypeManager typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                    JPATypeConverter conv = typeMgr.getTypeConverterForName(converterCls.getName());
                    if (typeMgr.getTypeConverterForName(converterCls.getName()) == null) {
                        AttributeConverter entityConv = JPATypeConverterUtils.createAttributeConverterInstance(this.mmgr.getNucleusContext(), converterCls);
                        attrType = member.getType();
                        if (Map.class.isAssignableFrom(member.getType())) {
                            if ("key".equals(convAttrName)) {
                                attrType = ClassUtils.getMapKeyType((Class)member.getType(), (Type)member.getGenericType());
                            } else if ("value".equals(convAttrName)) {
                                attrType = ClassUtils.getMapValueType((Class)member.getType(), (Type)member.getGenericType());
                            }
                        } else if (Collection.class.isAssignableFrom(member.getType())) {
                            attrType = ClassUtils.getCollectionElementType((Class)member.getType(), (Type)member.getGenericType());
                        }
                        dbType = JPATypeConverterUtils.getDatabaseTypeForAttributeConverter(converterCls, attrType, null);
                        if (dbType == null && Collection.class.isAssignableFrom(member.getType())) {
                            attrType = member.getType();
                            dbType = JPATypeConverterUtils.getDatabaseTypeForAttributeConverter(converterCls, attrType, null);
                        }
                        conv = new JPATypeConverter(entityConv);
                        typeMgr.registerConverter(converterCls.getName(), conv, attrType, dbType, false, null);
                    } else {
                        attrType = typeMgr.getMemberTypeForTypeConverter((TypeConverter)conv, dbType);
                        dbType = typeMgr.getDatastoreTypeForTypeConverter((TypeConverter)conv, attrType);
                    }
                    if (StringUtils.isWhitespace((String)convAttrName)) {
                        if (Collection.class.isAssignableFrom(member.getType()) && !Collection.class.isAssignableFrom(attrType)) {
                            if (elemmd == null) {
                                elemmd = new ElementMetaData();
                                mmd.setElementMetaData(elemmd);
                            }
                            elemmd.addExtension("type-converter-name", converterCls.getName());
                            continue;
                        }
                        mmd.setTypeConverterName(converterCls.getName());
                        continue;
                    }
                    if ("key".equals(convAttrName)) {
                        if (keymd == null) {
                            keymd = new KeyMetaData();
                            mmd.setKeyMetaData(keymd);
                        }
                        keymd.addExtension("type-converter-name", converterCls.getName());
                        continue;
                    }
                    if ("value".equals(convAttrName)) {
                        if (valmd == null) {
                            valmd = new ValueMetaData();
                            mmd.setValueMetaData(valmd);
                        }
                        valmd.addExtension("type-converter-name", converterCls.getName());
                        continue;
                    }
                    NucleusLogger.METADATA.warn((Object)("Field " + mmd.getFullFieldName() + " has @Convert annotation for attribute " + convAttrName + " but this is not yet fully supported. Ignored"));
                }
                if (oneToMany && mmd.getJoinMetaData() == null && mmd.getMappedBy() == null && columnMetaData == null) {
                    joinmd = new JoinMetaData();
                    mmd.setJoinMetaData(joinmd);
                }
                if (manyToMany && mmd.getJoinMetaData() == null && mmd.getMappedBy() == null) {
                    joinmd = new JoinMetaData();
                    mmd.setJoinMetaData(joinmd);
                }
                if (mmd.getOrderMetaData() == null && Collection.class.isAssignableFrom(member.getType())) {
                    OrderMetaData ordmd = new OrderMetaData();
                    ordmd.setOrdering("#PK");
                    mmd.setOrderMetaData(ordmd);
                }
                if (columnMetaData == null && (colmd = this.newColumnMetaData(mmd, member, annotations)) != null) {
                    columnMetaData = new ColumnMetaData[]{colmd};
                }
                if (columnMetaData != null) {
                    boolean elementCollection = false;
                    for (AnnotationObject annotation : annotations) {
                        String annName = annotation.getName();
                        if (!annName.equals(JPAAnnotationUtils.ELEMENT_COLLECTION)) continue;
                        elementCollection = true;
                        break;
                    }
                    if ((mmd.hasCollection() || mmd.hasArray()) && joinmd == null) {
                        elemmd = mmd.getElementMetaData();
                        if (elemmd == null) {
                            elemmd = new ElementMetaData();
                            mmd.setElementMetaData(elemmd);
                        }
                        if (columnTable != null) {
                            elemmd.setTable(columnTable);
                        }
                        for (int i = 0; i < columnMetaData.length; ++i) {
                            elemmd.addColumn(columnMetaData[i]);
                        }
                    } else if (mmd.hasMap() && joinmd == null) {
                        valmd = mmd.getValueMetaData();
                        if (valmd == null) {
                            valmd = new ValueMetaData();
                            mmd.setValueMetaData(valmd);
                        }
                        if (columnTable != null) {
                            valmd.setTable(columnTable);
                        }
                        for (int i = 0; i < columnMetaData.length; ++i) {
                            valmd.addColumn(columnMetaData[i]);
                        }
                    } else if (elementCollection) {
                        if (mmd.hasCollection() || mmd.hasArray()) {
                            elemmd = mmd.getElementMetaData();
                            if (elemmd == null) {
                                elemmd = new ElementMetaData();
                                mmd.setElementMetaData(elemmd);
                            }
                            for (int i = 0; i < columnMetaData.length; ++i) {
                                elemmd.addColumn(columnMetaData[i]);
                            }
                        } else if (mmd.hasMap()) {
                            valmd = mmd.getValueMetaData();
                            if (valmd == null) {
                                valmd = new ValueMetaData();
                                mmd.setValueMetaData(valmd);
                            }
                            for (int i = 0; i < columnMetaData.length; ++i) {
                                valmd.addColumn(columnMetaData[i]);
                            }
                        }
                    } else {
                        for (int i = 0; i < columnMetaData.length; ++i) {
                            mmd.addColumn(columnMetaData[i]);
                        }
                    }
                }
            }
            return mmd;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processEmbeddedAttributeOverride(AbstractMemberMetaData mmd, String overriddenName, Class type, Column column) {
        EmbeddedMetaData embmd;
        String overrideName;
        block24: {
            block25: {
                block23: {
                    overrideName = overriddenName;
                    embmd = null;
                    if (!mmd.hasCollection()) break block23;
                    type = this.clr.classForName(mmd.getCollection().getElementType());
                    ElementMetaData elemmd = mmd.getElementMetaData();
                    if (elemmd == null) {
                        elemmd = new ElementMetaData();
                        mmd.setElementMetaData(elemmd);
                    }
                    if ((embmd = elemmd.getEmbeddedMetaData()) == null) {
                        embmd = elemmd.newEmbeddedMetaData();
                    }
                    break block24;
                }
                if (!mmd.hasMap()) break block25;
                if (overrideName.startsWith("key.")) {
                    overrideName = overrideName.substring(4);
                    type = this.clr.classForName(mmd.getMap().getKeyType());
                    KeyMetaData keymd = mmd.getKeyMetaData();
                    if (keymd == null) {
                        keymd = new KeyMetaData();
                        mmd.setKeyMetaData(keymd);
                    }
                    if ((embmd = keymd.getEmbeddedMetaData()) == null) {
                        embmd = keymd.newEmbeddedMetaData();
                    }
                    break block24;
                } else {
                    if (!overrideName.startsWith("value.")) {
                        NucleusLogger.METADATA.warn((Object)("Attempt to override '" + overriddenName + "' on Map field. Should prefix key field(s) with 'key.' and value fields with 'value.'"));
                        return;
                    }
                    overrideName = overrideName.substring(6);
                    type = this.clr.classForName(mmd.getMap().getValueType());
                    ValueMetaData valmd = mmd.getValueMetaData();
                    if (valmd == null) {
                        valmd = new ValueMetaData();
                        mmd.setValueMetaData(valmd);
                    }
                    if ((embmd = valmd.getEmbeddedMetaData()) == null) {
                        embmd = valmd.newEmbeddedMetaData();
                    }
                }
                break block24;
            }
            embmd = mmd.getEmbeddedMetaData();
            if (embmd == null) {
                mmd.setEmbedded(true);
                embmd = new EmbeddedMetaData();
                embmd.setParent((MetaData)mmd);
            }
            mmd.setEmbeddedMetaData(embmd);
        }
        if (overrideName.indexOf(46) > 0) {
            AccessibleObject overrideMember2;
            int position = overrideName.indexOf(46);
            String string = overrideName.substring(0, position);
            String nestedMemberName = overrideName.substring(position + 1);
            FieldMetaData ammd = null;
            try {
                overrideMember2 = type.getDeclaredField(string);
                ammd = new FieldMetaData((MetaData)embmd, string);
                type = ((Field)overrideMember2).getType();
            }
            catch (Exception overrideMember2) {
                // empty catch block
            }
            if (ammd == null) {
                try {
                    overrideMember2 = type.getDeclaredMethod(ClassUtils.getJavaBeanGetterName((String)string, (boolean)false), new Class[0]);
                    ammd = new FieldMetaData((MetaData)embmd, string);
                    type = ((Method)overrideMember2).getReturnType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ammd == null) {
                throw new NucleusException("Cannot obtain override field/property " + overrideName + " of class " + type + " for persistent class " + mmd.getClassName(true));
            }
            embmd.addMember(ammd);
            ammd.setParent((MetaData)embmd);
            this.processEmbeddedAttributeOverride((AbstractMemberMetaData)ammd, nestedMemberName, type, column);
            return;
        }
        Member overriddenMember = null;
        Object var8_10 = null;
        FieldMetaData ammd = null;
        try {
            Field field = type.getDeclaredField(overrideName);
            overriddenMember = new Member(field);
            ammd = new FieldMetaData((MetaData)embmd, overrideName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ammd == null) {
            try {
                Method method = type.getDeclaredMethod(ClassUtils.getJavaBeanGetterName((String)overrideName, (boolean)false), new Class[0]);
                overriddenMember = new Member(method);
                ammd = new PropertyMetaData((MetaData)embmd, overrideName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ammd == null) {
            throw new NucleusException("Cannot obtain override field/property " + overrideName + " of class " + type + " for persistent class " + mmd.getClassName(true));
        }
        embmd.addMember(ammd);
        ammd.addColumn(JPAAnnotationUtils.getColumnMetaDataForColumnAnnotation(ammd, overriddenMember, column));
    }

    protected void processMethodAnnotations(AbstractClassMetaData cmd, Method method) {
        Annotation[] annotations = method.getAnnotations();
        if (annotations != null && annotations.length > 0) {
            EventListenerMetaData elmd = cmd.getListenerForClass(cmd.getFullClassName());
            for (Annotation annotation : annotations) {
                String annotationTypeName = annotation.annotationType().getName();
                if (!annotationTypeName.equals(PrePersist.class.getName()) && !annotationTypeName.equals(PostPersist.class.getName()) && !annotationTypeName.equals(PreRemove.class.getName()) && !annotationTypeName.equals(PostRemove.class.getName()) && !annotationTypeName.equals(PreUpdate.class.getName()) && !annotationTypeName.equals(PostUpdate.class.getName()) && !annotationTypeName.equals(PostLoad.class.getName())) continue;
                if (elmd == null) {
                    elmd = new EventListenerMetaData(cmd.getFullClassName());
                    cmd.addListener(elmd);
                }
                elmd.addCallback(annotationTypeName, method.getDeclaringClass().getName(), method.getName());
            }
        }
    }

    private AbstractMemberMetaData newMetaDataForMember(AbstractClassMetaData cmd, Member field, AnnotationObject[] annotations) {
        PropertyMetaData mmd = field.isProperty() ? new PropertyMetaData((MetaData)cmd, field.getName()) : new FieldMetaData((MetaData)cmd, field.getName());
        FieldPersistenceModifier modifier = null;
        Class targetEntity = null;
        for (AnnotationObject annotation : annotations) {
            String annName = annotation.getName();
            Map annotationValues = annotation.getNameValueMap();
            if (annName.equals(JPAAnnotationUtils.EMBEDDED)) {
                mmd.setEmbedded(true);
                this.setCascadesOnMember((AbstractMemberMetaData)mmd, new CascadeType[]{CascadeType.ALL});
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ID)) {
                mmd.setPrimaryKey(true);
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.TRANSIENT)) {
                modifier = FieldPersistenceModifier.NONE;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ENUMERATED)) {
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.VERSION)) {
                VersionMetaData vermd = cmd.newVersionMetadata();
                vermd.setStrategy(VersionStrategy.VERSION_NUMBER).setFieldName(mmd.getName());
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EMBEDDED_ID)) {
                mmd.setPrimaryKey(true);
                mmd.setEmbedded(true);
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.BASIC)) {
                FetchType fetch = (FetchType)annotationValues.get("fetch");
                mmd.setDefaultFetchGroup((fetch == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE).booleanValue());
                modifier = FieldPersistenceModifier.PERSISTENT;
                if (field.getType().isPrimitive()) continue;
                boolean optional = (Boolean)annotationValues.get("optional");
                String nullValue = optional ? "none" : "exception";
                mmd.setNullValue(NullValue.getNullValue((String)nullValue));
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ONE_TO_ONE)) {
                modifier = FieldPersistenceModifier.PERSISTENT;
                mmd.setMappedBy((String)annotationValues.get("mappedBy"));
                mmd.setRelationTypeString("OneToOne");
                mmd.setCascadeRemoveOrphans(((Boolean)annotationValues.get("orphanRemoval")).booleanValue());
                this.setCascadesOnMember((AbstractMemberMetaData)mmd, (CascadeType[])annotationValues.get("cascade"));
                mmd.setDefaultFetchGroup((annotationValues.get("fetch") == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE).booleanValue());
                mmd.setNullValue(NullValue.getNullValue((String)((Boolean)annotationValues.get("optional") != false ? "none" : "exception")));
                if (StringUtils.isWhitespace((String)mmd.getMappedBy())) {
                    mmd.setUnique(true);
                }
                targetEntity = (Class)annotationValues.get("targetEntity");
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ONE_TO_MANY)) {
                modifier = FieldPersistenceModifier.PERSISTENT;
                mmd.setMappedBy((String)annotationValues.get("mappedBy"));
                mmd.setRelationTypeString("OneToMany");
                mmd.setCascadeRemoveOrphans(((Boolean)annotationValues.get("orphanRemoval")).booleanValue());
                this.setCascadesOnMember((AbstractMemberMetaData)mmd, (CascadeType[])annotationValues.get("cascade"));
                mmd.setDefaultFetchGroup((annotationValues.get("fetch") == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE).booleanValue());
                targetEntity = (Class)annotationValues.get("targetEntity");
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.MANY_TO_MANY)) {
                modifier = FieldPersistenceModifier.PERSISTENT;
                mmd.setMappedBy((String)annotationValues.get("mappedBy"));
                mmd.setRelationTypeString("ManyToMany");
                this.setCascadesOnMember((AbstractMemberMetaData)mmd, (CascadeType[])annotationValues.get("cascade"));
                mmd.setDefaultFetchGroup((annotationValues.get("fetch") == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE).booleanValue());
                targetEntity = (Class)annotationValues.get("targetEntity");
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.MANY_TO_ONE)) {
                modifier = FieldPersistenceModifier.PERSISTENT;
                mmd.setMappedBy((String)annotationValues.get("mappedBy"));
                mmd.setRelationTypeString("ManyToOne");
                this.setCascadesOnMember((AbstractMemberMetaData)mmd, (CascadeType[])annotationValues.get("cascade"));
                mmd.setDefaultFetchGroup((annotationValues.get("fetch") == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE).booleanValue());
                mmd.setNullValue(NullValue.getNullValue((String)((Boolean)annotationValues.get("optional") != false ? "none" : "exception")));
                targetEntity = (Class)annotationValues.get("targetEntity");
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.MAPS_ID)) {
                mmd.setMapsIdAttribute((String)annotationValues.get("value"));
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ELEMENT_COLLECTION)) {
                modifier = FieldPersistenceModifier.PERSISTENT;
                this.setCascadesOnMember((AbstractMemberMetaData)mmd, new CascadeType[]{CascadeType.ALL});
                mmd.setDefaultFetchGroup((annotationValues.get("fetch") == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE).booleanValue());
                if (mmd.getJoinMetaData() == null) {
                    JoinMetaData joinmd = new JoinMetaData();
                    mmd.setJoinMetaData(joinmd);
                }
                targetEntity = (Class)annotationValues.get("targetClass");
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.GENERATED_VALUE)) {
                GenerationType type = (GenerationType)annotationValues.get("strategy");
                String valueStrategy = JPAAnnotationUtils.getValueGenerationStrategyString(type);
                String valueGenerator = (String)annotationValues.get("generator");
                if (valueStrategy == null) continue;
                mmd.setValueStrategy(valueStrategy);
                if (valueGenerator == null) continue;
                mmd.setSequence(valueGenerator);
                mmd.setValueGeneratorName(valueGenerator);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.LOB)) {
                mmd.setStoreInLob();
                modifier = FieldPersistenceModifier.PERSISTENT;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EXTENSION)) {
                mmd.addExtension((String)annotationValues.get("key"), (String)annotationValues.get("value"));
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EXTENSIONS)) {
                Extension[] values = (Extension[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                for (Extension ext : values) {
                    mmd.addExtension(ext.key().toString(), ext.value().toString());
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.SEQUENCE_GENERATOR)) {
                this.processSequenceGeneratorAnnotation(cmd.getPackageMetaData(), annotationValues);
                continue;
            }
            if (!annName.equals(JPAAnnotationUtils.TABLE_GENERATOR)) continue;
            this.processTableGeneratorAnnotation(cmd.getPackageMetaData(), annotationValues);
        }
        if (this.mmgr.getApiAdapter().isMemberDefaultPersistent(field.getType()) && modifier == null) {
            modifier = FieldPersistenceModifier.PERSISTENT;
        }
        if (modifier != null) {
            mmd.setPersistenceModifier(modifier);
        }
        cmd.addMember((AbstractMemberMetaData)mmd);
        ContainerHandler containerHandler = this.mmgr.getNucleusContext().getTypeManager().getContainerHandler(field.getType());
        ContainerMetaData contmd = null;
        if (containerHandler != null) {
            contmd = containerHandler.newMetaData();
        }
        if (contmd instanceof CollectionMetaData) {
            String elementType = null;
            if (targetEntity != null && targetEntity != Void.TYPE) {
                elementType = targetEntity.getName();
            }
            if (elementType == null) {
                Class elType = ClassUtils.getCollectionElementType((Class)field.getType(), (Type)field.getGenericType());
                elementType = elType != null ? elType.getName() : null;
            }
            ((CollectionMetaData)contmd).setElementType(elementType);
        } else if (contmd instanceof MapMetaData) {
            Class keyCls = ClassUtils.getMapKeyType((Class)field.getType(), (Type)field.getGenericType());
            String keyType = keyCls != null ? keyCls.getName() : null;
            String valueType = null;
            if (targetEntity != null && targetEntity != Void.TYPE) {
                valueType = targetEntity.getName();
            }
            if (valueType == null) {
                Class valueCls = ClassUtils.getMapValueType((Class)field.getType(), (Type)field.getGenericType());
                valueType = valueCls != null ? valueCls.getName() : null;
            }
            contmd = new MapMetaData();
            MapMetaData mapmd = (MapMetaData)contmd;
            mapmd.setKeyType(keyType);
            mapmd.setValueType(valueType);
        } else if (contmd instanceof ArrayMetaData) {
            String elementType = null;
            if (targetEntity != null && targetEntity != Void.TYPE) {
                elementType = targetEntity.getName();
            }
            if (elementType == null) {
                elementType = field.getType().getComponentType().getName();
            }
            ((ArrayMetaData)contmd).setElementType(elementType);
        }
        if (contmd != null) {
            mmd.setContainer(contmd);
        }
        return mmd;
    }

    private void setCascadesOnMember(AbstractMemberMetaData mmd, CascadeType[] cascades) {
        if (cascades != null) {
            for (int i = 0; i < cascades.length; ++i) {
                if (cascades[i] == CascadeType.ALL) {
                    mmd.setCascadePersist(true);
                    mmd.setCascadeUpdate(true);
                    mmd.setCascadeDelete(true);
                    mmd.setCascadeDetach(true);
                    mmd.setCascadeRefresh(true);
                    continue;
                }
                if (cascades[i] == CascadeType.PERSIST) {
                    mmd.setCascadePersist(true);
                    continue;
                }
                if (cascades[i] == CascadeType.MERGE) {
                    mmd.setCascadeUpdate(true);
                    continue;
                }
                if (cascades[i] == CascadeType.REMOVE) {
                    mmd.setCascadeDelete(true);
                    continue;
                }
                if (cascades[i] == CascadeType.REFRESH) {
                    mmd.setCascadeRefresh(true);
                    continue;
                }
                if (cascades[i] != CascadeType.DETACH) continue;
                mmd.setCascadeDetach(true);
            }
        }
    }

    private ColumnMetaData newColumnMetaDataForAnnotation(MetaData parent, Class fieldType, Map<String, Object> annotationValues) {
        String tmp;
        String columnTable;
        int scaleValue;
        int precisionValue;
        String columnName = null;
        String target = null;
        String targetField = null;
        String jdbcType = null;
        String sqlType = null;
        String typePrecision = null;
        String typeLength = null;
        String typeScale = null;
        String allowsNull = null;
        String defaultValue = null;
        String insertValue = null;
        String insertable = null;
        String updateable = null;
        String unique = null;
        String table = null;
        String columnDdl = null;
        columnName = (String)annotationValues.get("name");
        typeLength = "" + annotationValues.get("length");
        if (annotationValues.get("precision") != null && (precisionValue = ((Integer)annotationValues.get("precision")).intValue()) != 0) {
            typePrecision = "" + precisionValue;
        }
        if (annotationValues.get("scale") != null && (scaleValue = ((Integer)annotationValues.get("scale")).intValue()) != 0) {
            typeScale = "" + scaleValue;
        }
        if (fieldType == Character.TYPE || fieldType == Character.class) {
            jdbcType = "CHAR";
            typeLength = "1";
        } else if ((fieldType == Boolean.TYPE || fieldType == Boolean.class) && this.mmgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.jpa.legacy.mapBooleanToSmallint", false)) {
            String memberName = "unknown";
            if (parent instanceof AbstractMemberMetaData) {
                memberName = ((AbstractMemberMetaData)parent).getFullFieldName();
            }
            NucleusLogger.METADATA.info((Object)("Member " + memberName + " has column of type " + fieldType.getName() + " and being mapped to SMALLINT JDBC type. This is deprecated and could be removed in the future. Use @JdbcType instead"));
            jdbcType = "SMALLINT";
        }
        if (annotationValues.get("nullable") != null) {
            allowsNull = annotationValues.get("nullable").toString();
        }
        if (annotationValues.get("insertable") != null) {
            insertable = annotationValues.get("insertable").toString();
        }
        if (annotationValues.get("updatable") != null) {
            updateable = annotationValues.get("updatable").toString();
        }
        if (annotationValues.get("unique") != null) {
            unique = annotationValues.get("unique").toString();
        }
        if (annotationValues.get("table") != null && !StringUtils.isWhitespace((String)(columnTable = (String)annotationValues.get("table")))) {
            table = columnTable;
        }
        if (!StringUtils.isWhitespace((String)(tmp = (String)annotationValues.get("columnDefinition")))) {
            columnDdl = tmp;
        }
        String length = null;
        String scale = null;
        if (Enum.class.isAssignableFrom(fieldType)) {
            if (jdbcType != null && jdbcType.equals("VARCHAR")) {
                length = typeLength;
            } else if (typePrecision != null) {
                length = typePrecision;
            }
        } else {
            length = String.class.isAssignableFrom(fieldType) || fieldType == Character.class || fieldType == Character.TYPE ? typeLength : (typePrecision != null ? typePrecision : typeLength);
            scale = typeScale;
        }
        if (columnName == null && length == null && scale == null && insertable == null && updateable == null && allowsNull == null && unique == null && jdbcType == null) {
            return null;
        }
        ColumnMetaData colmd = new ColumnMetaData();
        colmd.setName(columnName);
        colmd.setTarget(target);
        colmd.setTargetMember(targetField);
        colmd.setJdbcType(jdbcType);
        colmd.setSqlType(sqlType);
        colmd.setLength(length);
        colmd.setScale(scale);
        colmd.setAllowsNull(allowsNull);
        colmd.setDefaultValue(defaultValue);
        colmd.setInsertValue(insertValue);
        colmd.setInsertable(insertable);
        colmd.setUpdateable(updateable);
        colmd.setUnique(unique);
        if (columnDdl != null) {
            colmd.setColumnDdl(columnDdl);
        }
        if (parent instanceof AbstractMemberMetaData) {
            AbstractMemberMetaData apmd = (AbstractMemberMetaData)parent;
            if (!StringUtils.isWhitespace((String)table)) {
                apmd.setTable(table);
            }
            if (apmd.isPrimaryKey()) {
                colmd.setAllowsNull(Boolean.valueOf(false));
            }
        } else if (parent instanceof KeyMetaData) {
            KeyMetaData keymd = (KeyMetaData)parent;
            AbstractMemberMetaData mmd = (AbstractMemberMetaData)keymd.getParent();
            if (!StringUtils.isWhitespace((String)table)) {
                mmd.setTable(table);
            }
        }
        return colmd;
    }

    private ColumnMetaData newColumnMetaData(AbstractMemberMetaData mmd, Member member, AnnotationObject[] annotations) {
        Class fieldType = member.getType();
        if (mmd.getJoinMetaData() != null && !mmd.isSerialized()) {
            if (mmd.hasCollection() && Collection.class.isAssignableFrom(fieldType)) {
                if ((fieldType = ClassUtils.getCollectionElementType((Class)fieldType, (Type)member.getGenericType())) == null) {
                    fieldType = this.clr.classForName(mmd.getCollection().getElementType());
                }
            } else if (mmd.hasMap() && Map.class.isAssignableFrom(fieldType)) {
                if ((fieldType = ClassUtils.getMapValueType((Class)fieldType, (Type)member.getGenericType())) == null) {
                    fieldType = this.clr.classForName(mmd.getMap().getValueType());
                }
            } else if (mmd.hasArray() && fieldType.isArray() && (fieldType = fieldType.getComponentType()) == null) {
                fieldType = this.clr.classForName(mmd.getArray().getElementType());
            }
        }
        String columnName = null;
        String target = null;
        String targetField = null;
        String jdbcType = null;
        String sqlType = null;
        String typePrecision = null;
        String typeLength = null;
        String typeScale = null;
        String allowsNull = null;
        String defaultValue = null;
        String insertValue = null;
        String insertable = null;
        String updateable = null;
        String unique = null;
        String table = null;
        String columnDdl = null;
        for (int i = 0; annotations != null && i < annotations.length; ++i) {
            EnumType type;
            String annName = annotations[i].getName();
            Map annotationValues = annotations[i].getNameValueMap();
            if (annName.equals(JPAAnnotationUtils.COLUMN)) {
                String tmp;
                String columnTable;
                int scaleValue;
                int precisionValue;
                columnName = (String)annotationValues.get("name");
                typeLength = "" + annotationValues.get("length");
                if (annotationValues.get("precision") != null && (precisionValue = ((Integer)annotationValues.get("precision")).intValue()) != 0) {
                    typePrecision = "" + precisionValue;
                }
                if (annotationValues.get("scale") != null && (scaleValue = ((Integer)annotationValues.get("scale")).intValue()) != 0) {
                    typeScale = "" + scaleValue;
                }
                if (fieldType == Character.TYPE || fieldType == Character.class) {
                    jdbcType = "CHAR";
                    typeLength = "1";
                } else if ((fieldType == Boolean.TYPE || fieldType == Boolean.class) && this.mmgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.jpa.legacy.mapBooleanToSmallint", false)) {
                    String memberName = mmd.getFullFieldName();
                    NucleusLogger.METADATA.info((Object)("Member " + memberName + " has column of type " + fieldType.getName() + " and being mapped to SMALLINT JDBC type. This is deprecated and could be removed in the future. Use @JdbcType instead"));
                    jdbcType = "SMALLINT";
                }
                if (annotationValues.get("nullable") != null) {
                    allowsNull = annotationValues.get("nullable").toString();
                }
                if (annotationValues.get("insertable") != null) {
                    insertable = annotationValues.get("insertable").toString();
                }
                if (annotationValues.get("updatable") != null) {
                    updateable = annotationValues.get("updatable").toString();
                }
                if (annotationValues.get("unique") != null) {
                    unique = annotationValues.get("unique").toString();
                }
                if (annotationValues.get("table") != null && !StringUtils.isWhitespace((String)(columnTable = (String)annotationValues.get("table")))) {
                    table = columnTable;
                }
                if (StringUtils.isWhitespace((String)(tmp = (String)annotationValues.get("columnDefinition")))) continue;
                columnDdl = tmp;
                continue;
            }
            if (Enum.class.isAssignableFrom(fieldType) && annName.equals(JPAAnnotationUtils.ENUMERATED)) {
                type = (EnumType)annotationValues.get("value");
                jdbcType = type == EnumType.STRING ? "VARCHAR" : "INTEGER";
                continue;
            }
            if (!JPAAnnotationUtils.isTemporalType(fieldType) || !annName.equals(JPAAnnotationUtils.TEMPORAL)) continue;
            type = (TemporalType)annotationValues.get("value");
            if (type == TemporalType.DATE) {
                jdbcType = "DATE";
                continue;
            }
            if (type == TemporalType.TIME) {
                jdbcType = "TIME";
                continue;
            }
            if (type != TemporalType.TIMESTAMP) continue;
            jdbcType = "TIMESTAMP";
        }
        String length = null;
        String scale = null;
        if (Enum.class.isAssignableFrom(fieldType)) {
            if (jdbcType != null && jdbcType.equals("VARCHAR")) {
                length = typeLength;
            } else if (typePrecision != null) {
                length = typePrecision;
            }
        } else {
            length = String.class.isAssignableFrom(fieldType) || fieldType == Character.class || fieldType == Character.TYPE ? typeLength : (typePrecision != null ? typePrecision : typeLength);
            scale = typeScale;
        }
        if (columnName == null && length == null && scale == null && insertable == null && updateable == null && allowsNull == null && unique == null && jdbcType == null) {
            return null;
        }
        ColumnMetaData colmd = new ColumnMetaData();
        colmd.setName(columnName);
        colmd.setTarget(target);
        colmd.setTargetMember(targetField);
        colmd.setJdbcType(jdbcType);
        colmd.setSqlType(sqlType);
        colmd.setLength(length);
        colmd.setScale(scale);
        colmd.setAllowsNull(allowsNull);
        colmd.setDefaultValue(defaultValue);
        colmd.setInsertValue(insertValue);
        colmd.setInsertable(insertable);
        colmd.setUpdateable(updateable);
        colmd.setUnique(unique);
        if (columnDdl != null) {
            colmd.setColumnDdl(columnDdl);
        }
        if (!StringUtils.isWhitespace(table)) {
            mmd.setTable(table);
        }
        if (mmd.isPrimaryKey()) {
            colmd.setAllowsNull(Boolean.valueOf(false));
        }
        return colmd;
    }

    private void processSequenceGeneratorAnnotation(PackageMetaData pmd, Map<String, Object> annotationValues) {
        String schemaName;
        Integer allocationSize;
        String name = (String)annotationValues.get("name");
        String seqName = (String)annotationValues.get("sequenceName");
        Integer initialValue = (Integer)annotationValues.get("initialValue");
        if (initialValue == null) {
            initialValue = 1;
        }
        if ((allocationSize = (Integer)annotationValues.get("allocationSize")) == null) {
            allocationSize = 50;
        }
        SequenceMetaData seqmd = pmd.newSequenceMetadata(name, null);
        seqmd.setDatastoreSequence(seqName);
        seqmd.setInitialValue(initialValue.intValue());
        seqmd.setAllocationSize(allocationSize.intValue());
        String catalogName = (String)annotationValues.get("catalog");
        if (!StringUtils.isWhitespace((String)catalogName)) {
            seqmd.setCatalogName(catalogName);
        }
        if (!StringUtils.isWhitespace((String)(schemaName = (String)annotationValues.get("schema")))) {
            seqmd.setSchemaName(schemaName);
        }
    }

    private void processTableGeneratorAnnotation(PackageMetaData pmd, Map<String, Object> annotationValues) {
        TableGeneratorMetaData tgmd = pmd.newTableGeneratorMetadata((String)annotationValues.get("name"));
        tgmd.setTableName((String)annotationValues.get("table"));
        tgmd.setCatalogName((String)annotationValues.get("catalog"));
        tgmd.setSchemaName((String)annotationValues.get("schema"));
        tgmd.setPKColumnName((String)annotationValues.get("pkColumnName"));
        tgmd.setPKColumnValue((String)annotationValues.get("pkColumnValue"));
        tgmd.setValueColumnName((String)annotationValues.get("valueColumnName"));
        tgmd.setInitialValue((long)((Integer)annotationValues.get("initialValue")).intValue());
        tgmd.setAllocationSize((long)((Integer)annotationValues.get("allocationSize")).intValue());
    }

    protected AnnotationObject isClassPersistable(AnnotationObject[] annotations) {
        for (AnnotationObject annotation : annotations) {
            if (JPAAnnotationUtils.ENTITY.equals(annotation.getName())) {
                return annotation;
            }
            if (JPAAnnotationUtils.EMBEDDABLE.equals(annotation.getName())) {
                return annotation;
            }
            if (!JPAAnnotationUtils.MAPPED_SUPERCLASS.equals(annotation.getName())) continue;
            return annotation;
        }
        return null;
    }

    protected boolean isClassPersistenceAware(AnnotationObject[] annotations) {
        for (AnnotationObject annotation : annotations) {
            if (!JPAAnnotationUtils.PERSISTENCE_AWARE.equals(annotation.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean doesClassHaveNamedQueries(AnnotationObject[] annotations) {
        for (AnnotationObject annotation : annotations) {
            String annClassName = annotation.getName();
            if (!annClassName.equals(JPAAnnotationUtils.NAMED_QUERIES) && !annClassName.equals(JPAAnnotationUtils.NAMED_QUERY) && !annClassName.equals(JPAAnnotationUtils.NAMED_NATIVE_QUERIES) && !annClassName.equals(JPAAnnotationUtils.NAMED_NATIVE_QUERY) && !annClassName.equals(JPAAnnotationUtils.NAMED_STOREDPROC_QUERIES) && !annClassName.equals(JPAAnnotationUtils.NAMED_STOREDPROC_QUERY)) continue;
            return true;
        }
        return false;
    }

    protected boolean doesClassHaveConverter(Class cls, AnnotationObject[] annotations) {
        for (AnnotationObject annotation : annotations) {
            String annClassName = annotation.getName();
            if (!annClassName.equals(JPAAnnotationUtils.CONVERTER)) continue;
            Map annotationValues = annotation.getNameValueMap();
            boolean autoApply = (Boolean)annotationValues.get("autoApply");
            TypeManager typeMgr = this.mmgr.getNucleusContext().getTypeManager();
            Class attrType = JPATypeConverterUtils.getAttributeTypeForAttributeConverter(cls, null);
            Class dbType = JPATypeConverterUtils.getDatabaseTypeForAttributeConverter(cls, attrType, null);
            if (attrType != null) {
                JPATypeConverter typeConv = typeMgr.getTypeConverterForName(cls.getName());
                if (typeConv == null) {
                    typeConv = new JPATypeConverter(JPATypeConverterUtils.createAttributeConverterInstance(this.mmgr.getNucleusContext(), cls));
                    typeMgr.registerConverter(cls.getName(), typeConv, attrType, dbType, autoApply, attrType.getName());
                } else {
                    typeMgr.registerConverter(cls.getName(), typeConv, attrType, dbType, autoApply, attrType.getName());
                }
                if (NucleusLogger.METADATA.isDebugEnabled()) {
                    NucleusLogger.METADATA.debug((Object)("Registering AttributeConverter for java=" + attrType.getName() + " db=" + dbType.getName() + " autoApply=" + autoApply));
                }
            }
            return true;
        }
        return false;
    }
}

