/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.EntityGraph;
import javax.persistence.Subgraph;
import org.datanucleus.api.jpa.AbstractJPAGraph;
import org.datanucleus.api.jpa.JPASubgraph;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.StringUtils;

public class JPAEntityGraph<T>
extends AbstractJPAGraph<T>
implements EntityGraph<T> {
    public static final String LOADGRAPH_PROPERTY = "javax.persistence.loadgraph";
    public static final String FETCHGRAPH_PROPERTY = "javax.persistence.fetchgraph";
    String name;
    boolean includeAllAttributes = false;
    Map<Class, Subgraph> subclassSubgraphsByType = null;

    public JPAEntityGraph(MetaDataManager mmgr, String name, Class clsType) {
        super(mmgr, clsType);
        this.name = name;
    }

    public void setName(String name) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setIncludeAll() {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        this.includeAllAttributes = true;
    }

    public boolean getIncludeAllAttributes() {
        return this.includeAllAttributes;
    }

    public JPAEntityGraph<T> cloneMutableEntityGraph() {
        JPAEntityGraph<T> eg = new JPAEntityGraph<T>(this.mmgr, this.name, this.classType);
        if (this.attributeNodeMap != null) {
            eg.attributeNodeMap = new HashMap();
            eg.attributeNodeMap.putAll(this.attributeNodeMap);
        }
        if (this.subclassSubgraphsByType != null) {
            eg.subclassSubgraphsByType = new HashMap<Class, Subgraph>();
            eg.subclassSubgraphsByType.putAll(this.subclassSubgraphsByType);
        }
        return eg;
    }

    public <V> Subgraph<? extends V> addSubclassSubgraph(Class<? extends V> type) {
        if (!this.mutable) {
            throw new IllegalStateException("This Graph is not mutable");
        }
        if (this.subclassSubgraphsByType == null) {
            this.subclassSubgraphsByType = new HashMap<Class, Subgraph>();
        }
        JPASubgraph<? extends V> subgraph = new JPASubgraph<V>(this.mmgr, type);
        this.subclassSubgraphsByType.put(type, subgraph);
        return subgraph;
    }

    public Map<Class, Subgraph> getSubclassSubgraphs() {
        if (this.subclassSubgraphsByType == null) {
            return Collections.EMPTY_MAP;
        }
        return this.subclassSubgraphsByType;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Graph(");
        str.append("\"").append(this.name).append("\"");
        str.append(", type=").append(this.classType.getName());
        if (this.attributeNodeMap != null) {
            boolean hasSubgraphs = false;
            str.append(", attributes=[");
            int i = 0;
            for (AttributeNode attr : this.attributeNodeMap.values()) {
                if (i > 0) {
                    str.append(",");
                }
                if (!hasSubgraphs && attr.getSubgraphs() != null && attr.getSubgraphs().size() > 0) {
                    hasSubgraphs = true;
                }
                str.append(attr.toString());
                ++i;
            }
            str.append("]");
            if (hasSubgraphs) {
                str.append(", subgraphs=[");
                for (AttributeNode attr : this.attributeNodeMap.values()) {
                    Map subgraphs = attr.getSubgraphs();
                    if (subgraphs == null || subgraphs.size() <= 0) continue;
                    str.append(StringUtils.collectionToString(subgraphs.values()));
                }
                str.append("]");
            }
            if (this.subclassSubgraphsByType != null) {
                str.append(", subclasses=[");
                Iterator<Map.Entry<Class, Subgraph>> subclassIter = this.subclassSubgraphsByType.entrySet().iterator();
                while (subclassIter.hasNext()) {
                    Map.Entry<Class, Subgraph> entry = subclassIter.next();
                    str.append("{cls=" + entry.getKey());
                    str.append(", graph=");
                    str.append(entry.getValue());
                    str.append("}");
                    if (!subclassIter.hasNext()) continue;
                    str.append(",");
                }
                str.append("]");
            }
        }
        str.append(")");
        return str.toString();
    }
}

