/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.metamodel;

import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Type;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.metamodel.ManagedTypeImpl;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;

public class AttributeImpl<X, Y>
implements Attribute<X, Y> {
    AbstractMemberMetaData mmd;
    ManagedTypeImpl<X> owner;

    public AttributeImpl(AbstractMemberMetaData mmd, ManagedTypeImpl<X> owner) {
        this.mmd = mmd;
        this.owner = owner;
    }

    public AbstractMemberMetaData getMetadata() {
        return this.mmd;
    }

    public ManagedType<X> getDeclaringType() {
        Class ownerCls = this.owner.getModel().getClassLoaderResolver().classForName(this.mmd.getClassName(true));
        return this.owner.getModel().managedType(ownerCls);
    }

    public Member getJavaMember() {
        return this.mmd.getMemberRepresented();
    }

    public Class<Y> getJavaType() {
        return this.mmd.getType();
    }

    public String getName() {
        return this.mmd.getName();
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        RelationType relationType = this.mmd.getRelationType(this.owner.getModel().getClassLoaderResolver());
        if (relationType == RelationType.MANY_TO_ONE_BI) {
            return Attribute.PersistentAttributeType.MANY_TO_ONE;
        }
        if (relationType == RelationType.ONE_TO_ONE_UNI || relationType == RelationType.ONE_TO_ONE_BI) {
            if (this.mmd.getRelationTypeString() != null && this.mmd.getRelationTypeString().equals("ManyToOne")) {
                return Attribute.PersistentAttributeType.MANY_TO_ONE;
            }
            return Attribute.PersistentAttributeType.ONE_TO_ONE;
        }
        if (relationType == RelationType.ONE_TO_MANY_UNI || relationType == RelationType.ONE_TO_MANY_BI) {
            return Attribute.PersistentAttributeType.ONE_TO_MANY;
        }
        if (relationType == RelationType.MANY_TO_MANY_BI) {
            return Attribute.PersistentAttributeType.MANY_TO_MANY;
        }
        if (Collection.class.isAssignableFrom(this.mmd.getType())) {
            return Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
        }
        if (Map.class.isAssignableFrom(this.mmd.getType())) {
            return Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
        }
        return Attribute.PersistentAttributeType.BASIC;
    }

    public boolean isAssociation() {
        RelationType relationType = this.mmd.getRelationType(this.owner.getModel().getClassLoaderResolver());
        return relationType != RelationType.NONE;
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.mmd.getType()) || Map.class.isAssignableFrom(this.mmd.getType());
    }

    public final Type<Y> getType() {
        ClassLoaderResolver clr = this.owner.getModel().getClassLoaderResolver();
        if (this.mmd.hasCollection()) {
            return this.owner.model.getType(clr.classForName(this.mmd.getCollection().getElementType()));
        }
        if (this.mmd.hasMap()) {
            return this.owner.model.getType(clr.classForName(this.mmd.getMap().getValueType()));
        }
        if (this.mmd.hasArray()) {
            return this.owner.model.getType(this.mmd.getType().getComponentType());
        }
        return this.owner.model.getType(this.mmd.getType());
    }
}

