/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.api.jpa.JPAEntityManager;
import org.datanucleus.api.jpa.NucleusJPAHelper;
import org.datanucleus.api.jpa.state.LifeCycleStateFactory;
import org.datanucleus.enhancer.Detachable;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.LifeCycleState;

public class JPAAdapter
implements ApiAdapter {
    private static final long serialVersionUID = 7676231809409935625L;
    protected static final Set<String> defaultPersistentTypeNames = new HashSet<String>();

    public String getName() {
        return "JPA";
    }

    public boolean isMemberDefaultPersistent(Class type) {
        String typeName = type.getName();
        if (defaultPersistentTypeNames.contains(typeName)) {
            return true;
        }
        if (Calendar.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type) || Serializable.class.isAssignableFrom(type)) {
            return true;
        }
        return this.isPersistable(type);
    }

    public boolean isManaged(Object pc) {
        return this.getExecutionContext(pc) != null;
    }

    public ExecutionContext getExecutionContext(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Persistable) {
            return ((Persistable)obj).dnGetExecutionContext();
        }
        if (obj instanceof JPAEntityManager) {
            return ((JPAEntityManager)obj).getExecutionContext();
        }
        return null;
    }

    public LifeCycleState getLifeCycleState(int stateType) {
        return LifeCycleStateFactory.getLifeCycleState(stateType);
    }

    public boolean isPersistent(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsPersistent() : false;
    }

    public boolean isNew(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsNew() : false;
    }

    public boolean isDirty(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsDirty() : false;
    }

    public boolean isDeleted(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsDeleted() : false;
    }

    public boolean isDetached(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsDetached() : false;
    }

    public boolean isTransactional(Object obj) {
        return obj instanceof Persistable ? ((Persistable)obj).dnIsTransactional() : false;
    }

    public boolean isPersistable(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof Persistable;
    }

    public boolean isPersistable(Class cls) {
        if (cls == null) {
            return false;
        }
        return Persistable.class.isAssignableFrom(cls);
    }

    public boolean isDetachable(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof Detachable;
    }

    public String getObjectState(Object pc) {
        if (pc == null) {
            return null;
        }
        if (this.isDetached(pc)) {
            if (this.isDirty(pc)) {
                return "detached-dirty";
            }
            return "detached-clean";
        }
        if (this.isPersistent(pc)) {
            if (this.isTransactional(pc)) {
                if (this.isDirty(pc)) {
                    if (this.isNew(pc)) {
                        if (this.isDeleted(pc)) {
                            return "persistent-new-deleted";
                        }
                        return "persistent-new";
                    }
                    if (this.isDeleted(pc)) {
                        return "persistent-deleted";
                    }
                    return "persistent-dirty";
                }
                return "persistent-clean";
            }
            if (this.isDirty(pc)) {
                return "persistent-nontransactional-dirty";
            }
            return "hollow/persistent-nontransactional";
        }
        if (this.isTransactional(pc)) {
            if (this.isDirty(pc)) {
                return "transient-dirty";
            }
            return "transient-clean";
        }
        return "transient";
    }

    public void makeDirty(Object obj, String member) {
        ((Persistable)obj).dnMakeDirty(member);
    }

    public Object getIdForObject(Object obj) {
        if (!this.isPersistable(obj)) {
            return null;
        }
        return ((Persistable)obj).dnGetObjectId();
    }

    public Object getVersionForObject(Object obj) {
        if (!this.isPersistable(obj)) {
            return null;
        }
        return ((Persistable)obj).dnGetVersion();
    }

    public boolean isValidPrimaryKeyClass(Class pkClass, AbstractClassMetaData cmd, ClassLoaderResolver clr, int noOfPkFields, MetaDataManager mmgr) {
        return true;
    }

    public boolean allowPersistOfDeletedObject() {
        return true;
    }

    public boolean allowDeleteOfNonPersistentObject() {
        return true;
    }

    public boolean allowReadFieldOfDeletedObject() {
        return true;
    }

    public boolean clearLoadedFlagsOnDeleteObject() {
        return false;
    }

    public boolean getDefaultCascadePersistForField() {
        return false;
    }

    public boolean getDefaultCascadeUpdateForField() {
        return false;
    }

    public boolean getDefaultCascadeDeleteForField() {
        return false;
    }

    public boolean getDefaultCascadeRefreshForField() {
        return false;
    }

    public boolean getDefaultDFGForPersistableField() {
        return true;
    }

    public Map getDefaultFactoryProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("datanucleus.DetachAllOnCommit", "true");
        props.put("datanucleus.DetachAllOnRollback", "true");
        props.put("datanucleus.CopyOnAttach", "true");
        props.put("datanucleus.RetainValues", "true");
        props.put("datanucleus.Optimistic", "true");
        props.put("datanucleus.nontx.atomic", "false");
        props.put("datanucleus.metadata.allowLoadAtRuntime", "false");
        props.put("datanucleus.identifier.namingFactory", "jpa");
        props.put("datanucleus.identifierFactory", "jpa");
        props.put("datanucleus.persistenceByReachabilityAtCommit", "false");
        props.put("datanucleus.manageRelationships", "false");
        props.put("datanucleus.manageRelationshipsChecks", "false");
        props.put("datanucleus.query.sql.allowAll", "true");
        props.put("datanucleus.maxFetchDepth", "-1");
        props.put("datanucleus.findObject.validateWhenCached", "false");
        props.put("datanucleus.useImplementationCreator", "false");
        props.put("datanucleus.allowAttachOfTransient", "true");
        return props;
    }

    public RuntimeException getUserExceptionForException(String msg, Exception e) {
        return new PersistenceException(msg, (Throwable)e);
    }

    public RuntimeException getDataStoreExceptionForException(String msg, Exception e) {
        return new PersistenceException(msg, (Throwable)e);
    }

    public RuntimeException getApiExceptionForNucleusException(NucleusException ne) {
        return NucleusJPAHelper.getJPAExceptionForNucleusException(ne);
    }

    public void copyKeyFieldsFromIdToObject(Object pc, Persistable.ObjectIdFieldConsumer fm, Object id) {
        ((Persistable)pc).dnCopyKeyFieldsFromObjectId(fm, id);
    }

    static {
        defaultPersistentTypeNames.add(ClassNameConstants.BOOLEAN);
        defaultPersistentTypeNames.add(ClassNameConstants.BYTE);
        defaultPersistentTypeNames.add(ClassNameConstants.CHAR);
        defaultPersistentTypeNames.add(ClassNameConstants.DOUBLE);
        defaultPersistentTypeNames.add(ClassNameConstants.FLOAT);
        defaultPersistentTypeNames.add(ClassNameConstants.INT);
        defaultPersistentTypeNames.add(ClassNameConstants.LONG);
        defaultPersistentTypeNames.add(ClassNameConstants.SHORT);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_BOOLEAN);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_BYTE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_CHARACTER);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_DOUBLE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_FLOAT);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_INTEGER);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_LONG);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_SHORT);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_STRING);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_UTIL_DATE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_SQL_DATE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_SQL_TIME);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_SQL_TIMESTAMP);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_MATH_BIGDECIMAL);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_MATH_BIGINTEGER);
        defaultPersistentTypeNames.add(ClassNameConstants.BYTE_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.CHAR_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_BYTE_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_CHARACTER_ARRAY);
    }
}

