/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.datanucleus.api.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.api.jpa.criteria.ExpressionImpl;
import org.datanucleus.api.jpa.criteria.JPQLHelper;
import org.datanucleus.api.jpa.criteria.LiteralExpression;
import org.datanucleus.api.jpa.criteria.PredicateImpl;
import org.datanucleus.query.expression.DyadicExpression;

public class InPredicate<X>
extends PredicateImpl
implements Predicate,
CriteriaBuilder.In<X> {
    ExpressionImpl<? extends X> expr;
    List<Expression<? extends X>> values;
    boolean negated = false;

    public InPredicate(CriteriaBuilderImpl cb, Expression<? extends X> expr) {
        super(cb);
        this.expr = (ExpressionImpl)expr;
    }

    public InPredicate(CriteriaBuilderImpl cb, Expression<? extends X> expr, X ... values) {
        this(cb, expr);
        for (int i = 0; i < values.length; ++i) {
            this.value(values[i]);
        }
    }

    public InPredicate(CriteriaBuilderImpl cb, Expression<? extends X> expr, List<Expression<? extends X>> values) {
        this(cb, expr);
        this.values = values;
    }

    public InPredicate(CriteriaBuilderImpl cb, Expression<? extends X> expr, Expression<? extends X> ... values) {
        this(cb, expr, Arrays.asList(values));
    }

    public InPredicate(CriteriaBuilderImpl cb, Expression<? extends X> expr, Collection<X> values) {
        this(cb, expr);
        for (X val : values) {
            this.value(val);
        }
    }

    @Override
    public Predicate.BooleanOperator getOperator() {
        return Predicate.BooleanOperator.AND;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Predicate not() {
        this.negated = !this.negated;
        return this;
    }

    public Expression<X> getExpression() {
        return this.expr;
    }

    public CriteriaBuilder.In<X> value(X value) {
        if (this.values == null) {
            this.values = new ArrayList<Expression<? extends X>>();
        }
        LiteralExpression<X> litExpr = new LiteralExpression<X>(this.cb, value);
        this.values.add(litExpr);
        this.queryExpr = null;
        return this;
    }

    public CriteriaBuilder.In<X> value(Expression<? extends X> value) {
        if (this.values == null) {
            this.values = new ArrayList<Expression<? extends X>>();
        }
        this.values.add((ExpressionImpl)value);
        this.queryExpr = null;
        return this;
    }

    @Override
    public org.datanucleus.query.expression.Expression getQueryExpression() {
        if (this.queryExpr == null) {
            if (this.values == null || this.values.isEmpty()) {
                return null;
            }
            DyadicExpression dyExpr = null;
            for (Expression<? extends X> expression : this.values) {
                DyadicExpression valDyExpr = new DyadicExpression(this.expr.getQueryExpression(), org.datanucleus.query.expression.Expression.OP_EQ, ((ExpressionImpl)expression).getQueryExpression());
                if (dyExpr == null) {
                    dyExpr = valDyExpr;
                    continue;
                }
                dyExpr = new DyadicExpression((org.datanucleus.query.expression.Expression)dyExpr, org.datanucleus.query.expression.Expression.OP_OR, (org.datanucleus.query.expression.Expression)valDyExpr);
            }
            this.queryExpr = dyExpr;
        }
        return this.queryExpr;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.negated) {
            str.append("!(");
        }
        str.append(JPQLHelper.getJPQLForExpression(this.expr.getQueryExpression())).append(" IN (");
        boolean firstValue = true;
        for (Expression<X> valExpr : this.values) {
            if (!firstValue) {
                str.append(",");
            }
            str.append(valExpr.toString());
            firstValue = false;
        }
        str.append(")");
        if (this.negated) {
            str.append(")");
        }
        return str.toString();
    }
}

