/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.datanucleus.FetchPlan;
import org.datanucleus.api.jpa.NucleusJPAHelper;
import org.datanucleus.exceptions.NucleusException;

public class JPAFetchPlan
implements Serializable {
    private final FetchPlan fp;

    public JPAFetchPlan(FetchPlan fp) {
        this.fp = fp;
    }

    public Set getGroups() {
        return this.fp.getGroups();
    }

    public JPAFetchPlan addGroup(String group) {
        this.fp.addGroup(group);
        return this;
    }

    public JPAFetchPlan clearGroups() {
        this.fp.clearGroups();
        return this;
    }

    public JPAFetchPlan removeGroup(String group) {
        this.fp.removeGroup(group);
        return this;
    }

    public JPAFetchPlan setGroup(String group) {
        this.fp.setGroup(group);
        return this;
    }

    public JPAFetchPlan setGroups(Collection groups) {
        this.fp.setGroups(groups);
        return this;
    }

    public JPAFetchPlan setGroups(String ... groups) {
        this.fp.setGroups(groups);
        return this;
    }

    public int getFetchSize() {
        return this.fp.getFetchSize();
    }

    public JPAFetchPlan setFetchSize(int size) {
        this.fp.setFetchSize(size);
        return this;
    }

    public int getMaxFetchDepth() {
        return this.fp.getMaxFetchDepth();
    }

    public JPAFetchPlan setMaxFetchDepth(int depth) {
        try {
            this.fp.setMaxFetchDepth(depth);
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
        return this;
    }

    public int getDetachmentOptions() {
        return this.fp.getDetachmentOptions();
    }

    public Class[] getDetachmentRootClasses() {
        return this.fp.getDetachmentRootClasses();
    }

    public Collection getDetachmentRoots() {
        return this.fp.getDetachmentRoots();
    }

    public JPAFetchPlan setDetachmentOptions(int options) {
        try {
            this.fp.setDetachmentOptions(options);
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
        return this;
    }

    public JPAFetchPlan setDetachmentRootClasses(Class ... rootClasses) {
        try {
            this.fp.setDetachmentRootClasses(rootClasses);
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
        return this;
    }

    public JPAFetchPlan setDetachmentRoots(Collection roots) {
        this.fp.setDetachmentRoots(roots);
        return this;
    }

    public final FetchPlan getInternalFetchPlan() {
        return this.fp;
    }

    public String toString() {
        return this.fp.toString();
    }
}

