/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.criteria.ExpressionImpl;
import org.datanucleus.api.jpa.criteria.JoinImpl;
import org.datanucleus.api.jpa.criteria.PredicateImpl;
import org.datanucleus.api.jpa.criteria.RootImpl;
import org.datanucleus.api.jpa.metamodel.MetamodelImpl;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.JPQLSymbolResolver;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.ClassExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolResolver;
import org.datanucleus.query.symbol.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaUpdateImpl<T>
implements CriteriaUpdate<T> {
    MetamodelImpl model;
    private RootImpl<T> from;
    private Map sets = new HashMap();
    private PredicateImpl filter;
    String jpqlString = null;
    QueryCompilation compilation = null;

    public CriteriaUpdateImpl(MetamodelImpl model) {
        this.model = model;
    }

    public Metamodel getMetamodel() {
        return this.model;
    }

    public Predicate getRestriction() {
        return this.filter;
    }

    public <U> Subquery<U> subquery(Class<U> cls) {
        throw new UnsupportedOperationException("CriteriaDelete.subquery not yet supported");
    }

    public Root<T> from(Class<T> cls) {
        if (this.model == null) {
            throw new IllegalArgumentException("Metamodel on this CriteriaUpdate is null. Use 'from(EntityType)' method instead");
        }
        this.discardCompiled();
        EntityType<T> entity = this.model.entity(cls);
        if (entity == null) {
            throw new IllegalArgumentException("The specified class (" + cls.getName() + ") is not an entity");
        }
        return this.from(entity);
    }

    public Root<T> from(EntityType<T> type) {
        this.discardCompiled();
        this.from = new RootImpl<T>(type);
        return this.from;
    }

    public Root<T> getRoot() {
        return this.from;
    }

    public <Y> CriteriaUpdate<T> set(Path<Y> path, Expression<? extends Y> expr) {
        this.sets.put(path, expr);
        return this;
    }

    public <Y, X extends Y> CriteriaUpdate<T> set(Path<Y> path, X val) {
        this.sets.put(path, val);
        return this;
    }

    public <Y> CriteriaUpdate<T> set(SingularAttribute<? super T, Y> attr, Expression<? extends Y> expr) {
        return this.set(this.from.get(attr), (Object)expr);
    }

    public <Y, X extends Y> CriteriaUpdate<T> set(SingularAttribute<? super T, Y> attr, X val) {
        return this.set(this.from.get(attr), val);
    }

    public CriteriaUpdate<T> set(String name, Object val) {
        return null;
    }

    public CriteriaUpdate<T> where(Expression<Boolean> expr) {
        this.discardCompiled();
        if (expr == null) {
            this.filter = null;
            return this;
        }
        this.filter = (PredicateImpl)expr;
        return this;
    }

    public CriteriaUpdate<T> where(Predicate ... exprs) {
        this.discardCompiled();
        if (exprs == null || exprs.length == 0) {
            this.filter = null;
            return this;
        }
        if (this.filter == null) {
            this.filter = new PredicateImpl();
        }
        for (int i = 0; i < exprs.length; ++i) {
            this.filter = this.filter.append(exprs[i]);
        }
        return this;
    }

    protected void discardCompiled() {
        this.jpqlString = null;
        this.compilation = null;
    }

    public QueryCompilation getCompilation(MetaDataManager mmgr, ClassLoaderResolver clr) {
        return this.getCompilation(mmgr, clr, null);
    }

    public QueryCompilation getCompilation(MetaDataManager mmgr, ClassLoaderResolver clr, SymbolTable parentSymtbl) {
        if (this.compilation == null) {
            Class candidateClass = this.from.getJavaType();
            String candidateAlias = this.from.getAlias();
            if (candidateAlias == null) {
                candidateAlias = "DN_THIS";
                this.from.alias(candidateAlias);
            }
            SymbolTable symtbl = new SymbolTable();
            symtbl.setSymbolResolver((SymbolResolver)new JPQLSymbolResolver(mmgr, clr, symtbl, candidateClass, candidateAlias));
            symtbl.addSymbol((Symbol)new PropertySymbol(candidateAlias, candidateClass));
            if (parentSymtbl != null) {
                symtbl.setParentSymbolTable(parentSymtbl);
            }
            org.datanucleus.query.expression.Expression[] updateExprs = new org.datanucleus.query.expression.Expression[this.sets.size()];
            Iterator updateEntryIter = this.sets.entrySet().iterator();
            int i = 0;
            while (updateEntryIter.hasNext()) {
                Map.Entry entry = updateEntryIter.next();
                org.datanucleus.query.expression.Expression keyQueryExpr = ((ExpressionImpl)entry.getKey()).getQueryExpression();
                Object val = entry.getValue();
                Object valQueryExpr = null;
                valQueryExpr = val instanceof ExpressionImpl ? ((ExpressionImpl)val).getQueryExpression() : new Literal(val);
                updateExprs[i++] = new DyadicExpression(keyQueryExpr, org.datanucleus.query.expression.Expression.OP_EQ, valQueryExpr);
            }
            org.datanucleus.query.expression.Expression[] fromExprs = new org.datanucleus.query.expression.Expression[1];
            Set frmJoins = this.from.getJoins();
            if (frmJoins != null && !frmJoins.isEmpty()) {
                for (Join frmJoin : frmJoins) {
                    if (frmJoin.getAlias() == null) continue;
                    Class frmJoinCls = ((JoinImpl)frmJoin).getType().getJavaType();
                    symtbl.addSymbol((Symbol)new PropertySymbol(frmJoin.getAlias(), frmJoinCls));
                }
            }
            ClassExpression clsExpr = (ClassExpression)this.from.getQueryExpression(true);
            clsExpr.bind(symtbl);
            fromExprs[0] = clsExpr;
            org.datanucleus.query.expression.Expression filterExpr = null;
            if (this.filter != null && (filterExpr = this.filter.getQueryExpression()) != null) {
                filterExpr.bind(symtbl);
            }
            this.compilation = new QueryCompilation(candidateClass, candidateAlias, symtbl, null, fromExprs, filterExpr, null, null, null, updateExprs);
            this.compilation.setQueryLanguage("JPQL");
        }
        return this.compilation;
    }

    public String toString() {
        if (this.jpqlString == null) {
            StringBuffer str = new StringBuffer();
            str.append("UPDATE ");
            str.append(this.from.toString(true));
            str.append(" SET ");
            Iterator setEntryIter = this.sets.entrySet().iterator();
            while (setEntryIter.hasNext()) {
                Map.Entry entry = setEntryIter.next();
                Object key = entry.getKey();
                Object val = entry.getValue();
                str.append(key.toString());
                str.append(" = ");
                if (val instanceof String || val instanceof Character) {
                    str.append("'").append(val.toString()).append("'");
                } else {
                    str.append(val.toString());
                }
                if (!setEntryIter.hasNext()) continue;
                str.append(",");
            }
            str.append(" ");
            if (this.filter != null) {
                str.append("WHERE ").append(this.filter.toString()).append(" ");
            }
            this.jpqlString = str.toString().trim();
        }
        return this.jpqlString;
    }
}

