/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AttributeConverter;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.ConstraintMode;
import javax.persistence.Convert;
import javax.persistence.DiscriminatorType;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.FieldResult;
import javax.persistence.ForeignKey;
import javax.persistence.GenerationType;
import javax.persistence.Index;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.NamedStoredProcedureQuery;
import javax.persistence.NamedSubgraph;
import javax.persistence.ParameterMode;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.StoredProcedureParameter;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.JPAEntityGraph;
import org.datanucleus.api.jpa.JPASubgraph;
import org.datanucleus.api.jpa.annotations.Extension;
import org.datanucleus.api.jpa.metadata.JPAAnnotationUtils;
import org.datanucleus.api.jpa.metadata.JPAMetaDataManager;
import org.datanucleus.api.jpa.metadata.JPATypeConverter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.StoredProcQueryMetaData;
import org.datanucleus.metadata.StoredProcQueryParameterMetaData;
import org.datanucleus.metadata.StoredProcQueryParameterMode;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.metadata.annotations.AbstractAnnotationReader;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.Member;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAAnnotationReader
extends AbstractAnnotationReader {
    ClassLoaderResolver clr = null;

    public JPAAnnotationReader(MetaDataManager mgr) {
        super(mgr);
        this.setSupportedAnnotationPackages(new String[]{"javax.persistence", "org.datanucleus"});
    }

    protected AbstractClassMetaData processClassAnnotations(PackageMetaData pmd, Class cls, AnnotationObject[] annotations, ClassLoaderResolver clr) {
        this.clr = clr;
        ClassMetaData cmd = null;
        if (annotations != null && annotations.length > 0) {
            Iterator iter;
            int i;
            if (this.isClassPersistenceCapable(cls)) {
                cmd = pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
                cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
            } else if (this.isClassPersistenceAware(cls)) {
                cmd = pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
                cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_AWARE);
            } else if (this.doesClassHaveNamedQueries(cls)) {
                cmd = pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
                cmd.setPersistenceModifier(ClassPersistenceModifier.NON_PERSISTENT);
            } else {
                if (this.doesClassHaveConverter(cls)) {
                    return null;
                }
                return null;
            }
            this.processNamedQueries((AbstractClassMetaData)cmd, annotations);
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                return cmd;
            }
            IdentityType identityType = IdentityType.APPLICATION;
            String identityColumn = null;
            String identityStrategy = null;
            String identityGenerator = null;
            String cacheable = "true";
            String requiresExtent = "true";
            String detachable = "true";
            String embeddedOnly = "false";
            String idClassName = null;
            String catalog = null;
            String schema = null;
            String table = null;
            String inheritanceStrategyForTree = null;
            String inheritanceStrategy = null;
            String discriminatorColumnName = null;
            String discriminatorColumnType = null;
            Integer discriminatorColumnLength = null;
            String discriminatorColumnDdl = null;
            String discriminatorValue = null;
            String entityName = null;
            Class[] entityListeners = null;
            boolean excludeSuperClassListeners = false;
            boolean excludeDefaultListeners = false;
            ColumnMetaData[] pkColumnMetaData = null;
            HashSet<UniqueMetaData> uniques = null;
            HashSet<IndexMetaData> indexes = null;
            HashSet<FieldMetaData> overriddenFields = null;
            ArrayList<QueryResultMetaData> resultMappings = null;
            HashSet<ExtensionMetaData> extensions = null;
            for (i = 0; i < annotations.length; ++i) {
                String attributeName;
                FieldMetaData fmd;
                AttributeOverride[] overrides;
                Object[] values;
                GenerationType type;
                HashMap annotationValues = annotations[i].getNameValueMap();
                String annName = annotations[i].getName();
                if (annName.equals(JPAAnnotationUtils.ENTITY)) {
                    entityName = (String)annotationValues.get("name");
                    if (entityName != null && entityName.length() != 0) continue;
                    entityName = ClassUtils.getClassNameForClass((Class)cls);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.MAPPED_SUPERCLASS)) {
                    cmd.setMappedSuperclass(true);
                    if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) continue;
                    inheritanceStrategy = InheritanceStrategy.SUBCLASS_TABLE.toString();
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.DATASTORE_IDENTITY)) {
                    identityType = IdentityType.DATASTORE;
                    identityColumn = (String)annotationValues.get("column");
                    type = (GenerationType)annotationValues.get("generationType");
                    identityStrategy = JPAAnnotationUtils.getIdentityStrategyString(type);
                    identityGenerator = (String)annotationValues.get("generator");
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.SURROGATE_VERSION)) {
                    String indexed;
                    VersionMetaData vermd = cmd.newVersionMetadata();
                    vermd.setStrategy(VersionStrategy.VERSION_NUMBER);
                    String colName = (String)annotationValues.get("columnName");
                    if (!StringUtils.isWhitespace((String)colName)) {
                        vermd.setColumnName(colName);
                    }
                    if (StringUtils.isWhitespace((String)(indexed = (String)annotationValues.get("indexed")))) continue;
                    vermd.setIndexed(IndexedValue.getIndexedValue((String)indexed));
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.TABLE)) {
                    Index[] indexConstrs;
                    table = (String)annotationValues.get("name");
                    catalog = (String)annotationValues.get("catalog");
                    schema = (String)annotationValues.get("schema");
                    UniqueConstraint[] constrs = (UniqueConstraint[])annotationValues.get("uniqueConstraints");
                    if (constrs != null && constrs.length > 0) {
                        for (int j = 0; j < constrs.length; ++j) {
                            UniqueMetaData unimd = new UniqueMetaData();
                            unimd.setTable((String)annotationValues.get("name"));
                            for (int k = 0; k < constrs[j].columnNames().length; ++k) {
                                ColumnMetaData colmd = new ColumnMetaData();
                                colmd.setName(constrs[j].columnNames()[k]);
                                unimd.addColumn(colmd);
                            }
                            if (uniques == null) {
                                uniques = new HashSet<UniqueMetaData>();
                            }
                            uniques.add(unimd);
                        }
                    }
                    if ((indexConstrs = (Index[])annotationValues.get("indexes")) == null || indexConstrs.length <= 0) continue;
                    for (int j = 0; j < indexConstrs.length; ++j) {
                        String colStr;
                        String[] cols;
                        IndexMetaData idxmd = new IndexMetaData();
                        if (!StringUtils.isWhitespace((String)indexConstrs[j].name())) {
                            idxmd.setName(indexConstrs[j].name());
                        }
                        if ((cols = StringUtils.split((String)(colStr = indexConstrs[j].columnList()), (String)",")) != null) {
                            for (int k = 0; k < cols.length; ++k) {
                                ColumnMetaData colmd = new ColumnMetaData();
                                colmd.setName(cols[k]);
                                colmd.setParent((MetaData)idxmd);
                                idxmd.addColumn(colmd);
                            }
                        }
                        if (indexConstrs[j].unique()) {
                            idxmd.setUnique(true);
                        }
                        if (indexes == null) {
                            indexes = new HashSet<IndexMetaData>();
                        }
                        indexes.add(idxmd);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ID_CLASS)) {
                    idClassName = ((Class)annotationValues.get("value")).getName();
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.INHERITANCE)) {
                    InheritanceType inhType = (InheritanceType)annotationValues.get("strategy");
                    inheritanceStrategyForTree = inhType.toString();
                    if (inhType == InheritanceType.JOINED) {
                        inheritanceStrategy = InheritanceStrategy.NEW_TABLE.toString();
                        continue;
                    }
                    if (inhType == InheritanceType.TABLE_PER_CLASS) {
                        inheritanceStrategy = InheritanceStrategy.COMPLETE_TABLE.toString();
                        continue;
                    }
                    if (inhType != InheritanceType.SINGLE_TABLE) continue;
                }
                if (annName.equals(JPAAnnotationUtils.DISCRIMINATOR_COLUMN)) {
                    discriminatorColumnName = (String)annotationValues.get("name");
                    type = (DiscriminatorType)annotationValues.get("discriminatorType");
                    if (type == DiscriminatorType.CHAR) {
                        discriminatorColumnType = "CHAR";
                    } else if (type == DiscriminatorType.INTEGER) {
                        discriminatorColumnType = "INTEGER";
                    } else if (type == DiscriminatorType.STRING) {
                        discriminatorColumnType = "VARCHAR";
                    }
                    discriminatorColumnLength = (Integer)annotationValues.get("length");
                    String tmp = (String)annotationValues.get("columnDefinition");
                    if (StringUtils.isWhitespace((String)tmp)) continue;
                    discriminatorColumnDdl = tmp;
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.DISCRIMINATOR_VALUE)) {
                    discriminatorValue = (String)annotationValues.get("value");
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.EMBEDDABLE)) {
                    embeddedOnly = "true";
                    identityType = IdentityType.NONDURABLE;
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.CACHEABLE)) {
                    Boolean cacheableVal = (Boolean)annotationValues.get("value");
                    if (cacheableVal != Boolean.FALSE) continue;
                    cacheable = "false";
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ENTITY_LISTENERS)) {
                    entityListeners = (Class[])annotationValues.get("value");
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.EXCLUDE_SUPERCLASS_LISTENERS)) {
                    excludeSuperClassListeners = true;
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.EXCLUDE_DEFAULT_LISTENERS)) {
                    excludeDefaultListeners = true;
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.SEQUENCE_GENERATOR)) {
                    this.processSequenceGeneratorAnnotation(pmd, annotationValues);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.TABLE_GENERATOR)) {
                    this.processTableGeneratorAnnotation(pmd, annotationValues);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.PRIMARY_KEY_JOIN_COLUMN)) {
                    pkColumnMetaData = new ColumnMetaData[]{new ColumnMetaData()};
                    pkColumnMetaData[0].setName((String)annotationValues.get("name"));
                    pkColumnMetaData[0].setTarget((String)annotationValues.get("referencedColumnName"));
                    ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                    if (fk == null || fk.value() == ConstraintMode.PROVIDER_DEFAULT) continue;
                    ForeignKeyMetaData fkmd = cmd.newForeignKeyMetadata();
                    fkmd.setName(fk.name());
                    fkmd.setFkDefinition(fk.foreignKeyDefinition());
                    fkmd.addColumn(pkColumnMetaData[0]);
                    if (fk.value() != ConstraintMode.NO_CONSTRAINT) continue;
                    fkmd.setFkDefinitionApplies(false);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.PRIMARY_KEY_JOIN_COLUMNS)) {
                    values = (PrimaryKeyJoinColumn[])annotationValues.get("value");
                    pkColumnMetaData = new ColumnMetaData[values.length];
                    ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                    ForeignKeyMetaData fkmd = null;
                    if (fk != null && fk.value() != ConstraintMode.PROVIDER_DEFAULT) {
                        fkmd = cmd.newForeignKeyMetadata();
                        fkmd.setName(fk.name());
                        fkmd.setFkDefinition(fk.foreignKeyDefinition());
                        if (fk.value() == ConstraintMode.NO_CONSTRAINT) {
                            fkmd.setFkDefinitionApplies(false);
                        }
                    }
                    for (int j = 0; j < values.length; ++j) {
                        pkColumnMetaData[j] = new ColumnMetaData();
                        pkColumnMetaData[j].setName(values[j].name());
                        pkColumnMetaData[j].setTarget(values[j].referencedColumnName());
                        if (!StringUtils.isWhitespace((String)values[j].columnDefinition())) {
                            pkColumnMetaData[j].setColumnDdl(values[j].columnDefinition());
                        }
                        if (fkmd == null) continue;
                        fkmd.addColumn(pkColumnMetaData[j]);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ATTRIBUTE_OVERRIDES)) {
                    overrides = (AttributeOverride[])annotationValues.get("value");
                    if (overrides == null) continue;
                    if (overriddenFields == null) {
                        overriddenFields = new HashSet();
                    }
                    for (int j = 0; j < overrides.length; ++j) {
                        FieldMetaData fmd2 = new FieldMetaData((MetaData)cmd, "#UNKNOWN." + overrides[j].name());
                        fmd2.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT);
                        Column col = overrides[j].column();
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(col.name());
                        colmd.setLength(Integer.valueOf(col.length()));
                        colmd.setScale(Integer.valueOf(col.scale()));
                        colmd.setAllowsNull(Boolean.valueOf(col.nullable()));
                        colmd.setInsertable(col.insertable());
                        colmd.setUpdateable(col.updatable());
                        colmd.setUnique(col.unique());
                        fmd2.addColumn(colmd);
                        overriddenFields.add(fmd2);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ATTRIBUTE_OVERRIDE)) {
                    if (overriddenFields == null) {
                        overriddenFields = new HashSet<FieldMetaData>();
                    }
                    fmd = new FieldMetaData((MetaData)cmd, "#UNKNOWN." + (String)annotationValues.get("name"));
                    Column col = (Column)annotationValues.get("column");
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(col.name());
                    colmd.setLength(Integer.valueOf(col.length()));
                    colmd.setScale(Integer.valueOf(col.scale()));
                    colmd.setAllowsNull(Boolean.valueOf(col.nullable()));
                    colmd.setInsertable(col.insertable());
                    colmd.setUpdateable(col.updatable());
                    colmd.setUnique(col.unique());
                    fmd.addColumn(colmd);
                    overriddenFields.add(fmd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ASSOCIATION_OVERRIDES)) {
                    overrides = (AssociationOverride[])annotationValues.get("value");
                    if (overrides == null) continue;
                    if (overriddenFields == null) {
                        overriddenFields = new HashSet();
                    }
                    for (int j = 0; j < overrides.length; ++j) {
                        FieldMetaData fmd3 = new FieldMetaData((MetaData)cmd, "#UNKNOWN." + overrides[j].name());
                        JoinColumn[] cols = overrides[j].joinColumns();
                        for (int k = 0; k < cols.length; ++k) {
                            ColumnMetaData colmd = new ColumnMetaData();
                            colmd.setName(cols[k].name());
                            colmd.setTarget(cols[k].referencedColumnName());
                            colmd.setAllowsNull(Boolean.valueOf(cols[k].nullable()));
                            colmd.setInsertable(cols[k].insertable());
                            colmd.setUpdateable(cols[k].updatable());
                            colmd.setUnique(cols[k].unique());
                            fmd3.addColumn(colmd);
                        }
                        overriddenFields.add(fmd3);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ASSOCIATION_OVERRIDE)) {
                    if (overriddenFields == null) {
                        overriddenFields = new HashSet();
                    }
                    fmd = new FieldMetaData((MetaData)cmd, "#UNKNOWN." + (String)annotationValues.get("name"));
                    JoinColumn[] cols = (JoinColumn[])annotationValues.get("joinColumns");
                    for (int k = 0; k < cols.length; ++k) {
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(cols[k].name());
                        colmd.setTarget(cols[k].referencedColumnName());
                        colmd.setAllowsNull(Boolean.valueOf(cols[k].nullable()));
                        colmd.setInsertable(cols[k].insertable());
                        colmd.setUpdateable(cols[k].updatable());
                        colmd.setUnique(cols[k].unique());
                        fmd.addColumn(colmd);
                    }
                    overriddenFields.add(fmd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.SQL_RESULTSET_MAPPINGS)) {
                    SqlResultSetMapping[] mappings = (SqlResultSetMapping[])annotationValues.get("value");
                    if (resultMappings == null) {
                        resultMappings = new ArrayList();
                    }
                    for (int j = 0; j < mappings.length; ++j) {
                        ColumnResult[] colResults;
                        QueryResultMetaData qrmd = new QueryResultMetaData(mappings[j].name());
                        EntityResult[] entityResults = mappings[j].entities();
                        if (entityResults != null) {
                            for (int k = 0; k < entityResults.length; ++k) {
                                String entityClassName = entityResults[k].entityClass().getName();
                                qrmd.addPersistentTypeMapping(entityClassName, null, entityResults[k].discriminatorColumn());
                                FieldResult[] fields = entityResults[k].fields();
                                if (fields == null) continue;
                                for (int l = 0; l < fields.length; ++l) {
                                    qrmd.addMappingForPersistentTypeMapping(entityClassName, fields[l].name(), fields[l].column());
                                }
                            }
                        }
                        if ((colResults = mappings[j].columns()) != null) {
                            for (int k = 0; k < colResults.length; ++k) {
                                qrmd.addScalarColumn(colResults[k].name());
                            }
                        }
                        resultMappings.add(qrmd);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.SQL_RESULTSET_MAPPING)) {
                    ColumnResult[] colResults;
                    if (resultMappings == null) {
                        resultMappings = new ArrayList<QueryResultMetaData>();
                    }
                    QueryResultMetaData qrmd = new QueryResultMetaData((String)annotationValues.get("name"));
                    EntityResult[] entityResults = (EntityResult[])annotationValues.get("entities");
                    if (entityResults != null) {
                        for (int j = 0; j < entityResults.length; ++j) {
                            String entityClassName = entityResults[j].entityClass().getName();
                            qrmd.addPersistentTypeMapping(entityClassName, null, entityResults[j].discriminatorColumn());
                            FieldResult[] fields = entityResults[j].fields();
                            if (fields == null) continue;
                            for (int k = 0; k < fields.length; ++k) {
                                qrmd.addMappingForPersistentTypeMapping(entityClassName, fields[k].name(), fields[k].column());
                            }
                        }
                    }
                    if ((colResults = (ColumnResult[])annotationValues.get("columns")) != null) {
                        for (int j = 0; j < colResults.length; ++j) {
                            qrmd.addScalarColumn(colResults[j].name());
                        }
                    }
                    resultMappings.add(qrmd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.SECONDARY_TABLES) || annName.equals(JPAAnnotationUtils.SECONDARY_TABLE)) continue;
                if (annName.equals(JPAAnnotationUtils.NAMED_ENTITY_GRAPHS)) {
                    NamedEntityGraph[] graphs = (NamedEntityGraph[])annotationValues.get("value");
                    for (int j = 0; j < graphs.length; ++j) {
                        NamedSubgraph[] subclassSubgraphs;
                        NamedSubgraph[] subgraphs;
                        String subgraphName;
                        String graphName = graphs[j].name();
                        if (StringUtils.isWhitespace((String)graphName)) {
                            graphName = entityName;
                        }
                        JPAEntityGraph eg = new JPAEntityGraph(this.mgr, graphName, cls);
                        boolean includeAll = graphs[j].includeAllAttributes();
                        if (includeAll) {
                            eg.setIncludeAll();
                        }
                        HashMap<String, String> attributeNameBySubgraphName = new HashMap<String, String>();
                        NamedAttributeNode[] nodes = graphs[j].attributeNodes();
                        if (nodes != null && nodes.length > 0) {
                            for (int k = 0; k < nodes.length; ++k) {
                                attributeName = nodes[k].value();
                                subgraphName = nodes[k].subgraph();
                                eg.addAttributeNodes(attributeName);
                                if (StringUtils.isWhitespace((String)subgraphName)) continue;
                                attributeNameBySubgraphName.put(subgraphName, attributeName);
                            }
                        }
                        if ((subgraphs = graphs[j].subgraphs()) != null && subgraphs.length > 0) {
                            for (int k = 0; k < subgraphs.length; ++k) {
                                subgraphName = subgraphs[k].name();
                                if (attributeNameBySubgraphName == null) {
                                    NucleusLogger.METADATA.warn((Object)("EntityGraph " + graphName + " defined with subgraph name=" + subgraphName + " but no AttributeNode for that subgroup. Ignoring"));
                                    continue;
                                }
                                String attributeName2 = (String)attributeNameBySubgraphName.get(subgraphName);
                                JPASubgraph subgraph = (JPASubgraph)eg.addSubgraph(attributeName2, subgraphs[k].type());
                                NamedAttributeNode[] subnodes = subgraphs[k].attributeNodes();
                                if (subnodes == null || subnodes.length <= 0) continue;
                                for (int l = 0; l < subnodes.length; ++l) {
                                    subgraph.addAttributeNodes(subnodes[l].value());
                                }
                            }
                        }
                        if ((subclassSubgraphs = graphs[j].subclassSubgraphs()) != null && subclassSubgraphs.length > 0) {
                            for (int k = 0; k < subgraphs.length; ++k) {
                                JPASubgraph subgraph = (JPASubgraph)eg.addSubclassSubgraph(subgraphs[k].type());
                                NamedAttributeNode[] subnodes = subgraphs[k].attributeNodes();
                                if (subnodes == null || subnodes.length <= 0) continue;
                                for (int l = 0; l < subnodes.length; ++l) {
                                    subgraph.addAttributeNodes(subnodes[l].value());
                                }
                            }
                        }
                        ((JPAMetaDataManager)this.mgr).registerEntityGraph(eg);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.NAMED_ENTITY_GRAPH)) {
                    NamedSubgraph[] subclassSubgraphs;
                    NamedSubgraph[] subgraphs;
                    String graphName = (String)annotationValues.get("name");
                    if (StringUtils.isWhitespace((String)graphName)) {
                        graphName = entityName;
                    }
                    JPAEntityGraph eg = new JPAEntityGraph(this.mgr, graphName, cls);
                    boolean includeAll = (Boolean)annotationValues.get("includeAllAttributes");
                    if (includeAll) {
                        eg.setIncludeAll();
                    }
                    HashMap<String, String> attributeNameBySubgraphName = new HashMap<String, String>();
                    NamedAttributeNode[] nodes = (NamedAttributeNode[])annotationValues.get("attributeNodes");
                    if (nodes != null && nodes.length > 0) {
                        for (int k = 0; k < nodes.length; ++k) {
                            String attributeName3 = nodes[k].value();
                            String subgraphName = nodes[k].subgraph();
                            eg.addAttributeNodes(attributeName3);
                            if (StringUtils.isWhitespace((String)subgraphName)) continue;
                            attributeNameBySubgraphName.put(subgraphName, attributeName3);
                        }
                    }
                    if ((subgraphs = (NamedSubgraph[])annotationValues.get("subgraphs")) != null && subgraphs.length > 0) {
                        for (int k = 0; k < subgraphs.length; ++k) {
                            String subgraphName = subgraphs[k].name();
                            if (attributeNameBySubgraphName == null) {
                                NucleusLogger.METADATA.warn((Object)("EntityGraph " + graphName + " defined with subgraph name=" + subgraphName + " but no AttributeNode for that subgroup. Ignoring"));
                                continue;
                            }
                            attributeName = (String)attributeNameBySubgraphName.get(subgraphName);
                            JPASubgraph subgraph = (JPASubgraph)eg.addSubgraph(attributeName, subgraphs[k].type());
                            NamedAttributeNode[] subnodes = subgraphs[k].attributeNodes();
                            if (subnodes == null || subnodes.length <= 0) continue;
                            for (int l = 0; l < subnodes.length; ++l) {
                                subgraph.addAttributeNodes(subnodes[l].value());
                            }
                        }
                    }
                    if ((subclassSubgraphs = (NamedSubgraph[])annotationValues.get("subclassSubgraphs")) != null && subclassSubgraphs.length > 0) {
                        for (int k = 0; k < subclassSubgraphs.length; ++k) {
                            JPASubgraph subgraph = (JPASubgraph)eg.addSubclassSubgraph(subclassSubgraphs[k].type());
                            NamedAttributeNode[] subnodes = subclassSubgraphs[k].attributeNodes();
                            if (subnodes == null || subnodes.length <= 0) continue;
                            for (int l = 0; l < subnodes.length; ++l) {
                                subgraph.addAttributeNodes(subnodes[l].value());
                            }
                        }
                    }
                    ((JPAMetaDataManager)this.mgr).registerEntityGraph(eg);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.EXTENSION)) {
                    ExtensionMetaData extmd = new ExtensionMetaData((String)annotationValues.get("vendorName"), (String)annotationValues.get("key"), (String)annotationValues.get("value"));
                    if (extensions == null) {
                        extensions = new HashSet<ExtensionMetaData>(1);
                    }
                    extensions.add(extmd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.EXTENSIONS)) {
                    values = (Extension[])annotationValues.get("value");
                    if (values == null || values.length <= 0) continue;
                    if (extensions == null) {
                        extensions = new HashSet(values.length);
                    }
                    for (int j = 0; j < values.length; ++j) {
                        ExtensionMetaData extmd = new ExtensionMetaData(values[j].vendorName(), values[j].key().toString(), values[j].value().toString());
                        extensions.add(extmd);
                    }
                    continue;
                }
                NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044203", (Object)cls.getName(), (Object)annotations[i].getName()));
            }
            if (entityName == null || entityName.length() == 0) {
                entityName = ClassUtils.getClassNameForClass((Class)cls);
            }
            NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044200", (Object)cls.getName(), (Object)"JPA"));
            cmd.setTable(table);
            cmd.setCatalog(catalog);
            cmd.setSchema(schema);
            cmd.setEntityName(entityName);
            cmd.setDetachable(detachable);
            cmd.setRequiresExtent(requiresExtent);
            cmd.setObjectIdClass(idClassName);
            cmd.setEmbeddedOnly(embeddedOnly);
            cmd.setCacheable(cacheable);
            cmd.setIdentityType(identityType);
            if (this.isClassPersistenceCapable(cls.getSuperclass())) {
                cmd.setPersistenceCapableSuperclass(cls.getSuperclass().getName());
            }
            if (excludeSuperClassListeners) {
                cmd.excludeSuperClassListeners();
            }
            if (excludeDefaultListeners) {
                cmd.excludeDefaultListeners();
            }
            if (entityListeners != null) {
                for (i = 0; i < entityListeners.length; ++i) {
                    EventListenerMetaData elmd = new EventListenerMetaData(entityListeners[i].getName());
                    cmd.addListener(elmd);
                }
            }
            InheritanceMetaData inhmd = null;
            if (inheritanceStrategy != null) {
                inhmd = cmd.newInheritanceMetadata().setStrategy(inheritanceStrategy);
                inhmd.setStrategyForTree(inheritanceStrategyForTree);
            } else if (discriminatorValue != null || discriminatorColumnName != null || discriminatorColumnLength != null || discriminatorColumnType != null) {
                inhmd = cmd.newInheritanceMetadata().setStrategyForTree(inheritanceStrategyForTree);
            }
            if (discriminatorValue != null || discriminatorColumnName != null || discriminatorColumnLength != null || discriminatorColumnType != null) {
                DiscriminatorMetaData dismd = inhmd.newDiscriminatorMetadata();
                if (discriminatorValue != null) {
                    dismd.setColumnName(discriminatorColumnName);
                    dismd.setValue(discriminatorValue).setStrategy(DiscriminatorStrategy.VALUE_MAP).setIndexed("false");
                } else {
                    if (!Modifier.isAbstract(cls.getModifiers())) {
                        discriminatorValue = cls.getName();
                        dismd.setValue(discriminatorValue);
                    }
                    dismd.setColumnName(discriminatorColumnName);
                    dismd.setStrategy(DiscriminatorStrategy.VALUE_MAP).setIndexed("false");
                }
                ColumnMetaData discolmd = null;
                if (discriminatorColumnLength != null || discriminatorColumnName != null || discriminatorColumnType != null) {
                    discolmd = new ColumnMetaData();
                    discolmd.setName(discriminatorColumnName);
                    if (discriminatorColumnType != null) {
                        discolmd.setJdbcType(discriminatorColumnType);
                    }
                    if (discriminatorColumnLength != null) {
                        discolmd.setLength(discriminatorColumnLength);
                    }
                    dismd.setColumnMetaData(discolmd);
                    if (discriminatorColumnDdl != null) {
                        discolmd.setColumnDdl(discriminatorColumnDdl);
                    }
                }
            }
            if (identityType == IdentityType.DATASTORE) {
                IdentityMetaData idmd = cmd.newIdentityMetadata();
                idmd.setColumnName(identityColumn);
                idmd.setValueStrategy(IdentityStrategy.getIdentityStrategy((String)identityStrategy));
                if (identityGenerator != null) {
                    idmd.setSequence(identityGenerator);
                    idmd.setValueGeneratorName(identityGenerator);
                }
            }
            if (pkColumnMetaData != null) {
                PrimaryKeyMetaData pkmd = cmd.newPrimaryKeyMetadata();
                for (int i2 = 0; i2 < pkColumnMetaData.length; ++i2) {
                    pkmd.addColumn(pkColumnMetaData[i2]);
                }
            }
            if (uniques != null && uniques.size() > 0) {
                Iterator uniquesIter = uniques.iterator();
                while (uniquesIter.hasNext()) {
                    cmd.addUniqueConstraint((UniqueMetaData)uniquesIter.next());
                }
            }
            if (indexes != null && !indexes.isEmpty()) {
                Iterator indexesIter = indexes.iterator();
                while (indexesIter.hasNext()) {
                    cmd.addIndex((IndexMetaData)indexesIter.next());
                }
            }
            if (overriddenFields != null) {
                iter = overriddenFields.iterator();
                while (iter.hasNext()) {
                    cmd.addMember((AbstractMemberMetaData)iter.next());
                }
            }
            if (resultMappings != null) {
                iter = resultMappings.iterator();
                while (iter.hasNext()) {
                    cmd.addQueryResultMetaData((QueryResultMetaData)iter.next());
                }
            }
            if (extensions != null) {
                for (ExtensionMetaData extmd : extensions) {
                    cmd.addExtension(extmd.getVendorName(), extmd.getKey(), extmd.getValue());
                }
            }
            this.newJoinMetaDataForClass((AbstractClassMetaData)cmd, annotations);
        }
        return cmd;
    }

    protected void processNamedQueries(AbstractClassMetaData cmd, AnnotationObject[] annotations) {
        HashSet<QueryMetaData> namedQueries = null;
        HashSet<StoredProcQueryMetaData> namedStoredProcQueries = null;
        for (int i = 0; i < annotations.length; ++i) {
            String[] resultSetMappings;
            StoredProcQueryParameterMetaData parammd;
            StoredProcedureParameter[] params;
            NamedQuery[] queries;
            HashMap annotationValues = annotations[i].getNameValueMap();
            String annName = annotations[i].getName();
            if (annName.equals(JPAAnnotationUtils.NAMED_QUERIES)) {
                queries = (NamedQuery[])annotationValues.get("value");
                if (namedQueries == null) {
                    namedQueries = new HashSet();
                }
                for (int j = 0; j < queries.length; ++j) {
                    if (StringUtils.isWhitespace((String)queries[j].name())) {
                        throw new InvalidClassMetaDataException(LOCALISER, "044154", cmd.getFullClassName());
                    }
                    QueryMetaData qmd = new QueryMetaData(queries[j].name());
                    qmd.setLanguage(QueryLanguage.JPQL.toString());
                    qmd.setUnmodifiable(true);
                    qmd.setQuery(queries[j].query());
                    namedQueries.add(qmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.NAMED_QUERY)) {
                if (namedQueries == null) {
                    namedQueries = new HashSet<QueryMetaData>();
                }
                if (StringUtils.isWhitespace((String)((String)annotationValues.get("name")))) {
                    throw new InvalidClassMetaDataException(LOCALISER, "044154", cmd.getFullClassName());
                }
                QueryMetaData qmd = new QueryMetaData((String)annotationValues.get("name"));
                qmd.setLanguage(QueryLanguage.JPQL.toString());
                qmd.setUnmodifiable(true);
                qmd.setQuery((String)annotationValues.get("query"));
                namedQueries.add(qmd);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.NAMED_NATIVE_QUERIES)) {
                queries = (NamedNativeQuery[])annotationValues.get("value");
                if (namedQueries == null) {
                    namedQueries = new HashSet();
                }
                for (int j = 0; j < queries.length; ++j) {
                    String resultClassName = null;
                    if (queries[j].resultClass() != null && queries[j].resultClass() != Void.TYPE) {
                        resultClassName = queries[j].resultClass().getName();
                    }
                    String resultMappingName = null;
                    if (queries[j].resultSetMapping() != null) {
                        resultMappingName = queries[j].resultSetMapping();
                    }
                    QueryMetaData qmd = new QueryMetaData(queries[j].name());
                    qmd.setLanguage(QueryLanguage.SQL.toString());
                    qmd.setUnmodifiable(true);
                    qmd.setResultClass(resultClassName);
                    qmd.setResultMetaDataName(resultMappingName);
                    qmd.setQuery(queries[j].query());
                    namedQueries.add(qmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.NAMED_NATIVE_QUERY)) {
                String resultMappingName;
                if (namedQueries == null) {
                    namedQueries = new HashSet();
                }
                Class resultClass = (Class)annotationValues.get("resultClass");
                String resultClassName = null;
                if (resultClass != null && resultClass != Void.TYPE) {
                    resultClassName = resultClass.getName();
                }
                if (StringUtils.isWhitespace((String)(resultMappingName = (String)annotationValues.get("resultSetMapping")))) {
                    resultMappingName = null;
                }
                QueryMetaData qmd = new QueryMetaData((String)annotationValues.get("name"));
                qmd.setLanguage(QueryLanguage.SQL.toString());
                qmd.setUnmodifiable(true);
                qmd.setResultClass(resultClassName);
                qmd.setResultMetaDataName(resultMappingName);
                qmd.setQuery((String)annotationValues.get("query"));
                namedQueries.add(qmd);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.NAMED_STOREDPROC_QUERIES)) {
                NamedStoredProcedureQuery[] procs = (NamedStoredProcedureQuery[])annotationValues.get("value");
                if (namedStoredProcQueries == null) {
                    namedStoredProcQueries = new HashSet();
                }
                for (int j = 0; j < procs.length; ++j) {
                    int k;
                    if (StringUtils.isWhitespace((String)procs[j].name())) {
                        throw new InvalidClassMetaDataException(LOCALISER, "044154", cmd.getFullClassName());
                    }
                    StoredProcQueryMetaData spqmd = new StoredProcQueryMetaData(procs[j].name());
                    if (procs[j].resultClasses() != null && procs[j].resultClasses().length > 0) {
                        Class[] resultClasses = procs[j].resultClasses();
                        for (k = 0; k < resultClasses.length; ++k) {
                            spqmd.addResultClass(resultClasses[k].getName());
                        }
                    }
                    if (procs[j].resultSetMappings() != null && procs[j].resultSetMappings().length > 0) {
                        String[] resultSetMappings2 = procs[j].resultSetMappings();
                        for (k = 0; k < resultSetMappings2.length; ++k) {
                            spqmd.addResultSetMapping(resultSetMappings2[k]);
                        }
                    }
                    if (procs[j].parameters() != null && procs[j].parameters().length > 0) {
                        params = procs[j].parameters();
                        for (k = 0; k < params.length; ++k) {
                            parammd = this.getMetaDataForStoredProcParameter(params[k]);
                            spqmd.addParameter(parammd);
                        }
                    }
                    namedStoredProcQueries.add(spqmd);
                }
                continue;
            }
            if (!annName.equals(JPAAnnotationUtils.NAMED_STOREDPROC_QUERY)) continue;
            if (namedStoredProcQueries == null) {
                namedStoredProcQueries = new HashSet<StoredProcQueryMetaData>();
            }
            if (StringUtils.isWhitespace((String)((String)annotationValues.get("name")))) {
                throw new InvalidClassMetaDataException(LOCALISER, "044154", cmd.getFullClassName());
            }
            StoredProcQueryMetaData spqmd = new StoredProcQueryMetaData((String)annotationValues.get("name"));
            spqmd.setProcedureName((String)annotationValues.get("procedureName"));
            Class[] resultClasses = (Class[])annotationValues.get("resultClasses");
            if (resultClasses != null) {
                for (int j = 0; j < resultClasses.length; ++j) {
                    spqmd.addResultClass(resultClasses[j].getName());
                }
            }
            if ((resultSetMappings = (String[])annotationValues.get("resultSetMappings")) != null) {
                for (int j = 0; j < resultSetMappings.length; ++j) {
                    spqmd.addResultSetMapping(resultSetMappings[j]);
                }
            }
            if ((params = (StoredProcedureParameter[])annotationValues.get("parameters")) != null) {
                for (int j = 0; j < params.length; ++j) {
                    parammd = this.getMetaDataForStoredProcParameter(params[j]);
                    spqmd.addParameter(parammd);
                }
            }
            namedStoredProcQueries.add(spqmd);
        }
        if (namedQueries != null) {
            Iterator iter = namedQueries.iterator();
            while (iter.hasNext()) {
                cmd.addQuery((QueryMetaData)iter.next());
            }
        }
        if (namedStoredProcQueries != null) {
            Iterator iter = namedStoredProcQueries.iterator();
            while (iter.hasNext()) {
                cmd.addStoredProcQuery((StoredProcQueryMetaData)iter.next());
            }
        }
    }

    protected StoredProcQueryParameterMetaData getMetaDataForStoredProcParameter(StoredProcedureParameter param) {
        StoredProcQueryParameterMetaData pmd = new StoredProcQueryParameterMetaData();
        pmd.setName(param.name());
        pmd.setType(param.type().getName());
        if (param.mode() == ParameterMode.IN) {
            pmd.setMode(StoredProcQueryParameterMode.IN);
        } else if (param.mode() == ParameterMode.OUT) {
            pmd.setMode(StoredProcQueryParameterMode.OUT);
        } else if (param.mode() == ParameterMode.INOUT) {
            pmd.setMode(StoredProcQueryParameterMode.INOUT);
        } else if (param.mode() == ParameterMode.REF_CURSOR) {
            pmd.setMode(StoredProcQueryParameterMode.REF_CURSOR);
        }
        return pmd;
    }

    protected AbstractMemberMetaData processMemberAnnotations(AbstractClassMetaData cmd, Member member, AnnotationObject[] annotations, boolean propertyAccessor) {
        if (Modifier.isTransient(member.getModifiers())) {
            return null;
        }
        if (member.getName().startsWith("jdo")) {
            return null;
        }
        if (annotations != null && annotations.length > 0 || this.mgr.getApiAdapter().isMemberDefaultPersistent(member.getType())) {
            ColumnMetaData colmd;
            int i;
            if (!member.isProperty() && (annotations == null || annotations.length == 0) && propertyAccessor) {
                return null;
            }
            if (member.isProperty() && (annotations == null || annotations.length == 0) && !propertyAccessor) {
                return null;
            }
            AbstractMemberMetaData mmd = this.newMetaDataForMember(cmd, member, annotations);
            boolean elementCollection = false;
            for (int i2 = 0; i2 < annotations.length; ++i2) {
                String annName = annotations[i2].getName();
                if (!annName.equals(JPAAnnotationUtils.ELEMENT_COLLECTION)) continue;
                elementCollection = true;
                break;
            }
            ColumnMetaData[] columnMetaData = null;
            JoinMetaData joinmd = null;
            KeyMetaData keymd = null;
            boolean oneToMany = false;
            boolean manyToMany = false;
            for (i = 0; annotations != null && i < annotations.length; ++i) {
                EnumType type;
                ColumnMetaData colmd2;
                int k;
                Index[] joinIndexConstrs;
                String schemaName;
                String tableName;
                ForeignKeyMetaData fkmd;
                JoinColumn[] cols;
                String annName = annotations[i].getName();
                HashMap annotationValues = annotations[i].getNameValueMap();
                if (annName.equals(JPAAnnotationUtils.JOIN_COLUMNS)) {
                    cols = (JoinColumn[])annotationValues.get("value");
                    ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                    fkmd = null;
                    if (fk != null && fk.value() != ConstraintMode.PROVIDER_DEFAULT) {
                        fkmd = mmd.newForeignKeyMetaData();
                        fkmd.setName(fk.name());
                        fkmd.setFkDefinition(fk.foreignKeyDefinition());
                        if (fk.value() == ConstraintMode.NO_CONSTRAINT) {
                            fkmd.setFkDefinitionApplies(false);
                        }
                    }
                    if (cols == null) continue;
                    columnMetaData = new ColumnMetaData[cols.length];
                    for (int j = 0; j < cols.length; ++j) {
                        columnMetaData[j] = new ColumnMetaData();
                        columnMetaData[j].setName(cols[j].name());
                        columnMetaData[j].setTarget(cols[j].referencedColumnName());
                        columnMetaData[j].setAllowsNull(Boolean.valueOf(cols[j].nullable()));
                        columnMetaData[j].setInsertable(cols[j].insertable());
                        columnMetaData[j].setUpdateable(cols[j].updatable());
                        columnMetaData[j].setUnique(cols[j].unique());
                        if (fkmd == null) continue;
                        fkmd.addColumn(columnMetaData[j]);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.JOIN_COLUMN)) {
                    columnMetaData = new ColumnMetaData[1];
                    String colNullable = null;
                    String colInsertable = null;
                    String colUpdateable = null;
                    String colUnique = null;
                    if (annotationValues.get("nullable") != null) {
                        colNullable = annotationValues.get("nullable").toString();
                    }
                    if (annotationValues.get("insertable") != null) {
                        colInsertable = annotationValues.get("insertable").toString();
                    }
                    if (annotationValues.get("updatable") != null) {
                        colUpdateable = annotationValues.get("updatable").toString();
                    }
                    if (annotationValues.get("unique") != null) {
                        colUnique = annotationValues.get("unique").toString();
                    }
                    columnMetaData[0] = new ColumnMetaData();
                    columnMetaData[0].setName((String)annotationValues.get("name"));
                    columnMetaData[0].setTarget((String)annotationValues.get("referencedColumnName"));
                    columnMetaData[0].setAllowsNull(colNullable);
                    columnMetaData[0].setInsertable(colInsertable);
                    columnMetaData[0].setUpdateable(colUpdateable);
                    columnMetaData[0].setUnique(colUnique);
                    ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                    ForeignKeyMetaData fkmd2 = null;
                    if (fk == null || fk.value() == ConstraintMode.PROVIDER_DEFAULT) continue;
                    fkmd2 = mmd.newForeignKeyMetaData();
                    fkmd2.setName(fk.name());
                    fkmd2.setFkDefinition(fk.foreignKeyDefinition());
                    if (fk.value() == ConstraintMode.NO_CONSTRAINT) {
                        fkmd2.setFkDefinitionApplies(false);
                    }
                    fkmd2.addColumn(columnMetaData[0]);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.PRIMARY_KEY_JOIN_COLUMNS)) {
                    cols = (PrimaryKeyJoinColumn[])annotationValues.get("value");
                    if (cols == null) continue;
                    ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                    fkmd = null;
                    if (fk != null && fk.value() != ConstraintMode.PROVIDER_DEFAULT) {
                        fkmd = mmd.newForeignKeyMetaData();
                        fkmd.setName(fk.name());
                        fkmd.setFkDefinition(fk.foreignKeyDefinition());
                        if (fk.value() == ConstraintMode.NO_CONSTRAINT) {
                            fkmd.setFkDefinitionApplies(false);
                        }
                    }
                    columnMetaData = new ColumnMetaData[cols.length];
                    for (int j = 0; j < cols.length; ++j) {
                        columnMetaData[j] = new ColumnMetaData();
                        columnMetaData[j].setName(cols[j].name());
                        columnMetaData[j].setTarget(cols[j].referencedColumnName());
                        if (fkmd == null) continue;
                        fkmd.addColumn(columnMetaData[j]);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.PRIMARY_KEY_JOIN_COLUMN)) {
                    columnMetaData = new ColumnMetaData[]{new ColumnMetaData()};
                    columnMetaData[0].setName((String)annotationValues.get("name"));
                    columnMetaData[0].setTarget((String)annotationValues.get("referencedColumnName"));
                    ForeignKey fk = (ForeignKey)annotationValues.get("foreignKey");
                    ForeignKeyMetaData fkmd3 = null;
                    if (fk == null || fk.value() == ConstraintMode.PROVIDER_DEFAULT) continue;
                    fkmd3 = mmd.newForeignKeyMetaData();
                    fkmd3.setName(fk.name());
                    fkmd3.setFkDefinition(fk.foreignKeyDefinition());
                    if (fk.value() == ConstraintMode.NO_CONSTRAINT) {
                        fkmd3.setFkDefinitionApplies(false);
                    }
                    fkmd3.addColumn(columnMetaData[0]);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ATTRIBUTE_OVERRIDES)) {
                    mmd.setEmbedded(true);
                    AttributeOverride[] attributeOverride = (AttributeOverride[])annotationValues.get("value");
                    for (int j = 0; j < attributeOverride.length; ++j) {
                        this.processEmbeddedAttributeOverride(mmd, attributeOverride[j].name(), member.getType(), attributeOverride[j].column());
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ATTRIBUTE_OVERRIDE)) {
                    mmd.setEmbedded(true);
                    this.processEmbeddedAttributeOverride(mmd, (String)annotationValues.get("name"), member.getType(), (Column)annotationValues.get("column"));
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.JOIN_TABLE)) {
                    UniqueConstraint[] joinUniqueConstraints;
                    ForeignKey fk;
                    String catalogName;
                    tableName = (String)annotationValues.get("name");
                    if (!StringUtils.isWhitespace((String)tableName)) {
                        mmd.setTable(tableName);
                    }
                    if (!StringUtils.isWhitespace((String)(catalogName = (String)annotationValues.get("catalog")))) {
                        mmd.setCatalog(catalogName);
                    }
                    if (!StringUtils.isWhitespace((String)(schemaName = (String)annotationValues.get("schema")))) {
                        mmd.setSchema(schemaName);
                    }
                    joinmd = new JoinMetaData();
                    mmd.setJoinMetaData(joinmd);
                    if (annotationValues.get("joinColumns") != null) {
                        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>();
                        joinColumns.addAll(Arrays.asList((JoinColumn[])annotationValues.get("joinColumns")));
                        for (int j = 0; j < joinColumns.size(); ++j) {
                            ColumnMetaData colmd3 = new ColumnMetaData();
                            colmd3.setName(((JoinColumn)joinColumns.get(j)).name());
                            colmd3.setTarget(((JoinColumn)joinColumns.get(j)).referencedColumnName());
                            colmd3.setAllowsNull(Boolean.valueOf(((JoinColumn)joinColumns.get(j)).nullable()));
                            joinmd.addColumn(colmd3);
                        }
                    }
                    if (annotationValues.containsKey("foreignKey") && (fk = (ForeignKey)annotationValues.get("foreignKey")).value() == ConstraintMode.CONSTRAINT) {
                        ForeignKeyMetaData fkmd4 = joinmd.newForeignKeyMetaData();
                        fkmd4.setName(fk.name());
                        fkmd4.setFkDefinition(fk.foreignKeyDefinition());
                    }
                    if (annotationValues.get("inverseJoinColumns") != null) {
                        ArrayList<JoinColumn> elementColumns = new ArrayList<JoinColumn>();
                        elementColumns.addAll(Arrays.asList((JoinColumn[])annotationValues.get("inverseJoinColumns")));
                        ValueMetaData aemd = null;
                        if (Map.class.isAssignableFrom(member.getType())) {
                            aemd = new ValueMetaData();
                            mmd.setValueMetaData(aemd);
                        } else {
                            aemd = new ElementMetaData();
                            mmd.setElementMetaData((ElementMetaData)aemd);
                        }
                        for (int j = 0; j < elementColumns.size(); ++j) {
                            ColumnMetaData colmd4 = new ColumnMetaData();
                            colmd4.setName(((JoinColumn)elementColumns.get(j)).name());
                            colmd4.setTarget(((JoinColumn)elementColumns.get(j)).referencedColumnName());
                            colmd4.setAllowsNull(Boolean.valueOf(((JoinColumn)elementColumns.get(j)).nullable()));
                            aemd.addColumn(colmd4);
                        }
                    }
                    if (annotationValues.containsKey("inverseForeignKey") && (fk = (ForeignKey)annotationValues.get("inverseForeignKey")).value() == ConstraintMode.CONSTRAINT) {
                        ForeignKeyMetaData fkmd5 = mmd.newForeignKeyMetaData();
                        fkmd5.setName(fk.name());
                        fkmd5.setFkDefinition(fk.foreignKeyDefinition());
                    }
                    if ((joinUniqueConstraints = (UniqueConstraint[])annotationValues.get("uniqueConstraints")) != null && joinUniqueConstraints.length > 0) {
                        for (int j = 0; j < joinUniqueConstraints.length; ++j) {
                            UniqueMetaData unimd = new UniqueMetaData();
                            for (int k2 = 0; k2 < joinUniqueConstraints[j].columnNames().length; ++k2) {
                                ColumnMetaData colmd5 = new ColumnMetaData();
                                colmd5.setName(joinUniqueConstraints[j].columnNames()[k2]);
                                unimd.addColumn(colmd5);
                            }
                            joinmd.setUniqueMetaData(unimd);
                        }
                    }
                    if ((joinIndexConstrs = (Index[])annotationValues.get("indexes")) == null || joinIndexConstrs.length <= 0) continue;
                    for (int j = 0; j < joinIndexConstrs.length; ++j) {
                        String colStr;
                        String[] cols2;
                        IndexMetaData idxmd = new IndexMetaData();
                        if (!StringUtils.isWhitespace((String)joinIndexConstrs[j].name())) {
                            idxmd.setName(joinIndexConstrs[j].name());
                        }
                        if ((cols2 = StringUtils.split((String)(colStr = joinIndexConstrs[j].columnList()), (String)",")) != null) {
                            for (k = 0; k < cols2.length; ++k) {
                                colmd2 = new ColumnMetaData();
                                colmd2.setName(cols2[k]);
                                colmd2.setParent((MetaData)idxmd);
                                idxmd.addColumn(colmd2);
                            }
                        }
                        if (joinIndexConstrs[j].unique()) {
                            idxmd.setUnique(true);
                        }
                        joinmd.setIndexMetaData(idxmd);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.COLLECTION_TABLE)) {
                    UniqueConstraint[] joinUniqueConstraints;
                    ForeignKey fk;
                    String catalogName;
                    tableName = (String)annotationValues.get("name");
                    if (!StringUtils.isWhitespace((String)tableName)) {
                        mmd.setTable(tableName);
                    }
                    if (!StringUtils.isWhitespace((String)(catalogName = (String)annotationValues.get("catalog")))) {
                        mmd.setCatalog(catalogName);
                    }
                    if (!StringUtils.isWhitespace((String)(schemaName = (String)annotationValues.get("schema")))) {
                        mmd.setSchema(schemaName);
                    }
                    if ((joinmd = mmd.getJoinMetaData()) == null) {
                        joinmd = new JoinMetaData();
                        mmd.setJoinMetaData(joinmd);
                    }
                    if (annotationValues.get("joinColumns") != null) {
                        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>();
                        joinColumns.addAll(Arrays.asList((JoinColumn[])annotationValues.get("joinColumns")));
                        for (int j = 0; j < joinColumns.size(); ++j) {
                            ColumnMetaData colmd6 = new ColumnMetaData();
                            colmd6.setName(((JoinColumn)joinColumns.get(j)).name());
                            colmd6.setTarget(((JoinColumn)joinColumns.get(j)).referencedColumnName());
                            colmd6.setAllowsNull(Boolean.valueOf(((JoinColumn)joinColumns.get(j)).nullable()));
                            joinmd.addColumn(colmd6);
                        }
                    }
                    if (annotationValues.containsKey("foreignKey") && (fk = (ForeignKey)annotationValues.get("foreignKey")).value() == ConstraintMode.CONSTRAINT) {
                        ForeignKeyMetaData fkmd6 = joinmd.newForeignKeyMetaData();
                        fkmd6.setName(fk.name());
                        fkmd6.setFkDefinition(fk.foreignKeyDefinition());
                    }
                    if ((joinUniqueConstraints = (UniqueConstraint[])annotationValues.get("uniqueConstraints")) != null && joinUniqueConstraints.length > 0) {
                        for (int j = 0; j < joinUniqueConstraints.length; ++j) {
                            UniqueMetaData unimd = new UniqueMetaData();
                            for (int k3 = 0; k3 < joinUniqueConstraints[j].columnNames().length; ++k3) {
                                ColumnMetaData colmd7 = new ColumnMetaData();
                                colmd7.setName(joinUniqueConstraints[j].columnNames()[k3]);
                                unimd.addColumn(colmd7);
                            }
                            joinmd.setUniqueMetaData(unimd);
                        }
                    }
                    if ((joinIndexConstrs = (Index[])annotationValues.get("indexes")) == null || joinIndexConstrs.length <= 0) continue;
                    for (int j = 0; j < joinIndexConstrs.length; ++j) {
                        String colStr;
                        String[] cols3;
                        IndexMetaData idxmd = new IndexMetaData();
                        if (!StringUtils.isWhitespace((String)joinIndexConstrs[j].name())) {
                            idxmd.setName(joinIndexConstrs[j].name());
                        }
                        if ((cols3 = StringUtils.split((String)(colStr = joinIndexConstrs[j].columnList()), (String)",")) != null) {
                            for (k = 0; k < cols3.length; ++k) {
                                colmd2 = new ColumnMetaData();
                                colmd2.setName(cols3[k]);
                                colmd2.setParent((MetaData)idxmd);
                                idxmd.addColumn(colmd2);
                            }
                        }
                        if (joinIndexConstrs[j].unique()) {
                            idxmd.setUnique(true);
                        }
                        joinmd.setIndexMetaData(idxmd);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.MAP_KEY_COLUMN)) {
                    String name;
                    if (keymd == null) {
                        keymd = new KeyMetaData();
                        mmd.setKeyMetaData(keymd);
                    }
                    if ((name = (String)annotationValues.get("name")) != null) {
                        keymd.setMappedBy(name);
                    }
                    Class keyType = mmd.getMap() != null && mmd.getMap().getKeyType() != null ? this.clr.classForName(mmd.getMap().getKeyType()) : Object.class;
                    keymd.addColumn(this.newColumnMetaData((MetaData)keymd, keyType, annotations));
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.MAP_KEY)) {
                    String keyMappedBy = (String)annotationValues.get("name");
                    if (keyMappedBy == null) continue;
                    if (keymd == null) {
                        keymd = new KeyMetaData();
                        mmd.setKeyMetaData(keymd);
                    }
                    keymd.setMappedBy(keyMappedBy);
                    if (mmd.getMap() == null || mmd.getMap().getKeyType() != null && !mmd.getMap().getKeyType().equals(Object.class.getName())) continue;
                    String valueType = mmd.getMap().getValueType();
                    try {
                        Class cls = this.clr.classForName(valueType);
                        try {
                            Field fld = cls.getDeclaredField(keyMappedBy);
                            mmd.getMap().setKeyType(fld.getType().getName());
                        }
                        catch (NoSuchFieldException nsfe) {
                            try {
                                String getterName = ClassUtils.getJavaBeanGetterName((String)keyMappedBy, (boolean)false);
                                Method mthd = cls.getDeclaredMethod(getterName, null);
                                mmd.getMap().setKeyType(mthd.getReturnType().getName());
                            }
                            catch (NoSuchMethodException nsme) {
                            }
                        }
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.MAP_KEY_ENUMERATED)) {
                    type = (EnumType)annotationValues.get("value");
                    if (keymd == null) {
                        keymd = new KeyMetaData();
                        mmd.setKeyMetaData(keymd);
                    }
                    ColumnMetaData colmd8 = keymd.newColumnMetaData();
                    colmd8.setJdbcType(type == EnumType.STRING ? "VARCHAR" : "INTEGER");
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.MAP_KEY_TEMPORAL)) {
                    type = (TemporalType)annotationValues.get("value");
                    String jdbcType = null;
                    if (type == TemporalType.DATE) {
                        jdbcType = "DATE";
                    } else if (type == TemporalType.TIME) {
                        jdbcType = "TIME";
                    } else if (type == TemporalType.TIMESTAMP) {
                        jdbcType = "TIMESTAMP";
                    }
                    if (keymd == null) {
                        keymd = new KeyMetaData();
                        mmd.setKeyMetaData(keymd);
                    }
                    ColumnMetaData colmd9 = keymd.newColumnMetaData();
                    colmd9.setJdbcType(jdbcType);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ORDER_BY)) {
                    if (mmd.getOrderMetaData() != null) {
                        throw new NucleusException("@OrderBy found yet field=" + cmd.getFullClassName() + "." + member.getName() + " already has ordering information!");
                    }
                    String orderBy = (String)annotationValues.get("value");
                    if (orderBy == null) continue;
                    OrderMetaData ordmd = new OrderMetaData();
                    ordmd.setOrdering(orderBy);
                    mmd.setOrderMetaData(ordmd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ORDER_COLUMN)) {
                    if (mmd.getOrderMetaData() != null) {
                        throw new NucleusException("@OrderColumn found yet field=" + cmd.getFullClassName() + "." + member.getName() + " already has ordering information!");
                    }
                    String columnName = (String)annotationValues.get("name");
                    OrderMetaData ordermd = new OrderMetaData();
                    ordermd.setColumnName(columnName);
                    String colNullable = null;
                    String colInsertable = null;
                    String colUpdateable = null;
                    if (annotationValues.get("nullable") != null) {
                        colNullable = annotationValues.get("nullable").toString();
                    }
                    if (annotationValues.get("insertable") != null) {
                        colInsertable = annotationValues.get("insertable").toString();
                    }
                    if (annotationValues.get("updatable") != null) {
                        colUpdateable = annotationValues.get("updatable").toString();
                    }
                    ColumnMetaData colmd10 = new ColumnMetaData();
                    colmd10.setName(columnName);
                    colmd10.setAllowsNull(colNullable);
                    colmd10.setInsertable(colInsertable);
                    colmd10.setUpdateable(colUpdateable);
                    String tmp = (String)annotationValues.get("columnDefinition");
                    if (!StringUtils.isWhitespace((String)tmp)) {
                        colmd10.setColumnDdl(tmp);
                    }
                    ordermd.addColumn(colmd10);
                    mmd.setOrderMetaData(ordermd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ONE_TO_MANY)) {
                    oneToMany = true;
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.MANY_TO_MANY)) {
                    manyToMany = true;
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.CONVERTS)) {
                    Convert[] converts = (Convert[])annotationValues.get("value");
                    if (converts == null || converts.length == 0) continue;
                    if (converts.length > 1) {
                        NucleusLogger.METADATA.warn((Object)"Dont currently support @Converts annotation for embedded fields");
                        continue;
                    }
                    if (converts.length != 1) continue;
                    Class converterCls = converts[0].converter();
                    String subfieldName = converts[0].attributeName();
                    Boolean disable = converts[0].disableConversion();
                    if (disable == Boolean.TRUE) {
                        mmd.setTypeConverterDisabled();
                        continue;
                    }
                    if (!StringUtils.isWhitespace((String)subfieldName)) {
                        NucleusLogger.METADATA.warn((Object)("Field " + mmd.getFullFieldName() + " has @Convert annotation for attribute " + subfieldName + " but this is not yet supported. Ignored"));
                        continue;
                    }
                    TypeManager typeMgr = this.mgr.getNucleusContext().getTypeManager();
                    if (typeMgr.getTypeConverterForName(converterCls.getName()) == null) {
                        AttributeConverter entityConv = (AttributeConverter)ClassUtils.newInstance((Class)converterCls, null, null);
                        Class<?> dbType = null;
                        try {
                            Method[] methods = entityConv.getClass().getDeclaredMethods();
                            if (methods != null) {
                                for (int j = 0; j < methods.length; ++j) {
                                    Class<?> returnCls;
                                    if (!methods[j].getName().equals("convertToDatabaseColumn") || (returnCls = methods[j].getReturnType()) == Object.class) continue;
                                    dbType = returnCls;
                                }
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        JPATypeConverter conv = new JPATypeConverter(entityConv, member.getType(), dbType);
                        typeMgr.registerConverter(converterCls.getName(), conv);
                        mmd.setTypeConverterName(converterCls.getName());
                        continue;
                    }
                    mmd.setTypeConverterName(converterCls.getName());
                    continue;
                }
                if (!annName.equals(JPAAnnotationUtils.CONVERT)) continue;
                Class converterCls = (Class)annotationValues.get("converter");
                String subfieldName = (String)annotationValues.get("attributeName");
                Boolean disable = (Boolean)annotationValues.get("disableConversion");
                if (disable == Boolean.TRUE) continue;
                if (!StringUtils.isWhitespace((String)subfieldName)) {
                    NucleusLogger.METADATA.warn((Object)("Field " + mmd.getFullFieldName() + " has @Convert annotation for attribute " + subfieldName + " but this is not yet supported. Ignored"));
                    continue;
                }
                TypeManager typeMgr = this.mgr.getNucleusContext().getTypeManager();
                if (typeMgr.getTypeConverterForName(converterCls.getName()) == null) {
                    AttributeConverter entityConv = (AttributeConverter)ClassUtils.newInstance((Class)converterCls, null, null);
                    Class<?> dbType = null;
                    try {
                        Method[] methods = entityConv.getClass().getDeclaredMethods();
                        if (methods != null) {
                            for (int j = 0; j < methods.length; ++j) {
                                Class<?> returnCls;
                                if (!methods[j].getName().equals("convertToDatabaseColumn") || (returnCls = methods[j].getReturnType()) == Object.class) continue;
                                dbType = returnCls;
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    JPATypeConverter conv = new JPATypeConverter(entityConv, member.getType(), dbType);
                    typeMgr.registerConverter(converterCls.getName(), conv);
                    mmd.setTypeConverterName(converterCls.getName());
                    continue;
                }
                mmd.setTypeConverterName(converterCls.getName());
            }
            if (oneToMany && mmd.getJoinMetaData() == null && mmd.getMappedBy() == null && columnMetaData == null) {
                mmd.setJoinMetaData(new JoinMetaData());
            }
            if (manyToMany && mmd.getJoinMetaData() == null && mmd.getMappedBy() == null) {
                mmd.setJoinMetaData(new JoinMetaData());
            }
            if (mmd.getOrderMetaData() == null && Collection.class.isAssignableFrom(member.getType())) {
                OrderMetaData ordmd = new OrderMetaData();
                ordmd.setOrdering("#PK");
                mmd.setOrderMetaData(ordmd);
            }
            if (columnMetaData == null && (colmd = this.newColumnMetaData((MetaData)mmd, member.getType(), annotations)) != null) {
                columnMetaData = new ColumnMetaData[]{colmd};
            }
            if (columnMetaData != null) {
                if ((mmd.hasCollection() || mmd.hasArray()) && joinmd == null) {
                    ElementMetaData elemmd = mmd.getElementMetaData();
                    if (elemmd == null) {
                        elemmd = new ElementMetaData();
                        mmd.setElementMetaData(elemmd);
                    }
                    for (int i3 = 0; i3 < columnMetaData.length; ++i3) {
                        elemmd.addColumn(columnMetaData[i3]);
                    }
                } else if (mmd.hasMap() && joinmd == null) {
                    ValueMetaData valmd = mmd.getValueMetaData();
                    if (valmd == null) {
                        valmd = new ValueMetaData();
                        mmd.setValueMetaData(valmd);
                    }
                    for (int i4 = 0; i4 < columnMetaData.length; ++i4) {
                        valmd.addColumn(columnMetaData[i4]);
                    }
                } else if (elementCollection) {
                    if (mmd.hasCollection() || mmd.hasArray()) {
                        ElementMetaData elemmd = mmd.getElementMetaData();
                        if (elemmd == null) {
                            elemmd = new ElementMetaData();
                            mmd.setElementMetaData(elemmd);
                        }
                        for (int i5 = 0; i5 < columnMetaData.length; ++i5) {
                            elemmd.addColumn(columnMetaData[i5]);
                        }
                    } else if (mmd.hasMap()) {
                        ValueMetaData valmd = mmd.getValueMetaData();
                        if (valmd == null) {
                            valmd = new ValueMetaData();
                            mmd.setValueMetaData(valmd);
                        }
                        for (int i6 = 0; i6 < columnMetaData.length; ++i6) {
                            valmd.addColumn(columnMetaData[i6]);
                        }
                    }
                } else {
                    for (i = 0; i < columnMetaData.length; ++i) {
                        mmd.addColumn(columnMetaData[i]);
                    }
                }
            }
            return mmd;
        }
        return null;
    }

    protected void processEmbeddedAttributeOverride(AbstractMemberMetaData mmd, String overriddenName, Class type, Column column) {
        EmbeddedMetaData embmd = null;
        if (mmd.hasCollection()) {
            type = this.clr.classForName(mmd.getCollection().getElementType());
            ElementMetaData elemmd = mmd.getElementMetaData();
            if (elemmd == null) {
                elemmd = new ElementMetaData();
                mmd.setElementMetaData(elemmd);
            }
            if ((embmd = elemmd.getEmbeddedMetaData()) == null) {
                embmd = elemmd.newEmbeddedMetaData();
            }
        } else {
            embmd = mmd.getEmbeddedMetaData();
            if (embmd == null) {
                embmd = new EmbeddedMetaData();
                embmd.setParent((MetaData)mmd);
                mmd.setEmbeddedMetaData(embmd);
            }
            mmd.setEmbeddedMetaData(embmd);
        }
        if (overriddenName.indexOf(46) > 0) {
            AccessibleObject overrideMember;
            int position = overriddenName.indexOf(46);
            String baseMemberName = overriddenName.substring(0, position);
            String nestedMemberName = overriddenName.substring(position + 1);
            FieldMetaData ammd = null;
            try {
                overrideMember = type.getDeclaredField(baseMemberName);
                ammd = new FieldMetaData((MetaData)embmd, baseMemberName);
                type = ((Field)overrideMember).getType();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ammd == null) {
                try {
                    overrideMember = type.getDeclaredMethod(ClassUtils.getJavaBeanGetterName((String)baseMemberName, (boolean)false), new Class[0]);
                    ammd = new FieldMetaData((MetaData)embmd, baseMemberName);
                    type = ((Method)overrideMember).getReturnType();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (ammd == null) {
                throw new NucleusException("Cannot obtain override field/property " + overriddenName + " of class " + type + " for persistent class " + mmd.getClassName(true));
            }
            embmd.addMember(ammd);
            ammd.setParent((MetaData)embmd);
            this.processEmbeddedAttributeOverride((AbstractMemberMetaData)ammd, nestedMemberName, type, column);
        } else {
            Member overriddenMember = null;
            AccessibleObject overrideMember = null;
            FieldMetaData ammd = null;
            try {
                overrideMember = type.getDeclaredField(overriddenName);
                overriddenMember = new Member(overrideMember);
                ammd = new FieldMetaData((MetaData)embmd, overriddenName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ammd == null) {
                try {
                    overrideMember = type.getDeclaredMethod(ClassUtils.getJavaBeanGetterName((String)overriddenName, (boolean)false), new Class[0]);
                    overriddenMember = new Member((Method)overrideMember);
                    ammd = new PropertyMetaData((MetaData)embmd, overriddenName);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (ammd == null) {
                throw new NucleusException("Cannot obtain override field/property " + overriddenName + " of class " + type + " for persistent class " + mmd.getClassName(true));
            }
            embmd.addMember(ammd);
            ammd.addColumn(JPAAnnotationUtils.getColumnMetaDataForColumnAnnotation(ammd, overriddenMember, column));
        }
    }

    protected void processMethodAnnotations(AbstractClassMetaData cmd, Method method) {
        Annotation[] annotations = method.getAnnotations();
        if (annotations != null && annotations.length > 0) {
            EventListenerMetaData elmd = cmd.getListenerForClass(cmd.getFullClassName());
            for (int i = 0; i < annotations.length; ++i) {
                String annotationTypeName = annotations[i].annotationType().getName();
                if (!annotationTypeName.equals(PrePersist.class.getName()) && !annotationTypeName.equals(PostPersist.class.getName()) && !annotationTypeName.equals(PreRemove.class.getName()) && !annotationTypeName.equals(PostRemove.class.getName()) && !annotationTypeName.equals(PreUpdate.class.getName()) && !annotationTypeName.equals(PostUpdate.class.getName()) && !annotationTypeName.equals(PostLoad.class.getName())) continue;
                if (elmd == null) {
                    elmd = new EventListenerMetaData(cmd.getFullClassName());
                    cmd.addListener(elmd);
                }
                elmd.addCallback(annotationTypeName, method.getDeclaringClass().getName(), method.getName());
            }
        }
    }

    private AbstractMemberMetaData newMetaDataForMember(AbstractClassMetaData cmd, Member field, AnnotationObject[] annotations) {
        FieldPersistenceModifier modifier = null;
        Boolean dfg = null;
        Boolean embedded = null;
        Boolean pk = null;
        String version = null;
        String nullValue = null;
        String mappedBy = null;
        boolean orphanRemoval = false;
        CascadeType[] cascades = null;
        HashSet<ExtensionMetaData> extensions = null;
        String valueStrategy = null;
        String valueGenerator = null;
        boolean storeInLob = false;
        Class targetEntity = null;
        boolean addJoin = false;
        for (int i = 0; annotations != null && i < annotations.length; ++i) {
            boolean optional;
            FetchType fetch;
            String annName = annotations[i].getName();
            HashMap annotationValues = annotations[i].getNameValueMap();
            if (annName.equals(JPAAnnotationUtils.EMBEDDED)) {
                embedded = Boolean.TRUE;
                cascades = new CascadeType[]{CascadeType.ALL};
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ID)) {
                pk = Boolean.TRUE;
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.TRANSIENT)) {
                modifier = FieldPersistenceModifier.NONE;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ENUMERATED)) {
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.VERSION)) {
                version = "true";
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EMBEDDED_ID)) {
                pk = Boolean.TRUE;
                embedded = Boolean.TRUE;
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.BASIC)) {
                fetch = (FetchType)annotationValues.get("fetch");
                dfg = fetch == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE;
                modifier = FieldPersistenceModifier.PERSISTENT;
                if (field.getType().isPrimitive()) continue;
                optional = (Boolean)annotationValues.get("optional");
                if (!optional) {
                    nullValue = "exception";
                    continue;
                }
                nullValue = "none";
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ONE_TO_ONE)) {
                modifier = FieldPersistenceModifier.PERSISTENT;
                mappedBy = (String)annotationValues.get("mappedBy");
                cascades = (CascadeType[])annotationValues.get("cascade");
                targetEntity = (Class)annotationValues.get("targetEntity");
                fetch = (FetchType)annotationValues.get("fetch");
                dfg = fetch == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE;
                optional = (Boolean)annotationValues.get("optional");
                nullValue = !optional ? "exception" : "none";
                orphanRemoval = (Boolean)annotationValues.get("orphanRemoval");
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ONE_TO_MANY)) {
                modifier = FieldPersistenceModifier.PERSISTENT;
                mappedBy = (String)annotationValues.get("mappedBy");
                cascades = (CascadeType[])annotationValues.get("cascade");
                targetEntity = (Class)annotationValues.get("targetEntity");
                fetch = (FetchType)annotationValues.get("fetch");
                dfg = fetch == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE;
                orphanRemoval = (Boolean)annotationValues.get("orphanRemoval");
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.MANY_TO_MANY)) {
                modifier = FieldPersistenceModifier.PERSISTENT;
                mappedBy = (String)annotationValues.get("mappedBy");
                cascades = (CascadeType[])annotationValues.get("cascade");
                targetEntity = (Class)annotationValues.get("targetEntity");
                fetch = (FetchType)annotationValues.get("fetch");
                dfg = fetch == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.MANY_TO_ONE)) {
                modifier = FieldPersistenceModifier.PERSISTENT;
                mappedBy = (String)annotationValues.get("mappedBy");
                cascades = (CascadeType[])annotationValues.get("cascade");
                targetEntity = (Class)annotationValues.get("targetEntity");
                fetch = (FetchType)annotationValues.get("fetch");
                dfg = fetch == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE;
                optional = (Boolean)annotationValues.get("optional");
                if (!optional) {
                    nullValue = "exception";
                    continue;
                }
                nullValue = "none";
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ELEMENT_COLLECTION)) {
                modifier = FieldPersistenceModifier.PERSISTENT;
                targetEntity = (Class)annotationValues.get("targetClass");
                addJoin = true;
                fetch = (FetchType)annotationValues.get("fetch");
                dfg = fetch == FetchType.LAZY ? Boolean.FALSE : Boolean.TRUE;
                cascades = new CascadeType[]{CascadeType.ALL};
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.GENERATED_VALUE)) {
                GenerationType type = (GenerationType)annotationValues.get("strategy");
                valueStrategy = JPAAnnotationUtils.getIdentityStrategyString(type);
                valueGenerator = (String)annotationValues.get("generator");
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.LOB)) {
                storeInLob = true;
                modifier = FieldPersistenceModifier.PERSISTENT;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EXTENSION)) {
                ExtensionMetaData extmd = new ExtensionMetaData((String)annotationValues.get("vendorName"), (String)annotationValues.get("key"), (String)annotationValues.get("value"));
                if (extensions == null) {
                    extensions = new HashSet<ExtensionMetaData>(1);
                }
                extensions.add(extmd);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EXTENSIONS)) {
                Extension[] values = (Extension[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                if (extensions == null) {
                    extensions = new HashSet(values.length);
                }
                for (int j = 0; j < values.length; ++j) {
                    ExtensionMetaData extmd = new ExtensionMetaData(values[j].vendorName(), values[j].key().toString(), values[j].value().toString());
                    extensions.add(extmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.SEQUENCE_GENERATOR)) {
                this.processSequenceGeneratorAnnotation(cmd.getPackageMetaData(), annotationValues);
                continue;
            }
            if (!annName.equals(JPAAnnotationUtils.TABLE_GENERATOR)) continue;
            this.processTableGeneratorAnnotation(cmd.getPackageMetaData(), annotationValues);
        }
        if (this.mgr.getApiAdapter().isMemberDefaultPersistent(field.getType()) && modifier == null) {
            modifier = FieldPersistenceModifier.PERSISTENT;
        }
        Object fmd = field.isProperty() ? new PropertyMetaData((MetaData)cmd, field.getName()) : new FieldMetaData((MetaData)cmd, field.getName());
        if (modifier != null) {
            fmd.setPersistenceModifier(modifier);
        }
        if (pk != null) {
            fmd.setPrimaryKey(pk.booleanValue());
        }
        if (dfg != null) {
            fmd.setDefaultFetchGroup(dfg.booleanValue());
        }
        if (embedded != null) {
            fmd.setEmbedded(embedded.booleanValue());
        }
        fmd.setNullValue(NullValue.getNullValue(nullValue));
        fmd.setMappedBy(mappedBy);
        if (version != null) {
            VersionMetaData vermd = cmd.newVersionMetadata();
            vermd.setStrategy(VersionStrategy.VERSION_NUMBER).setFieldName(fmd.getName());
        }
        cmd.addMember((AbstractMemberMetaData)fmd);
        if (orphanRemoval) {
            fmd.setCascadeRemoveOrphans(true);
        }
        if (cascades != null) {
            for (int i = 0; i < cascades.length; ++i) {
                if (cascades[i] == CascadeType.ALL) {
                    fmd.setCascadePersist(true);
                    fmd.setCascadeUpdate(true);
                    fmd.setCascadeDelete(true);
                    fmd.setCascadeDetach(true);
                    fmd.setCascadeRefresh(true);
                    continue;
                }
                if (cascades[i] == CascadeType.PERSIST) {
                    fmd.setCascadePersist(true);
                    continue;
                }
                if (cascades[i] == CascadeType.MERGE) {
                    fmd.setCascadeUpdate(true);
                    continue;
                }
                if (cascades[i] == CascadeType.REMOVE) {
                    fmd.setCascadeDelete(true);
                    continue;
                }
                if (cascades[i] == CascadeType.REFRESH) {
                    fmd.setCascadeRefresh(true);
                    continue;
                }
                if (cascades[i] != CascadeType.DETACH) continue;
                fmd.setCascadeDetach(true);
            }
        }
        if (valueStrategy != null && valueGenerator != null) {
            fmd.setSequence(valueGenerator);
            fmd.setValueGeneratorName(valueGenerator);
        }
        if (valueStrategy != null) {
            fmd.setValueStrategy(valueStrategy);
        }
        if (storeInLob) {
            fmd.setStoreInLob();
        }
        ArrayMetaData contmd = null;
        if (Collection.class.isAssignableFrom(field.getType())) {
            String elementType = null;
            if (targetEntity != null && targetEntity != Void.TYPE) {
                elementType = targetEntity.getName();
            }
            if (elementType == null) {
                Class elType = ClassUtils.getCollectionElementType((Class)field.getType(), (Type)field.getGenericType());
                elementType = elType != null ? elType.getName() : null;
            }
            contmd = new CollectionMetaData();
            ((CollectionMetaData)contmd).setElementType(elementType);
        } else if (field.getType().isArray()) {
            contmd = new ArrayMetaData();
        } else if (Map.class.isAssignableFrom(field.getType())) {
            Class keyCls = ClassUtils.getMapKeyType((Class)field.getType(), (Type)field.getGenericType());
            String keyType = keyCls != null ? keyCls.getName() : null;
            String valueType = null;
            if (targetEntity != null && targetEntity != Void.TYPE) {
                valueType = targetEntity.getName();
            }
            if (valueType == null) {
                Class valueCls = ClassUtils.getMapValueType((Class)field.getType(), (Type)field.getGenericType());
                valueType = valueCls != null ? valueCls.getName() : null;
            }
            contmd = new MapMetaData();
            MapMetaData mapmd = (MapMetaData)contmd;
            mapmd.setKeyType(keyType);
            mapmd.setValueType(valueType);
        }
        if (contmd != null) {
            fmd.setContainer((ContainerMetaData)contmd);
        }
        if (addJoin && fmd.getJoinMetaData() == null) {
            JoinMetaData joinmd = new JoinMetaData();
            fmd.setJoinMetaData(joinmd);
        }
        if (extensions != null) {
            for (ExtensionMetaData extmd : extensions) {
                fmd.addExtension(extmd.getVendorName(), extmd.getKey(), extmd.getValue());
            }
        }
        return fmd;
    }

    private ColumnMetaData newColumnMetaData(MetaData parent, Class fieldType, AnnotationObject[] annotations) {
        String columnName = null;
        String target = null;
        String targetField = null;
        String jdbcType = null;
        String sqlType = null;
        String typePrecision = null;
        String typeLength = null;
        String typeScale = null;
        String allowsNull = null;
        String defaultValue = null;
        String insertValue = null;
        String insertable = null;
        String updateable = null;
        String unique = null;
        String table = null;
        String columnDdl = null;
        for (int i = 0; annotations != null && i < annotations.length; ++i) {
            EnumType type;
            String annName = annotations[i].getName();
            HashMap annotationValues = annotations[i].getNameValueMap();
            if (annName.equals(JPAAnnotationUtils.COLUMN) || parent instanceof KeyMetaData && annName.equals(JPAAnnotationUtils.MAP_KEY_COLUMN)) {
                String tmp;
                String columnTable;
                int scaleValue;
                int precisionValue;
                columnName = (String)annotationValues.get("name");
                typeLength = "" + (Integer)annotationValues.get("length");
                if (annotationValues.get("precision") != null && (precisionValue = ((Integer)annotationValues.get("precision")).intValue()) != 0) {
                    typePrecision = "" + precisionValue;
                }
                if (annotationValues.get("scale") != null && (scaleValue = ((Integer)annotationValues.get("scale")).intValue()) != 0) {
                    typeScale = "" + scaleValue;
                }
                if (fieldType == Character.TYPE || fieldType == Character.class) {
                    jdbcType = "CHAR";
                    typeLength = "1";
                } else if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                    jdbcType = "SMALLINT";
                }
                if (annotationValues.get("nullable") != null) {
                    allowsNull = annotationValues.get("nullable").toString();
                }
                if (annotationValues.get("insertable") != null) {
                    insertable = annotationValues.get("insertable").toString();
                }
                if (annotationValues.get("updatable") != null) {
                    updateable = annotationValues.get("updatable").toString();
                }
                if (annotationValues.get("unique") != null) {
                    unique = annotationValues.get("unique").toString();
                }
                if (annotationValues.get("table") != null && !StringUtils.isWhitespace((String)(columnTable = (String)annotationValues.get("table")))) {
                    table = columnTable;
                }
                if (StringUtils.isWhitespace((String)(tmp = (String)annotationValues.get("columnDefinition")))) continue;
                columnDdl = tmp;
                continue;
            }
            if (Enum.class.isAssignableFrom(fieldType) && annName.equals(JPAAnnotationUtils.ENUMERATED)) {
                type = (EnumType)annotationValues.get("value");
                jdbcType = type == EnumType.STRING ? "VARCHAR" : "INTEGER";
                continue;
            }
            if (!JPAAnnotationUtils.isTemporalType(fieldType) || !annName.equals(JPAAnnotationUtils.TEMPORAL)) continue;
            type = (TemporalType)annotationValues.get("value");
            if (type == TemporalType.DATE) {
                jdbcType = "DATE";
                continue;
            }
            if (type == TemporalType.TIME) {
                jdbcType = "TIME";
                continue;
            }
            if (type != TemporalType.TIMESTAMP) continue;
            jdbcType = "TIMESTAMP";
        }
        String length = null;
        String scale = null;
        if (Enum.class.isAssignableFrom(fieldType)) {
            if (jdbcType != null && jdbcType.equals("VARCHAR")) {
                length = typeLength;
            } else if (typePrecision != null) {
                length = typePrecision;
            }
        } else {
            length = String.class.isAssignableFrom(fieldType) || fieldType == Character.class || fieldType == Character.TYPE ? typeLength : (typePrecision != null ? typePrecision : null);
            scale = typeScale;
        }
        if (columnName == null && length == null && scale == null && insertable == null && updateable == null && allowsNull == null && unique == null && jdbcType == null && sqlType == null) {
            return null;
        }
        ColumnMetaData colmd = new ColumnMetaData();
        colmd.setName(columnName);
        colmd.setTarget(target);
        colmd.setTargetMember(targetField);
        colmd.setJdbcType(jdbcType);
        colmd.setSqlType(sqlType);
        colmd.setLength(length);
        colmd.setScale(scale);
        colmd.setAllowsNull(allowsNull);
        colmd.setDefaultValue(defaultValue);
        colmd.setInsertValue(insertValue);
        colmd.setInsertable(insertable);
        colmd.setUpdateable(updateable);
        colmd.setUnique(unique);
        if (columnDdl != null) {
            colmd.setColumnDdl(columnDdl);
        }
        if (parent instanceof AbstractMemberMetaData) {
            AbstractMemberMetaData apmd = (AbstractMemberMetaData)parent;
            if (!StringUtils.isWhitespace(table)) {
                apmd.setTable(table);
            }
            colmd.setAllowsNull(Boolean.valueOf(apmd.isPrimaryKey() ? false : colmd.isAllowsNull()));
        } else if (parent instanceof KeyMetaData) {
            KeyMetaData keymd = (KeyMetaData)parent;
            AbstractMemberMetaData apmd = (AbstractMemberMetaData)keymd.getParent();
            if (!StringUtils.isWhitespace((String)table)) {
                apmd.setTable(table);
            }
            colmd.setAllowsNull(Boolean.valueOf(colmd.isAllowsNull()));
        }
        return colmd;
    }

    private JoinMetaData[] newJoinMetaDataForClass(AbstractClassMetaData cmd, AnnotationObject[] annotations) {
        HashSet<JoinMetaData> joins = new HashSet<JoinMetaData>();
        for (int i = 0; annotations != null && i < annotations.length; ++i) {
            Index[] indexConstrs;
            UniqueConstraint[] constrs;
            ForeignKey fk;
            ColumnMetaData colmd;
            ColumnMetaData colmd2;
            String annName = annotations[i].getName();
            HashMap annotationValues = annotations[i].getNameValueMap();
            if (annName.equals(JPAAnnotationUtils.SECONDARY_TABLES)) {
                SecondaryTable[] secTableAnns = (SecondaryTable[])annotationValues.get("value");
                if (secTableAnns == null) continue;
                for (int j = 0; j < secTableAnns.length; ++j) {
                    Index[] indexConstrs2;
                    JoinMetaData joinmd = new JoinMetaData();
                    joinmd.setTable(secTableAnns[j].name());
                    joinmd.setCatalog(secTableAnns[j].catalog());
                    joinmd.setSchema(secTableAnns[j].schema());
                    PrimaryKeyJoinColumn[] pkJoinCols = secTableAnns[j].pkJoinColumns();
                    if (pkJoinCols != null) {
                        for (int k = 0; k < pkJoinCols.length; ++k) {
                            colmd2 = new ColumnMetaData();
                            colmd2.setName(pkJoinCols[k].name());
                            colmd2.setTarget(pkJoinCols[k].referencedColumnName());
                            joinmd.addColumn(colmd2);
                        }
                    }
                    joins.add(joinmd);
                    cmd.addJoin(joinmd);
                    UniqueConstraint[] constrs2 = secTableAnns[j].uniqueConstraints();
                    if (constrs2 != null && constrs2.length > 0) {
                        for (int k = 0; k < constrs2.length; ++k) {
                            UniqueMetaData unimd = new UniqueMetaData();
                            unimd.setTable((String)annotationValues.get("table"));
                            for (int l = 0; l < constrs2[k].columnNames().length; ++l) {
                                colmd = new ColumnMetaData();
                                colmd.setName(constrs2[k].columnNames()[l]);
                                unimd.addColumn(colmd);
                            }
                            joinmd.setUniqueMetaData(unimd);
                        }
                    }
                    if ((indexConstrs2 = secTableAnns[j].indexes()) == null || indexConstrs2.length <= 0) continue;
                    for (int k = 0; k < indexConstrs2.length; ++k) {
                        String colStr;
                        String[] cols;
                        IndexMetaData idxmd = new IndexMetaData();
                        if (!StringUtils.isWhitespace((String)indexConstrs2[k].name())) {
                            idxmd.setName(indexConstrs2[k].name());
                        }
                        if ((cols = StringUtils.split((String)(colStr = indexConstrs2[k].columnList()), (String)",")) != null) {
                            for (int l = 0; l < cols.length; ++l) {
                                ColumnMetaData colmd3 = new ColumnMetaData();
                                colmd3.setName(cols[l]);
                                colmd3.setParent((MetaData)idxmd);
                                idxmd.addColumn(colmd3);
                            }
                        }
                        if (indexConstrs2[k].unique()) {
                            idxmd.setUnique(true);
                        }
                        joinmd.setIndexMetaData(idxmd);
                    }
                }
                continue;
            }
            if (!annName.equals(JPAAnnotationUtils.SECONDARY_TABLE)) continue;
            JoinMetaData joinmd = new JoinMetaData();
            joinmd.setTable((String)annotationValues.get("name"));
            joinmd.setCatalog((String)annotationValues.get("catalog"));
            joinmd.setSchema((String)annotationValues.get("schema"));
            if (annotationValues.get("pkJoinColumns") != null) {
                PrimaryKeyJoinColumn[] joinCols = (PrimaryKeyJoinColumn[])annotationValues.get("pkJoinColumns");
                for (int j = 0; j < joinCols.length; ++j) {
                    ColumnMetaData colmd4 = new ColumnMetaData();
                    colmd4.setName(joinCols[j].name());
                    colmd4.setTarget(joinCols[j].referencedColumnName());
                    joinmd.addColumn(colmd4);
                }
            }
            joins.add(joinmd);
            cmd.addJoin(joinmd);
            if (annotationValues.containsKey("foreignKey") && (fk = (ForeignKey)annotationValues.get("foreignKey")).value() == ConstraintMode.CONSTRAINT) {
                ForeignKeyMetaData fkmd = joinmd.newForeignKeyMetaData();
                fkmd.setName(fk.name());
                fkmd.setFkDefinition(fk.foreignKeyDefinition());
            }
            if ((constrs = (UniqueConstraint[])annotationValues.get("uniqueConstraints")) != null && constrs.length > 0) {
                for (int j = 0; j < constrs.length; ++j) {
                    UniqueMetaData unimd = new UniqueMetaData();
                    unimd.setTable((String)annotationValues.get("table"));
                    for (int k = 0; k < constrs[j].columnNames().length; ++k) {
                        colmd2 = new ColumnMetaData();
                        colmd2.setName(constrs[j].columnNames()[k]);
                        unimd.addColumn(colmd2);
                    }
                    joinmd.setUniqueMetaData(unimd);
                }
            }
            if ((indexConstrs = (Index[])annotationValues.get("indexes")) == null || indexConstrs.length <= 0) continue;
            for (int j = 0; j < indexConstrs.length; ++j) {
                String colStr;
                String[] cols;
                IndexMetaData idxmd = new IndexMetaData();
                if (!StringUtils.isWhitespace((String)indexConstrs[j].name())) {
                    idxmd.setName(indexConstrs[j].name());
                }
                if ((cols = StringUtils.split((String)(colStr = indexConstrs[j].columnList()), (String)",")) != null) {
                    for (int k = 0; k < cols.length; ++k) {
                        colmd = new ColumnMetaData();
                        colmd.setName(cols[k]);
                        colmd.setParent((MetaData)idxmd);
                        idxmd.addColumn(colmd);
                    }
                }
                if (indexConstrs[j].unique()) {
                    idxmd.setUnique(true);
                }
                joinmd.setIndexMetaData(idxmd);
            }
        }
        return joins.toArray(new JoinMetaData[joins.size()]);
    }

    private void processSequenceGeneratorAnnotation(PackageMetaData pmd, HashMap<String, Object> annotationValues) {
        Integer allocationSize;
        String name = (String)annotationValues.get("name");
        String seqName = (String)annotationValues.get("sequenceName");
        Integer initialValue = (Integer)annotationValues.get("initialValue");
        if (initialValue == null) {
            initialValue = 1;
        }
        if ((allocationSize = (Integer)annotationValues.get("allocationSize")) == null) {
            allocationSize = 50;
        }
        SequenceMetaData seqmd = pmd.newSequenceMetadata(name, null);
        seqmd.setDatastoreSequence(seqName);
        seqmd.setInitialValue(initialValue.intValue());
        seqmd.setAllocationSize(allocationSize.intValue());
    }

    private void processTableGeneratorAnnotation(PackageMetaData pmd, HashMap<String, Object> annotationValues) {
        TableGeneratorMetaData tgmd = pmd.newTableGeneratorMetadata((String)annotationValues.get("name"));
        tgmd.setTableName((String)annotationValues.get("table"));
        tgmd.setCatalogName((String)annotationValues.get("catalog"));
        tgmd.setSchemaName((String)annotationValues.get("schema"));
        tgmd.setPKColumnName((String)annotationValues.get("pkColumnName"));
        tgmd.setPKColumnValue((String)annotationValues.get("pkColumnValue"));
        tgmd.setValueColumnName((String)annotationValues.get("valueColumnName"));
        tgmd.setInitialValue((long)((Integer)annotationValues.get("initialValue")).intValue());
        tgmd.setAllocationSize((long)((Integer)annotationValues.get("allocationSize")).intValue());
    }

    protected boolean isClassPersistenceCapable(Class cls) {
        AnnotationObject[] annotations = this.getClassAnnotationsForClass(cls);
        for (int i = 0; i < annotations.length; ++i) {
            String annClassName = annotations[i].getName();
            if (annClassName.equals(JPAAnnotationUtils.ENTITY)) {
                return true;
            }
            if (annClassName.equals(JPAAnnotationUtils.EMBEDDABLE)) {
                return true;
            }
            if (!annClassName.equals(JPAAnnotationUtils.MAPPED_SUPERCLASS)) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassPersistenceAware(Class cls) {
        AnnotationObject[] annotations = this.getClassAnnotationsForClass(cls);
        for (int i = 0; i < annotations.length; ++i) {
            String annName = annotations[i].getName();
            if (!annName.equals(JPAAnnotationUtils.PERSISTENCE_AWARE)) continue;
            return true;
        }
        return false;
    }

    protected boolean doesClassHaveNamedQueries(Class cls) {
        AnnotationObject[] annotations = this.getClassAnnotationsForClass(cls);
        for (int i = 0; i < annotations.length; ++i) {
            String annClassName = annotations[i].getName();
            if (!annClassName.equals(JPAAnnotationUtils.NAMED_QUERIES) && !annClassName.equals(JPAAnnotationUtils.NAMED_QUERY) && !annClassName.equals(JPAAnnotationUtils.NAMED_NATIVE_QUERIES) && !annClassName.equals(JPAAnnotationUtils.NAMED_NATIVE_QUERY) && !annClassName.equals(JPAAnnotationUtils.NAMED_STOREDPROC_QUERIES) && !annClassName.equals(JPAAnnotationUtils.NAMED_STOREDPROC_QUERY)) continue;
            return true;
        }
        return false;
    }

    protected boolean doesClassHaveConverter(Class cls) {
        AnnotationObject[] annotations = this.getClassAnnotationsForClass(cls);
        for (int i = 0; i < annotations.length; ++i) {
            String annClassName = annotations[i].getName();
            if (!annClassName.equals(JPAAnnotationUtils.CONVERTER)) continue;
            HashMap annotationValues = annotations[i].getNameValueMap();
            boolean autoApply = (Boolean)annotationValues.get("autoApply");
            TypeManager typeMgr = this.mgr.getNucleusContext().getTypeManager();
            if (typeMgr.getTypeConverterForName(cls.getName()) == null) {
                AttributeConverter entityConv = (AttributeConverter)ClassUtils.newInstance((Class)cls, null, null);
                Class<?> javaType = null;
                Class<?> dbType = null;
                try {
                    Method[] methods = entityConv.getClass().getDeclaredMethods();
                    if (methods != null) {
                        for (int j = 0; j < methods.length; ++j) {
                            Class<?> returnCls;
                            if (methods[j].getName().equals("convertToDatabaseColumn") && (returnCls = methods[j].getReturnType()) != Object.class) {
                                dbType = returnCls;
                            }
                            if (!methods[j].getName().equals("convertToEntityAttribute") || (returnCls = methods[j].getReturnType()) == Object.class) continue;
                            javaType = returnCls;
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                JPATypeConverter conv = new JPATypeConverter(entityConv, javaType, dbType);
                typeMgr.registerConverter(cls.getName(), conv, autoApply, javaType.getName());
            }
            return true;
        }
        return false;
    }
}

