/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.QueryTimeoutException;
import javax.persistence.TemporalType;
import javax.persistence.jpa21.ParameterMode;
import javax.persistence.jpa21.StoredProcedureQuery;
import org.datanucleus.api.jpa.JPAEntityManagerFactory;
import org.datanucleus.api.jpa.JPAQueryParameter;
import org.datanucleus.api.jpa.NucleusJPAHelper;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.StoredProcQueryParameterMode;
import org.datanucleus.store.query.AbstractStoredProcedureQuery;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.util.Localiser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAStoredProcedureQuery
implements StoredProcedureQuery {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.api.jpa.Localisation", (ClassLoader)JPAEntityManagerFactory.class.getClassLoader());
    EntityManager em;
    String procName;
    AbstractStoredProcedureQuery query;
    FlushModeType flushMode = FlushModeType.AUTO;
    LockModeType lockMode = null;
    private long startPosition = 0L;
    private long maxResults = Long.MAX_VALUE;
    boolean executeProcessed = false;

    public JPAStoredProcedureQuery(EntityManager em, Query query) {
        this.em = em;
        this.query = (AbstractStoredProcedureQuery)query;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    @Override
    public StoredProcedureQuery setFlushMode(FlushModeType mode) {
        this.flushMode = mode;
        return this;
    }

    public LockModeType getLockMode() {
        return this.lockMode;
    }

    public javax.persistence.Query setLockMode(LockModeType arg0) {
        throw new IllegalStateException("Stored Procedures don't support locking");
    }

    public Map<String, Object> getHints() {
        Map extensions = this.query.getExtensions();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (extensions != null && extensions.size() > 0) {
            map.putAll(extensions);
        }
        return map;
    }

    @Override
    public StoredProcedureQuery setHint(String hintName, Object value) {
        if (hintName != null && hintName.equalsIgnoreCase("javax.persistence.query.timeout")) {
            this.query.setDatastoreReadTimeoutMillis((Integer)value);
        }
        if (hintName != null && hintName.equalsIgnoreCase("datanucleus.query.fetchSize")) {
            if (value instanceof Integer) {
                this.query.getFetchPlan().setFetchSize(((Integer)value).intValue());
            } else if (value instanceof Long) {
                this.query.getFetchPlan().setFetchSize(((Long)value).intValue());
            }
        }
        this.query.addExtension(hintName, value);
        return this;
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        for (Object paramKey : paramKeys) {
            Object value;
            if (!(paramKey instanceof Integer) || (Integer)paramKey != position || (value = this.query.getImplicitParameters().get(paramKey)) == null || !type.isAssignableFrom(value.getClass())) continue;
            return new JPAQueryParameter<T>((Integer)paramKey, type);
        }
        throw new IllegalArgumentException("No parameter at position=" + position + " and type=" + type.getName());
    }

    public Parameter<?> getParameter(int position) {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        for (Object paramKey : paramKeys) {
            if (!(paramKey instanceof Integer) || (Integer)paramKey != position) continue;
            Object value = this.query.getImplicitParameters().get(paramKey);
            return new JPAQueryParameter((Integer)paramKey, value != null ? value.getClass() : null);
        }
        throw new IllegalArgumentException("No parameter at position=" + position);
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        for (Object paramKey : paramKeys) {
            Object value;
            if (!(paramKey instanceof String) || !((String)paramKey).equals(name) || (value = this.query.getImplicitParameters().get(paramKey)) == null || !type.isAssignableFrom(value.getClass())) continue;
            return new JPAQueryParameter<T>((String)paramKey, type);
        }
        throw new IllegalArgumentException("No parameter with name " + name + " and type=" + type.getName());
    }

    public Parameter<?> getParameter(String name) {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        for (Object paramKey : paramKeys) {
            if (!(paramKey instanceof String) || !((String)paramKey).equals(name)) continue;
            Object value = this.query.getImplicitParameters().get(paramKey);
            return new JPAQueryParameter((String)paramKey, value != null ? value.getClass() : null);
        }
        throw new IllegalArgumentException("No parameter with name " + name);
    }

    public Set<Parameter<?>> getParameters() {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        HashSet parameters = new HashSet();
        for (Object paramKey : paramKeys) {
            Object value = this.query.getImplicitParameters().get(paramKey);
            if (paramKey instanceof String) {
                parameters.add(new JPAQueryParameter((String)paramKey, value != null ? value.getClass() : null));
                continue;
            }
            if (!(paramKey instanceof Integer)) continue;
            parameters.add(new JPAQueryParameter((Integer)paramKey, value != null ? value.getClass() : null));
        }
        return parameters;
    }

    public Object getParameterValue(int position) {
        if (this.query.getImplicitParameters().containsKey(position)) {
            return this.query.getImplicitParameters().get(position);
        }
        return null;
    }

    public <T> T getParameterValue(Parameter<T> param) {
        if (param.getName() != null) {
            if (this.query.getImplicitParameters().containsKey(param.getName())) {
                return (T)this.query.getImplicitParameters().get(param.getName());
            }
        } else if (this.query.getImplicitParameters().containsKey(param.getPosition())) {
            return (T)this.query.getImplicitParameters().get(param.getPosition());
        }
        throw new IllegalStateException("No parameter matching " + param + " bound to this query");
    }

    public Object getParameterValue(String name) {
        if (this.query.getImplicitParameters().containsKey(name)) {
            return this.query.getImplicitParameters().get(name);
        }
        return null;
    }

    public boolean isBound(Parameter<?> param) {
        return param.getName() != null ? this.query.getImplicitParameters().containsKey(param.getName()) : this.query.getImplicitParameters().containsKey(param.getPosition());
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls == Query.class) {
            return (T)this.query;
        }
        throw new PersistenceException("Not supported unwrapping of query to " + cls.getName());
    }

    @Override
    public <T> StoredProcedureQuery setParameter(Parameter<T> param, T value) {
        if (param.getName() != null) {
            this.setParameter(param.getName(), value);
        } else {
            this.setParameter(param.getPosition(), value);
        }
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(Parameter<Calendar> param, Calendar cal, TemporalType type) {
        if (param.getName() != null) {
            this.setParameter(param.getName(), cal, type);
        } else {
            this.setParameter((int)param.getPosition(), cal, type);
        }
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(Parameter<Date> param, Date date, TemporalType type) {
        if (param.getName() != null) {
            this.setParameter(param.getName(), date, type);
        } else {
            this.setParameter((int)param.getPosition(), date, type);
        }
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(String name, Object value) {
        try {
            this.query.setImplicitParameter(name, value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage(), ipe);
        }
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(String name, Calendar value, TemporalType temporalType) {
        Comparable<Calendar> paramValue = value;
        if (temporalType == TemporalType.DATE) {
            paramValue = value.getTime();
        } else if (temporalType == TemporalType.TIME) {
            paramValue = new Time(value.getTime().getTime());
        } else if (temporalType == TemporalType.TIMESTAMP) {
            paramValue = new Timestamp(value.getTime().getTime());
        }
        try {
            this.query.setImplicitParameter(name, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(String name, Date value, TemporalType temporalType) {
        Date paramValue = value;
        if (temporalType == TemporalType.TIME && !(value instanceof Time)) {
            paramValue = new Time(value.getTime());
        } else if (temporalType == TemporalType.TIMESTAMP && !(value instanceof Timestamp)) {
            paramValue = new Timestamp(value.getTime());
        }
        try {
            this.query.setImplicitParameter(name, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(int position, Object value) {
        try {
            this.query.setImplicitParameter(position, value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage(), ipe);
        }
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(int position, Calendar value, TemporalType temporalType) {
        Comparable<Calendar> paramValue = value;
        if (temporalType == TemporalType.DATE) {
            paramValue = value.getTime();
        } else if (temporalType == TemporalType.TIME) {
            paramValue = new Time(value.getTime().getTime());
        } else if (temporalType == TemporalType.TIMESTAMP) {
            paramValue = new Timestamp(value.getTime().getTime());
        }
        try {
            this.query.setImplicitParameter(position, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(int position, Date value, TemporalType temporalType) {
        Date paramValue = value;
        if (temporalType == TemporalType.TIME && !(value instanceof Time)) {
            paramValue = new Time(value.getTime());
        } else if (temporalType == TemporalType.TIMESTAMP && !(value instanceof Timestamp)) {
            paramValue = new Timestamp(value.getTime());
        }
        try {
            this.query.setImplicitParameter(position, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    @Override
    public StoredProcedureQuery registerStoredProcedureParameter(int position, Class type, ParameterMode mode) {
        StoredProcQueryParameterMode paramMode = null;
        if (mode == ParameterMode.IN) {
            paramMode = StoredProcQueryParameterMode.IN;
        } else if (mode == ParameterMode.OUT) {
            paramMode = StoredProcQueryParameterMode.OUT;
        } else if (mode == ParameterMode.INOUT) {
            paramMode = StoredProcQueryParameterMode.INOUT;
        } else if (mode == ParameterMode.REF_CURSOR) {
            paramMode = StoredProcQueryParameterMode.REF_CURSOR;
        }
        this.query.registerParameter(position, type, paramMode);
        return this;
    }

    @Override
    public StoredProcedureQuery registerStoredProcedureParameter(String parameterName, Class type, ParameterMode mode) {
        StoredProcQueryParameterMode paramMode = null;
        if (mode == ParameterMode.IN) {
            paramMode = StoredProcQueryParameterMode.IN;
        } else if (mode == ParameterMode.OUT) {
            paramMode = StoredProcQueryParameterMode.OUT;
        } else if (mode == ParameterMode.INOUT) {
            paramMode = StoredProcQueryParameterMode.INOUT;
        } else if (mode == ParameterMode.REF_CURSOR) {
            paramMode = StoredProcQueryParameterMode.REF_CURSOR;
        }
        this.query.registerParameter(parameterName, type, paramMode);
        return this;
    }

    @Override
    public Object getOutputParameterValue(int position) {
        return this.query.getOutputParameterValue(position);
    }

    @Override
    public Object getOutputParameterValue(String parameterName) {
        return this.query.getOutputParameterValue(parameterName);
    }

    @Override
    public boolean execute() {
        Object hasResultSet = this.query.execute();
        this.executeProcessed = true;
        return (Boolean)hasResultSet;
    }

    @Override
    public boolean hasMoreResults() {
        if (this.executeProcessed) {
            return this.query.hasMoreResults();
        }
        return false;
    }

    @Override
    public int getUpdateCount() {
        if (this.executeProcessed) {
            return this.query.getUpdateCount();
        }
        return -1;
    }

    public int executeUpdate() {
        try {
            Boolean hasResultSet;
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            if ((hasResultSet = (Boolean)this.query.execute()).booleanValue()) {
                throw new IllegalStateException("Stored procedure returned a result set but method requires an update count");
            }
            return this.query.getUpdateCount();
        }
        catch (NoQueryResultsException nqre) {
            return 0;
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public List getResultList() {
        if (this.executeProcessed) {
            return (List)this.query.getNextResults();
        }
        try {
            Boolean hasResultSet;
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            if (!(hasResultSet = (Boolean)this.query.execute()).booleanValue()) {
                throw new IllegalStateException("Stored proc should have returned result set but didnt");
            }
            return (List)this.query.getNextResults();
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public Object getSingleResult() {
        if (this.executeProcessed) {
            this.query.setUnique(true);
            return this.query.getNextResults();
        }
        try {
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            this.query.setUnique(true);
            Boolean hasResultSet = (Boolean)this.query.execute();
            if (!hasResultSet.booleanValue()) {
                throw new IllegalStateException("Stored proc should have returned result set but didnt");
            }
            return this.query.getNextResults();
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public int getFirstResult() {
        return (int)this.query.getRangeFromIncl();
    }

    public int getMaxResults() {
        long queryMin = this.query.getRangeFromIncl();
        long queryMax = this.query.getRangeToExcl();
        long max = queryMax - queryMin;
        if (max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)max;
    }

    public javax.persistence.Query setFirstResult(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.StartPositionInvalid"));
        }
        this.startPosition = startPosition;
        if (this.maxResults == Long.MAX_VALUE) {
            this.query.setRange(this.startPosition, Long.MAX_VALUE);
        } else {
            this.query.setRange(this.startPosition, this.startPosition + this.maxResults);
        }
        return this;
    }

    public javax.persistence.Query setMaxResults(int max) {
        if (max < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.MaxResultsInvalid"));
        }
        this.maxResults = max;
        this.query.setRange(this.startPosition, this.startPosition + (long)max);
        return this;
    }
}

