/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.beanvalidation;

import java.lang.reflect.Constructor;
import javax.persistence.PersistenceException;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.store.ExecutionContext;

public class BeanValidatorHandlerFactory {
    public static CallbackHandler newInstance(ExecutionContext ec) {
        PersistenceConfiguration conf = ec.getNucleusContext().getPersistenceConfiguration();
        if (conf.hasPropertyNotNull("javax.persistence.validation.mode") && conf.getStringProperty("javax.persistence.validation.mode").equalsIgnoreCase("none")) {
            return null;
        }
        try {
            Class cls = ec.getClassLoaderResolver().classForName("org.datanucleus.api.jpa.beanvalidation.BeanValidatorHandler");
            Constructor constructor = cls.getConstructor(ExecutionContext.class);
            return (CallbackHandler)constructor.newInstance(ec);
        }
        catch (Throwable ex) {
            if (conf.hasPropertyNotNull("javax.persistence.validation.mode") && conf.getStringProperty("javax.persistence.validation.mode").equalsIgnoreCase("callback")) {
                throw new PersistenceException(ex.getMessage(), ex);
            }
            return null;
        }
    }
}

