/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.beanvalidation;

import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.api.jpa.beanvalidation.JPATraversalResolver;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.store.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeanValidatorHandler
implements CallbackHandler {
    Validator validator;
    ClassLoaderResolver clr;
    PersistenceConfiguration conf;

    public BeanValidatorHandler(ExecutionContext ec) {
        this.conf = ec.getNucleusContext().getPersistenceConfiguration();
        this.clr = ec.getClassLoaderResolver();
        ValidatorFactory factory = this.conf.hasProperty("javax.persistence.validation.factory") ? (ValidatorFactory)this.conf.getProperty("javax.persistence.validation.factory") : Validation.buildDefaultValidatorFactory();
        this.validator = factory.usingContext().traversableResolver((TraversableResolver)new JPATraversalResolver(ec)).getValidator();
    }

    public void validate(Object pc, Class<?>[] groups) {
        if (this.validator == null) {
            return;
        }
        Set violations = this.validator.validate(pc, (Class[])groups);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    public void addListener(Object listener, Class[] classes) {
    }

    public void close() {
    }

    public void postAttach(Object pc, Object detachedPC) {
    }

    public void postClear(Object pc) {
    }

    public void postCreate(Object pc) {
    }

    public void postDelete(Object pc) {
    }

    public void postDetach(Object pc, Object detachedPC) {
    }

    public void postDirty(Object pc) {
    }

    public void postLoad(Object pc) {
    }

    public void postRefresh(Object pc) {
    }

    public void postStore(Object pc) {
    }

    public void preAttach(Object detachedPC) {
    }

    public void preClear(Object pc) {
    }

    public void preDelete(Object pc) {
        this.validate(pc, this.getGroups(this.conf.getStringProperty("javax.persistence.validation.group.pre-remove")));
    }

    public void preDetach(Object pc) {
    }

    public void preDirty(Object pc) {
    }

    public void preStore(Object pc) {
        this.validate(pc, this.getGroups(this.conf.getStringProperty("javax.persistence.validation.group.pre-update")));
    }

    public void removeListener(Object listener) {
    }

    public void prePersist(Object pc) {
        this.validate(pc, this.getGroups(this.conf.getStringProperty("javax.persistence.validation.group.pre-persist")));
    }

    private Class<?>[] getGroups(String property) {
        if (property == null || property.trim().length() == 0) {
            return new Class[]{Default.class};
        }
        String[] classNames = property.trim().split(",");
        Class[] groups = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            groups[i] = this.clr.classForName(classNames[i].trim());
        }
        return groups;
    }
}

