/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.jdo.JDOUserCallbackException;
import javax.jdo.listener.AttachCallback;
import javax.jdo.listener.AttachLifecycleListener;
import javax.jdo.listener.ClearCallback;
import javax.jdo.listener.ClearLifecycleListener;
import javax.jdo.listener.CreateLifecycleListener;
import javax.jdo.listener.DeleteCallback;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.DetachCallback;
import javax.jdo.listener.DetachLifecycleListener;
import javax.jdo.listener.DirtyLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.LoadCallback;
import javax.jdo.listener.LoadLifecycleListener;
import javax.jdo.listener.StoreCallback;
import javax.jdo.listener.StoreLifecycleListener;
import org.datanucleus.BeanValidationHandler;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jdo.FieldInstanceLifecycleEvent;
import org.datanucleus.api.jdo.LifecycleListenerForClass;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JDOCallbackHandler
implements CallbackHandler {
    ExecutionContext ec;
    private final Map<InstanceLifecycleListener, LifecycleListenerForClass> listeners = new IdentityHashMap<InstanceLifecycleListener, LifecycleListenerForClass>(1);
    private List<LifecycleListenerForClass> listenersWorkingCopy = null;
    BeanValidationHandler beanValidationHandler;
    boolean allowAnnotatedCallbacks = false;

    public JDOCallbackHandler(ExecutionContext ec) {
        this.ec = ec;
        this.beanValidationHandler = ec.getNucleusContext().getBeanValidationHandler(ec);
        this.allowAnnotatedCallbacks = ec.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.allowInstanceCallbackAnnotations", false);
    }

    public void postCreate(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof CreateLifecycleListener)) continue;
            ((CreateLifecycleListener)listener.getListener()).postCreate(new InstanceLifecycleEvent(pc, 0, null));
        }
    }

    public void prePersist(Object pc) {
        if (this.beanValidationHandler != null) {
            this.beanValidationHandler.prePersist(pc);
        }
    }

    public void preStore(Object pc) {
        ObjectProvider op;
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof StoreLifecycleListener)) continue;
            ObjectProvider op2 = this.ec.findObjectProvider(pc);
            String[] fieldNames = op2.getDirtyFieldNames();
            if (fieldNames == null) {
                fieldNames = op2.getLoadedFieldNames();
            }
            ((StoreLifecycleListener)listener.getListener()).preStore((InstanceLifecycleEvent)new FieldInstanceLifecycleEvent(pc, 2, null, fieldNames));
        }
        if (this.allowAnnotatedCallbacks) {
            this.invokeCallback(pc, "javax.jdo.annotations.PreStore", false);
        }
        if (pc instanceof StoreCallback) {
            try {
                ((StoreCallback)pc).jdoPreStore();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPreStore"}), (Throwable)e);
            }
        }
        if (this.beanValidationHandler != null && !(op = this.ec.findObjectProvider(pc)).getLifecycleState().isNew()) {
            this.beanValidationHandler.preStore(pc);
        }
    }

    public void postStore(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof StoreLifecycleListener)) continue;
            ((StoreLifecycleListener)listener.getListener()).postStore(new InstanceLifecycleEvent(pc, 2, null));
        }
    }

    public void preClear(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof ClearLifecycleListener)) continue;
            ((ClearLifecycleListener)listener.getListener()).preClear(new InstanceLifecycleEvent(pc, 3, null));
        }
        if (this.allowAnnotatedCallbacks) {
            this.invokeCallback(pc, "javax.jdo.annotations.PreClear", false);
        }
        if (pc instanceof ClearCallback) {
            try {
                ((ClearCallback)pc).jdoPreClear();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPreClear"}), (Throwable)e);
            }
        }
    }

    public void postClear(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof ClearLifecycleListener)) continue;
            ((ClearLifecycleListener)listener.getListener()).postClear(new InstanceLifecycleEvent(pc, 3, null));
        }
    }

    public void preDelete(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DeleteLifecycleListener)) continue;
            ((DeleteLifecycleListener)listener.getListener()).preDelete(new InstanceLifecycleEvent(pc, 4, null));
        }
        if (this.allowAnnotatedCallbacks) {
            this.invokeCallback(pc, "javax.jdo.annotations.PreDelete", false);
        }
        if (pc instanceof DeleteCallback) {
            try {
                ((DeleteCallback)pc).jdoPreDelete();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPreDelete"}), (Throwable)e);
            }
        }
        if (this.beanValidationHandler != null) {
            this.beanValidationHandler.preDelete(pc);
        }
    }

    public void postDelete(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DeleteLifecycleListener)) continue;
            ((DeleteLifecycleListener)listener.getListener()).postDelete(new InstanceLifecycleEvent(pc, 4, null));
        }
    }

    public void preDirty(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DirtyLifecycleListener)) continue;
            ((DirtyLifecycleListener)listener.getListener()).preDirty(new InstanceLifecycleEvent(pc, 5, null));
        }
    }

    public void postDirty(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DirtyLifecycleListener)) continue;
            ((DirtyLifecycleListener)listener.getListener()).postDirty(new InstanceLifecycleEvent(pc, 5, null));
        }
    }

    public void postLoad(Object pc) {
        if (this.allowAnnotatedCallbacks) {
            this.invokeCallback(pc, "javax.jdo.annotations.PostLoad", false);
        }
        if (pc instanceof LoadCallback) {
            try {
                ((LoadCallback)pc).jdoPostLoad();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPostLoad"}), (Throwable)e);
            }
        }
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof LoadLifecycleListener)) continue;
            ((LoadLifecycleListener)listener.getListener()).postLoad(new InstanceLifecycleEvent(pc, 1, null));
        }
    }

    public void postRefresh(Object pc) {
    }

    public void preDetach(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DetachLifecycleListener)) continue;
            ((DetachLifecycleListener)listener.getListener()).preDetach(new InstanceLifecycleEvent(pc, 6, null));
        }
        if (this.allowAnnotatedCallbacks) {
            this.invokeCallback(pc, "javax.jdo.annotations.PreDetach", false);
        }
        if (pc instanceof DetachCallback) {
            try {
                ((DetachCallback)pc).jdoPreDetach();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPreDetach"}), (Throwable)e);
            }
        }
    }

    public void postDetach(Object pc, Object detachedPC) {
        if (this.allowAnnotatedCallbacks) {
            this.invokeCallback(pc, "javax.jdo.annotations.PostDetach", true);
        }
        if (pc instanceof DetachCallback) {
            try {
                ((DetachCallback)detachedPC).jdoPostDetach(pc);
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPostDetach"}), (Throwable)e);
            }
        }
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DetachLifecycleListener)) continue;
            ((DetachLifecycleListener)listener.getListener()).postDetach(new InstanceLifecycleEvent(detachedPC, 6, pc));
        }
    }

    public void preAttach(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof AttachLifecycleListener)) continue;
            ((AttachLifecycleListener)listener.getListener()).preAttach(new InstanceLifecycleEvent(pc, 7, null));
        }
        if (this.allowAnnotatedCallbacks) {
            this.invokeCallback(pc, "javax.jdo.annotations.PreAttach", false);
        }
        if (pc instanceof AttachCallback) {
            try {
                ((AttachCallback)pc).jdoPreAttach();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPreAttach"}), (Throwable)e);
            }
        }
    }

    public void postAttach(Object pc, Object detachedPC) {
        if (this.allowAnnotatedCallbacks) {
            this.invokeCallback(pc, "javax.jdo.annotations.PostAttach", true);
        }
        if (pc instanceof AttachCallback) {
            try {
                ((AttachCallback)pc).jdoPostAttach(detachedPC);
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPostAttach"}), (Throwable)e);
            }
        }
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof AttachLifecycleListener)) continue;
            ((AttachLifecycleListener)listener.getListener()).postAttach(new InstanceLifecycleEvent(pc, 7, detachedPC));
        }
    }

    public void addListener(Object listener, Class[] classes) {
        if (listener == null) {
            return;
        }
        InstanceLifecycleListener jdoListener = (InstanceLifecycleListener)listener;
        LifecycleListenerForClass entry = this.listeners.containsKey(jdoListener) ? this.listeners.get(jdoListener).mergeClasses(classes) : new LifecycleListenerForClass(jdoListener, classes);
        this.listeners.put(jdoListener, entry);
        this.listenersWorkingCopy = null;
    }

    public void removeListener(Object listener) {
        if (this.listeners.remove(listener) != null) {
            this.listenersWorkingCopy = null;
        }
    }

    public void close() {
        this.listeners.clear();
        this.listenersWorkingCopy = null;
    }

    protected List<LifecycleListenerForClass> getListenersWorkingCopy() {
        if (this.listenersWorkingCopy == null) {
            this.listenersWorkingCopy = new ArrayList<LifecycleListenerForClass>(this.listeners.values());
        }
        return this.listenersWorkingCopy;
    }

    private void invokeCallback(Object pc, String callbackClassName, boolean pcArgument) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        ArrayList<String> entityMethodsToInvoke = null;
        for (AbstractClassMetaData acmd = this.ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), clr); acmd != null; acmd = acmd.getSuperAbstractClassMetaData()) {
            List listenerMetaData = acmd.getListeners();
            if (listenerMetaData == null || listenerMetaData.isEmpty()) continue;
            for (EventListenerMetaData elmd : listenerMetaData) {
                String methodName;
                if (!elmd.getClassName().equals(acmd.getFullClassName()) || (methodName = elmd.getMethodNameForCallbackClass(callbackClassName)) == null) continue;
                if (entityMethodsToInvoke == null) {
                    entityMethodsToInvoke = new ArrayList<String>();
                }
                if (entityMethodsToInvoke.contains(methodName)) continue;
                entityMethodsToInvoke.add(methodName);
            }
            if (acmd.isExcludeSuperClassListeners()) break;
        }
        if (entityMethodsToInvoke != null && !entityMethodsToInvoke.isEmpty()) {
            for (int i = 0; i < entityMethodsToInvoke.size(); ++i) {
                String methodName = (String)entityMethodsToInvoke.get(i);
                this.invokeCallbackMethod(pc, methodName, clr, pcArgument);
            }
        }
    }

    private void invokeCallbackMethod(final Object pc, String methodName, ClassLoaderResolver clr, final boolean pcArgument) {
        String callbackClassName = methodName.substring(0, methodName.lastIndexOf(46));
        final String callbackMethodName = methodName.substring(methodName.lastIndexOf(46) + 1);
        final Class callbackClass = callbackClassName.equals(pc.getClass().getName()) ? pc.getClass() : clr.classForName(callbackClassName);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Object[] objectArray;
                    Class[] classArgs;
                    Class[] classArray;
                    if (pcArgument) {
                        Class[] classArray2 = new Class[1];
                        classArray = classArray2;
                        classArray2[0] = Object.class;
                    } else {
                        classArray = classArgs = null;
                    }
                    if (pcArgument) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = pc;
                    } else {
                        objectArray = null;
                    }
                    Object[] methodArgs = objectArray;
                    Method m = callbackClass.getDeclaredMethod(callbackMethodName, classArgs);
                    if (!m.isAccessible()) {
                        m.setAccessible(true);
                    }
                    m.invoke(pc, methodArgs);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException e) {
                    NucleusLogger.GENERAL.warn((Object)"Exception in JDOCallbackHandler", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof RuntimeException) {
                        throw (RuntimeException)e.getTargetException();
                    }
                    throw new RuntimeException(e.getTargetException());
                }
                return null;
            }
        });
    }
}

