/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.query;

import java.util.Iterator;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.query.OrderExpression;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.api.jdo.query.BooleanExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionImpl;
import org.datanucleus.api.jdo.query.JDOQLTypedSubqueryImpl;
import org.datanucleus.api.jdo.query.OrderExpressionImpl;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.JDOQLSymbolResolver;
import org.datanucleus.query.compiler.PropertySymbol;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.compiler.Symbol;
import org.datanucleus.query.compiler.SymbolResolver;
import org.datanucleus.query.compiler.SymbolTable;
import org.datanucleus.query.expression.CaseExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.store.query.Query;

public abstract class AbstractJDOQLTypedQuery<T> {
    protected AbstractJDOQLTypedQuery parentQuery;
    protected Query.QueryType type = Query.QueryType.SELECT;
    protected Class candidateCls;
    protected boolean subclasses = true;
    protected String candidateAlias = null;
    protected List<ExpressionImpl> updateExprs;
    protected List<ExpressionImpl> updateVals;
    protected List<ExpressionImpl> result;
    protected Boolean resultDistinct = null;
    protected boolean unique = false;
    protected Class resultClass = null;
    protected BooleanExpressionImpl filter;
    protected List<ExpressionImpl> grouping;
    protected ExpressionImpl having;
    protected List<OrderExpressionImpl> ordering;
    protected ExpressionImpl rangeLowerExpr;
    protected ExpressionImpl rangeUpperExpr;
    protected PersistenceManager pm;
    protected ExecutionContext ec;
    protected QueryCompilation compilation = null;
    protected String queryString = null;

    public AbstractJDOQLTypedQuery(PersistenceManager pm, Class<T> cls, String alias, AbstractJDOQLTypedQuery parentQuery) {
        this.pm = pm;
        this.ec = ((JDOPersistenceManager)pm).getExecutionContext();
        this.candidateCls = cls;
        this.candidateAlias = alias;
        this.parentQuery = parentQuery;
    }

    protected void discardCompiled() {
        this.compilation = null;
        this.queryString = null;
    }

    protected QueryCompilation compile(MetaDataManager mmgr, ClassLoaderResolver clr) {
        SymbolTable symtbl = new SymbolTable();
        symtbl.setSymbolResolver((SymbolResolver)new JDOQLSymbolResolver(mmgr, clr, symtbl, this.candidateCls, this.candidateAlias));
        if (this.parentQuery != null) {
            symtbl.setParentSymbolTable(this.parentQuery.compilation.getSymbolTable());
        }
        symtbl.addSymbol((Symbol)new PropertySymbol(this.candidateAlias, this.candidateCls));
        Expression[] resultExprs = null;
        if (this.result != null && !this.result.isEmpty()) {
            String resultExprId;
            resultExprs = new Expression[this.result.size()];
            Iterator<ExpressionImpl> iter = this.result.iterator();
            int i = 0;
            while (iter.hasNext()) {
                ExpressionImpl result = iter.next();
                Expression resultExpr = result.getQueryExpression();
                resultExpr.bind(symtbl);
                resultExprs[i++] = resultExpr;
            }
            if (resultExprs.length == 1 && resultExprs[0] instanceof PrimaryExpression && (resultExprId = ((PrimaryExpression)resultExprs[0]).getId()).equalsIgnoreCase(this.candidateAlias)) {
                resultExprs = null;
            }
        }
        Expression filterExpr = null;
        if (this.filter != null && (filterExpr = this.filter.getQueryExpression()) != null) {
            filterExpr.bind(symtbl);
        }
        Expression[] groupingExprs = null;
        if (this.grouping != null && !this.grouping.isEmpty()) {
            groupingExprs = new Expression[this.grouping.size()];
            Iterator<ExpressionImpl> iter = this.grouping.iterator();
            int i = 0;
            while (iter.hasNext()) {
                ExpressionImpl grp = iter.next();
                Expression groupingExpr = grp.getQueryExpression();
                groupingExpr.bind(symtbl);
                groupingExprs[i++] = groupingExpr;
            }
        }
        Expression havingExpr = null;
        if (this.having != null) {
            havingExpr = this.having.getQueryExpression();
            havingExpr.bind(symtbl);
        }
        Expression[] orderExprs = null;
        if (this.ordering != null && !this.ordering.isEmpty()) {
            orderExprs = new Expression[this.ordering.size()];
            Iterator<OrderExpressionImpl> iter = this.ordering.iterator();
            int i = 0;
            while (iter.hasNext()) {
                OrderExpressionImpl order = iter.next();
                OrderExpression.OrderNullsPosition nullsPos = order.getNullsPosition();
                OrderExpression orderExpr = nullsPos != null ? new OrderExpression(((ExpressionImpl)order.getExpression()).getQueryExpression(), order.getDirection() == OrderExpression.OrderDirection.ASC ? "ascending" : "descending", nullsPos == OrderExpression.OrderNullsPosition.FIRST ? "nulls first" : "nulls last") : new OrderExpression(((ExpressionImpl)order.getExpression()).getQueryExpression(), order.getDirection() == OrderExpression.OrderDirection.ASC ? "ascending" : "descending");
                orderExpr.bind(symtbl);
                orderExprs[i++] = orderExpr;
            }
        }
        Expression[] updateExprs = null;
        if (this.updateExprs != null) {
            Iterator<ExpressionImpl> expIter = this.updateExprs.iterator();
            Iterator<ExpressionImpl> valIter = this.updateVals.iterator();
            updateExprs = new Expression[this.updateExprs.size()];
            int i = 0;
            while (expIter.hasNext()) {
                ExpressionImpl updateExpr = expIter.next();
                ExpressionImpl updateVal = valIter.next();
                updateExprs[i++] = new DyadicExpression(updateExpr.getQueryExpression(), Expression.OP_EQ, updateVal.getQueryExpression());
            }
        }
        this.compilation = new QueryCompilation(this.candidateCls, this.candidateAlias, symtbl, resultExprs, null, filterExpr, groupingExprs, havingExpr, orderExprs, updateExprs);
        if (this.resultDistinct != null && this.resultDistinct.booleanValue()) {
            this.compilation.setResultDistinct();
        }
        this.compilation.setQueryLanguage("JDOQL");
        return this.compilation;
    }

    public QueryCompilation getCompilation() {
        if (this.compilation == null) {
            this.compilation = this.compile(this.ec.getMetaDataManager(), this.ec.getClassLoaderResolver());
        }
        return this.compilation;
    }

    public String toString() {
        if (this.queryString == null) {
            Iterator<Object> iter;
            StringBuilder str = null;
            str = this.type == Query.QueryType.BULK_UPDATE ? new StringBuilder("UPDATE") : (this.type == Query.QueryType.BULK_DELETE ? new StringBuilder("DELETE") : new StringBuilder("SELECT"));
            if (this.type == Query.QueryType.SELECT) {
                if (this.unique) {
                    str.append(" UNIQUE");
                }
                if (this.result != null && !this.result.isEmpty()) {
                    if (this.resultDistinct != null && this.resultDistinct.booleanValue()) {
                        str.append(" DISTINCT");
                    }
                    str.append(" ");
                    iter = this.result.iterator();
                    while (iter.hasNext()) {
                        ExpressionImpl resultExpr = iter.next();
                        str.append(this.getJDOQLForExpression(resultExpr.getQueryExpression()));
                        if (!iter.hasNext()) continue;
                        str.append(",");
                    }
                }
                if (this.resultClass != null) {
                    str.append(" INTO ").append(this.resultClass.getName());
                }
            }
            if (this.type == Query.QueryType.SELECT || this.type == Query.QueryType.BULK_DELETE) {
                str.append(" FROM ").append(this.candidateCls.getName());
            } else {
                str.append(" " + this.candidateCls.getName());
            }
            if (this instanceof JDOQLTypedSubqueryImpl) {
                str.append(" " + this.candidateAlias);
            }
            if (!this.subclasses) {
                str.append(" EXCLUDE SUBCLASSES");
            }
            if (this.type == Query.QueryType.BULK_UPDATE) {
                str.append(" SET");
                Iterator<ExpressionImpl> exprIter = this.updateExprs.iterator();
                Iterator<ExpressionImpl> valIter = this.updateVals.iterator();
                while (exprIter.hasNext()) {
                    ExpressionImpl expr = exprIter.next();
                    ExpressionImpl val = valIter.next();
                    str.append(" ").append(this.getJDOQLForExpression(expr.getQueryExpression()));
                    str.append(" = ").append(this.getJDOQLForExpression(val.getQueryExpression()));
                    if (!exprIter.hasNext()) continue;
                    str.append(",");
                }
            }
            if (this.filter != null) {
                str.append(" WHERE ");
                str.append(this.getJDOQLForExpression(this.filter.getQueryExpression()));
            }
            if (this.type == Query.QueryType.SELECT) {
                if (this.grouping != null && !this.grouping.isEmpty()) {
                    str.append(" GROUP BY ");
                    iter = this.grouping.iterator();
                    while (iter.hasNext()) {
                        ExpressionImpl groupExpr = iter.next();
                        str.append(this.getJDOQLForExpression(groupExpr.getQueryExpression()));
                        if (!iter.hasNext()) continue;
                        str.append(",");
                    }
                }
                if (this.having != null) {
                    str.append(" HAVING ");
                    str.append(this.getJDOQLForExpression(this.having.getQueryExpression()));
                }
                if (this.ordering != null && !this.ordering.isEmpty()) {
                    str.append(" ORDER BY ");
                    iter = this.ordering.iterator();
                    while (iter.hasNext()) {
                        OrderExpressionImpl orderExpr = (OrderExpressionImpl)iter.next();
                        str.append(this.getJDOQLForExpression(((ExpressionImpl)orderExpr.getExpression()).getQueryExpression()));
                        str.append(" " + (orderExpr.getDirection() == OrderExpression.OrderDirection.ASC ? "ASCENDING" : "DESCENDING"));
                        OrderExpression.OrderNullsPosition nullsPos = orderExpr.getNullsPosition();
                        if (nullsPos != null) {
                            str.append(" " + (nullsPos == OrderExpression.OrderNullsPosition.FIRST ? "NULLS FIRST" : "NULLS LAST"));
                        }
                        if (!iter.hasNext()) continue;
                        str.append(",");
                    }
                }
                if (this.rangeLowerExpr != null && this.rangeUpperExpr != null) {
                    str.append(" RANGE ");
                    str.append(this.getJDOQLForExpression(this.rangeLowerExpr.getQueryExpression()));
                    str.append(",");
                    str.append(this.getJDOQLForExpression(this.rangeUpperExpr.getQueryExpression()));
                }
            }
            this.queryString = str.toString();
        }
        return this.queryString;
    }

    public String getJDOQLForExpression(Expression expr) {
        if (expr instanceof DyadicExpression) {
            DyadicExpression dyExpr = (DyadicExpression)expr;
            Expression left = dyExpr.getLeft();
            Expression right = dyExpr.getRight();
            StringBuilder str = new StringBuilder("(");
            if (dyExpr.getOperator() == Expression.OP_DISTINCT) {
                str.append("DISTINCT ");
            }
            if (left != null && dyExpr.getOperator() == Expression.OP_NOT) {
                str.append("!").append(this.getJDOQLForExpression(left));
            } else if (dyExpr.getOperator() == Expression.OP_CAST) {
                str.append("(").append(((Literal)right).getLiteral()).append(")").append(this.getJDOQLForExpression(left));
            } else {
                if (left != null) {
                    str.append(this.getJDOQLForExpression(left));
                }
                if (dyExpr.getOperator() == Expression.OP_AND) {
                    str.append(" && ");
                } else if (dyExpr.getOperator() == Expression.OP_OR) {
                    str.append(" || ");
                } else if (dyExpr.getOperator() == Expression.OP_ADD) {
                    str.append(" + ");
                } else if (dyExpr.getOperator() == Expression.OP_SUB) {
                    str.append(" - ");
                } else if (dyExpr.getOperator() == Expression.OP_MUL) {
                    str.append(" * ");
                } else if (dyExpr.getOperator() == Expression.OP_DIV) {
                    str.append(" / ");
                } else if (dyExpr.getOperator() == Expression.OP_EQ) {
                    str.append(" == ");
                } else if (dyExpr.getOperator() == Expression.OP_GT) {
                    str.append(" > ");
                } else if (dyExpr.getOperator() == Expression.OP_LT) {
                    str.append(" < ");
                } else if (dyExpr.getOperator() == Expression.OP_GTEQ) {
                    str.append(" >= ");
                } else if (dyExpr.getOperator() == Expression.OP_LTEQ) {
                    str.append(" <= ");
                } else if (dyExpr.getOperator() == Expression.OP_NOTEQ) {
                    str.append(" != ");
                } else if (dyExpr.getOperator() != Expression.OP_DISTINCT) {
                    if (dyExpr.getOperator() == Expression.OP_IS) {
                        str.append(" instanceof ");
                    } else {
                        throw new UnsupportedOperationException("Dont currently support operator " + dyExpr.getOperator() + " in JDOQL conversion");
                    }
                }
                if (right != null) {
                    str.append(this.getJDOQLForExpression(right));
                }
            }
            str.append(")");
            return str.toString();
        }
        if (expr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)expr;
            if (primExpr.getLeft() != null) {
                return this.getJDOQLForExpression(primExpr.getLeft()) + "." + primExpr.getId();
            }
            return primExpr.getId();
        }
        if (expr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)expr;
            if (paramExpr.getId() != null) {
                return ":" + paramExpr.getId();
            }
            return "?" + paramExpr.getPosition();
        }
        if (expr instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)expr;
            return varExpr.getId();
        }
        if (expr instanceof InvokeExpression) {
            InvokeExpression invExpr = (InvokeExpression)expr;
            StringBuilder str = new StringBuilder();
            if (invExpr.getLeft() != null) {
                str.append(this.getJDOQLForExpression(invExpr.getLeft())).append(".");
            }
            str.append(invExpr.getOperation());
            str.append("(");
            List args = invExpr.getArguments();
            if (args != null) {
                Iterator iter = args.iterator();
                while (iter.hasNext()) {
                    str.append(this.getJDOQLForExpression((Expression)iter.next()));
                    if (!iter.hasNext()) continue;
                    str.append(",");
                }
            }
            str.append(")");
            return str.toString();
        }
        if (expr instanceof Literal) {
            Literal litExpr = (Literal)expr;
            Object value = litExpr.getLiteral();
            if (value instanceof String || value instanceof Character) {
                return "'" + value.toString() + "'";
            }
            if (value instanceof Class) {
                return ((Class)value).getName();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "TRUE" : "FALSE";
            }
            if (litExpr.getLiteral() == null) {
                return "null";
            }
            return litExpr.getLiteral().toString();
        }
        if (expr instanceof CaseExpression) {
            CaseExpression caseExpr = (CaseExpression)expr;
            List conds = caseExpr.getConditions();
            Expression elseExpr = caseExpr.getElseExpression();
            StringBuilder str = new StringBuilder();
            for (CaseExpression.ExpressionPair pair : conds) {
                if (str.length() > 0) {
                    str.append(" ELSE ");
                }
                str.append("IF ").append(this.getJDOQLForExpression(pair.getWhenExpression())).append(" ");
                str.append(this.getJDOQLForExpression(pair.getActionExpression()));
            }
            if (elseExpr != null) {
                str.append(" ELSE ").append(this.getJDOQLForExpression(elseExpr));
            }
            return str.toString();
        }
        throw new UnsupportedOperationException("Dont currently support " + expr.getClass().getName() + " in JDOQLHelper");
    }
}

