/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.query;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.FetchPlan;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOQLTypedQuery;
import javax.jdo.JDOQLTypedSubquery;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.query.BooleanExpression;
import javax.jdo.query.CharacterExpression;
import javax.jdo.query.CollectionExpression;
import javax.jdo.query.DateExpression;
import javax.jdo.query.DateTimeExpression;
import javax.jdo.query.ListExpression;
import javax.jdo.query.MapExpression;
import javax.jdo.query.NumericExpression;
import javax.jdo.query.OrderExpression;
import javax.jdo.query.PersistableExpression;
import javax.jdo.query.StringExpression;
import javax.jdo.query.TimeExpression;
import javax.jdo.spi.JDOPermission;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jdo.JDOFetchPlan;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.api.jdo.NucleusJDOHelper;
import org.datanucleus.api.jdo.query.AbstractJDOQLTypedQuery;
import org.datanucleus.api.jdo.query.BooleanExpressionImpl;
import org.datanucleus.api.jdo.query.ByteExpressionImpl;
import org.datanucleus.api.jdo.query.CharacterExpressionImpl;
import org.datanucleus.api.jdo.query.CollectionExpressionImpl;
import org.datanucleus.api.jdo.query.ComparableExpressionImpl;
import org.datanucleus.api.jdo.query.DateExpressionImpl;
import org.datanucleus.api.jdo.query.DateTimeExpressionImpl;
import org.datanucleus.api.jdo.query.EnumExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionType;
import org.datanucleus.api.jdo.query.JDOQLTypedSubqueryImpl;
import org.datanucleus.api.jdo.query.ListExpressionImpl;
import org.datanucleus.api.jdo.query.MapExpressionImpl;
import org.datanucleus.api.jdo.query.NumericExpressionImpl;
import org.datanucleus.api.jdo.query.ObjectExpressionImpl;
import org.datanucleus.api.jdo.query.OrderExpressionImpl;
import org.datanucleus.api.jdo.query.StringExpressionImpl;
import org.datanucleus.api.jdo.query.TimeExpressionImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class JDOQLTypedQueryImpl<T>
extends AbstractJDOQLTypedQuery<T>
implements JDOQLTypedQuery<T> {
    private static final long serialVersionUID = -8359479260893321900L;
    private boolean closed = false;
    protected JDOFetchPlan fetchPlan;
    protected boolean ignoreCache = false;
    protected Boolean serializeRead = null;
    protected Integer datastoreReadTimeout = null;
    protected Integer datastoreWriteTimeout = null;
    protected Map<String, Object> extensions = null;
    protected Collection<T> candidates = null;
    boolean unmodifiable = false;
    protected Map<String, ExpressionImpl> parameterExprByName = null;
    protected Map<String, Object> parameterValuesByName = null;
    protected transient Set<JDOQLTypedSubqueryImpl> subqueries = null;
    protected transient Set<Query> internalQueries = null;

    public JDOQLTypedQueryImpl(PersistenceManager pm, Class<T> candidateClass) {
        super(pm, candidateClass, "this");
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closeAll();
        Boolean closeableQuery = this.ec.getBooleanProperty("datanucleus.query.closeable");
        if (closeableQuery == Boolean.TRUE) {
            if (this.fetchPlan != null) {
                this.fetchPlan.clearGroups();
                this.fetchPlan = null;
            }
            this.parameterExprByName = null;
            this.parameterValuesByName = null;
            this.ec = null;
            this.pm = null;
            this.internalQueries = null;
            this.subqueries = null;
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close(Object result) {
        this.assertIsOpen();
        if (this.internalQueries != null) {
            for (Query query : this.internalQueries) {
                query.close(result);
            }
        }
    }

    public void closeAll() {
        this.assertIsOpen();
        if (this.internalQueries != null) {
            for (Query query : this.internalQueries) {
                query.closeAll();
            }
            this.internalQueries.clear();
            this.internalQueries = null;
        }
    }

    public PersistableExpression candidate() {
        this.assertIsOpen();
        String candName = this.candidateCls.getName();
        int pos = candName.lastIndexOf(46);
        String qName = candName.substring(0, pos + 1) + JDOQLTypedQueryImpl.getQueryClassNameForClassName(candName.substring(pos + 1));
        try {
            Class qClass = this.ec.getClassLoaderResolver().classForName(qName);
            Method method = qClass.getMethod("candidate", new Class[0]);
            Object candObj = method.invoke(null, (Object[])null);
            if (candObj == null || !(candObj instanceof PersistableExpression)) {
                throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
            }
            return (PersistableExpression)candObj;
        }
        catch (NoSuchMethodException nsfe) {
            throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
        }
        catch (InvocationTargetException ite) {
            throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
        }
        catch (IllegalAccessException iae) {
            throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
        }
    }

    public <P> javax.jdo.query.Expression<P> parameter(String name, Class<P> type) {
        this.assertIsOpen();
        this.discardCompiled();
        ExpressionImpl paramExpr = null;
        if (type == Boolean.class || type == Boolean.TYPE) {
            paramExpr = new BooleanExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (type == Byte.class || type == Byte.TYPE) {
            paramExpr = new ByteExpressionImpl((Class<Byte>)type, name, ExpressionType.PARAMETER);
        } else if (type == Character.class || type == Character.TYPE) {
            paramExpr = new CharacterExpressionImpl((Class<Character>)type, name, ExpressionType.PARAMETER);
        } else if (type == Double.class || type == Double.TYPE) {
            paramExpr = new NumericExpressionImpl((Class<Number>)type, name, ExpressionType.PARAMETER);
        } else if (type == Float.class || type == Float.TYPE) {
            paramExpr = new NumericExpressionImpl((Class<Number>)type, name, ExpressionType.PARAMETER);
        } else if (type == Integer.class || type == Integer.TYPE) {
            paramExpr = new NumericExpressionImpl((Class<Number>)type, name, ExpressionType.PARAMETER);
        } else if (type == Long.class || type == Long.TYPE) {
            paramExpr = new NumericExpressionImpl((Class<Number>)type, name, ExpressionType.PARAMETER);
        } else if (type == Short.class || type == Short.TYPE) {
            paramExpr = new NumericExpressionImpl((Class<Number>)type, name, ExpressionType.PARAMETER);
        } else if (type == String.class) {
            paramExpr = new StringExpressionImpl((Class<String>)type, name, ExpressionType.PARAMETER);
        } else if (Time.class.isAssignableFrom(type)) {
            paramExpr = new TimeExpressionImpl((Class<Time>)type, name, ExpressionType.PARAMETER);
        } else if (Date.class.isAssignableFrom(type)) {
            paramExpr = new DateExpressionImpl((Class<Date>)type, name, ExpressionType.PARAMETER);
        } else if (java.util.Date.class.isAssignableFrom(type)) {
            paramExpr = new DateTimeExpressionImpl((Class<java.util.Date>)type, name, ExpressionType.PARAMETER);
        } else if (this.ec.getApiAdapter().isPersistable(type)) {
            String typeName = type.getName();
            int pos = typeName.lastIndexOf(46);
            String qName = typeName.substring(0, pos + 1) + JDOQLTypedQueryImpl.getQueryClassNameForClassName(typeName.substring(pos + 1));
            try {
                Class qClass = this.ec.getClassLoaderResolver().classForName(qName);
                Constructor ctr = qClass.getConstructor(Class.class, String.class, ExpressionType.class);
                Object candObj = ctr.newInstance(new Object[]{type, name, ExpressionType.PARAMETER});
                paramExpr = (ExpressionImpl)candObj;
            }
            catch (NoSuchMethodException nsme) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for parameters");
            }
            catch (IllegalAccessException iae) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for parameters");
            }
            catch (InvocationTargetException ite) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for parameters");
            }
            catch (InstantiationException ie) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for parameters");
            }
        } else {
            paramExpr = new ObjectExpressionImpl<Boolean>(type, name, ExpressionType.PARAMETER);
        }
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    public StringExpression stringParameter(String name) {
        this.assertIsOpen();
        StringExpressionImpl paramExpr = new StringExpressionImpl(String.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    public CharacterExpression characterParameter(String name) {
        this.assertIsOpen();
        CharacterExpressionImpl paramExpr = new CharacterExpressionImpl(Character.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    public NumericExpression<?> numericParameter(String name) {
        this.assertIsOpen();
        NumericExpressionImpl paramExpr = new NumericExpressionImpl(Number.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    public DateExpression dateParameter(String name) {
        this.assertIsOpen();
        DateExpressionImpl paramExpr = new DateExpressionImpl(Date.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    public TimeExpression timeParameter(String name) {
        this.assertIsOpen();
        TimeExpressionImpl paramExpr = new TimeExpressionImpl(Time.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    public DateTimeExpression datetimeParameter(String name) {
        this.assertIsOpen();
        DateTimeExpressionImpl paramExpr = new DateTimeExpressionImpl(java.util.Date.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    public CollectionExpression collectionParameter(String name) {
        this.assertIsOpen();
        CollectionExpressionImpl paramExpr = new CollectionExpressionImpl(Collection.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    public MapExpression mapParameter(String name) {
        this.assertIsOpen();
        MapExpressionImpl paramExpr = new MapExpressionImpl(Map.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    public ListExpression listParameter(String name) {
        this.assertIsOpen();
        ListExpressionImpl paramExpr = new ListExpressionImpl(List.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    public <V> javax.jdo.query.Expression<V> variable(String name, Class<V> type) {
        this.assertIsOpen();
        this.discardCompiled();
        ExpressionImpl varExpr = null;
        if (this.ec.getApiAdapter().isPersistable(type)) {
            String typeName = type.getName();
            int pos = typeName.lastIndexOf(46);
            String qName = typeName.substring(0, pos + 1) + JDOQLTypedQueryImpl.getQueryClassNameForClassName(typeName.substring(pos + 1));
            try {
                Class qClass = this.ec.getClassLoaderResolver().classForName(qName);
                Constructor ctr = qClass.getConstructor(Class.class, String.class, ExpressionType.class);
                Object candObj = ctr.newInstance(new Object[]{type, name, ExpressionType.VARIABLE});
                varExpr = (ObjectExpressionImpl<Boolean>)candObj;
            }
            catch (NoSuchMethodException nsme) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for variables");
            }
            catch (IllegalAccessException iae) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for variables");
            }
            catch (InvocationTargetException ite) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for variables");
            }
            catch (InstantiationException ie) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for variables");
            }
        } else {
            varExpr = type == Boolean.class || type == Boolean.TYPE ? new BooleanExpressionImpl(type, name, ExpressionType.VARIABLE) : (type == Byte.class || type == Byte.TYPE ? new ByteExpressionImpl((Class<Byte>)type, name, ExpressionType.VARIABLE) : (type == Character.class || type == Character.TYPE ? new CharacterExpressionImpl((Class<Character>)type, name, ExpressionType.VARIABLE) : (type == Double.class || type == Double.TYPE ? new NumericExpressionImpl((Class<Number>)type, name, ExpressionType.VARIABLE) : (type == Float.class || type == Float.TYPE ? new NumericExpressionImpl((Class<Number>)type, name, ExpressionType.VARIABLE) : (type == Integer.class || type == Integer.TYPE ? new NumericExpressionImpl((Class<Number>)type, name, ExpressionType.VARIABLE) : (type == Long.class || type == Long.TYPE ? new NumericExpressionImpl((Class<Number>)type, name, ExpressionType.VARIABLE) : (type == Short.class || type == Short.TYPE ? new NumericExpressionImpl((Class<Number>)type, name, ExpressionType.VARIABLE) : (type == String.class ? new StringExpressionImpl((Class<String>)type, name, ExpressionType.VARIABLE) : (Time.class.isAssignableFrom(type) ? new TimeExpressionImpl((Class<Time>)type, name, ExpressionType.VARIABLE) : (Date.class.isAssignableFrom(type) ? new DateExpressionImpl((Class<Date>)type, name, ExpressionType.VARIABLE) : (java.util.Date.class.isAssignableFrom(type) ? new DateTimeExpressionImpl((Class<java.util.Date>)type, name, ExpressionType.VARIABLE) : new ObjectExpressionImpl<Boolean>(type, name, ExpressionType.VARIABLE))))))))))));
        }
        return varExpr;
    }

    public JDOQLTypedQuery<T> excludeSubclasses() {
        this.assertIsOpen();
        this.assertIsModifiable();
        this.discardCompiled();
        this.subclasses = false;
        return this;
    }

    public JDOQLTypedQuery<T> includeSubclasses() {
        this.assertIsOpen();
        this.assertIsModifiable();
        this.discardCompiled();
        this.subclasses = true;
        return this;
    }

    public JDOQLTypedQuery<T> filter(BooleanExpression expr) {
        this.assertIsOpen();
        this.assertIsModifiable();
        this.discardCompiled();
        this.filter = (BooleanExpressionImpl)expr;
        return this;
    }

    public JDOQLTypedQuery<T> groupBy(javax.jdo.query.Expression ... exprs) {
        this.assertIsOpen();
        this.assertIsModifiable();
        this.discardCompiled();
        if (exprs != null && exprs.length > 0) {
            this.grouping = new ArrayList();
            for (int i = 0; i < exprs.length; ++i) {
                this.grouping.add((ExpressionImpl)exprs[i]);
            }
        }
        return this;
    }

    public JDOQLTypedQuery<T> having(javax.jdo.query.Expression expr) {
        this.assertIsOpen();
        this.assertIsModifiable();
        this.discardCompiled();
        this.having = (ExpressionImpl)expr;
        return this;
    }

    public JDOQLTypedQuery<T> orderBy(OrderExpression ... exprs) {
        this.assertIsOpen();
        this.assertIsModifiable();
        this.discardCompiled();
        if (exprs != null && exprs.length > 0) {
            this.ordering = new ArrayList();
            for (int i = 0; i < exprs.length; ++i) {
                this.ordering.add((OrderExpressionImpl)exprs[i]);
            }
        }
        return this;
    }

    public JDOQLTypedQuery<T> range(long lowerIncl, long upperExcl) {
        this.assertIsOpen();
        this.discardCompiled();
        this.rangeLowerExpr = new NumericExpressionImpl((Expression)new Literal((Object)lowerIncl));
        this.rangeUpperExpr = new NumericExpressionImpl((Expression)new Literal((Object)upperExcl));
        return this;
    }

    public JDOQLTypedQuery<T> range(NumericExpression lowerInclExpr, NumericExpression upperExclExpr) {
        this.assertIsOpen();
        this.discardCompiled();
        this.rangeLowerExpr = (ExpressionImpl)lowerInclExpr;
        this.rangeUpperExpr = (ExpressionImpl)upperExclExpr;
        return this;
    }

    public JDOQLTypedQuery<T> range(javax.jdo.query.Expression paramLowerInclExpr, javax.jdo.query.Expression paramUpperExclExpr) {
        this.assertIsOpen();
        this.discardCompiled();
        if (!((ExpressionImpl)paramLowerInclExpr).isParameter()) {
            throw new JDOUserException("lower inclusive expression should be a parameter");
        }
        if (!((ExpressionImpl)paramUpperExclExpr).isParameter()) {
            throw new JDOUserException("upper exclusive expression should be a parameter");
        }
        this.rangeLowerExpr = (ExpressionImpl)paramLowerInclExpr;
        this.rangeUpperExpr = (ExpressionImpl)paramUpperExclExpr;
        return this;
    }

    public <S> JDOQLTypedSubquery<S> subquery(Class<S> candidateClass, String candidateAlias) {
        this.assertIsOpen();
        this.discardCompiled();
        JDOQLTypedSubqueryImpl<S> subquery = new JDOQLTypedSubqueryImpl<S>(this.pm, candidateClass, candidateAlias, this);
        if (this.subqueries == null) {
            this.subqueries = new HashSet<JDOQLTypedSubqueryImpl>();
        }
        this.subqueries.add(subquery);
        return subquery;
    }

    public JDOQLTypedSubquery<T> subquery(String candidateAlias) {
        this.assertIsOpen();
        this.discardCompiled();
        JDOQLTypedSubqueryImpl subquery = new JDOQLTypedSubqueryImpl(this.pm, this.candidateCls, candidateAlias, this);
        if (this.subqueries == null) {
            this.subqueries = new HashSet<JDOQLTypedSubqueryImpl>();
        }
        this.subqueries.add(subquery);
        return subquery;
    }

    public JDOQLTypedQuery<T> setParameters(Map namedParamMap) {
        this.assertIsOpen();
        this.discardCompiled();
        if (namedParamMap == null || namedParamMap.isEmpty()) {
            this.parameterValuesByName = null;
            return this;
        }
        if (this.parameterValuesByName == null) {
            this.parameterValuesByName = new HashMap<String, Object>();
        }
        for (Map.Entry entry : namedParamMap.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (key instanceof String) {
                if (this.parameterExprByName == null || this.parameterExprByName != null && !this.parameterExprByName.containsKey(key)) {
                    throw new JDOUserException("Parameter with name " + key + " doesnt exist for this query");
                }
                this.parameterValuesByName.put((String)key, val);
                continue;
            }
            if (!(key instanceof javax.jdo.query.Expression)) continue;
            ParameterExpression internalParamExpr = (ParameterExpression)((ExpressionImpl)key).getQueryExpression();
            if (this.parameterExprByName == null || this.parameterExprByName != null && !this.parameterExprByName.containsKey(internalParamExpr.getAlias())) {
                throw new JDOUserException("Parameter with name " + internalParamExpr.getAlias() + " doesnt exist for this query");
            }
            this.parameterValuesByName.put(internalParamExpr.getAlias(), val);
        }
        return this;
    }

    public JDOQLTypedQuery<T> setParameter(javax.jdo.query.Expression paramExpr, Object value) {
        this.assertIsOpen();
        this.discardCompiled();
        ParameterExpression internalParamExpr = (ParameterExpression)((ExpressionImpl)paramExpr).getQueryExpression();
        if (this.parameterExprByName == null || this.parameterExprByName != null && !this.parameterExprByName.containsKey(internalParamExpr.getAlias())) {
            throw new JDOUserException("Parameter with name " + internalParamExpr.getAlias() + " doesnt exist for this query");
        }
        if (this.parameterValuesByName == null) {
            this.parameterValuesByName = new HashMap<String, Object>();
        }
        this.parameterValuesByName.put(internalParamExpr.getAlias(), value);
        return this;
    }

    public JDOQLTypedQuery<T> setParameter(String paramName, Object value) {
        this.assertIsOpen();
        this.discardCompiled();
        if (this.parameterExprByName == null || this.parameterExprByName != null && !this.parameterExprByName.containsKey(paramName)) {
            throw new JDOUserException("Parameter with name " + paramName + " doesnt exist for this query");
        }
        if (this.parameterValuesByName == null) {
            this.parameterValuesByName = new HashMap<String, Object>();
        }
        this.parameterValuesByName.put(paramName, value);
        return this;
    }

    public JDOQLTypedQuery<T> setCandidates(Collection<T> candidates) {
        this.assertIsOpen();
        this.candidates = candidates != null ? new ArrayList<T>(candidates) : null;
        return null;
    }

    public JDOQLTypedQuery<T> result(boolean distinct, javax.jdo.query.Expression<?> ... exprs) {
        this.assertIsOpen();
        this.assertIsModifiable();
        this.discardCompiled();
        this.result = null;
        if (exprs != null && exprs.length > 0) {
            this.result = new ArrayList();
            for (int i = 0; i < exprs.length; ++i) {
                this.result.add((ExpressionImpl)exprs[i]);
            }
        }
        this.resultDistinct = distinct;
        return this;
    }

    public <R> List<R> executeResultList(Class<R> resultCls) {
        this.assertIsOpen();
        if (this.result == null) {
            throw new JDOUserException("Cannot call executeResultList method when query has result unset. Call executeList instead.");
        }
        this.type = Query.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.unique = false;
        this.resultClass = resultCls;
        return (List)this.executeInternalQuery(this.getInternalQuery());
    }

    public <R> R executeResultUnique(Class<R> resultCls) {
        this.assertIsOpen();
        if (this.result == null) {
            throw new JDOUserException("Cannot call executeResultUnique method when query has result unset. Call executeUnique instead.");
        }
        this.type = Query.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.unique = true;
        this.resultClass = resultCls;
        return (R)this.executeInternalQuery(this.getInternalQuery());
    }

    public List executeResultList() {
        this.assertIsOpen();
        if (this.result == null) {
            throw new JDOUserException("Cannot call executeResultList method when query has result unset. Call executeList instead.");
        }
        this.type = Query.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.unique = false;
        this.resultClass = null;
        return (List)this.executeInternalQuery(this.getInternalQuery());
    }

    public Object executeResultUnique() {
        this.assertIsOpen();
        if (this.result == null) {
            throw new JDOUserException("Cannot call executeResultUnique method when query has result unset. Call executeUnique instead.");
        }
        this.type = Query.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.unique = true;
        this.resultClass = null;
        return this.executeInternalQuery(this.getInternalQuery());
    }

    public List<T> executeList() {
        this.assertIsOpen();
        if (this.result != null) {
            throw new JDOUserException("Cannot call executeList method when query has result set to " + StringUtils.collectionToString((Collection)this.result) + ". Call executeResultList instead.");
        }
        this.type = Query.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.unique = false;
        return (List)this.executeInternalQuery(this.getInternalQuery());
    }

    public T executeUnique() {
        this.assertIsOpen();
        if (this.result != null) {
            throw new JDOUserException("Cannot call executeUnique method when query has result set to " + StringUtils.collectionToString((Collection)this.result) + ". Call executeResultUnique instead.");
        }
        this.type = Query.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.unique = true;
        return (T)this.executeInternalQuery(this.getInternalQuery());
    }

    protected Query getInternalQuery() {
        Query internalQuery = this.ec.getStoreManager().getQueryManager().newQuery("JDOQL", this.ec, (Object)this.toString());
        internalQuery.setIgnoreCache(this.ignoreCache);
        if (this.extensions != null) {
            internalQuery.setExtensions(this.extensions);
        }
        if (this.fetchPlan != null) {
            internalQuery.setFetchPlan(this.fetchPlan.getInternalFetchPlan());
        }
        if (this.serializeRead != null) {
            internalQuery.setSerializeRead(this.serializeRead);
        }
        if (this.datastoreReadTimeout != null) {
            internalQuery.setDatastoreReadTimeoutMillis(this.datastoreReadTimeout);
        }
        if (this.datastoreWriteTimeout != null) {
            internalQuery.setDatastoreWriteTimeoutMillis(this.datastoreWriteTimeout);
        }
        if (!this.subclasses) {
            internalQuery.setSubclasses(false);
        }
        if (this.type == Query.QueryType.SELECT) {
            internalQuery.setType(Query.QueryType.SELECT);
            if (this.resultDistinct != null) {
                internalQuery.setResultDistinct(this.resultDistinct.booleanValue());
            }
            internalQuery.setResultClass(this.resultClass);
            internalQuery.setUnique(this.unique);
            if (this.candidates != null) {
                internalQuery.setCandidates(this.candidates);
            }
        } else if (this.type == Query.QueryType.BULK_UPDATE) {
            internalQuery.setType(Query.QueryType.BULK_UPDATE);
        } else if (this.type == Query.QueryType.BULK_DELETE) {
            internalQuery.setType(Query.QueryType.BULK_DELETE);
        }
        QueryCompilation compilation = this.getCompilation();
        internalQuery.setCompilation(compilation);
        return internalQuery;
    }

    protected Object executeInternalQuery(Query internalQuery) {
        if (this.internalQueries == null) {
            this.internalQueries = new HashSet<Query>();
        }
        this.internalQueries.add(internalQuery);
        try {
            if (this.parameterValuesByName != null || this.parameterExprByName != null) {
                this.validateParameters();
                Object object = internalQuery.executeWithMap(this.parameterValuesByName);
                return object;
            }
            Object object = internalQuery.execute();
            return object;
        }
        catch (NoQueryResultsException nqre) {
            Object var3_6 = null;
            return var3_6;
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
        finally {
            this.parameterValuesByName = null;
        }
    }

    public long deletePersistentAll() {
        this.assertIsOpen();
        if (this.result != null || this.resultClass != null) {
            throw new JDOUserException("Cannot call deletePersistentAll method when query has result or resultClass set. Remove the result setting.");
        }
        this.type = Query.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.unique = false;
        try {
            Query internalQuery = this.getInternalQuery();
            if (this.parameterValuesByName != null || this.parameterExprByName != null) {
                this.validateParameters();
                long l = internalQuery.deletePersistentAll(this.parameterValuesByName);
                return l;
            }
            long l = internalQuery.deletePersistentAll();
            return l;
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
        finally {
            this.parameterValuesByName = null;
        }
    }

    private void validateParameters() {
        int numValues;
        int numParams = this.parameterExprByName != null ? this.parameterExprByName.size() : 0;
        int n = numValues = this.parameterValuesByName != null ? this.parameterValuesByName.size() : 0;
        if (numParams == 0 && numValues == 0) {
            return;
        }
        if (numParams != numValues) {
            throw new JDOUserException("Query has " + numParams + " but " + numValues + " values have been provided");
        }
        for (String paramName : this.parameterExprByName.keySet()) {
            if (this.parameterValuesByName.containsKey(paramName)) continue;
            throw new JDOUserException("Query has a parameter " + paramName + " defined but no value supplied");
        }
    }

    public JDOQLTypedQuery<T> set(javax.jdo.query.Expression expr, Object val) {
        this.assertIsOpen();
        this.type = Query.QueryType.BULK_UPDATE;
        if (this.updateExprs == null) {
            this.updateExprs = new ArrayList();
            this.updateVals = new ArrayList();
        }
        ComparableExpressionImpl valExpr = null;
        Literal literalExpr = new Literal(val);
        if (val instanceof String) {
            valExpr = new StringExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Number) {
            valExpr = new NumericExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Time) {
            valExpr = new TimeExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Date) {
            valExpr = new DateExpressionImpl((Expression)literalExpr);
        } else if (val instanceof java.util.Date) {
            valExpr = new DateTimeExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Boolean) {
            valExpr = new BooleanExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Byte) {
            valExpr = new ByteExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Enum) {
            valExpr = new EnumExpressionImpl((Expression)literalExpr);
        }
        this.updateExprs.add((ExpressionImpl)expr);
        this.updateVals.add(valExpr);
        return this;
    }

    public long update() {
        this.assertIsOpen();
        this.type = Query.QueryType.BULK_UPDATE;
        if (this.updateExprs == null || this.updateExprs.isEmpty()) {
            throw new JDOUserException("No update expressions defined. Use set() method");
        }
        return (Long)this.executeInternalQuery(this.getInternalQuery());
    }

    public long delete() {
        this.assertIsOpen();
        this.type = Query.QueryType.BULK_DELETE;
        this.updateExprs = null;
        this.updateVals = null;
        return (Long)this.executeInternalQuery(this.getInternalQuery());
    }

    public FetchPlan getFetchPlan() {
        this.assertIsOpen();
        if (this.fetchPlan == null) {
            this.fetchPlan = new JDOFetchPlan(this.ec.getFetchPlan().getCopy());
        }
        return this.fetchPlan;
    }

    public PersistenceManager getPersistenceManager() {
        this.assertIsOpen();
        return this.pm;
    }

    @Override
    public QueryCompilation compile(MetaDataManager mmgr, ClassLoaderResolver clr) {
        this.assertIsOpen();
        QueryCompilation compilation = super.compile(mmgr, clr);
        if (this.subqueries != null && !this.subqueries.isEmpty()) {
            for (JDOQLTypedSubqueryImpl subquery : this.subqueries) {
                QueryCompilation subqueryCompilation = subquery.getCompilation();
                compilation.addSubqueryCompilation(subquery.getAlias(), subqueryCompilation);
            }
        }
        return compilation;
    }

    public static String getQueryClassNameForClassName(String name) {
        return "Q" + name;
    }

    public Integer getDatastoreReadTimeoutMillis() {
        this.assertIsOpen();
        return this.datastoreReadTimeout;
    }

    public JDOQLTypedQuery<T> datastoreReadTimeoutMillis(Integer interval) {
        this.assertIsOpen();
        this.datastoreReadTimeout = interval;
        return this;
    }

    public Integer getDatastoreWriteTimeoutMillis() {
        this.assertIsOpen();
        return this.datastoreWriteTimeout;
    }

    public JDOQLTypedQuery<T> datastoreWriteTimeoutMillis(Integer interval) {
        this.assertIsOpen();
        this.datastoreWriteTimeout = interval;
        return this;
    }

    public Boolean getSerializeRead() {
        this.assertIsOpen();
        return this.serializeRead;
    }

    public JDOQLTypedQuery<T> serializeRead(Boolean serialize) {
        this.assertIsOpen();
        this.serializeRead = serialize;
        return this;
    }

    public boolean isUnmodifiable() {
        this.assertIsOpen();
        return this.unmodifiable;
    }

    public JDOQLTypedQuery<T> unmodifiable() {
        this.assertIsOpen();
        this.unmodifiable = true;
        return this;
    }

    public boolean getIgnoreCache() {
        this.assertIsOpen();
        return this.ignoreCache;
    }

    public JDOQLTypedQuery<T> ignoreCache(boolean flag) {
        this.assertIsOpen();
        this.ignoreCache = flag;
        return this;
    }

    public JDOQLTypedQuery<T> extension(String key, Object value) {
        this.assertIsOpen();
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, value);
        return this;
    }

    public JDOQLTypedQuery<T> extensions(Map values) {
        this.assertIsOpen();
        this.extensions = new HashMap<String, Object>(this.extensions);
        return this;
    }

    public void cancelAll() {
        this.assertIsOpen();
        if (this.internalQueries == null || this.internalQueries.isEmpty()) {
            return;
        }
        try {
            for (Query query : this.internalQueries) {
                query.cancel();
            }
        }
        catch (NucleusException ne) {
            throw new JDOException("Error in calling Query.cancelAll. See the nested exception", (Throwable)ne);
        }
        catch (UnsupportedOperationException uoe) {
            throw new JDOUnsupportedOptionException();
        }
    }

    public void cancel(Thread thread) {
        this.assertIsOpen();
        if (this.internalQueries == null || this.internalQueries.isEmpty()) {
            return;
        }
        try {
            for (Query query : this.internalQueries) {
                query.cancel(thread);
            }
        }
        catch (NucleusException ne) {
            throw new JDOException("Error in calling Query.cancelAll. See the nested exception", (Throwable)ne);
        }
        catch (UnsupportedOperationException uoe) {
            throw new JDOUnsupportedOptionException();
        }
    }

    public JDOQLTypedQuery<T> saveAsNamedQuery(String name) {
        this.assertIsOpen();
        JDOPersistenceManagerFactory.checkJDOPermission(JDOPermission.GET_METADATA);
        QueryMetaData qmd = new QueryMetaData(name);
        qmd.setLanguage("JDOQL");
        Query query = this.getInternalQuery();
        qmd.setQuery(query.toString());
        qmd.setResultClass(query.getResultClassName());
        qmd.setUnique(query.isUnique());
        Map queryExts = query.getExtensions();
        if (queryExts != null && !queryExts.isEmpty()) {
            for (Map.Entry queryExtEntry : queryExts.entrySet()) {
                qmd.addExtension((String)queryExtEntry.getKey(), "" + queryExtEntry.getValue());
            }
        }
        query.getExecutionContext().getMetaDataManager().registerNamedQuery(qmd);
        return this;
    }

    @Override
    public String getJDOQLForExpression(Expression expr) {
        if (expr instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)expr;
            if (this.subqueries != null) {
                for (JDOQLTypedSubqueryImpl subq : this.subqueries) {
                    if (!varExpr.getId().equals(subq.getAlias())) continue;
                    return "(" + subq.toString() + ")";
                }
            }
        }
        return super.getJDOQLForExpression(expr);
    }

    protected void assertIsModifiable() {
        if (this.unmodifiable) {
            throw new NucleusUserException(Localiser.msg((String)"021014"));
        }
    }

    protected void assertIsOpen() {
        if (this.closed) {
            throw new JDOFatalUserException(Localiser.msg((String)"011100"));
        }
    }
}

