/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.datastore.DataStoreCache;
import javax.jdo.datastore.Sequence;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.metadata.JDOMetadata;
import javax.jdo.metadata.TypeMetadata;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.JDOPermission;
import javax.jdo.spi.StateInterrogation;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.datanucleus.AbstractNucleusContext;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchGroup;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.PersistenceNucleusContextImpl;
import org.datanucleus.api.jdo.JDOClassNameConstants;
import org.datanucleus.api.jdo.JDODataStoreCache;
import org.datanucleus.api.jdo.JDOFetchGroup;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.api.jdo.JDOPersistenceManagerProxy;
import org.datanucleus.api.jdo.JDOQueryCache;
import org.datanucleus.api.jdo.JDOStateInterrogation;
import org.datanucleus.api.jdo.LifecycleListenerForClass;
import org.datanucleus.api.jdo.NucleusJDOHelper;
import org.datanucleus.api.jdo.metadata.ClassMetadataImpl;
import org.datanucleus.api.jdo.metadata.InterfaceMetadataImpl;
import org.datanucleus.api.jdo.metadata.JDOMetadataImpl;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.TransactionActiveOnCloseException;
import org.datanucleus.exceptions.TransactionIsolationNotSupportedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.properties.CorePropertyValidator;
import org.datanucleus.query.cache.QueryCompilationCache;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ConnectionResourceType;
import org.datanucleus.store.query.cache.QueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JDOPersistenceManagerFactory
implements PersistenceManagerFactory,
ObjectFactory,
Referenceable,
Serializable {
    private static final long serialVersionUID = -575257641123665920L;
    private static ConcurrentHashMap<String, JDOPersistenceManagerFactory> pmfByName;
    protected transient PersistenceNucleusContext nucleusContext;
    private transient Set<JDOPersistenceManager> pmCache;
    protected transient Map<InstanceLifecycleListener, LifecycleListenerForClass> lifecycleListeners;
    private transient Map<String, Sequence> sequenceByFactoryClass;
    private transient DataStoreCache datastoreCache;
    private transient JDOQueryCache queryCache;
    private transient Set<JDOFetchGroup> jdoFetchGroups;
    private boolean closed;
    private boolean configurable;
    private transient ThreadLocal<PersistenceManager> pmProxyThreadLocal;
    private static final String[] OPTION_ARRAY;
    private Map<String, Object> deserialisationProps;

    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Properties overridingProps) {
        HashMap<String, String> overridingMap = new HashMap<String, String>();
        Enumeration<?> e = overridingProps.propertyNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            overridingMap.put(param, overridingProps.getProperty(param));
        }
        JDOPersistenceManagerFactory pmf = new JDOPersistenceManagerFactory(overridingMap);
        pmf.freezeConfiguration();
        return pmf;
    }

    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Map overridingProps) {
        HashMap<String, String> overridingMap = null;
        if (overridingProps instanceof Properties) {
            overridingMap = new HashMap<String, String>();
            Enumeration<?> e = ((Properties)((Object)overridingProps)).propertyNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                overridingMap.put(param, ((Properties)((Object)overridingProps)).getProperty(param));
            }
        } else {
            overridingMap = overridingProps;
        }
        return JDOPersistenceManagerFactory.createPersistenceManagerFactory(overridingMap);
    }

    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Map overrides, Map props) {
        HashMap<String, String> propsMap = null;
        if (props instanceof Properties) {
            propsMap = new HashMap<String, String>();
            Enumeration<?> e = ((Properties)((Object)props)).propertyNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                propsMap.put(param, ((Properties)((Object)props)).getProperty(param));
            }
        } else {
            propsMap = props;
        }
        HashMap<String, String> overridesMap = null;
        if (overrides instanceof Properties) {
            overridesMap = new HashMap<String, String>();
            Enumeration<?> e = ((Properties)((Object)overrides)).propertyNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                overridesMap.put(param, ((Properties)((Object)overrides)).getProperty(param));
            }
        } else {
            overridesMap = overrides;
        }
        HashMap<String, String> overallMap = null;
        overallMap = propsMap != null ? new HashMap(propsMap) : new HashMap<String, String>();
        if (overridesMap != null) {
            overallMap.putAll(overridesMap);
        }
        return JDOPersistenceManagerFactory.createPersistenceManagerFactory(overallMap);
    }

    protected static JDOPersistenceManagerFactory createPersistenceManagerFactory(Map props) {
        JDOPersistenceManagerFactory pmf;
        Boolean singleton;
        String pmfClassName;
        Class<?> pmfClass = null;
        if (props != null && props.containsKey("javax.jdo.PersistenceManagerFactoryClass") && !(pmfClassName = (String)props.get("javax.jdo.PersistenceManagerFactoryClass")).equals(JDOPersistenceManagerFactory.class.getName())) {
            try {
                pmfClass = Class.forName(pmfClassName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((singleton = (pmf = pmfClass != null ? (JDOPersistenceManagerFactory)ClassUtils.newInstance(pmfClass, (Class[])new Class[]{Map.class}, (Object[])new Object[]{props}) : new JDOPersistenceManagerFactory(props)).getConfiguration().getBooleanObjectProperty("datanucleus.singletonPMFForName")) != null && singleton.booleanValue()) {
            String name;
            if (pmfByName == null) {
                pmfByName = new ConcurrentHashMap();
            }
            if ((name = pmf.getName()) == null) {
                name = pmf.getPersistenceUnitName();
            }
            if (name != null && pmfByName.containsKey(name)) {
                pmf.close();
                NucleusLogger.PERSISTENCE.warn((Object)("Requested PMF of name \"" + name + "\" but already exists and using singleton pattern, so returning existing PMF"));
                return pmfByName.get(name);
            }
            pmfByName.putIfAbsent(name, pmf);
        }
        pmf.freezeConfiguration();
        return pmf;
    }

    public JDOPersistenceManagerFactory() {
        this(null);
    }

    public JDOPersistenceManagerFactory(PersistenceUnitMetaData pumd, Map overrideProps) {
        this.pmCache = new HashSet<JDOPersistenceManager>();
        this.datastoreCache = null;
        this.queryCache = null;
        this.jdoFetchGroups = null;
        this.configurable = true;
        this.pmProxyThreadLocal = new InheritableThreadLocal<PersistenceManager>(){

            @Override
            protected PersistenceManager initialValue() {
                return null;
            }
        };
        this.deserialisationProps = null;
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        if (pumd != null && pumd.getProperties() != null) {
            props.putAll(pumd.getProperties());
        }
        if (overrideProps != null) {
            props.putAll(overrideProps);
        }
        if (!props.containsKey("datanucleus.TransactionType") && !props.containsKey("javax.jdo.option.TransactionType")) {
            props.put("datanucleus.TransactionType", TransactionType.RESOURCE_LOCAL.toString());
        } else {
            String transactionType;
            String string = transactionType = props.get("datanucleus.TransactionType") != null ? (String)props.get("datanucleus.TransactionType") : (String)props.get("javax.jdo.option.TransactionType");
            if (TransactionType.JTA.toString().equalsIgnoreCase(transactionType)) {
                props.put("datanucleus.connection.resourceType", ConnectionResourceType.JTA.toString());
                props.put("datanucleus.connection2.resourceType", ConnectionResourceType.JTA.toString());
            }
        }
        this.nucleusContext = new PersistenceNucleusContextImpl("JDO", props);
        this.initialiseMetaData(pumd);
        this.processLifecycleListenersFromProperties(props);
    }

    public JDOPersistenceManagerFactory(Map props) {
        PersistenceUnitMetaData pumd;
        HashMap<Object, Object> pmfProps;
        block19: {
            this.pmCache = new HashSet<JDOPersistenceManager>();
            this.datastoreCache = null;
            this.queryCache = null;
            this.jdoFetchGroups = null;
            this.configurable = true;
            this.pmProxyThreadLocal = new /* invalid duplicate definition of identical inner class */;
            this.deserialisationProps = null;
            HashMap startupProps = null;
            if (props != null) {
                for (String startupPropName : AbstractNucleusContext.STARTUP_PROPERTIES) {
                    if (!props.containsKey(startupPropName)) continue;
                    if (startupProps == null) {
                        startupProps = new HashMap();
                    }
                    startupProps.put(startupPropName, props.get(startupPropName));
                }
            }
            this.nucleusContext = new PersistenceNucleusContextImpl("JDO", startupProps);
            pmfProps = new HashMap<Object, Object>();
            pumd = null;
            if (props != null) {
                String persistenceUnitName = (String)props.get("datanucleus.PersistenceUnitName");
                if (persistenceUnitName == null) {
                    persistenceUnitName = (String)props.get("javax.jdo.option.PersistenceUnitName");
                }
                if (persistenceUnitName != null) {
                    this.getConfiguration().setProperty("datanucleus.PersistenceUnitName", (Object)persistenceUnitName);
                    try {
                        pumd = this.nucleusContext.getMetaDataManager().getMetaDataForPersistenceUnit(persistenceUnitName);
                        if (pumd != null) {
                            if (pumd.getProperties() != null) {
                                pmfProps.putAll(pumd.getProperties());
                            }
                            break block19;
                        }
                        throw new JDOUserException(Localiser.msg((String)"012004", (Object[])new Object[]{persistenceUnitName}));
                    }
                    catch (NucleusException ne) {
                        throw new JDOUserException(Localiser.msg((String)"012005", (Object[])new Object[]{persistenceUnitName}), (Throwable)ne);
                    }
                }
            }
        }
        if (props != null) {
            pmfProps.putAll(props);
            if (!pmfProps.containsKey("datanucleus.TransactionType") && !pmfProps.containsKey("javax.jdo.option.TransactionType")) {
                pmfProps.put("datanucleus.TransactionType", TransactionType.RESOURCE_LOCAL.toString());
            } else {
                String transactionType;
                String string = transactionType = pmfProps.get("datanucleus.TransactionType") != null ? (String)pmfProps.get("datanucleus.TransactionType") : (String)pmfProps.get("javax.jdo.option.TransactionType");
                if (TransactionType.JTA.toString().equalsIgnoreCase(transactionType)) {
                    pmfProps.put("datanucleus.connection.resourceType", ConnectionResourceType.JTA.toString());
                    pmfProps.put("datanucleus.connection2.resourceType", ConnectionResourceType.JTA.toString());
                }
            }
        } else {
            pmfProps.put("datanucleus.TransactionType", TransactionType.RESOURCE_LOCAL.toString());
        }
        try {
            String propsFileProp = "datanucleus.propertiesFile";
            if (pmfProps.containsKey(propsFileProp)) {
                this.getConfiguration().setPropertiesUsingFile((String)pmfProps.get(propsFileProp));
                pmfProps.remove(propsFileProp);
            }
            this.getConfiguration().setPersistenceProperties(pmfProps);
        }
        catch (IllegalArgumentException iae) {
            throw new JDOFatalUserException("Exception thrown setting persistence properties", (Throwable)iae);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
        this.initialiseMetaData(pumd);
        this.processLifecycleListenersFromProperties(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        this.checkJDOPermission(JDOPermission.CLOSE_PERSISTENCE_MANAGER_FACTORY);
        if (this.isClosed()) {
            return;
        }
        this.setIsNotConfigurable();
        Object object = this.pmCache;
        synchronized (object) {
            HashSet<JDOUserException> exceptions = new HashSet<JDOUserException>();
            for (JDOPersistenceManager pm : this.pmCache) {
                ExecutionContext om = pm.getExecutionContext();
                if (!om.getTransaction().isActive()) continue;
                TransactionActiveOnCloseException tae = new TransactionActiveOnCloseException((Object)om);
                exceptions.add(new JDOUserException(tae.getMessage(), (Object)pm));
            }
            if (!exceptions.isEmpty()) {
                throw new JDOUserException(Localiser.msg((String)"012002"), exceptions.toArray(new Throwable[exceptions.size()]));
            }
            for (JDOPersistenceManager pm : this.pmCache) {
                pm.internalClose();
            }
            this.pmCache.clear();
        }
        if (pmfByName != null) {
            object = pmfByName;
            synchronized (object) {
                Iterator<Map.Entry<String, JDOPersistenceManagerFactory>> pmfIter = pmfByName.entrySet().iterator();
                while (pmfIter.hasNext()) {
                    Map.Entry<String, JDOPersistenceManagerFactory> entry = pmfIter.next();
                    if (entry.getValue() != this) continue;
                    pmfIter.remove();
                    break;
                }
            }
        }
        if (this.sequenceByFactoryClass != null) {
            this.sequenceByFactoryClass.clear();
            this.sequenceByFactoryClass = null;
        }
        if (this.lifecycleListeners != null) {
            this.lifecycleListeners.clear();
            this.lifecycleListeners = null;
        }
        if (this.datastoreCache != null) {
            this.datastoreCache.evictAll();
            this.datastoreCache = null;
        }
        if (this.queryCache != null) {
            this.queryCache.evictAll();
            this.queryCache = null;
        }
        if (this.jdoFetchGroups != null) {
            this.jdoFetchGroups.clear();
            this.jdoFetchGroups = null;
        }
        this.nucleusContext.close();
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    protected void processLifecycleListenersFromProperties(Map props) {
        if (props != null) {
            for (Map.Entry entry : props.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("javax.jdo.listener.InstanceLifecycleListener")) continue;
                String listenerClsName = key.substring(45);
                String listenerClasses = (String)entry.getValue();
                ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
                Class listenerCls = null;
                try {
                    listenerCls = clr.classForName(listenerClsName);
                }
                catch (ClassNotResolvedException cnre) {
                    throw new JDOUserException(Localiser.msg((String)"012022", (Object[])new Object[]{listenerClsName}));
                }
                InstanceLifecycleListener listener = null;
                Method method = ClassUtils.getMethodForClass((Class)listenerCls, (String)"getInstance", null);
                if (method != null) {
                    try {
                        listener = (InstanceLifecycleListener)method.invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new JDOUserException(Localiser.msg((String)"012021", (Object[])new Object[]{listenerClsName}), (Throwable)e);
                    }
                }
                try {
                    listener = (InstanceLifecycleListener)listenerCls.newInstance();
                }
                catch (Exception e) {
                    throw new JDOUserException(Localiser.msg((String)"012020", (Object[])new Object[]{listenerClsName}), (Throwable)e);
                }
                Class[] classes = null;
                if (!StringUtils.isWhitespace((String)listenerClasses)) {
                    String[] classNames = StringUtils.split((String)listenerClasses, (String)",");
                    classes = new Class[classNames.length];
                    for (int i = 0; i < classNames.length; ++i) {
                        classes[i] = clr.classForName(classNames[i]);
                    }
                }
                this.addInstanceLifecycleListener(listener, classes);
            }
        }
    }

    protected void initialiseMetaData(PersistenceUnitMetaData pumd) {
        boolean allowMetadataLoad;
        this.nucleusContext.getMetaDataManager().setAllowXML(this.getConfiguration().getBooleanProperty("datanucleus.metadata.allowXML"));
        this.nucleusContext.getMetaDataManager().setAllowAnnotations(this.getConfiguration().getBooleanProperty("datanucleus.metadata.allowAnnotations"));
        this.nucleusContext.getMetaDataManager().setValidate(this.getConfiguration().getBooleanProperty("datanucleus.metadata.xml.validate"));
        if (pumd != null) {
            try {
                this.nucleusContext.getMetaDataManager().loadPersistenceUnit(pumd, null);
                if (pumd.getValidationMode() != null) {
                    this.getConfiguration().setProperty("datanucleus.validation.mode", (Object)pumd.getValidationMode());
                }
            }
            catch (NucleusException jpe) {
                throw new JDOException(jpe.getMessage(), (Throwable)jpe);
            }
        }
        if (!(allowMetadataLoad = this.nucleusContext.getConfiguration().getBooleanProperty("datanucleus.metadata.allowLoadAtRuntime"))) {
            this.nucleusContext.getMetaDataManager().setAllowMetaDataLoad(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freezeConfiguration() {
        if (this.isConfigurable()) {
            Method m = null;
            try {
                m = JDOImplHelper.class.getDeclaredMethod("assertOnlyKnownStandardProperties", Map.class);
                m.invoke(null, this.nucleusContext.getConfiguration().getPersistenceProperties());
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof JDOException) {
                    throw (JDOException)ite.getCause();
                }
            }
            catch (JDOException jdoe) {
                throw jdoe;
            }
            catch (Exception exception) {
                // empty catch block
            }
            JDOPersistenceManagerFactory jDOPersistenceManagerFactory = this;
            synchronized (jDOPersistenceManagerFactory) {
                try {
                    this.nucleusContext.initialise();
                    this.datastoreCache = new JDODataStoreCache(this.nucleusContext.getLevel2Cache());
                    this.setIsNotConfigurable();
                }
                catch (TransactionIsolationNotSupportedException inse) {
                    throw new JDOUnsupportedOptionException(inse.getMessage());
                }
                catch (NucleusException jpe) {
                    throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
                }
            }
        }
    }

    public PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(this.getConnectionUserName(), this.getConnectionPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceManager getPersistenceManager(String userName, String password) {
        this.assertIsOpen();
        this.freezeConfiguration();
        JDOPersistenceManager pm = this.newPM(this, userName, password);
        if (this.lifecycleListeners != null) {
            for (LifecycleListenerForClass listener : this.lifecycleListeners.values()) {
                pm.addInstanceLifecycleListener(listener.getListener(), listener.getClasses());
            }
        }
        Set<JDOPersistenceManager> set = this.pmCache;
        synchronized (set) {
            this.pmCache.add(pm);
        }
        return pm;
    }

    protected JDOPersistenceManager newPM(JDOPersistenceManagerFactory jdoPmf, String userName, String password) {
        return new JDOPersistenceManager(jdoPmf, userName, password);
    }

    public PersistenceNucleusContext getNucleusContext() {
        return this.nucleusContext;
    }

    protected Configuration getConfiguration() {
        return this.nucleusContext.getConfiguration();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JDOPersistenceManagerFactory)) {
            return false;
        }
        return super.equals(obj);
    }

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        JDOPersistenceManagerFactory pmf = null;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)("Creating PersistenceManagerFactory instance via JNDI with values [object] " + (obj == null ? "" : obj.toString()) + " " + "[name] " + (name == null ? "" : name.toString()) + " " + "[context] " + (ctx == null ? "" : ctx.toString()) + " " + "[env] " + (env == null ? "" : env.toString()) + " "));
        }
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            if (ref.getClassName().equals(JDOClassNameConstants.JDOPersistenceManagerFactory) || ref.getClassName().equals(JDOClassNameConstants.JAVAX_JDO_PersistenceManagerFactory)) {
                Properties p = new Properties();
                Enumeration<RefAddr> e = ref.getAll();
                while (e.hasMoreElements()) {
                    StringRefAddr sra = (StringRefAddr)e.nextElement();
                    p.setProperty(sra.getType(), (String)sra.getContent());
                }
                pmf = new JDOPersistenceManagerFactory(p);
                pmf.freezeConfiguration();
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"012006", (Object[])new Object[]{name.toString()}));
                }
            } else {
                NucleusLogger.PERSISTENCE.warn((Object)Localiser.msg((String)"012007", (Object[])new Object[]{ref.getClassName(), JDOClassNameConstants.JDOPersistenceManagerFactory}));
            }
        } else {
            NucleusLogger.PERSISTENCE.warn((Object)Localiser.msg((String)"012008", (Object[])new Object[]{obj != null ? obj.getClass().getName() : null}));
        }
        return pmf;
    }

    @Override
    public Reference getReference() {
        Reference rc = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            rc = new Reference(JDOClassNameConstants.JAVAX_JDO_PersistenceManagerFactory, JDOClassNameConstants.JDOPersistenceManagerFactory, null);
            Map p = this.getConfiguration().getPersistenceProperties();
            for (Map.Entry entry : p.entrySet()) {
                String value;
                String key = (String)entry.getKey();
                Object valueObj = entry.getValue();
                if (valueObj instanceof String) {
                    value = (String)valueObj;
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) continue;
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"012009", (Object[])new Object[]{key, value}));
                    continue;
                }
                if (valueObj instanceof Long) {
                    value = "" + valueObj;
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) continue;
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"012009", (Object[])new Object[]{key, value}));
                    continue;
                }
                if (valueObj instanceof Integer) {
                    value = "" + valueObj;
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) continue;
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"012009", (Object[])new Object[]{key, value}));
                    continue;
                }
                if (valueObj instanceof Boolean) {
                    value = (Boolean)valueObj != false ? "true" : "false";
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) continue;
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"012009", (Object[])new Object[]{key, value}));
                    continue;
                }
                NucleusLogger.PERSISTENCE.warn((Object)Localiser.msg((String)"012010", (Object[])new Object[]{key}));
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled() && p.isEmpty()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"012011"));
            }
        }
        catch (IOException ex) {
            NucleusLogger.PERSISTENCE.error((Object)ex.getMessage());
            throw new NucleusException(ex.getMessage(), (Throwable)ex);
        }
        return rc;
    }

    public PersistenceManager getPersistenceManagerProxy() {
        return new JDOPersistenceManagerProxy(this);
    }

    PersistenceManager getPMProxyDelegate() {
        PersistenceManager pm = this.pmProxyThreadLocal.get();
        if (pm == null) {
            pm = this.getPersistenceManager();
            this.pmProxyThreadLocal.set(pm);
        }
        return pm;
    }

    void clearPMProxyDelegate() {
        PersistenceManagerFactory pmf = this.getPMProxyDelegate().getPersistenceManagerFactory();
        String txnType = pmf.getTransactionType();
        if (TransactionType.RESOURCE_LOCAL.toString().equalsIgnoreCase(txnType)) {
            this.getPMProxyDelegate().close();
            this.pmProxyThreadLocal.remove();
        } else if (TransactionType.JTA.toString().equalsIgnoreCase(txnType)) {
            // empty if block
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("VendorName", "DataNucleus");
        props.setProperty("VersionNumber", this.nucleusContext.getPluginManager().getVersionForBundle("org.datanucleus.api.jdo"));
        props.putAll((Map<?, ?>)this.nucleusContext.getConfiguration().getPersistenceProperties());
        return props;
    }

    public Collection<String> supportedOptions() {
        HashSet<String> options = new HashSet<String>(Arrays.asList(OPTION_ARRAY));
        StoreManager storeMgr = this.nucleusContext.getStoreManager();
        if (storeMgr != null) {
            Collection storeMgrOptions = storeMgr.getSupportedOptions();
            if (!storeMgrOptions.contains("NonDurableId")) {
                options.remove("javax.jdo.option.NonDurableIdentity");
            }
            if (!storeMgrOptions.contains("DatastoreId")) {
                options.remove("javax.jdo.option.DatastoreIdentity");
            }
            if (!storeMgrOptions.contains("ApplicationId")) {
                options.remove("javax.jdo.option.ApplicationIdentity");
            }
            if (!storeMgr.supportsQueryLanguage("JDOQL")) {
                options.remove("javax.jdo.query.JDOQL");
            }
            if (!storeMgr.supportsQueryLanguage("SQL")) {
                options.remove("javax.jdo.query.SQL");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.read-committed")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.read-committed");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.read-uncommitted")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.read-uncommitted");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.repeatable-read");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.serializable")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.serializable");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.snapshot")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.snapshot");
            }
            if (storeMgrOptions.contains("Query.Cancel")) {
                options.add("javax.jdo.option.QueryCancel");
            }
            if (storeMgrOptions.contains("Datastore.Timeout")) {
                options.add("javax.jdo.option.DatastoreTimeout");
            }
        }
        return Collections.unmodifiableSet(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePersistenceManager(JDOPersistenceManager pm) {
        boolean close = false;
        Set<JDOPersistenceManager> set = this.pmCache;
        synchronized (set) {
            if (this.pmCache.contains(pm)) {
                close = true;
                this.pmCache.remove(pm);
            }
        }
        if (close) {
            pm.internalClose();
        }
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new JDOUserException(Localiser.msg((String)"012025"));
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public DataStoreCache getDataStoreCache() {
        this.freezeConfiguration();
        return this.datastoreCache;
    }

    public JDOQueryCache getQueryCache() {
        if (this.queryCache != null) {
            return this.queryCache;
        }
        QueryResultsCache cache = this.nucleusContext.getStoreManager().getQueryManager().getQueryResultsCache();
        this.queryCache = new JDOQueryCache(cache);
        return this.queryCache;
    }

    public QueryCompilationCache getQueryGenericCompilationCache() {
        return this.nucleusContext.getStoreManager().getQueryManager().getQueryCompilationCache();
    }

    public QueryDatastoreCompilationCache getQueryDatastoreCompilationCache() {
        return this.nucleusContext.getStoreManager().getQueryManager().getQueryDatastoreCompilationCache();
    }

    public void setConnectionUserName(String userName) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionUserName", (Object)userName);
    }

    public void setConnectionPassword(String password) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionPassword", (Object)password);
    }

    public void setConnectionURL(String url) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionURL", (Object)url);
    }

    public void setConnectionDriverName(String driverName) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionDriverName", (Object)driverName);
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionFactoryName", (Object)connectionFactoryName);
    }

    public void setConnectionFactory(Object connectionFactory) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionFactory", connectionFactory);
    }

    public void setConnectionFactory2Name(String connectionFactoryName) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionFactory2Name", (Object)connectionFactoryName);
    }

    public void setConnectionFactory2(Object connectionFactory) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionFactory2", connectionFactory);
    }

    public void setMultithreaded(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.Multithreaded", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setOptimistic(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.Optimistic", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setRetainValues(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.RetainValues", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setRestoreValues(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.RestoreValues", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setNontransactionalRead(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.NontransactionalRead", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setNontransactionalWrite(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.NontransactionalWrite", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setIgnoreCache(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.IgnoreCache", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setDetachAllOnCommit(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.DetachAllOnCommit", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setCopyOnAttach(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.CopyOnAttach", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setMapping(String mapping) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.mapping", (Object)mapping);
    }

    public void setCatalog(String catalog) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.mapping.Catalog", (Object)catalog);
    }

    public void setSchema(String schema) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.mapping.Schema", (Object)schema);
    }

    public void setDatastoreReadTimeoutMillis(Integer timeout) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.datastoreReadTimeout", (Object)timeout);
    }

    public void setDatastoreWriteTimeoutMillis(Integer timeout) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.datastoreWriteTimeout", (Object)timeout);
    }

    public void setTransactionType(String type) {
        this.assertConfigurable();
        boolean validated = new CorePropertyValidator().validate("datanucleus.TransactionType", (Object)type);
        if (!validated) {
            throw new JDOUserException(Localiser.msg((String)"012026", (Object[])new Object[]{"javax.jdo.option.TransactionType", type}));
        }
        this.getConfiguration().setProperty("datanucleus.TransactionType", (Object)type);
    }

    public void setPersistenceUnitName(String name) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.PersistenceUnitName", (Object)name);
    }

    public void setPersistenceXmlFilename(String name) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.persistenceXmlFilename", (Object)name);
    }

    public void setName(String name) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.Name", (Object)name);
    }

    public void setServerTimeZoneID(String id) {
        this.assertConfigurable();
        boolean validated = new CorePropertyValidator().validate("datanucleus.ServerTimeZoneID", (Object)id);
        if (!validated) {
            throw new JDOUserException("Invalid TimeZone ID specified");
        }
        this.getConfiguration().setProperty("datanucleus.ServerTimeZoneID", (Object)id);
    }

    public void setReadOnly(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.readOnlyDatastore", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setTransactionIsolationLevel(String level) {
        this.assertConfigurable();
        if (this.nucleusContext.getStoreManager() != null && !this.nucleusContext.getStoreManager().getSupportedOptions().contains("TransactionIsolationLevel." + level)) {
            throw new JDOUnsupportedOptionException("Isolation level \"" + level + "\" is not supported for this datastore");
        }
        this.getConfiguration().setProperty("datanucleus.transactionIsolation", (Object)(level != null ? level : "read-committed"));
    }

    public String getConnectionUserName() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionUserName");
    }

    public String getConnectionPassword() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionPassword");
    }

    public String getConnectionURL() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionURL");
    }

    public String getConnectionDriverName() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionDriverName");
    }

    public String getConnectionFactoryName() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionFactoryName");
    }

    public String getConnectionFactory2Name() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionFactory2Name");
    }

    public Object getConnectionFactory() {
        return this.getConfiguration().getProperty("datanucleus.ConnectionFactory");
    }

    public Object getConnectionFactory2() {
        return this.getConfiguration().getProperty("datanucleus.ConnectionFactory2");
    }

    public boolean getMultithreaded() {
        return this.getConfiguration().getBooleanProperty("datanucleus.Multithreaded");
    }

    public boolean getOptimistic() {
        return this.getConfiguration().getBooleanProperty("datanucleus.Optimistic");
    }

    public boolean getRetainValues() {
        return this.getConfiguration().getBooleanProperty("datanucleus.RetainValues");
    }

    public boolean getRestoreValues() {
        return this.getConfiguration().getBooleanProperty("datanucleus.RestoreValues");
    }

    public boolean getNontransactionalRead() {
        return this.getConfiguration().getBooleanProperty("datanucleus.NontransactionalRead");
    }

    public boolean getNontransactionalWrite() {
        return this.getConfiguration().getBooleanProperty("datanucleus.NontransactionalWrite");
    }

    public boolean getIgnoreCache() {
        return this.getConfiguration().getBooleanProperty("datanucleus.IgnoreCache");
    }

    public boolean getDetachAllOnCommit() {
        return this.getConfiguration().getBooleanProperty("datanucleus.DetachAllOnCommit");
    }

    public boolean getCopyOnAttach() {
        return this.getConfiguration().getBooleanProperty("datanucleus.CopyOnAttach");
    }

    public String getMapping() {
        return this.getConfiguration().getStringProperty("datanucleus.mapping");
    }

    public String getCatalog() {
        return this.getConfiguration().getStringProperty("datanucleus.mapping.Catalog");
    }

    public String getSchema() {
        return this.getConfiguration().getStringProperty("datanucleus.mapping.Schema");
    }

    public String getName() {
        return this.getConfiguration().getStringProperty("datanucleus.Name");
    }

    public String getPersistenceUnitName() {
        return this.getConfiguration().getStringProperty("datanucleus.PersistenceUnitName");
    }

    public String getPersistenceXmlFilename() {
        return this.getConfiguration().getStringProperty("datanucleus.persistenceXmlFilename");
    }

    public Integer getDatastoreReadTimeoutMillis() {
        return this.getConfiguration().getIntProperty("datanucleus.datastoreReadTimeout");
    }

    public Integer getDatastoreWriteTimeoutMillis() {
        return this.getConfiguration().getIntProperty("datanucleus.datastoreWriteTimeout");
    }

    public String getServerTimeZoneID() {
        return this.getConfiguration().getStringProperty("datanucleus.ServerTimeZoneID");
    }

    public boolean getReadOnly() {
        return this.getConfiguration().getBooleanProperty("datanucleus.readOnlyDatastore");
    }

    public String getTransactionType() {
        return this.getConfiguration().getStringProperty("datanucleus.TransactionType");
    }

    public String getTransactionIsolationLevel() {
        return this.getConfiguration().getStringProperty("datanucleus.transactionIsolation");
    }

    public void setPrimaryClassLoader(ClassLoader loader) {
        this.getConfiguration().setProperty("datanucleus.primaryClassLoader", (Object)loader);
    }

    public ClassLoader getPrimaryClassLoader() {
        return (ClassLoader)this.getConfiguration().getProperty("datanucleus.primaryClassLoader");
    }

    public void setPersistenceProperties(Map<String, Object> props) {
        this.assertConfigurable();
        this.getConfiguration().setPersistenceProperties(props);
    }

    public Map<String, Object> getPersistenceProperties() {
        return this.getConfiguration().getPersistenceProperties();
    }

    protected void assertConfigurable() {
        if (!this.isConfigurable()) {
            throw new JDOUserException(Localiser.msg((String)"012023"));
        }
    }

    protected boolean isConfigurable() {
        return this.configurable;
    }

    protected void setIsNotConfigurable() {
        this.configurable = false;
    }

    public List<LifecycleListenerForClass> getLifecycleListenerSpecifications() {
        if (this.lifecycleListeners == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<LifecycleListenerForClass>(this.lifecycleListeners.values());
    }

    public void addInstanceLifecycleListener(InstanceLifecycleListener listener, Class[] classes) {
        boolean allowListeners = this.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.allowListenerUpdateAfterInit", false);
        if (!allowListeners) {
            this.assertConfigurable();
        }
        if (listener == null) {
            return;
        }
        if ((classes = LifecycleListenerForClass.canonicaliseClasses(classes)) != null && classes.length == 0) {
            return;
        }
        if (this.lifecycleListeners == null) {
            this.lifecycleListeners = new ConcurrentHashMap<InstanceLifecycleListener, LifecycleListenerForClass>(1);
        }
        LifecycleListenerForClass entry = this.lifecycleListeners.containsKey(listener) ? this.lifecycleListeners.get(listener).mergeClasses(classes) : new LifecycleListenerForClass(listener, classes);
        this.lifecycleListeners.put(listener, entry);
    }

    public void removeInstanceLifecycleListener(InstanceLifecycleListener listener) {
        boolean allowListeners = this.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.allowListenerUpdateAfterInit", false);
        if (!allowListeners) {
            this.assertConfigurable();
        }
        if (listener == null || this.lifecycleListeners == null) {
            return;
        }
        this.lifecycleListeners.remove(listener);
    }

    public void addSequenceForFactoryClass(String factoryClassName, Sequence sequence) {
        if (this.sequenceByFactoryClass == null) {
            this.sequenceByFactoryClass = new HashMap<String, Sequence>();
        }
        this.sequenceByFactoryClass.put(factoryClassName, sequence);
    }

    public Sequence getSequenceForFactoryClass(String factoryClassName) {
        if (this.sequenceByFactoryClass == null) {
            return null;
        }
        return this.sequenceByFactoryClass.get(factoryClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<javax.jdo.FetchGroup> getFetchGroups() {
        Set<JDOFetchGroup> jdoGroups = this.getJDOFetchGroups(false);
        if (jdoGroups != null) {
            Set<JDOFetchGroup> set = jdoGroups;
            synchronized (set) {
                if (!jdoGroups.isEmpty()) {
                    return new HashSet<javax.jdo.FetchGroup>(jdoGroups);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.jdo.FetchGroup getFetchGroup(Class cls, String name) {
        Set<JDOFetchGroup> jdoGroups = this.getJDOFetchGroups(false);
        if (jdoGroups != null) {
            Set<JDOFetchGroup> set = jdoGroups;
            synchronized (set) {
                for (JDOFetchGroup jdoFetchGroup : jdoGroups) {
                    if (jdoFetchGroup.getType() != cls || !jdoFetchGroup.getName().equals(name)) continue;
                    return jdoFetchGroup;
                }
            }
        }
        try {
            FetchGroup internalGrp = this.nucleusContext.getInternalFetchGroup(cls, name);
            if (!internalGrp.isUnmodifiable()) {
                return new JDOFetchGroup(internalGrp);
            }
            internalGrp = this.nucleusContext.createInternalFetchGroup(cls, name);
            this.nucleusContext.addInternalFetchGroup(internalGrp);
            JDOFetchGroup jdoGrp = new JDOFetchGroup(internalGrp);
            return jdoGrp;
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFetchGroups(javax.jdo.FetchGroup ... groups) {
        Set<JDOFetchGroup> jdoGroups;
        if (groups == null || groups.length == 0) {
            return;
        }
        Set<JDOFetchGroup> set = jdoGroups = this.getJDOFetchGroups(true);
        synchronized (set) {
            for (int i = 0; i < groups.length; ++i) {
                JDOFetchGroup jdoFetchGroup = (JDOFetchGroup)groups[i];
                this.nucleusContext.addInternalFetchGroup(jdoFetchGroup.getInternalFetchGroup());
                jdoGroups.add(jdoFetchGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFetchGroups(javax.jdo.FetchGroup ... groups) {
        if (groups == null || groups.length == 0) {
            return;
        }
        Set<JDOFetchGroup> jdoGroups = this.getJDOFetchGroups(false);
        if (jdoGroups != null) {
            Set<JDOFetchGroup> set = jdoGroups;
            synchronized (set) {
                if (!jdoGroups.isEmpty()) {
                    for (int i = 0; i < groups.length; ++i) {
                        JDOFetchGroup jdoFetchGroup = (JDOFetchGroup)groups[i];
                        this.nucleusContext.removeInternalFetchGroup(jdoFetchGroup.getInternalFetchGroup());
                        jdoGroups.remove(jdoFetchGroup);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllFetchGroups() {
        Set<JDOFetchGroup> jdoGroups = this.getJDOFetchGroups(false);
        if (jdoGroups != null) {
            Set<JDOFetchGroup> set = jdoGroups;
            synchronized (set) {
                for (JDOFetchGroup jdoGrp : jdoGroups) {
                    this.nucleusContext.removeInternalFetchGroup(jdoGrp.getInternalFetchGroup());
                }
                jdoGroups.clear();
            }
        }
    }

    private synchronized Set<JDOFetchGroup> getJDOFetchGroups(boolean createIfNull) {
        if (this.jdoFetchGroups == null && createIfNull) {
            this.jdoFetchGroups = new HashSet<JDOFetchGroup>();
        }
        return this.jdoFetchGroups;
    }

    public JDOMetadata newMetadata() {
        return new JDOMetadataImpl();
    }

    public void registerMetadata(JDOMetadata metadata) {
        MetaDataManager mmgr = this.nucleusContext.getMetaDataManager();
        FileMetaData filemd = ((JDOMetadataImpl)metadata).getInternal();
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                if (!mmgr.hasMetaDataForClass(cmd.getFullClassName())) continue;
                throw new JDOUserException("Cannot redefine metadata for " + cmd.getFullClassName());
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData imd = pmd.getInterface(j);
                if (!mmgr.hasMetaDataForClass(imd.getFullClassName())) continue;
                throw new JDOUserException("Cannot redefine metadata for " + imd.getFullClassName());
            }
        }
        mmgr.loadUserMetaData(filemd, null);
    }

    public TypeMetadata getMetadata(String className) {
        MetaDataManager mmgr = this.nucleusContext.getMetaDataManager();
        AbstractClassMetaData acmd = mmgr.getMetaDataForClass(className, this.nucleusContext.getClassLoaderResolver(null));
        if (acmd == null) {
            return null;
        }
        if (acmd instanceof ClassMetaData) {
            return new ClassMetadataImpl((ClassMetaData)acmd);
        }
        return new InterfaceMetadataImpl((InterfaceMetaData)acmd);
    }

    public Collection<Class> getManagedClasses() {
        this.checkJDOPermission(JDOPermission.GET_METADATA);
        MetaDataManager mmgr = this.nucleusContext.getMetaDataManager();
        Collection classNames = mmgr.getClassesWithMetaData();
        HashSet<Class> classes = new HashSet<Class>();
        if (classNames != null) {
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            Iterator iter = classNames.iterator();
            while (iter.hasNext()) {
                try {
                    Class cls = clr.classForName((String)iter.next());
                    classes.add(cls);
                }
                catch (ClassNotResolvedException cnre) {}
            }
        }
        return classes;
    }

    public void unmanageClass(String className) {
        MetaDataManager mmgr = this.nucleusContext.getMetaDataManager();
        mmgr.unloadMetaDataForClass(className);
        this.nucleusContext.getStoreManager().unmanageClass(this.nucleusContext.getClassLoaderResolver(null), className, false);
    }

    private void checkJDOPermission(JDOPermission jdoPermission) {
        SecurityManager secmgr = System.getSecurityManager();
        if (secmgr != null) {
            secmgr.checkPermission((Permission)jdoPermission);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.nucleusContext.getConfiguration().getPersistenceProperties());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.deserialisationProps = (Map)ois.readObject();
    }

    private Object readResolve() throws InvalidObjectException {
        JDOPersistenceManagerFactory pmf = null;
        if (pmfByName != null) {
            String name = (String)this.deserialisationProps.get("datanucleus.Name");
            if (name == null) {
                name = (String)this.deserialisationProps.get("datanucleus.PersistenceUnitName");
            }
            if ((pmf = pmfByName.get(name)) != null) {
                return pmf;
            }
        }
        this.configurable = true;
        if (this.pmCache == null) {
            this.pmCache = new HashSet<JDOPersistenceManager>();
        }
        this.nucleusContext = new PersistenceNucleusContextImpl("JDO", this.deserialisationProps);
        PersistenceUnitMetaData pumd = null;
        if (this.getPersistenceUnitName() != null) {
            pumd = this.nucleusContext.getMetaDataManager().getMetaDataForPersistenceUnit(this.getPersistenceUnitName());
        }
        this.initialiseMetaData(pumd);
        this.processLifecycleListenersFromProperties(this.deserialisationProps);
        this.freezeConfiguration();
        this.deserialisationProps = null;
        return this;
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.api.jdo.Localisation", (ClassLoader)JDOPersistenceManagerFactory.class.getClassLoader());
        JDOImplHelper.getInstance().addStateInterrogation((StateInterrogation)new JDOStateInterrogation());
        OPTION_ARRAY = new String[]{"javax.jdo.option.TransientTransactional", "javax.jdo.option.NontransactionalWrite", "javax.jdo.option.NontransactionalRead", "javax.jdo.option.RetainValues", "javax.jdo.option.Optimistic", "javax.jdo.option.ApplicationIdentity", "javax.jdo.option.DatastoreIdentity", "javax.jdo.option.NonDurableIdentity", "javax.jdo.option.GetDataStoreConnection", "javax.jdo.option.GetJDBCConnection", "javax.jdo.option.version.DateTime", "javax.jdo.option.PreDirtyEvent", "javax.jdo.option.ArrayList", "javax.jdo.option.LinkedList", "javax.jdo.option.TreeSet", "javax.jdo.option.TreeMap", "javax.jdo.option.Vector", "javax.jdo.option.List", "javax.jdo.option.Stack", "javax.jdo.option.Map", "javax.jdo.option.HashMap", "javax.jdo.option.Hashtable", "javax.jdo.option.SortedSet", "javax.jdo.option.SortedMap", "javax.jdo.option.Array", "javax.jdo.option.NullCollection", "javax.jdo.option.mapping.HeterogeneousObjectType", "javax.jdo.option.mapping.HeterogeneousInterfaceType", "javax.jdo.option.mapping.JoinedTablePerClass", "javax.jdo.option.mapping.JoinedTablePerConcreteClass", "javax.jdo.option.mapping.NonJoinedTablePerConcreteClass", "javax.jdo.query.SQL", "javax.jdo.query.JDOQL", "javax.jdo.option.UnconstrainedQueryVariables"};
    }
}

