/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.state;

import javax.jdo.JDOUserException;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.state.LifeCycleState;

class PersistentNontransactionalDirty
extends LifeCycleState {
    protected PersistentNontransactionalDirty() {
        this.isPersistent = true;
        this.isDirty = true;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = false;
        this.stateType = 10;
    }

    public LifeCycleState transitionMakeTransactional(StateManager sm, boolean refreshFields) {
        return this;
    }

    public LifeCycleState transitionCommit(StateManager sm, Transaction tx) {
        sm.clearSavedFields();
        if (tx.getRetainValues()) {
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionRollback(StateManager sm, Transaction tx) {
        if (tx.getRestoreValues()) {
            sm.restoreFields();
            return this.changeState(sm, 10);
        }
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionEvict(StateManager sm) {
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionReadField(StateManager sm, boolean isLoaded) {
        Transaction tx = sm.getObjectManager().getTransaction();
        if (!tx.isActive() && !tx.getNontransactionalRead()) {
            throw new JDOUserException(LOCALISER.msg("027002"), sm.getInternalObjectId());
        }
        return this;
    }

    public LifeCycleState transitionBegin(StateManager sm, Transaction tx) {
        sm.saveFields();
        sm.enlistInTransaction();
        return this;
    }

    public LifeCycleState transitionWriteField(StateManager sm) {
        return this;
    }

    public LifeCycleState transitionDetach(StateManager sm) {
        return this.changeState(sm, 11);
    }

    public String toString() {
        return "P_NONTRANS_DIRTY";
    }
}

