/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.report;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.databene.contiperf.report.ReportModule;

public class ReportContext {
    private File reportFolder;
    private Constructor<? extends Error> failureCtor;
    private List<ReportModule> modules;

    public ReportContext(File reportFolder, Class<? extends Error> failureClass) {
        this.reportFolder = reportFolder;
        this.ensureDirectoryExists(reportFolder);
        try {
            this.failureCtor = failureClass.getConstructor(String.class);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Security exception in String constructor call of " + failureClass, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failure classes need a constructor with one String argument, " + failureClass + " does not have one", e);
        }
        this.modules = new ArrayList<ReportModule>();
    }

    public File getReportFolder() {
        return this.reportFolder;
    }

    public void addReportModule(ReportModule module) {
        module.setContext(this);
        this.modules.add(module);
    }

    public void fail(String message) {
        try {
            throw this.failureCtor.newInstance(message);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating failure. ", e);
        }
    }

    public List<ReportModule> getReportModules() {
        return this.modules;
    }

    public <T extends ReportModule> T getReportModule(Class<T> moduleClass) {
        for (ReportModule module : this.modules) {
            if (!moduleClass.isAssignableFrom(module.getClass())) continue;
            return (T)module;
        }
        throw new RuntimeException("No module of type '" + moduleClass.getName() + " found. Available: " + this.modules);
    }

    protected void ensureDirectoryExists(File dir) {
        if (!dir.exists()) {
            File parent = dir.getParentFile();
            if (parent != null) {
                this.ensureDirectoryExists(parent);
            }
            dir.mkdir();
        }
    }
}

