/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.junit;

import java.lang.reflect.Method;
import org.databene.contiperf.junit.ParallelScheduler;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelRunner
extends BlockJUnit4ClassRunner {
    public ParallelRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                ParallelRunner.this.runChildren(notifier);
            }
        };
    }

    private void runChildren(RunNotifier notifier) {
        ParallelScheduler scheduler = new ParallelScheduler();
        for (FrameworkMethod method : this.getChildren()) {
            scheduler.schedule(new ChildRunnable(method, notifier));
        }
        scheduler.finished();
    }

    public class ChildRunnable
    implements Runnable {
        FrameworkMethod method;
        RunNotifier notifier;

        public ChildRunnable(FrameworkMethod method, RunNotifier notifier) {
            this.method = method;
            this.notifier = notifier;
        }

        public void run() {
            ParallelRunner.this.runChild(this.method, this.notifier);
        }

        public String toString() {
            Method realMethod = this.method.getMethod();
            return realMethod.getDeclaringClass().getSimpleName() + '.' + realMethod.getName() + "()";
        }
    }
}

