/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.typeadapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;

public class PostConstructAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        for (Class t = type.getRawType(); t != Object.class; t = t.getSuperclass()) {
            for (Method m : t.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(PostConstruct.class)) continue;
                m.setAccessible(true);
                TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
                return new PostConstructAdapter(delegate, m);
            }
        }
        return null;
    }

    static final class PostConstructAdapter<T>
    extends TypeAdapter<T> {
        private final TypeAdapter<T> delegate;
        private final Method method;

        public PostConstructAdapter(TypeAdapter<T> delegate, Method method) {
            this.delegate = delegate;
            this.method = method;
        }

        public T read(JsonReader in) throws IOException {
            Object result = this.delegate.read(in);
            if (result != null) {
                try {
                    this.method.invoke(result, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError();
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException(e.getCause());
                }
            }
            return (T)result;
        }

        public void write(JsonWriter out, T value) throws IOException {
            this.delegate.write(out, value);
        }
    }
}

