/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.braille.css.saxon.impl;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import org.daisy.braille.css.BrailleCSSParserFactory;
import org.daisy.braille.css.InlineStyle;
import org.daisy.common.saxon.SaxonOutputValue;
import org.daisy.pipeline.braille.css.impl.BrailleCssSerializer;
import org.daisy.pipeline.braille.css.impl.BrailleCssTreeBuilder;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="css:parse-stylesheet", service={ExtensionFunctionDefinition.class})
public class ParseStylesheetDefinition
extends ExtensionFunctionDefinition {
    private static final String XMLNS_CSS = "http://www.daisy.org/ns/pipeline/braille-css";
    private static final StructuredQName funcname = new StructuredQName("css", "http://www.daisy.org/ns/pipeline/braille-css", "parse-stylesheet");
    private static final QName PAGE = new QName("page");
    private static final QName VOLUME = new QName("volume");
    private static final QName VENDOR_RULE = new QName("vendor-rule");
    private static final Logger logger = LoggerFactory.getLogger(ParseStylesheetDefinition.class);

    public StructuredQName getFunctionQName() {
        return funcname;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_STRING, SequenceType.SINGLE_BOOLEAN, SequenceType.OPTIONAL_QNAME};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.NODE_SEQUENCE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                Item i;
                if (arguments.length == 0) {
                    return EmptySequence.getInstance();
                }
                Item arg = arguments[0].head();
                if (arg == null) {
                    return EmptySequence.getInstance();
                }
                boolean deep = arguments.length > 1 ? ((BooleanValue)arguments[1]).getBooleanValue() : false;
                BrailleCSSParserFactory.Context styleCtxt = BrailleCSSParserFactory.Context.ELEMENT;
                if (arguments.length > 2 && (i = arguments[2].head()) != null) {
                    QName qn = ((QNameValue)i).toJaxpQName();
                    if (qn.equals(PAGE)) {
                        styleCtxt = BrailleCSSParserFactory.Context.PAGE;
                    } else if (qn.equals(VOLUME)) {
                        styleCtxt = BrailleCSSParserFactory.Context.VOLUME;
                    } else if (qn.equals(VENDOR_RULE)) {
                        styleCtxt = BrailleCSSParserFactory.Context.VENDOR_RULE;
                    } else {
                        throw new RuntimeException();
                    }
                }
                ArrayList result = new ArrayList();
                try {
                    BrailleCssTreeBuilder.Style style = BrailleCssTreeBuilder.Style.of(new InlineStyle(arg.getStringValue(), styleCtxt));
                    BrailleCssSerializer.toXml(style, (XMLStreamWriter)new SaxonOutputValue(item -> {
                        if (!(item instanceof XdmNode)) {
                            throw new RuntimeException();
                        }
                        result.add(((XdmNode)item).getUnderlyingNode());
                    }, context.getConfiguration()).asXMLStreamWriter(), deep);
                }
                catch (Exception e) {
                    logger.error("Error happened while parsing " + arg, (Throwable)e);
                }
                return new SequenceExtent(result);
            }
        };
    }
}

