/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.braille.css.calabash.impl;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.saxon.s9api.SaxonApiException;
import org.daisy.common.saxon.SaxonBuffer;
import org.daisy.common.stax.BaseURIAwareXMLStreamReader;
import org.daisy.common.stax.BaseURIAwareXMLStreamWriter;
import org.daisy.common.stax.XMLStreamWriterHelper;
import org.daisy.common.transform.Buffer;
import org.daisy.common.transform.InputValue;
import org.daisy.common.transform.OutputValue;
import org.daisy.common.transform.SingleInSingleOutXMLTransformer;
import org.daisy.common.transform.TransformerException;
import org.daisy.common.transform.XMLInputValue;
import org.daisy.common.transform.XMLOutputValue;
import org.daisy.common.xproc.calabash.XMLCalabashInputValue;
import org.daisy.common.xproc.calabash.XMLCalabashOutputValue;
import org.daisy.common.xproc.calabash.XProcStep;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssShiftIdStep
extends DefaultStep
implements XProcStep {
    private ReadablePipe sourcePipe = null;
    private WritablePipe resultPipe = null;
    private static final String XMLNS_CSS = "http://www.daisy.org/ns/pipeline/braille-css";
    private static final QName CSS_ID = new QName("http://www.daisy.org/ns/pipeline/braille-css", "id");
    private static final QName CSS_BOX = new QName("http://www.daisy.org/ns/pipeline/braille-css", "box");
    private static final QName CSS__ = new QName("http://www.daisy.org/ns/pipeline/braille-css", "_");
    private static final QName _TYPE = new QName("type");
    private static final QName CSS_COUNTER = new QName("http://www.daisy.org/ns/pipeline/braille-css", "counter");
    private static final QName _NAME = new QName("name");
    private static final QName _TARGET = new QName("target");
    private static final QName CSS_ANCHOR = new QName("http://www.daisy.org/ns/pipeline/braille-css", "anchor");
    private static final QName CSS_FLOW = new QName("http://www.daisy.org/ns/pipeline/braille-css", "flow");
    private static final Logger logger = LoggerFactory.getLogger(CssShiftIdStep.class);

    private CssShiftIdStep(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void setInput(String port, ReadablePipe pipe) {
        this.sourcePipe = pipe;
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.resultPipe = pipe;
    }

    public void reset() {
        this.sourcePipe.resetReader();
        this.resultPipe.resetWriter();
    }

    public void run() throws SaxonApiException {
        super.run();
        try {
            TreeMap<String, String> idMap = new TreeMap<String, String>();
            TreeSet<String> discardedIds = new TreeSet<String>();
            new ShiftIdTransformer(idMap, discardedIds).andThen(new UpdateRefsTransformer(idMap, discardedIds), (Buffer)new SaxonBuffer(this.runtime.getProcessor().getUnderlyingConfiguration()), false).transform((InputValue)new XMLCalabashInputValue(this.sourcePipe), (OutputValue)new XMLCalabashOutputValue(this.resultPipe, this.runtime)).run();
        }
        catch (Throwable e) {
            throw XProcStep.raiseError((Throwable)e, (XAtomicStep)this.step);
        }
    }

    private static class UpdateRefsTransformer
    extends SingleInSingleOutXMLTransformer {
        private final Map<String, String> idMap;
        private final Set<String> discardedIds;

        public UpdateRefsTransformer(Map<String, String> idMap, Set<String> discardedIds) {
            this.idMap = idMap;
            this.discardedIds = discardedIds;
        }

        public Runnable transform(XMLInputValue<?> source, XMLOutputValue<?> result, InputValue<?> params) throws IllegalArgumentException {
            if (source == null || result == null) {
                throw new IllegalArgumentException();
            }
            return () -> this.transform(source.asXMLStreamReader(), result.asXMLStreamWriter());
        }

        void transform(BaseURIAwareXMLStreamReader reader, BaseURIAwareXMLStreamWriter output) throws TransformerException {
            XMLStreamWriterHelper.BufferedXMLStreamWriter writer = new XMLStreamWriterHelper.BufferedXMLStreamWriter(output);
            try {
                try {
                    while (true) {
                        int event = reader.getEventType();
                        switch (event) {
                            case 1: {
                                XMLStreamWriterHelper.writeEvent((XMLStreamWriter)writer, (XMLStreamReader)reader);
                                QName elemName = reader.getName();
                                boolean isCounter = CSS_COUNTER.equals(elemName);
                                String counterTarget = null;
                                String anchor = null;
                                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                                    QName attrName = reader.getAttributeName(i);
                                    String attrValue = reader.getAttributeValue(i);
                                    if (CSS_ANCHOR.equals(attrName)) {
                                        anchor = attrValue;
                                        continue;
                                    }
                                    if (isCounter && _TARGET.equals(attrName)) {
                                        counterTarget = attrValue;
                                        continue;
                                    }
                                    XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)attrName, (String)attrValue);
                                }
                                if (anchor != null) {
                                    if (this.idMap.containsKey(anchor)) {
                                        anchor = this.idMap.get(anchor);
                                    } else if (this.discardedIds.contains(anchor)) {
                                        throw new RuntimeException();
                                    }
                                    XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)CSS_ANCHOR, (String)anchor);
                                }
                                if (counterTarget == null) break;
                                if (this.idMap.containsKey(counterTarget)) {
                                    counterTarget = this.idMap.get(counterTarget);
                                } else if (this.discardedIds.contains(counterTarget)) {
                                    throw new RuntimeException();
                                }
                                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)_TARGET, (String)counterTarget);
                                break;
                            }
                            default: {
                                XMLStreamWriterHelper.writeEvent((XMLStreamWriter)writer, (XMLStreamReader)reader);
                            }
                        }
                        reader.next();
                    }
                }
                catch (NoSuchElementException e) {
                    writer.flush();
                }
            }
            catch (XMLStreamException e) {
                throw new TransformerException((Throwable)e);
            }
        }
    }

    private static class ShiftIdTransformer
    extends SingleInSingleOutXMLTransformer {
        private final Map<String, String> idMap;
        private final Set<String> discardedIds;

        public ShiftIdTransformer(Map<String, String> idMap, Set<String> discardedIds) {
            this.idMap = idMap;
            this.discardedIds = discardedIds;
        }

        public Runnable transform(XMLInputValue<?> source, XMLOutputValue<?> result, InputValue<?> params) throws IllegalArgumentException {
            if (source == null || result == null) {
                throw new IllegalArgumentException();
            }
            return () -> this.transform(source.asXMLStreamReader(), result.asXMLStreamWriter());
        }

        public void transform(BaseURIAwareXMLStreamReader reader, BaseURIAwareXMLStreamWriter output) throws TransformerException {
            XMLStreamWriterHelper.BufferedXMLStreamWriter writer = new XMLStreamWriterHelper.BufferedXMLStreamWriter(output);
            boolean insideInlineBox = false;
            Stack<Boolean> blockBoxes = new Stack<Boolean>();
            Stack<Boolean> inlineBoxes = new Stack<Boolean>();
            ArrayList<String> pendingId = new ArrayList<String>();
            ShiftedId shiftedId = null;
            int depth = 0;
            String currentFlow = "normal";
            try {
                int event = reader.getEventType();
                try {
                    while (true) {
                        switch (event) {
                            case 1: {
                                XMLStreamWriterHelper.writeEvent((XMLStreamWriter)writer, (XMLStreamReader)reader);
                                boolean isInlineBox = false;
                                boolean isBlockBox = false;
                                if (insideInlineBox) {
                                    XMLStreamWriterHelper.writeAttributes((XMLStreamWriter)writer, (XMLStreamReader)reader);
                                } else {
                                    boolean isBox = CSS_BOX.equals(reader.getName());
                                    String id = null;
                                    String flow = depth == 0 ? "normal" : currentFlow;
                                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                                        QName name = reader.getAttributeName(i);
                                        String value = reader.getAttributeValue(i);
                                        if (CSS_ID.equals(name)) {
                                            id = value;
                                            continue;
                                        }
                                        if (isBox && _TYPE.equals(name)) {
                                            if ("inline".equalsIgnoreCase(value)) {
                                                isInlineBox = true;
                                            } else if ("block".equalsIgnoreCase(value)) {
                                                isBlockBox = true;
                                            }
                                        }
                                        if (depth == 0 && CSS_FLOW.equals(name)) {
                                            flow = value;
                                        }
                                        XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)name, (String)value);
                                    }
                                    boolean newFlow = !flow.equals(currentFlow);
                                    currentFlow = flow;
                                    if (newFlow || isBlockBox) {
                                        if (!pendingId.isEmpty()) {
                                            if (shiftedId == null) {
                                                if (newFlow) {
                                                    this.discardedIds.addAll(pendingId);
                                                    pendingId.clear();
                                                }
                                            } else {
                                                shiftedId.putAll(pendingId);
                                                pendingId.clear();
                                            }
                                        }
                                        if (shiftedId != null) {
                                            shiftedId.render();
                                            shiftedId = null;
                                        }
                                    }
                                    if (isInlineBox && shiftedId != null) {
                                        shiftedId.render();
                                        shiftedId = null;
                                    }
                                    if (isInlineBox) {
                                        if (id != null) {
                                            if (!pendingId.isEmpty()) {
                                                pendingId.add(id);
                                            } else {
                                                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)CSS_ID, (String)id);
                                            }
                                        }
                                        if (!pendingId.isEmpty()) {
                                            id = (String)pendingId.get(pendingId.size() - 1);
                                            for (String oldId : pendingId) {
                                                if (oldId.equals(id)) continue;
                                                this.idMap.put(oldId, id);
                                            }
                                            pendingId.clear();
                                            if (id != null) {
                                                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)CSS_ID, (String)id);
                                            }
                                        }
                                    } else if (id != null) {
                                        pendingId.add(id);
                                    }
                                    if (isInlineBox) {
                                        insideInlineBox = true;
                                    }
                                }
                                blockBoxes.push(isBlockBox);
                                inlineBoxes.push(isInlineBox);
                                ++depth;
                                break;
                            }
                            case 2: {
                                --depth;
                                boolean isBlockBox = (Boolean)blockBoxes.pop();
                                boolean isInlineBox = (Boolean)inlineBoxes.pop();
                                if (isBlockBox) {
                                    if (!pendingId.isEmpty()) {
                                        if (shiftedId == null) {
                                            this.discardedIds.addAll(pendingId);
                                        } else {
                                            shiftedId.putAll(pendingId);
                                        }
                                        pendingId.clear();
                                    }
                                } else if (isInlineBox) {
                                    if (shiftedId != null) {
                                        throw new RuntimeException("coding error");
                                    }
                                    shiftedId = new ShiftedId();
                                    writer.writeEvent((XMLStreamWriterHelper.FutureWriterEvent)shiftedId);
                                    insideInlineBox = false;
                                }
                                XMLStreamWriterHelper.writeEvent((XMLStreamWriter)writer, (XMLStreamReader)reader);
                                break;
                            }
                            default: {
                                XMLStreamWriterHelper.writeEvent((XMLStreamWriter)writer, (XMLStreamReader)reader);
                            }
                        }
                        event = reader.next();
                    }
                }
                catch (NoSuchElementException e) {
                    if (!pendingId.isEmpty()) {
                        if (shiftedId == null) {
                            throw new RuntimeException("invalid input");
                        }
                        shiftedId.putAll(pendingId);
                    }
                    if (shiftedId != null) {
                        shiftedId.render();
                    }
                    writer.flush();
                }
            }
            catch (XMLStreamException e) {
                throw new TransformerException((Throwable)e);
            }
        }

        private class ShiftedId
        implements XMLStreamWriterHelper.FutureWriterEvent {
            private List<String> ids;
            private boolean ready = false;

            private ShiftedId() {
            }

            private void put(String id) {
                if (this.ids == null) {
                    this.ids = new ArrayList<String>();
                }
                this.ids.add(id);
            }

            private void putAll(List<String> ids) {
                for (String id : ids) {
                    this.put(id);
                }
            }

            private void render() {
                this.ready = true;
            }

            public void writeTo(XMLStreamWriter writer) throws XMLStreamException {
                if (!this.ready) {
                    throw new XMLStreamException("not ready");
                }
                if (this.ids != null) {
                    String id = this.ids.get(0);
                    for (String oldId : this.ids) {
                        if (oldId.equals(id)) continue;
                        ShiftIdTransformer.this.idMap.put(oldId, id);
                    }
                    XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)writer, (QName)CSS__);
                    XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)CSS_ID, (String)id);
                    writer.writeEndElement();
                }
            }

            public boolean isReady() {
                return this.ready;
            }
        }
    }

    @Component(name="css:shift-id", service={XProcStepProvider.class}, property={"type:String={http://www.daisy.org/ns/pipeline/braille-css}shift-id"})
    public static class Provider
    implements XProcStepProvider {
        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step) {
            return new CssShiftIdStep(runtime, step);
        }
    }
}

