/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.daisy.pipeline.client.Pipeline2Exception;
import org.daisy.pipeline.client.Pipeline2Logger;
import org.daisy.pipeline.client.models.Argument;
import org.daisy.pipeline.client.utils.XML;
import org.daisy.pipeline.client.utils.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Script
implements Comparable<Script> {
    private String id;
    private String href;
    private List<String> inputFilesets = new ArrayList<String>();
    private List<String> outputFilesets = new ArrayList<String>();
    private String nicename;
    private String description;
    private String version;
    private String homepage;
    private List<Argument> inputs = new ArrayList<Argument>();
    private List<Argument> outputs = new ArrayList<Argument>();
    private Node scriptNode = null;
    private boolean lazyLoaded = false;

    public Script(Node scriptXml) throws Pipeline2Exception {
        this.scriptNode = scriptXml;
    }

    public Script(String href) throws Pipeline2Exception {
        this(XML.getXml("<script xmlns=\"http://www.daisy.org/ns/pipeline/data\"/>"));
        this.setHref(href);
    }

    private void lazyLoad() {
        if (this.lazyLoaded || this.scriptNode == null) {
            return;
        }
        try {
            Argument argument;
            if (this.scriptNode instanceof Document) {
                this.scriptNode = XPath.selectNode("/d:script", this.scriptNode, XPath.dp2ns);
            }
            this.id = XPath.selectText("@id", this.scriptNode, XPath.dp2ns);
            this.href = XPath.selectText("@href", this.scriptNode, XPath.dp2ns);
            String inputFilesetsString = XPath.selectText("@input-filesets", this.scriptNode, XPath.dp2ns);
            String outputFilesetsString = XPath.selectText("@output-filesets", this.scriptNode, XPath.dp2ns);
            if (inputFilesetsString != null && !"".equals(inputFilesetsString)) {
                for (String fileset : inputFilesetsString.split("\\s+")) {
                    if ("".equals(fileset)) continue;
                    this.inputFilesets.add(fileset);
                }
            }
            if (outputFilesetsString != null && !"".equals(outputFilesetsString)) {
                for (String fileset : outputFilesetsString.split("\\s+")) {
                    if ("".equals(fileset)) continue;
                    this.outputFilesets.add(fileset);
                }
            }
            if ((inputFilesetsString == null || "".equals(inputFilesetsString)) && (outputFilesetsString == null || "".equals(outputFilesetsString)) && this.id != null) {
                String[] split;
                if (this.id.matches("^[a-zA-Z0-9]+-to-[a-zA-Z0-9]+$")) {
                    split = this.id.split("-");
                    this.inputFilesets.add(split[0]);
                    this.outputFilesets.add(split[2]);
                } else if (this.id.matches("^[a-zA-Z0-9]+-validator$")) {
                    split = this.id.split("-");
                    this.inputFilesets.add(split[0]);
                }
            }
            this.nicename = XPath.selectText("d:nicename", this.scriptNode, XPath.dp2ns);
            this.description = XPath.selectText("d:description", this.scriptNode, XPath.dp2ns);
            this.version = XPath.selectText("d:version", this.scriptNode, XPath.dp2ns);
            this.homepage = XPath.selectText("d:homepage", this.scriptNode, XPath.dp2ns);
            List<Node> inputNodes = XPath.selectNodes("d:input | d:option", this.scriptNode, XPath.dp2ns);
            List<Node> outputNodes = XPath.selectNodes("d:output", this.scriptNode, XPath.dp2ns);
            for (Node inputNode : inputNodes) {
                argument = new Argument(inputNode);
                this.inputs.add(argument);
            }
            for (Node outputNode : outputNodes) {
                argument = new Argument(outputNode);
                this.outputs.add(argument);
            }
        }
        catch (Pipeline2Exception e) {
            Pipeline2Logger.logger().error("Unable to parse script XML", e);
        }
        this.lazyLoaded = true;
    }

    public Argument getArgument(String name) {
        this.lazyLoad();
        for (Argument arg : this.inputs) {
            if (!arg.getName().equals(name)) continue;
            return arg;
        }
        for (Argument arg : this.outputs) {
            if (!arg.getName().equals(name)) continue;
            return arg;
        }
        return null;
    }

    public static List<Script> parseScriptsXml(Node scriptsXml) throws Pipeline2Exception {
        ArrayList<Script> scripts = new ArrayList<Script>();
        if (scriptsXml instanceof Document) {
            scriptsXml = XPath.selectNode("/d:scripts", scriptsXml, XPath.dp2ns);
        }
        List<Node> scriptNodes = XPath.selectNodes("d:script", scriptsXml, XPath.dp2ns);
        for (Node scriptNode : scriptNodes) {
            scripts.add(new Script(scriptNode));
        }
        Collections.sort(scripts);
        return scripts;
    }

    @Override
    public int compareTo(Script other) {
        if (this.getId() == null) {
            return 1;
        }
        if (other.getId() == null) {
            return -1;
        }
        return this.getId().compareTo(other.getId());
    }

    public String getId() {
        this.lazyLoad();
        return this.id;
    }

    public String getHref() {
        this.lazyLoad();
        return this.href;
    }

    public List<String> getInputFilesets() {
        this.lazyLoad();
        return this.inputFilesets;
    }

    public List<String> getOutputFilesets() {
        this.lazyLoad();
        return this.outputFilesets;
    }

    public String getNicename() {
        this.lazyLoad();
        return this.nicename;
    }

    public String getDescription() {
        this.lazyLoad();
        return this.description;
    }

    public String getVersion() {
        this.lazyLoad();
        return this.version;
    }

    public String getHomepage() {
        this.lazyLoad();
        return this.homepage;
    }

    public List<Argument> getInputs() {
        this.lazyLoad();
        return this.inputs;
    }

    public List<Argument> getOutputs() {
        this.lazyLoad();
        return this.outputs;
    }

    public void setId(String id) {
        this.lazyLoad();
        this.id = id;
    }

    public void setHref(String href) {
        this.lazyLoad();
        this.href = href;
    }

    public void setInputFilesets(List<String> inputFilesets) {
        this.lazyLoad();
        this.inputFilesets = inputFilesets;
    }

    public void setOutputFilesets(List<String> outputFilesets) {
        this.lazyLoad();
        this.outputFilesets = outputFilesets;
    }

    public void setNicename(String nicename) {
        this.lazyLoad();
        this.nicename = nicename;
    }

    public void setDescription(String description) {
        this.lazyLoad();
        this.description = description;
    }

    public void setVersion(String version) {
        this.lazyLoad();
        this.version = version;
    }

    public void setHomepage(String homepage) {
        this.lazyLoad();
        this.homepage = homepage;
    }

    public void setInputs(List<Argument> inputs) {
        this.lazyLoad();
        this.inputs = inputs;
    }

    public void setOutputs(List<Argument> outputs) {
        this.lazyLoad();
        this.outputs = outputs;
    }

    public Document toXml() {
        Element e;
        int i;
        this.lazyLoad();
        Document scriptDocument = XML.getXml("<script xmlns=\"http://www.daisy.org/ns/pipeline/data\"/>");
        Element scriptElement = scriptDocument.getDocumentElement();
        if (this.id != null) {
            scriptElement.setAttribute("id", this.id);
        }
        if (this.href != null) {
            scriptElement.setAttribute("href", this.href);
        }
        if (this.inputFilesets != null) {
            String inputFilesetsJoined = "";
            for (i = 0; i < this.inputFilesets.size(); ++i) {
                if (i > 0) {
                    inputFilesetsJoined = inputFilesetsJoined + " ";
                }
                inputFilesetsJoined = inputFilesetsJoined + this.inputFilesets.get(i);
            }
            scriptElement.setAttribute("input-filesets", inputFilesetsJoined);
        }
        if (this.outputFilesets != null) {
            String outputFilesetsJoined = "";
            for (i = 0; i < this.outputFilesets.size(); ++i) {
                if (i > 0) {
                    outputFilesetsJoined = outputFilesetsJoined + " ";
                }
                outputFilesetsJoined = outputFilesetsJoined + this.outputFilesets.get(i);
            }
            scriptElement.setAttribute("output-filesets", outputFilesetsJoined);
        }
        if (this.nicename != null) {
            e = scriptDocument.createElementNS(XPath.dp2ns.get("d"), "nicename");
            e.setTextContent(this.nicename);
            scriptElement.appendChild(e);
        }
        if (this.description != null) {
            e = scriptDocument.createElementNS(XPath.dp2ns.get("d"), "description");
            e.setTextContent(this.description);
            scriptElement.appendChild(e);
        }
        if (this.version != null) {
            e = scriptDocument.createElementNS(XPath.dp2ns.get("d"), "version");
            e.setTextContent(this.version);
            scriptElement.appendChild(e);
        }
        if (this.homepage != null) {
            e = scriptDocument.createElementNS(XPath.dp2ns.get("d"), "homepage");
            e.setTextContent(this.homepage);
            scriptElement.appendChild(e);
        }
        if (this.inputs != null) {
            for (Argument arg : this.inputs) {
                XML.appendChildAcrossDocuments(scriptElement, arg.toXml().getDocumentElement());
            }
        }
        if (this.outputs != null) {
            for (Argument arg : this.outputs) {
                XML.appendChildAcrossDocuments(scriptElement, arg.toXml().getDocumentElement());
            }
        }
        return scriptDocument;
    }

    public List<Argument> getArguments() {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.addAll(this.getInputs());
        arguments.addAll(this.getOutputs());
        return arguments;
    }
}

