/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models;

import java.util.HashMap;
import java.util.Map;
import org.daisy.pipeline.client.Pipeline2Exception;
import org.daisy.pipeline.client.Pipeline2Logger;
import org.daisy.pipeline.client.models.datatypes.EnumType;
import org.daisy.pipeline.client.models.datatypes.RegexType;
import org.daisy.pipeline.client.utils.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DataType
implements Comparable<DataType> {
    public Node dataTypeXml;
    public String id;

    public DataType(Node dataTypeXml) {
        try {
            if (dataTypeXml instanceof Document) {
                dataTypeXml = XPath.selectNode("/*", dataTypeXml, XPath.dp2ns);
            }
            this.dataTypeXml = dataTypeXml;
            this.id = XPath.selectText("@id", dataTypeXml, XPath.dp2ns);
        }
        catch (Pipeline2Exception e) {
            Pipeline2Logger.logger().error("Unable to parse datatype XML", e);
        }
    }

    public static Map<String, String> getDataTypes(Node dataTypesXml) {
        HashMap<String, String> dataTypes = new HashMap<String, String>();
        try {
            if (dataTypesXml instanceof Document) {
                dataTypesXml = XPath.selectNode("/*", dataTypesXml, XPath.dp2ns);
            }
            for (Node dataTypeNode : XPath.selectNodes("d:datatype", dataTypesXml, XPath.dp2ns)) {
                String id = XPath.selectText("@id", dataTypeNode, XPath.dp2ns);
                String href = XPath.selectText("@href", dataTypeNode, XPath.dp2ns);
                dataTypes.put(id, href);
            }
        }
        catch (Pipeline2Exception e) {
            Pipeline2Logger.logger().error("Unable to parse datatype XML", e);
        }
        return dataTypes;
    }

    public static DataType getDataType(Node dataTypeXml) {
        try {
            if (dataTypeXml instanceof Document) {
                dataTypeXml = XPath.selectNode("/*", dataTypeXml, XPath.dp2ns);
            }
            if ("choice".equals(dataTypeXml.getLocalName())) {
                return new EnumType(dataTypeXml);
            }
            if ("data".equals(dataTypeXml.getLocalName()) && "pattern".equals(XPath.selectText("*[local-name()='param']/@name", dataTypeXml, XPath.dp2ns))) {
                return new RegexType(dataTypeXml);
            }
            return new DataType(dataTypeXml);
        }
        catch (Pipeline2Exception e) {
            Pipeline2Logger.logger().error("Unable to parse datatype XML", e);
            return null;
        }
    }

    @Override
    public int compareTo(DataType other) {
        if (this.id == null) {
            return 1;
        }
        if (other.id == null) {
            return -1;
        }
        return this.id.compareTo(other.id);
    }
}

