/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.model;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.constretto.model.CValue;

public class CPrimitive
extends CValue {
    private final Pattern variablePattern = Pattern.compile("#\\{(.*?)}");
    private String value;

    public CPrimitive(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    @Override
    public Set<String> referencedKeys() {
        HashSet<String> referencedKeys = new HashSet<String>();
        Matcher matcher = this.variablePattern.matcher(this.value);
        while (matcher.find()) {
            String group = matcher.group(1);
            referencedKeys.add(group);
        }
        return referencedKeys;
    }

    @Override
    public void replace(String key, String resolvedValue) {
        this.value = this.value.replaceAll("#\\{" + key + "\\}", Matcher.quoteReplacement(resolvedValue));
    }

    public String toString() {
        return this.value;
    }
}

