/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.testing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.net.ssl.SSLSocket;

public final class TestClient {
    private final SSLSocket socket;
    private InputStream input;
    private OutputStream output;

    public TestClient(SSLSocket socket) {
        this.socket = socket;
    }

    public void start() {
        try {
            this.socket.startHandshake();
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int readMessage(byte[] buffer) {
        try {
            int remaining;
            int totalBytesRead;
            int bytesRead;
            for (totalBytesRead = 0; totalBytesRead < buffer.length && (bytesRead = this.input.read(buffer, totalBytesRead, remaining = buffer.length - totalBytesRead)) != -1; totalBytesRead += bytesRead) {
            }
            return totalBytesRead;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void sendMessage(byte[] data) {
        try {
            this.output.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
        try {
            this.output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

