/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Streams {
    private Streams() {
    }

    public static byte[] readFully(InputStream in) throws IOException {
        try {
            byte[] byArray = Streams.readFullyNoClose(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    private static byte[] readFullyNoClose(InputStream in) throws IOException {
        int count;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((count = in.read(buffer)) != -1) {
            bytes.write(buffer, 0, count);
        }
        return bytes.toByteArray();
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int c;
        int total = 0;
        byte[] buffer = new byte[8192];
        while ((c = in.read(buffer)) != -1) {
            total += c;
            out.write(buffer, 0, c);
        }
        return total;
    }
}

