/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.FileDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.spec.GCMParameterSpec;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.conscrypt.AbstractConscryptSocket;
import org.conscrypt.AbstractOpenSSLSession;
import org.conscrypt.AddressUtils;
import org.conscrypt.ConscryptEngine;
import org.conscrypt.GCMParameters;
import org.conscrypt.OpenSSLExtendedSessionImpl;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLSocketFactoryImpl;
import org.conscrypt.SSLParametersImpl;
import sun.security.x509.AlgorithmId;

final class Platform {
    private static Method m_getCurveName;

    private Platform() {
    }

    static void setup() {
    }

    static FileDescriptor getFileDescriptor(Socket s) {
        try {
            SocketChannel channel = s.getChannel();
            if (channel != null) {
                Field f_fd = channel.getClass().getDeclaredField("fd");
                f_fd.setAccessible(true);
                return (FileDescriptor)f_fd.get(channel);
            }
        }
        catch (Exception channel) {
            // empty catch block
        }
        try {
            Field f_impl = Socket.class.getDeclaredField("impl");
            f_impl.setAccessible(true);
            Object socketImpl = f_impl.get(s);
            Field f_fd = SocketImpl.class.getDeclaredField("fd");
            f_fd.setAccessible(true);
            return (FileDescriptor)f_fd.get(socketImpl);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get FileDescriptor from socket", e);
        }
    }

    static FileDescriptor getFileDescriptorFromSSLSocket(AbstractConscryptSocket socket) {
        return Platform.getFileDescriptor(socket);
    }

    static String getCurveName(ECParameterSpec spec) {
        if (m_getCurveName == null) {
            return null;
        }
        try {
            return (String)m_getCurveName.invoke((Object)spec, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    static void setCurveName(ECParameterSpec spec, String curveName) {
    }

    static void setSocketWriteTimeout(Socket s, long timeoutMillis) throws SocketException {
    }

    public static void setSSLParameters(SSLParameters params, SSLParametersImpl impl, AbstractConscryptSocket socket) {
        block5: {
            impl.setEndpointIdentificationAlgorithm(params.getEndpointIdentificationAlgorithm());
            try {
                Method getUseCipherSuitesOrder = SSLParameters.class.getMethod("getUseCipherSuitesOrder", new Class[0]);
                impl.setUseCipherSuitesOrder((Boolean)getUseCipherSuitesOrder.invoke((Object)params, new Object[0]));
                Method getServerNames = SSLParameters.class.getMethod("getServerNames", new Class[0]);
                List serverNames = (List)getServerNames.invoke((Object)params, new Object[0]);
                int hostNameType = 0;
                if (serverNames == null) break block5;
                for (Object serverName : serverNames) {
                    if ((Integer)serverName.getClass().getMethod("getType", new Class[0]).invoke(serverName, new Object[0]) != hostNameType) continue;
                    socket.setHostname((String)serverName.getClass().getMethod("getAsciiName", new Class[0]).invoke(serverName, new Object[0]));
                    break;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static void getSSLParameters(SSLParameters params, SSLParametersImpl impl, AbstractConscryptSocket socket) {
        params.setEndpointIdentificationAlgorithm(impl.getEndpointIdentificationAlgorithm());
        try {
            Method setUseCipherSuitesOrder = SSLParameters.class.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
            setUseCipherSuitesOrder.invoke((Object)params, impl.getUseCipherSuitesOrder());
            Method setServerNames = SSLParameters.class.getMethod("setServerNames", List.class);
            if (impl.getUseSni() && AddressUtils.isValidSniHostname(socket.getHostname())) {
                Constructor<?> sniHostNameConstructor = Class.forName("javax.net.ssl.SNIHostName").getConstructor(String.class);
                setServerNames.invoke((Object)params, Collections.singletonList(sniHostNameConstructor.newInstance(socket.getHostname())));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    public static void setSSLParameters(SSLParameters params, SSLParametersImpl impl, ConscryptEngine engine) {
        block5: {
            impl.setEndpointIdentificationAlgorithm(params.getEndpointIdentificationAlgorithm());
            try {
                Method getUseCipherSuitesOrder = SSLParameters.class.getMethod("getUseCipherSuitesOrder", new Class[0]);
                impl.setUseCipherSuitesOrder((Boolean)getUseCipherSuitesOrder.invoke((Object)params, new Object[0]));
                Method getServerNames = SSLParameters.class.getMethod("getServerNames", new Class[0]);
                List serverNames = (List)getServerNames.invoke((Object)params, new Object[0]);
                int hostNameType = 0;
                if (serverNames == null) break block5;
                for (Object serverName : serverNames) {
                    if ((Integer)serverName.getClass().getMethod("getType", new Class[0]).invoke(serverName, new Object[0]) != hostNameType) continue;
                    engine.setHostname((String)serverName.getClass().getMethod("getAsciiName", new Class[0]).invoke(serverName, new Object[0]));
                    break;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static void getSSLParameters(SSLParameters params, SSLParametersImpl impl, ConscryptEngine engine) {
        params.setEndpointIdentificationAlgorithm(impl.getEndpointIdentificationAlgorithm());
        try {
            Method setUseCipherSuitesOrder = SSLParameters.class.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
            setUseCipherSuitesOrder.invoke((Object)params, impl.getUseCipherSuitesOrder());
            Method setServerNames = SSLParameters.class.getMethod("setServerNames", List.class);
            if (impl.getUseSni() && AddressUtils.isValidSniHostname(engine.getHostname())) {
                Constructor<?> sniHostNameConstructor = Class.forName("javax.net.ssl.SNIHostName").getConstructor(String.class);
                setServerNames.invoke((Object)params, Collections.singletonList(sniHostNameConstructor.newInstance(engine.getHostname())));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    static void setEndpointIdentificationAlgorithm(SSLParameters params, String endpointIdentificationAlgorithm) {
        params.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
    }

    static String getEndpointIdentificationAlgorithm(SSLParameters params) {
        return params.getEndpointIdentificationAlgorithm();
    }

    static void checkClientTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, AbstractConscryptSocket socket) throws CertificateException {
        if (tm instanceof X509ExtendedTrustManager) {
            X509ExtendedTrustManager x509etm = (X509ExtendedTrustManager)tm;
            x509etm.checkClientTrusted(chain, authType, socket);
        } else {
            tm.checkClientTrusted(chain, authType);
        }
    }

    static void checkServerTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, AbstractConscryptSocket socket) throws CertificateException {
        if (tm instanceof X509ExtendedTrustManager) {
            X509ExtendedTrustManager x509etm = (X509ExtendedTrustManager)tm;
            x509etm.checkServerTrusted(chain, authType, socket);
        } else {
            tm.checkServerTrusted(chain, authType);
        }
    }

    static void checkClientTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, ConscryptEngine engine) throws CertificateException {
        if (tm instanceof X509ExtendedTrustManager) {
            X509ExtendedTrustManager x509etm = (X509ExtendedTrustManager)tm;
            x509etm.checkClientTrusted(chain, authType, engine);
        } else {
            tm.checkClientTrusted(chain, authType);
        }
    }

    static void checkServerTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, ConscryptEngine engine) throws CertificateException {
        if (tm instanceof X509ExtendedTrustManager) {
            X509ExtendedTrustManager x509etm = (X509ExtendedTrustManager)tm;
            x509etm.checkServerTrusted(chain, authType, engine);
        } else {
            tm.checkServerTrusted(chain, authType);
        }
    }

    static OpenSSLKey wrapRsaKey(PrivateKey javaKey) {
        return null;
    }

    static void logEvent(String message) {
    }

    static boolean isLiteralIpAddress(String hostname) {
        return AddressUtils.isLiteralIpAddress(hostname);
    }

    static boolean isSniEnabledByDefault() {
        return true;
    }

    static SSLSocketFactory wrapSocketFactoryIfNeeded(OpenSSLSocketFactoryImpl factory) {
        return factory;
    }

    static GCMParameters fromGCMParameterSpec(AlgorithmParameterSpec params) {
        if (params instanceof GCMParameterSpec) {
            GCMParameterSpec gcmParams = (GCMParameterSpec)params;
            return new GCMParameters(gcmParams.getTLen(), gcmParams.getIV());
        }
        return null;
    }

    static AlgorithmParameterSpec toGCMParameterSpec(int tagLenInBits, byte[] iv) {
        return new GCMParameterSpec(tagLenInBits, iv);
    }

    static Object closeGuardGet() {
        return null;
    }

    static void closeGuardOpen(Object guardObj, String message) {
    }

    static void closeGuardClose(Object guardObj) {
    }

    static void closeGuardWarnIfOpen(Object guardObj) {
    }

    static void blockGuardOnNetwork() {
    }

    static String oidToAlgorithmName(String oid) {
        try {
            return AlgorithmId.get(oid).getName();
        }
        catch (NoSuchAlgorithmException e) {
            return oid;
        }
    }

    static SSLSession wrapSSLSession(AbstractOpenSSLSession sslSession) {
        return new OpenSSLExtendedSessionImpl(sslSession);
    }

    static SSLSession unwrapSSLSession(SSLSession sslSession) {
        if (sslSession instanceof OpenSSLExtendedSessionImpl) {
            return ((OpenSSLExtendedSessionImpl)sslSession).getDelegate();
        }
        return sslSession;
    }

    static String getHostStringFromInetSocketAddress(InetSocketAddress addr) {
        return addr.getHostString();
    }

    static boolean isCTVerificationRequired(String hostname) {
        if (hostname == null) {
            return false;
        }
        String property = Security.getProperty("conscrypt.ct.enable");
        if (property == null || !Boolean.valueOf(property.toLowerCase()).booleanValue()) {
            return false;
        }
        List<String> parts = Arrays.asList(hostname.split("\\."));
        Collections.reverse(parts);
        boolean enable = false;
        StringBuilder propertyName = new StringBuilder("conscrypt.ct.enforce");
        for (String part : parts) {
            property = Security.getProperty(propertyName + ".*");
            if (property != null) {
                enable = Boolean.valueOf(property.toLowerCase());
            }
            propertyName.append(".").append(part);
        }
        property = Security.getProperty(propertyName.toString());
        if (property != null) {
            enable = Boolean.valueOf(property.toLowerCase());
        }
        return enable;
    }

    static {
        try {
            m_getCurveName = ECParameterSpec.class.getDeclaredMethod("getCurveName", new Class[0]);
            m_getCurveName.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

