/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import org.conscrypt.AbstractOpenSSLSession;
import org.conscrypt.AbstractSessionContext;
import org.conscrypt.NativeCrypto;

class OpenSSLSessionImpl
extends AbstractOpenSSLSession {
    private long creationTime = 0L;
    long lastAccessedTime = 0L;
    final X509Certificate[] localCertificates;
    final X509Certificate[] peerCertificates;
    private final Map<String, Object> values = new HashMap<String, Object>();
    private byte[] peerCertificateOcspData;
    private byte[] peerTlsSctData;
    long sslSessionNativePointer;
    private String peerHost;
    private int peerPort = -1;
    private String cipherSuite;
    private String protocol;
    private byte[] id;

    OpenSSLSessionImpl(long sslSessionNativePointer, X509Certificate[] localCertificates, X509Certificate[] peerCertificates, byte[] peerCertificateOcspData, byte[] peerTlsSctData, String peerHost, int peerPort, AbstractSessionContext sessionContext) {
        super(sessionContext);
        this.sslSessionNativePointer = sslSessionNativePointer;
        this.localCertificates = localCertificates;
        this.peerCertificates = peerCertificates;
        this.peerCertificateOcspData = peerCertificateOcspData;
        this.peerTlsSctData = peerTlsSctData;
        this.peerHost = peerHost;
        this.peerPort = peerPort;
    }

    OpenSSLSessionImpl(byte[] derData, String peerHost, int peerPort, X509Certificate[] peerCertificates, byte[] peerCertificateOcspData, byte[] peerTlsSctData, AbstractSessionContext sessionContext) throws IOException {
        this(NativeCrypto.d2i_SSL_SESSION(derData), null, peerCertificates, peerCertificateOcspData, peerTlsSctData, peerHost, peerPort, sessionContext);
    }

    @Override
    public byte[] getId() {
        if (this.id == null) {
            this.resetId();
        }
        return this.id;
    }

    @Override
    void resetId() {
        this.id = NativeCrypto.SSL_SESSION_session_id(this.sslSessionNativePointer);
    }

    public byte[] getEncoded() {
        return NativeCrypto.i2d_SSL_SESSION(this.sslSessionNativePointer);
    }

    @Override
    public long getCreationTime() {
        if (this.creationTime == 0L) {
            this.creationTime = NativeCrypto.SSL_SESSION_get_time(this.sslSessionNativePointer);
        }
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime == 0L ? this.getCreationTime() : this.lastAccessedTime;
    }

    @Override
    public void setLastAccessedTime(long accessTimeMillis) {
        this.lastAccessedTime = accessTimeMillis;
    }

    @Override
    protected X509Certificate[] getX509LocalCertificates() {
        return this.localCertificates;
    }

    @Override
    protected X509Certificate[] getX509PeerCertificates() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null || this.peerCertificates.length == 0) {
            throw new SSLPeerUnverifiedException("No peer certificates");
        }
        return this.peerCertificates;
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public String getCipherSuite() {
        if (this.cipherSuite == null) {
            String name = NativeCrypto.SSL_SESSION_cipher(this.sslSessionNativePointer);
            this.cipherSuite = NativeCrypto.OPENSSL_TO_STANDARD_CIPHER_SUITES.get(name);
            if (this.cipherSuite == null) {
                this.cipherSuite = name;
            }
        }
        return this.cipherSuite;
    }

    @Override
    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = NativeCrypto.SSL_SESSION_get_version(this.sslSessionNativePointer);
        }
        return this.protocol;
    }

    @Override
    public Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        return this.values.get(name);
    }

    @Override
    public String[] getValueNames() {
        return this.values.keySet().toArray(new String[this.values.size()]);
    }

    @Override
    public void putValue(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name == null || value == null");
        }
        Object old = this.values.put(name, value);
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
        if (old instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)old).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    @Override
    public void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        Object old = this.values.remove(name);
        if (old instanceof SSLSessionBindingListener) {
            SSLSessionBindingListener listener = (SSLSessionBindingListener)old;
            listener.valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    @Override
    public String getRequestedServerName() {
        return NativeCrypto.get_SSL_SESSION_tlsext_hostname(this.sslSessionNativePointer);
    }

    @Override
    public List<byte[]> getStatusResponses() {
        if (this.peerCertificateOcspData == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList((byte[])this.peerCertificateOcspData.clone());
    }

    @Override
    public byte[] getTlsSctData() {
        if (this.peerTlsSctData == null) {
            return null;
        }
        return (byte[])this.peerTlsSctData.clone();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.sslSessionNativePointer != 0L) {
                NativeCrypto.SSL_SESSION_free(this.sslSessionNativePointer);
            }
        }
        finally {
            super.finalize();
        }
    }
}

