/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Build;
import android.util.Log;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.conscrypt.AbstractOpenSSLSession;
import org.conscrypt.AddressUtils;
import org.conscrypt.GCMParameters;
import org.conscrypt.KitKatPlatformOpenSSLSocketAdapterFactory;
import org.conscrypt.OpenSSLEngineImpl;
import org.conscrypt.OpenSSLExtendedSessionImpl;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLSocketFactoryImpl;
import org.conscrypt.OpenSSLSocketImpl;
import org.conscrypt.PreKitKatPlatformOpenSSLSocketAdapterFactory;
import org.conscrypt.SSLParametersImpl;

final class Platform {
    private static final String TAG = "Conscrypt";
    private static Method m_getCurveName;

    private Platform() {
    }

    public static void setup() {
    }

    public static FileDescriptor getFileDescriptor(Socket s) {
        try {
            Field f_impl = Socket.class.getDeclaredField("impl");
            f_impl.setAccessible(true);
            Object socketImpl = f_impl.get(s);
            Field f_fd = SocketImpl.class.getDeclaredField("fd");
            f_fd.setAccessible(true);
            return (FileDescriptor)f_fd.get(socketImpl);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get FileDescriptor from socket", e);
        }
    }

    public static FileDescriptor getFileDescriptorFromSSLSocket(OpenSSLSocketImpl openSSLSocketImpl) {
        return Platform.getFileDescriptor(openSSLSocketImpl);
    }

    public static String getCurveName(ECParameterSpec spec) {
        if (m_getCurveName == null) {
            return null;
        }
        try {
            return (String)m_getCurveName.invoke((Object)spec, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setCurveName(ECParameterSpec spec, String curveName) {
        try {
            Method setCurveName = spec.getClass().getDeclaredMethod("setCurveName", String.class);
            setCurveName.invoke((Object)spec, curveName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setSocketWriteTimeout(Socket s, long timeoutMillis) throws SocketException {
        try {
            Class<?> c_structTimeval = Platform.getClass("android.system.StructTimeval", "libcore.io.StructTimeval");
            if (c_structTimeval == null) {
                Log.w((String)TAG, (String)"StructTimeval == null; not setting socket write timeout");
                return;
            }
            Method m_fromMillis = c_structTimeval.getDeclaredMethod("fromMillis", Long.TYPE);
            if (m_fromMillis == null) {
                Log.w((String)TAG, (String)"fromMillis == null; not setting socket write timeout");
                return;
            }
            Object timeval = m_fromMillis.invoke(null, timeoutMillis);
            Class<?> c_Libcore = Class.forName("libcore.io.Libcore");
            if (c_Libcore == null) {
                Log.w((String)TAG, (String)"Libcore == null; not setting socket write timeout");
                return;
            }
            Field f_os = c_Libcore.getField("os");
            if (f_os == null) {
                Log.w((String)TAG, (String)"os == null; not setting socket write timeout");
                return;
            }
            Object instance_os = f_os.get(null);
            if (instance_os == null) {
                Log.w((String)TAG, (String)"instance_os == null; not setting socket write timeout");
                return;
            }
            Class<?> c_osConstants = Platform.getClass("android.system.OsConstants", "libcore.io.OsConstants");
            if (c_osConstants == null) {
                Log.w((String)TAG, (String)"OsConstants == null; not setting socket write timeout");
                return;
            }
            Field f_SOL_SOCKET = c_osConstants.getField("SOL_SOCKET");
            if (f_SOL_SOCKET == null) {
                Log.w((String)TAG, (String)"SOL_SOCKET == null; not setting socket write timeout");
                return;
            }
            Field f_SO_SNDTIMEO = c_osConstants.getField("SO_SNDTIMEO");
            if (f_SO_SNDTIMEO == null) {
                Log.w((String)TAG, (String)"SO_SNDTIMEO == null; not setting socket write timeout");
                return;
            }
            Method m_setsockoptTimeval = instance_os.getClass().getMethod("setsockoptTimeval", FileDescriptor.class, Integer.TYPE, Integer.TYPE, c_structTimeval);
            if (m_setsockoptTimeval == null) {
                Log.w((String)TAG, (String)"setsockoptTimeval == null; not setting socket write timeout");
                return;
            }
            m_setsockoptTimeval.invoke(instance_os, Platform.getFileDescriptor(s), f_SOL_SOCKET.get(null), f_SO_SNDTIMEO.get(null), timeval);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Could not set socket write timeout:");
            StackTraceElement[] elements = e.getStackTrace();
            for (int i = 0; i < 2 && i < elements.length; ++i) {
                Log.w((String)TAG, (String)("   " + elements[i].toString()));
            }
        }
    }

    private static void setSSLParametersOnImpl(SSLParameters params, SSLParametersImpl impl) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m_getEndpointIdentificationAlgorithm = params.getClass().getMethod("getEndpointIdentificationAlgorithm", new Class[0]);
        impl.setEndpointIdentificationAlgorithm((String)m_getEndpointIdentificationAlgorithm.invoke((Object)params, new Object[0]));
        Method m_getUseCipherSuitesOrder = params.getClass().getMethod("getUseCipherSuitesOrder", new Class[0]);
        impl.setUseCipherSuitesOrder((Boolean)m_getUseCipherSuitesOrder.invoke((Object)params, new Object[0]));
    }

    public static void setSSLParameters(SSLParameters params, SSLParametersImpl impl, OpenSSLSocketImpl socket) {
        try {
            String sniHostname;
            Platform.setSSLParametersOnImpl(params, impl);
            if (Build.VERSION.SDK_INT >= 24 && (sniHostname = Platform.getSniHostnameFromParams(params)) != null) {
                socket.setHostname(sniHostname);
            }
        }
        catch (NoSuchMethodException sniHostname) {
        }
        catch (IllegalAccessException sniHostname) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static void setSSLParameters(SSLParameters params, SSLParametersImpl impl, OpenSSLEngineImpl engine) {
        try {
            String sniHostname;
            Platform.setSSLParametersOnImpl(params, impl);
            if (Build.VERSION.SDK_INT >= 24 && (sniHostname = Platform.getSniHostnameFromParams(params)) != null) {
                engine.setSniHostname(sniHostname);
            }
        }
        catch (NoSuchMethodException sniHostname) {
        }
        catch (IllegalAccessException sniHostname) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @TargetApi(value=24)
    private static String getSniHostnameFromParams(SSLParameters params) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m_getServerNames = params.getClass().getMethod("getServerNames", new Class[0]);
        List serverNames = (List)m_getServerNames.invoke((Object)params, new Object[0]);
        if (serverNames != null) {
            for (SNIServerName serverName : serverNames) {
                if (serverName.getType() != 0) continue;
                return ((SNIHostName)serverName).getAsciiName();
            }
        }
        return null;
    }

    private static void getSSLParametersFromImpl(SSLParameters params, SSLParametersImpl impl) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m_setEndpointIdentificationAlgorithm = params.getClass().getMethod("setEndpointIdentificationAlgorithm", String.class);
        m_setEndpointIdentificationAlgorithm.invoke((Object)params, impl.getEndpointIdentificationAlgorithm());
        Method m_setUseCipherSuitesOrder = params.getClass().getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
        m_setUseCipherSuitesOrder.invoke((Object)params, impl.getUseCipherSuitesOrder());
    }

    public static void getSSLParameters(SSLParameters params, SSLParametersImpl impl, OpenSSLSocketImpl socket) {
        try {
            Platform.getSSLParametersFromImpl(params, impl);
            if (Build.VERSION.SDK_INT >= 24) {
                Platform.setParametersSniHostname(params, impl, socket);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @TargetApi(value=24)
    private static void setParametersSniHostname(SSLParameters params, SSLParametersImpl impl, OpenSSLSocketImpl socket) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (impl.getUseSni() && AddressUtils.isValidSniHostname(socket.getHostname())) {
            Method m_setServerNames = params.getClass().getMethod("setServerNames", List.class);
            m_setServerNames.invoke((Object)params, Collections.singletonList(new SNIHostName(socket.getHostname())));
        }
    }

    public static void getSSLParameters(SSLParameters params, SSLParametersImpl impl, OpenSSLEngineImpl engine) {
        try {
            Platform.getSSLParametersFromImpl(params, impl);
            if (Build.VERSION.SDK_INT >= 24) {
                Platform.setParametersSniHostname(params, impl, engine);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @TargetApi(value=24)
    private static void setParametersSniHostname(SSLParameters params, SSLParametersImpl impl, OpenSSLEngineImpl engine) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (impl.getUseSni() && AddressUtils.isValidSniHostname(engine.getSniHostname())) {
            Method m_setServerNames = params.getClass().getMethod("setServerNames", List.class);
            m_setServerNames.invoke((Object)params, Collections.singletonList(new SNIHostName(engine.getSniHostname())));
        }
    }

    private static Class<?> getClass(String ... klasses) {
        for (String klass : klasses) {
            try {
                return Class.forName(klass);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static void setEndpointIdentificationAlgorithm(SSLParameters params, String endpointIdentificationAlgorithm) {
    }

    public static String getEndpointIdentificationAlgorithm(SSLParameters params) {
        return null;
    }

    private static boolean checkTrusted(String methodName, X509TrustManager tm, X509Certificate[] chain, String authType, Class<?> argumentClass, Object argumentInstance) throws CertificateException {
        try {
            Method method = tm.getClass().getMethod(methodName, X509Certificate[].class, String.class, argumentClass);
            method.invoke((Object)tm, chain, authType, argumentInstance);
            return true;
        }
        catch (NoSuchMethodException method) {
        }
        catch (IllegalAccessException method) {
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CertificateException) {
                throw (CertificateException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public static void checkClientTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, OpenSSLSocketImpl socket) throws CertificateException {
        if (!Platform.checkTrusted("checkClientTrusted", tm, chain, authType, Socket.class, socket) && !Platform.checkTrusted("checkClientTrusted", tm, chain, authType, String.class, socket.getHandshakeSession().getPeerHost())) {
            tm.checkClientTrusted(chain, authType);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void checkServerTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, OpenSSLSocketImpl socket) throws CertificateException {
        if (!Platform.checkTrusted("checkServerTrusted", tm, chain, authType, Socket.class, socket) && !Platform.checkTrusted("checkServerTrusted", tm, chain, authType, String.class, socket.getHandshakeSession().getPeerHost())) {
            tm.checkServerTrusted(chain, authType);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void checkClientTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, OpenSSLEngineImpl engine) throws CertificateException {
        if (!Platform.checkTrusted("checkClientTrusted", tm, chain, authType, SSLEngine.class, engine) && !Platform.checkTrusted("checkClientTrusted", tm, chain, authType, String.class, engine.getHandshakeSession().getPeerHost())) {
            tm.checkClientTrusted(chain, authType);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void checkServerTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, OpenSSLEngineImpl engine) throws CertificateException {
        if (!Platform.checkTrusted("checkServerTrusted", tm, chain, authType, SSLEngine.class, engine) && !Platform.checkTrusted("checkServerTrusted", tm, chain, authType, String.class, engine.getHandshakeSession().getPeerHost())) {
            tm.checkServerTrusted(chain, authType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenSSLKey wrapRsaKey(PrivateKey javaKey) {
        Class<?> superClass;
        if (Build.VERSION.SDK_INT >= 17) {
            return null;
        }
        try {
            superClass = Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLRSAPrivateKey");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Cannot find system OpenSSLRSAPrivateKey class: " + e));
            return null;
        }
        if (!superClass.isInstance(javaKey)) {
            Log.e((String)TAG, (String)("Private key is not an OpenSSLRSAPrivateKey instance, its class name is:" + javaKey.getClass().getCanonicalName()));
            return null;
        }
        try {
            Method getPkeyContext;
            Method getKey = superClass.getDeclaredMethod("getOpenSSLKey", new Class[0]);
            getKey.setAccessible(true);
            Object opensslKey = null;
            try {
                opensslKey = getKey.invoke((Object)javaKey, new Object[0]);
            }
            finally {
                getKey.setAccessible(false);
            }
            if (opensslKey == null) {
                Log.e((String)TAG, (String)("Could not getOpenSSLKey on instance: " + javaKey.toString()));
                return null;
            }
            try {
                getPkeyContext = opensslKey.getClass().getDeclaredMethod("getPkeyContext", new Class[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("No getPkeyContext() method on OpenSSLKey member:" + e));
                return null;
            }
            getPkeyContext.setAccessible(true);
            long evp_pkey = 0L;
            try {
                evp_pkey = ((Number)getPkeyContext.invoke(opensslKey, new Object[0])).longValue();
            }
            finally {
                getPkeyContext.setAccessible(false);
            }
            if (evp_pkey == 0L) {
                Log.e((String)TAG, (String)"getPkeyContext() returned null");
                return null;
            }
            return new OpenSSLKey(evp_pkey);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error during conversion of privatekey instance: " + javaKey.toString()), (Throwable)e);
            return null;
        }
    }

    public static void logEvent(String message) {
        try {
            Class<?> processClass = Class.forName("android.os.Process");
            Object processInstance = processClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method myUidMethod = processClass.getMethod("myUid", null);
            int uid = (Integer)myUidMethod.invoke(processInstance, new Object[0]);
            Class<?> eventLogClass = Class.forName("android.util.EventLog");
            Object eventLogInstance = eventLogClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method writeEventMethod = eventLogClass.getMethod("writeEvent", Integer.TYPE, Object[].class);
            writeEventMethod.invoke(eventLogInstance, 1397638484, new Object[]{"conscrypt", uid, message});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isLiteralIpAddress(String hostname) {
        try {
            Method m_isNumeric = InetAddress.class.getMethod("isNumeric", String.class);
            return (Boolean)m_isNumeric.invoke(null, hostname);
        }
        catch (Exception exception) {
            return AddressUtils.isLiteralIpAddress(hostname);
        }
    }

    public static SSLSocketFactory wrapSocketFactoryIfNeeded(OpenSSLSocketFactoryImpl factory) {
        if (Build.VERSION.SDK_INT < 19) {
            return new PreKitKatPlatformOpenSSLSocketAdapterFactory(factory);
        }
        if (Build.VERSION.SDK_INT < 22) {
            return new KitKatPlatformOpenSSLSocketAdapterFactory(factory);
        }
        return factory;
    }

    public static GCMParameters fromGCMParameterSpec(AlgorithmParameterSpec params) {
        Class<?> gcmSpecClass;
        try {
            gcmSpecClass = Class.forName("javax.crypto.spec.GCMParameterSpec");
        }
        catch (ClassNotFoundException e) {
            gcmSpecClass = null;
        }
        if (gcmSpecClass != null && gcmSpecClass.isAssignableFrom(params.getClass())) {
            try {
                Method getTLenMethod = gcmSpecClass.getMethod("getTLen", new Class[0]);
                Method getIVMethod = gcmSpecClass.getMethod("getIV", new Class[0]);
                int tLen = (Integer)getTLenMethod.invoke((Object)params, new Object[0]);
                byte[] iv = (byte[])getIVMethod.invoke((Object)params, new Object[0]);
                return new GCMParameters(tLen, iv);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("GCMParameterSpec lacks expected methods", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("GCMParameterSpec lacks expected methods", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Could not fetch GCM parameters", e.getTargetException());
            }
        }
        return null;
    }

    public static AlgorithmParameterSpec toGCMParameterSpec(int tagLenInBits, byte[] iv) {
        Class<?> gcmSpecClass;
        try {
            gcmSpecClass = Class.forName("javax.crypto.spec.GCMParameterSpec");
        }
        catch (ClassNotFoundException e) {
            gcmSpecClass = null;
        }
        if (gcmSpecClass != null) {
            try {
                Constructor<?> constructor = gcmSpecClass.getConstructor(Integer.TYPE, byte[].class);
                return (AlgorithmParameterSpec)constructor.newInstance(tagLenInBits, iv);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
            }
        }
        return null;
    }

    public static CloseGuard closeGuardGet() {
        if (Build.VERSION.SDK_INT < 14) {
            return null;
        }
        return CloseGuard.get();
    }

    public static void closeGuardOpen(Object guardObj, String message) {
        if (Build.VERSION.SDK_INT < 14) {
            return;
        }
        CloseGuard guard = (CloseGuard)guardObj;
        guard.open(message);
    }

    public static void closeGuardClose(Object guardObj) {
        if (Build.VERSION.SDK_INT < 14) {
            return;
        }
        CloseGuard guard = (CloseGuard)guardObj;
        guard.close();
    }

    public static void closeGuardWarnIfOpen(Object guardObj) {
        if (Build.VERSION.SDK_INT < 14) {
            return;
        }
        CloseGuard guard = (CloseGuard)guardObj;
        guard.warnIfOpen();
    }

    public static void blockGuardOnNetwork() {
        BlockGuard.getThreadPolicy().onNetwork();
    }

    public static String oidToAlgorithmName(String oid) {
        try {
            Class<?> algNameMapperClass = Class.forName("org.apache.harmony.security.utils.AlgNameMapper");
            Method map2AlgNameMethod = algNameMapperClass.getDeclaredMethod("map2AlgName", String.class);
            map2AlgNameMethod.setAccessible(true);
            return (String)map2AlgNameMethod.invoke(null, oid);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            try {
                Class<?> algorithmIdClass = Class.forName("sun.security.x509.AlgorithmId");
                Method getMethod = algorithmIdClass.getDeclaredMethod("get", String.class);
                getMethod.setAccessible(true);
                Method getNameMethod = algorithmIdClass.getDeclaredMethod("getName", new Class[0]);
                getNameMethod.setAccessible(true);
                Object algIdObj = getMethod.invoke(null, oid);
                return (String)getNameMethod.invoke(algIdObj, new Object[0]);
            }
            catch (InvocationTargetException e2) {
                Throwable cause = e2.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(e2);
            }
            catch (Exception exception) {
                return oid;
            }
        }
    }

    public static SSLSession wrapSSLSession(AbstractOpenSSLSession sslSession) {
        if (Build.VERSION.SDK_INT <= 23) {
            return sslSession;
        }
        return new OpenSSLExtendedSessionImpl(sslSession);
    }

    public static SSLSession unwrapSSLSession(SSLSession sslSession) {
        if (Build.VERSION.SDK_INT <= 23) {
            return sslSession;
        }
        if (sslSession instanceof OpenSSLExtendedSessionImpl) {
            return ((OpenSSLExtendedSessionImpl)sslSession).getDelegate();
        }
        return sslSession;
    }

    public static String getHostStringFromInetSocketAddress(InetSocketAddress addr) {
        if (Build.VERSION.SDK_INT > 23) {
            try {
                Method m_getHostString = InetSocketAddress.class.getDeclaredMethod("getHostString", new Class[0]);
                return (String)m_getHostString.invoke((Object)addr, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isCTVerificationRequired(String hostname) {
        if (hostname == null) {
            return false;
        }
        String property = Security.getProperty("conscrypt.ct.enable");
        if (property == null || !Boolean.valueOf(property).booleanValue()) {
            return false;
        }
        List<String> parts = Arrays.asList(hostname.split("\\."));
        Collections.reverse(parts);
        boolean enable = false;
        String propertyName = "conscrypt.ct.enforce";
        for (String part : parts) {
            property = Security.getProperty(propertyName + ".*");
            if (property != null) {
                enable = Boolean.valueOf(property);
            }
            propertyName = propertyName + "." + part;
        }
        property = Security.getProperty(propertyName);
        if (property != null) {
            enable = Boolean.valueOf(property);
        }
        return enable;
    }

    static {
        try {
            m_getCurveName = ECParameterSpec.class.getDeclaredMethod("getCurveName", new Class[0]);
            m_getCurveName.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

