/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.soap.wssample;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.jws.WebService;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.connid.bundles.soap.exceptions.ProvisioningException;
import org.connid.bundles.soap.provisioning.interfaces.Provisioning;
import org.connid.bundles.soap.to.WSAttribute;
import org.connid.bundles.soap.to.WSAttributeValue;
import org.connid.bundles.soap.to.WSChange;
import org.connid.bundles.soap.to.WSUser;
import org.connid.bundles.soap.utilities.Operand;
import org.connid.bundles.soap.wssample.DefaultContentLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;

@WebService(endpointInterface="org.connid.bundles.soap.provisioning.interfaces.Provisioning", serviceName="Provisioning")
public class ProvisioningImpl
implements Provisioning {
    private static final Logger LOG = LoggerFactory.getLogger(Provisioning.class);

    public String delete(String accountid) throws ProvisioningException {
        LOG.debug("Delete request received");
        Connection conn = null;
        try {
            conn = this.connect();
            Statement statement = conn.createStatement();
            String query = "DELETE FROM user WHERE userId='" + accountid + "';";
            LOG.debug("Execute query: " + query);
            statement.executeUpdate(query);
            String string = accountid;
            return string;
        }
        catch (SQLException e) {
            throw new ProvisioningException("Delete operation failed", (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    this.close(conn);
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public Boolean isSyncSupported() {
        LOG.debug("isSyncSupported request received");
        return Boolean.FALSE;
    }

    public String checkAlive() {
        String result;
        LOG.debug("checkAlive request received");
        try {
            this.close(this.connect());
            LOG.debug("Services available");
            result = "OK";
        }
        catch (Exception e) {
            LOG.debug("Services not available");
            result = "KO";
        }
        return result;
    }

    public String update(String accountid, List<WSAttributeValue> data) throws ProvisioningException {
        LOG.debug("Update request received");
        if (data == null || data.isEmpty()) {
            LOG.warn("Empty data recevied");
            return accountid;
        }
        List schema = this.schema();
        HashSet<String> schemaNames = new HashSet<String>();
        for (WSAttribute attr : schema) {
            schemaNames.add(attr.getName());
        }
        schemaNames.add("__NAME__");
        schemaNames.add("__PASSWORD__");
        Connection conn = null;
        try {
            conn = this.connect();
            Statement statement = conn.createStatement();
            StringBuilder set = new StringBuilder();
            for (WSAttributeValue attr : data) {
                if (!schemaNames.contains(attr.getName())) continue;
                String value = attr.getValues() == null || attr.getValues().isEmpty() ? null : (attr.getValues().size() == 1 ? attr.getValues().get(0).toString() : attr.getValues().toString());
                if (attr.isKey() && accountid.equals(value)) continue;
                if (set.length() > 0) {
                    set.append(",");
                }
                if ("__NAME__".equals(attr.getName())) {
                    set.append("userId=");
                } else if ("__PASSWORD__".equals(attr.getName())) {
                    set.append("password=");
                } else {
                    set.append(attr.getName()).append('=');
                }
                set.append(value == null ? null : "'" + value + "'");
            }
            if (set.length() > 0) {
                String query = "UPDATE user SET " + set.toString() + " WHERE userId='" + accountid + "';";
                LOG.debug("Execute query: " + query);
                statement.executeUpdate(query);
            }
            String string = accountid;
            return string;
        }
        catch (SQLException e) {
            LOG.error("Update failed", (Throwable)e);
            throw new ProvisioningException("Update operation failed", (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    this.close(conn);
                }
                catch (SQLException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WSUser> query(Operand query) {
        LOG.debug("Query request received");
        ArrayList<WSUser> results = new ArrayList<WSUser>();
        Connection conn = null;
        try {
            String queryString = "SELECT * FROM user" + (query == null ? "" : " WHERE " + query.toString());
            queryString = queryString.replaceAll("__NAME__", "userId").replaceAll("__UID__", "userId").replaceAll("__PASSWORD__", "password");
            LOG.debug("Execute query: {}", (Object)queryString);
            if (queryString == null) throw new SQLException("Invalid query [" + queryString + "]");
            if (queryString.length() == 0) {
                throw new SQLException("Invalid query [" + queryString + "]");
            }
            conn = this.connect();
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(queryString);
            ResultSetMetaData metaData = rs.getMetaData();
            LOG.debug("Metadata: {}", (Object)metaData);
            while (rs.next()) {
                WSUser user = new WSUser();
                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                    WSAttributeValue attr = new WSAttributeValue();
                    attr.setName(metaData.getColumnLabel(i + 1));
                    if (StringUtils.isNotBlank((String)rs.getString(i + 1))) {
                        attr.addValue((Object)rs.getString(i + 1));
                    }
                    if ("userId".equalsIgnoreCase(metaData.getColumnName(i + 1))) {
                        attr.setKey(true);
                        user.setAccountid(rs.getString(i + 1));
                    }
                    user.addAttribute(attr);
                }
                results.add(user);
            }
            LOG.debug("Retrieved users: {}", results);
            if (conn == null) return results;
        }
        catch (SQLException e) {
            LOG.error("Search operation failed", (Throwable)e);
            return results;
        }
        try {
            this.close(conn);
            return results;
        }
        catch (SQLException ignore) {
            return results;
        }
        finally {
            if (conn != null) {
                try {
                    this.close(conn);
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public String create(List<WSAttributeValue> data) throws ProvisioningException {
        LOG.debug("Create request received with data {}", data);
        List schema = this.schema();
        HashSet<String> schemaNames = new HashSet<String>();
        for (WSAttribute attr : schema) {
            schemaNames.add(attr.getName());
        }
        schemaNames.add("__NAME__");
        schemaNames.add("__PASSWORD__");
        Connection conn = null;
        String query = null;
        try {
            conn = this.connect();
            Statement statement = conn.createStatement();
            StringBuilder keys = new StringBuilder();
            StringBuilder values = new StringBuilder();
            String accountid = null;
            for (WSAttributeValue attr : data) {
                if (!schemaNames.contains(attr.getName())) continue;
                LOG.debug("Bind attribute: {}", (Object)attr);
                String value = attr.getValues() == null || attr.getValues().isEmpty() ? null : (attr.getValues().size() == 1 ? attr.getValues().get(0).toString() : attr.getValues().toString());
                if (keys.length() > 0) {
                    keys.append(",");
                }
                if ("__NAME__".equals(attr.getName())) {
                    keys.append("userId");
                } else if ("__PASSWORD__".equals(attr.getName())) {
                    keys.append("password");
                } else {
                    keys.append(attr.getName());
                }
                if (values.length() > 0) {
                    values.append(",");
                }
                values.append(value == null ? null : "'" + value + "'");
                if (!attr.isKey() || attr.getValues().isEmpty()) continue;
                accountid = attr.getValues().get(0).toString();
            }
            query = "INSERT INTO user (" + keys.toString() + ") VALUES (" + values.toString() + ")";
            LOG.debug("Execute query: " + query);
            statement.executeUpdate(query);
            String string = accountid;
            return string;
        }
        catch (SQLException e) {
            LOG.error("Creation failed:\n" + query, (Throwable)e);
            throw new ProvisioningException("Create operation failed", (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    this.close(conn);
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public int getLatestChangeNumber() throws ProvisioningException {
        LOG.debug("getLatestChangeNumber request received");
        return 0;
    }

    public List<WSChange> sync() throws ProvisioningException {
        LOG.debug("sync request received");
        return Collections.emptyList();
    }

    public String resolve(String username) throws ProvisioningException {
        LOG.debug("Resolve request operation received: " + username);
        Connection conn = null;
        try {
            conn = this.connect();
            Statement statement = conn.createStatement();
            String query = "SELECT userId FROM user WHERE userId='" + username + "';";
            LOG.debug("Execute query: " + query);
            ResultSet rs = statement.executeQuery(query);
            String string = rs.next() ? rs.getString(1) : null;
            return string;
        }
        catch (SQLException e) {
            throw new ProvisioningException("Resolve operation failed", (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    this.close(conn);
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public List<WSAttribute> schema() {
        LOG.debug("schema request received");
        ArrayList<WSAttribute> attrs = new ArrayList<WSAttribute>();
        WSAttribute attr = new WSAttribute();
        attr.setName("userId");
        attr.setNullable(false);
        attr.setPassword(false);
        attr.setKey(true);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("password");
        attr.setNullable(false);
        attr.setPassword(true);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("type");
        attr.setNullable(false);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("residence");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("telephone");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("fax");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("preference");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("name");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("surname");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("fullname");
        attr.setNullable(false);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("birthdate");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("Date");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("telephone");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("gender");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("taxNumber");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("state");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("studyTitle");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("studyArea");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("job");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("companyType");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("companyName");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("vatNumber");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("String");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("mandatoryDisclaimer");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("Boolean");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("promoRCSDisclaimer");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("Boolean");
        attrs.add(attr);
        attr = new WSAttribute();
        attr.setName("promoThirdPartyDisclaimer");
        attr.setNullable(true);
        attr.setPassword(false);
        attr.setKey(false);
        attr.setType("Boolean");
        attrs.add(attr);
        return attrs;
    }

    public String authenticate(String username, String password) throws ProvisioningException {
        LOG.debug("authenticate request received");
        return username;
    }

    public Boolean isAuthenticationSupported() {
        LOG.debug("isAuthenticationSupported request received");
        return Boolean.FALSE;
    }

    private Connection connect() throws SQLException {
        if (DefaultContentLoader.localDataSource == null) {
            LOG.error("Data Source is null");
            return null;
        }
        Connection conn = DataSourceUtils.getConnection((DataSource)DefaultContentLoader.localDataSource);
        if (conn == null) {
            LOG.error("Connection is null");
        }
        return conn;
    }

    private void close(Connection conn) throws SQLException {
        DataSourceUtils.releaseConnection((Connection)conn, (DataSource)DefaultContentLoader.localDataSource);
    }
}

