/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.soap.wssample;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DefaultContentLoader
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultContentLoader.class);
    private final String DBSCHEMA = "/schema.sql";
    public static DataSource localDataSource = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        DataSource dataSource;
        WebApplicationContext springContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext());
        if (springContext == null) {
            LOG.error("Invalid Spring context");
            return;
        }
        localDataSource = dataSource = (DataSource)springContext.getBean(DataSource.class);
        DefaultDataTypeFactory dbUnitDataTypeFactory = (DefaultDataTypeFactory)springContext.getBean("dbUnitDataTypeFactory");
        Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
        StringBuilder statement = new StringBuilder();
        InputStream dbschema = DefaultContentLoader.class.getResourceAsStream("/schema.sql");
        BufferedReader buff = new BufferedReader(new InputStreamReader(dbschema));
        String line = null;
        try {
            while ((line = buff.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("--")) continue;
                statement.append(line);
            }
        }
        catch (IOException e) {
            LOG.error("Error reading file /schema.sql", (Throwable)e);
            return;
        }
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute(statement.toString());
        }
        catch (SQLException e) {
            LOG.error("Error creating schema:\n" + statement.toString(), (Throwable)e);
            return;
        }
        finally {
            try {
                st.close();
            }
            catch (Throwable t) {}
        }
        try {
            DatabaseConnection dbUnitConn = new DatabaseConnection(conn);
            DatabaseConfig config = dbUnitConn.getConfig();
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)dbUnitDataTypeFactory);
            boolean existingData = false;
            IDataSet existingDataSet = dbUnitConn.createDataSet();
            ITableIterator itor = existingDataSet.iterator();
            while (itor.next() && !existingData) {
                existingData = itor.getTable().getRowCount() > 0;
            }
            FlatXmlDataSetBuilder dataSetBuilder = new FlatXmlDataSetBuilder();
            dataSetBuilder.setColumnSensing(true);
            FlatXmlDataSet dataSet = dataSetBuilder.build(this.getClass().getResourceAsStream("/content.xml"));
            DatabaseOperation.REFRESH.execute((IDatabaseConnection)dbUnitConn, (IDataSet)dataSet);
        }
        catch (Throwable t) {
            LOG.error("Error loding default content", t);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)dataSource);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                LOG.info("Deregistering JDBC driver: {}", (Object)driver);
            }
            catch (SQLException e) {
                LOG.error("Error deregistering JDBC driver {}", (Object)driver, (Object)e);
            }
        }
    }
}

