/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.store;

import com.j_spaces.core.IJSpace;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jini.core.entry.Entry;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.compass.needle.gigaspaces.store.FileBucketEntry;
import org.compass.needle.gigaspaces.store.FileEntry;
import org.compass.needle.gigaspaces.store.GigaSpaceDirectoryException;
import org.compass.needle.gigaspaces.store.GigaSpaceIndexInput;
import org.compass.needle.gigaspaces.store.GigaSpaceLockFactory;
import org.compass.needle.gigaspaces.store.GigaSpaceMemIndexOutput;
import org.openspaces.core.GigaSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GigaSpaceDirectory
extends Directory {
    public static final int DEFAULT_BUCKET_SIZE = 20480;
    public static final int DEFAULT_FLUSH_RATE = 50;
    private IJSpace space;
    private String indexName;
    private int bucketSize = 20480;
    private int flushRate = 50;
    private Map<String, IndexOutput> onGoingIndexOutputs = new ConcurrentHashMap<String, IndexOutput>();

    public GigaSpaceDirectory(GigaSpace gigaSpace, String indexName) {
        this(gigaSpace.getSpace(), indexName);
    }

    public GigaSpaceDirectory(IJSpace space, String indexName) {
        this(space, indexName, 20480);
    }

    public GigaSpaceDirectory(IJSpace space, String indexName, int bucketSize) {
        this(space, indexName, bucketSize, 50);
    }

    public GigaSpaceDirectory(IJSpace space, String indexName, int bucketSize, int flushRate) {
        this.space = space;
        this.indexName = indexName;
        this.bucketSize = bucketSize;
        this.flushRate = flushRate;
        this.setLockFactory(new GigaSpaceLockFactory(space, indexName));
    }

    public void deleteContent() throws IOException {
        FileEntry fileEntry = new FileEntry(this.indexName, null);
        try {
            this.space.clear((Entry)fileEntry, null);
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.indexName, null, "Delete failed", e);
        }
        FileBucketEntry fileBucketEntry = new FileBucketEntry(this.indexName, null);
        try {
            this.space.clear((Entry)fileBucketEntry, null);
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.indexName, null, "Delete failed", e);
        }
    }

    Map<String, IndexOutput> getOnGoingIndexOutputs() {
        return this.onGoingIndexOutputs;
    }

    public IJSpace getSpace() {
        return this.space;
    }

    String getIndexName() {
        return this.indexName;
    }

    int getBucketSize() {
        return this.bucketSize;
    }

    int getFlushRate() {
        return this.flushRate;
    }

    public void deleteFile(String fileName) throws IOException {
        FileEntry fileEntry = new FileEntry(this.indexName, fileName);
        try {
            this.space.clear((Entry)fileEntry, null);
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.indexName, fileName, "Delete failed", e);
        }
        FileBucketEntry fileBucketEntry = new FileBucketEntry(this.indexName, fileName);
        try {
            this.space.clear((Entry)fileBucketEntry, null);
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.indexName, fileName, "Delete failed", e);
        }
    }

    public boolean fileExists(String fileName) throws IOException {
        if (this.onGoingIndexOutputs.containsKey(fileName)) {
            return true;
        }
        FileEntry fileEntry = new FileEntry(this.indexName, fileName);
        try {
            int count = this.space.count((Entry)fileEntry, null);
            return count > 0;
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.indexName, fileName, "File exists failed", e);
        }
    }

    public long fileLength(String fileName) throws IOException {
        FileEntry fileEntryTemplate = new FileEntry(this.indexName, fileName);
        try {
            FileEntry fileEntry = (FileEntry)this.space.read((Entry)fileEntryTemplate, null, 0L);
            if (fileEntry == null) {
                return 0L;
            }
            return fileEntry.getSize();
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.indexName, fileName, "File length failed", e);
        }
    }

    public long fileModified(String fileName) throws IOException {
        FileEntry fileEntryTemplate = new FileEntry(this.indexName, fileName);
        try {
            FileEntry fileEntry = (FileEntry)this.space.read((Entry)fileEntryTemplate, null, 0L);
            if (fileEntry == null) {
                return 0L;
            }
            return fileEntry.getLastModified();
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.indexName, fileName, "File modified failed", e);
        }
    }

    public String[] list() throws IOException {
        FileEntry fileEntryTemplate = new FileEntry(this.indexName, null);
        try {
            Entry[] results = this.space.readMultiple((Entry)fileEntryTemplate, null, Integer.MAX_VALUE);
            String[] retVal = new String[results.length];
            for (int i = 0; i < results.length; ++i) {
                retVal[i] = ((FileEntry)results[i]).getFileName();
            }
            return retVal;
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.indexName, null, "File list failed", e);
        }
    }

    public void renameFile(String from, String to) throws IOException {
        throw new UnsupportedOperationException("rename file not supported with GigaSpace direcotry");
    }

    public void touchFile(String fileName) throws IOException {
        FileEntry fileEntryTemplate = new FileEntry(this.indexName, fileName);
        try {
            FileEntry fileEntry = (FileEntry)this.space.take((Entry)fileEntryTemplate, null, 0L);
            if (fileEntry == null) {
                fileEntry = new FileEntry(this.indexName, fileName, 0L);
            }
            fileEntry.touch();
            this.space.write((Entry)fileEntry, null, Long.MAX_VALUE);
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.indexName, fileName, "File touch failed", e);
        }
    }

    public IndexInput openInput(String fileName) throws IOException {
        FileEntry fileEntry = new FileEntry(this.indexName, fileName);
        try {
            fileEntry = (FileEntry)this.space.read((Entry)fileEntry, null, 0L);
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.indexName, fileName, "File to read file entry", e);
        }
        if (fileEntry == null) {
            throw new GigaSpaceDirectoryException(this.indexName, fileName, "Failed to find file entry");
        }
        return new GigaSpaceIndexInput(this, fileEntry);
    }

    public IndexOutput createOutput(String fileName) throws IOException {
        GigaSpaceMemIndexOutput out = new GigaSpaceMemIndexOutput(this, fileName);
        this.onGoingIndexOutputs.put(fileName, out);
        return out;
    }

    public void close() throws IOException {
    }
}

