/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.lifecycle;

import java.util.Collection;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.event.DeleteListener;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.PersistListener;
import org.apache.openjpa.event.StoreListener;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.compass.core.mapping.CascadeMapping;
import org.compass.gps.device.jpa.AbstractDeviceJpaEntityListener;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.lifecycle.JpaEntityLifecycleInjector;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public class OpenJPAJpaEntityLifecycleInjector
implements JpaEntityLifecycleInjector {
    private boolean useSpecificClassEvents = true;
    private ClassLoader classLoader;
    private Object eventListener;

    public void setUseSpecificClassEvents(boolean useSpecificClassEvents) {
        this.useSpecificClassEvents = useSpecificClassEvents;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEventListener(Object eventListener) {
        this.eventListener = eventListener;
    }

    public boolean requireRefresh() {
        return true;
    }

    public void injectLifecycle(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        CompassGpsInterfaceDevice gps = (CompassGpsInterfaceDevice)device.getGps();
        EntityManagerFactoryImpl emf = (EntityManagerFactoryImpl)OpenJPAPersistence.cast((EntityManagerFactory)entityManagerFactory);
        if (this.eventListener == null) {
            this.eventListener = new OpenJPAEventListener(device);
        }
        if (this.useSpecificClassEvents) {
            Collection classes = emf.getConfiguration().getMetaDataRepositoryInstance().loadPersistentTypes(true, this.classLoader);
            for (Class clazz : classes) {
                ClassMetaData classMetaData = emf.getConfiguration().getMetaDataRepositoryInstance().getMetaData(clazz, this.classLoader, true);
                Class mappedClass = classMetaData.getDescribedType();
                if (!gps.hasMappingForEntityForMirror(mappedClass, CascadeMapping.Cascade.ALL)) continue;
                emf.addLifecycleListener(this.eventListener, new Class[]{mappedClass});
            }
        } else {
            emf.addLifecycleListener(this.eventListener, new Class[0]);
        }
    }

    public void removeLifecycle(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        EntityManagerFactoryImpl emf = (EntityManagerFactoryImpl)OpenJPAPersistence.cast((EntityManagerFactory)entityManagerFactory);
        this.eventListener = new OpenJPAEventListener(device);
        emf.removeLifecycleListener(this.eventListener);
    }

    private class OpenJPAEventListener
    extends AbstractDeviceJpaEntityListener
    implements DeleteListener,
    PersistListener,
    StoreListener {
        private JpaGpsDevice device;

        public OpenJPAEventListener(JpaGpsDevice device) {
            this.device = device;
        }

        protected JpaGpsDevice getDevice() {
            return this.device;
        }

        public void beforeDelete(LifecycleEvent lifecycleEvent) {
        }

        public void afterDelete(LifecycleEvent lifecycleEvent) {
            this.postRemove(lifecycleEvent.getSource());
        }

        public void beforePersist(LifecycleEvent lifecycleEvent) {
        }

        public void afterPersist(LifecycleEvent lifecycleEvent) {
            this.postPersist(lifecycleEvent.getSource());
        }

        public void beforeStore(LifecycleEvent lifecycleEvent) {
        }

        public void afterStore(LifecycleEvent lifecycleEvent) {
            this.postUpdate(lifecycleEvent.getSource());
        }
    }
}

