/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.util.Locale;
import org.compass.core.CompassException;
import org.compass.core.CompassHits;
import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryFilter;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.impl.DefaultCompassHits;
import org.compass.core.impl.DefaultCompassQueryFilter;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyLookup;
import org.compass.core.spi.InternalCompassSession;

public class DefaultCompassQuery
implements CompassQuery,
Cloneable {
    private SearchEngineQuery searchEngineQuery;
    private InternalCompassSession session;
    private CompassQueryFilter filter;

    public DefaultCompassQuery(SearchEngineQuery searchEngineQuery, InternalCompassSession session) {
        this.searchEngineQuery = searchEngineQuery;
        this.session = session;
    }

    public CompassQuery setBoost(float boost) {
        this.searchEngineQuery.setBoost(boost);
        return this;
    }

    public CompassQuery addSort(String name) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        this.searchEngineQuery.addSort(lookup.getPath());
        return this;
    }

    public CompassQuery addSort(String name, CompassQuery.SortDirection direction) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        this.searchEngineQuery.addSort(lookup.getPath(), direction);
        return this;
    }

    public CompassQuery addSort(String name, CompassQuery.SortPropertyType type) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        this.searchEngineQuery.addSort(lookup.getPath(), type);
        return this;
    }

    public CompassQuery addSort(String name, CompassQuery.SortPropertyType type, CompassQuery.SortDirection direction) {
        ResourcePropertyLookup lookup = this.session.getMapping().getResourcePropertyLookup(name);
        this.searchEngineQuery.addSort(lookup.getPath(), type, direction);
        return this;
    }

    public CompassQuery addSort(CompassQuery.SortImplicitType implicitType) {
        this.searchEngineQuery.addSort(implicitType);
        return this;
    }

    public CompassQuery addSort(CompassQuery.SortImplicitType implicitType, CompassQuery.SortDirection direction) {
        this.searchEngineQuery.addSort(implicitType, direction);
        return this;
    }

    public CompassQuery addSort(String propertyName, Locale locale, CompassQuery.SortDirection direction) {
        this.searchEngineQuery.addSort(propertyName, locale, direction);
        return this;
    }

    public CompassQuery addSort(String propertyName, Locale locale) {
        this.searchEngineQuery.addSort(propertyName, locale);
        return this;
    }

    public CompassQuery setSubIndexes(String ... subIndexes) {
        this.searchEngineQuery.setSubIndexes(subIndexes);
        return this;
    }

    public CompassQuery setAliases(String ... aliases) {
        this.searchEngineQuery.setAliases(aliases);
        return this;
    }

    public CompassQuery setTypes(Class ... types) {
        if (types == null) {
            this.searchEngineQuery.setAliases(null);
            return this;
        }
        String[] aliases = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            ResourceMapping resourceMapping = this.session.getMapping().getRootMappingByClass(types[i]);
            aliases[i] = resourceMapping.getAlias();
        }
        this.setAliases(aliases);
        return this;
    }

    public CompassQuery setFilter(CompassQueryFilter filter) {
        this.filter = filter;
        this.searchEngineQuery.setFilter(((DefaultCompassQueryFilter)filter).getFilter());
        return this;
    }

    public CompassQueryFilter getFilter() {
        return this.filter;
    }

    public CompassQuery rewrite() {
        this.searchEngineQuery.rewrite();
        return this;
    }

    public CompassQuery getSuggestedQuery() {
        if (this.session.getCompass().getSpellCheckManager() == null) {
            return this;
        }
        return this.session.getCompass().getSpellCheckManager().suggest(this);
    }

    public boolean isSuggested() {
        return this.searchEngineQuery.isSuggested();
    }

    public long count() {
        return this.searchEngineQuery.count();
    }

    public long count(float minimumScore) {
        return this.searchEngineQuery.count(minimumScore);
    }

    public CompassHits hits() throws CompassException {
        SearchEngineHits searchEngineHits = this.searchEngineQuery.hits();
        return new DefaultCompassHits(searchEngineHits, this.session, this);
    }

    public SearchEngineQuery getSearchEngineQuery() {
        return this.searchEngineQuery;
    }

    public String toString() {
        return this.searchEngineQuery.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultCompassQuery clone = (DefaultCompassQuery)super.clone();
        clone.searchEngineQuery = (SearchEngineQuery)this.searchEngineQuery.clone();
        return clone;
    }

    public static class DefaultCompassSpanQuey
    extends DefaultCompassQuery
    implements CompassQuery.CompassSpanQuery {
        private SearchEngineQuery.SearchEngineSpanQuery spanQuery;

        public DefaultCompassSpanQuey(SearchEngineQuery.SearchEngineSpanQuery searchEngineQuery, InternalCompassSession session) {
            super(searchEngineQuery, session);
            this.spanQuery = searchEngineQuery;
        }

        public SearchEngineQuery.SearchEngineSpanQuery getSearchEngineSpanQuery() {
            return this.spanQuery;
        }
    }
}

