/*
 * Copyright 2004-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.compass.core.transaction;

import org.compass.core.CompassException;
import org.compass.core.CompassTransaction;
import org.compass.core.spi.InternalCompassSession;

/**
 * Factory for {@link XATransaction}s.
 *
 * @author kimchy
 * @see XATransaction
 */
public class XATransactionFactory extends AbstractJTATransactionFactory {

    public InternalCompassTransaction doBeginTransaction(InternalCompassSession session,
                                                         CompassTransaction.TransactionIsolation transactionIsolation) throws CompassException {
        XATransaction tx = new XATransaction(getUserTransaction(), this);
        tx.begin(session, getTransactionManager(), transactionIsolation);
        return tx;
    }

    protected InternalCompassTransaction doContinueTransaction(InternalCompassSession session) throws CompassException {
        XATransaction tx = new XATransaction(getUserTransaction(), this);
        tx.join(session);
        return tx;
    }

}
