/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.VersionlessArtifactRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectVersionRefSerializerModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public ProjectVersionRefSerializerModule() {
        super("ProjectRef (with variants) Serializer");
        Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        logger.debug("Registering ProjectRef serializer/deserialer");
        this.addSerializer(ProjectRef.class, (JsonSerializer)new ProjectRefSerializer<ProjectRef>(ProjectRef.class, false));
        this.addKeySerializer(ProjectRef.class, (JsonSerializer)new ProjectRefSerializer<ProjectRef>(ProjectRef.class, true));
        this.addDeserializer(ProjectRef.class, (JsonDeserializer)new ProjectRefDeserializer<ProjectRef>(ProjectRef.class));
        this.addKeyDeserializer(ProjectRef.class, new ProjectRefKeyDeserializer<ProjectRef>(ProjectRef.class));
        logger.debug("Registering ProjectVersionRef serializer/deserialer");
        this.addSerializer(ProjectVersionRef.class, (JsonSerializer)new ProjectRefSerializer<ProjectVersionRef>(ProjectVersionRef.class, false));
        this.addKeySerializer(ProjectVersionRef.class, (JsonSerializer)new ProjectRefSerializer<ProjectVersionRef>(ProjectVersionRef.class, true));
        this.addDeserializer(ProjectVersionRef.class, (JsonDeserializer)new ProjectRefDeserializer<ProjectVersionRef>(ProjectVersionRef.class));
        this.addKeyDeserializer(ProjectVersionRef.class, new ProjectRefKeyDeserializer<ProjectVersionRef>(ProjectVersionRef.class));
        logger.debug("Registering ArtifactRef serializer/deserialer");
        this.addSerializer(ArtifactRef.class, (JsonSerializer)new ProjectRefSerializer<ArtifactRef>(ArtifactRef.class, false));
        this.addKeySerializer(ArtifactRef.class, (JsonSerializer)new ProjectRefSerializer<ArtifactRef>(ArtifactRef.class, true));
        this.addDeserializer(ArtifactRef.class, (JsonDeserializer)new ProjectRefDeserializer<ArtifactRef>(ArtifactRef.class));
        this.addKeyDeserializer(ArtifactRef.class, new ProjectRefKeyDeserializer<ArtifactRef>(ArtifactRef.class));
        logger.debug("Registering VersionlessArtifactRef serializer/deserialer");
        this.addSerializer(VersionlessArtifactRef.class, (JsonSerializer)new ProjectRefSerializer<VersionlessArtifactRef>(VersionlessArtifactRef.class, false));
        this.addKeySerializer(VersionlessArtifactRef.class, (JsonSerializer)new ProjectRefSerializer<VersionlessArtifactRef>(VersionlessArtifactRef.class, true));
        this.addDeserializer(VersionlessArtifactRef.class, (JsonDeserializer)new ProjectRefDeserializer<VersionlessArtifactRef>(VersionlessArtifactRef.class));
        this.addKeyDeserializer(VersionlessArtifactRef.class, new ProjectRefKeyDeserializer<VersionlessArtifactRef>(VersionlessArtifactRef.class));
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().getSimpleName().hashCode() + 17;
    }

    public boolean equals(Object other) {
        return ((Object)((Object)this)).getClass().equals(other.getClass());
    }

    private <T extends ProjectRef> T parse(String value, Class<T> type) throws IOException {
        try {
            Method parseMethod = type.getMethod("parse", String.class);
            return (T)((ProjectRef)type.cast(parseMethod.invoke(null, value)));
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Failed to lookup/invoke parse() method on " + type.getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to lookup/invoke parse() method on " + type.getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Failed to lookup/invoke parse() method on " + type.getSimpleName(), e);
        }
    }

    public class ProjectRefKeyDeserializer<T extends ProjectRef>
    extends KeyDeserializer {
        private static final long serialVersionUID = 1L;
        private final Class<T> refCls;

        public ProjectRefKeyDeserializer(Class<T> type) {
            this.refCls = type;
        }

        public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ProjectVersionRefSerializerModule.this.parse(key, this.refCls);
        }
    }

    private class ProjectRefDeserializer<T extends ProjectRef>
    extends StdDeserializer<T> {
        private static final long serialVersionUID = 1L;
        private final Class<T> refCls;

        ProjectRefDeserializer(Class<T> refCls) {
            super(refCls);
            this.refCls = refCls;
        }

        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return (T)ProjectVersionRefSerializerModule.this.parse(jp.getText(), this.refCls);
        }
    }

    private static final class ProjectRefSerializer<T extends ProjectRef>
    extends StdSerializer<T> {
        private boolean keySer;

        ProjectRefSerializer(Class<T> refCls, boolean keySer) {
            super(refCls);
            this.keySer = keySer;
        }

        public void serialize(T src, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (this.keySer) {
                generator.writeFieldName(src.toString());
            } else {
                generator.writeString(src.toString());
            }
        }
    }
}

