/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.vertx.vabr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonjava.util.logging.Logger;
import org.commonjava.vertx.vabr.Method;
import org.commonjava.vertx.vabr.RouteBinding;
import org.commonjava.vertx.vabr.RouteCollection;
import org.commonjava.vertx.vabr.RouteHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServerRequest;

public class ApplicationRouter
implements Handler<HttpServerRequest> {
    private static final String PATH_SEG_PATTERN = "([^\\/]+)";
    private final Logger logger = new Logger(this.getClass());
    private final Map<Method, List<PatternBinding>> bindings = new HashMap<Method, List<PatternBinding>>();
    private final Map<String, RouteHandler> routes = new HashMap<String, RouteHandler>();
    private Handler<HttpServerRequest> noMatchHandler;

    public ApplicationRouter() {
    }

    public ApplicationRouter(Collection<RouteHandler> routes, Iterable<RouteCollection> routeCollections) {
        this.bind(routes, routeCollections);
    }

    private void bind(Iterable<RouteHandler> routes, Iterable<RouteCollection> routeCollections) {
        for (RouteHandler route : routes) {
            this.routes.put(route.getClass().getName(), route);
        }
        for (RouteCollection rc : routeCollections) {
            for (RouteBinding rb : rc) {
                this.bind(rb);
            }
        }
    }

    public <T> T getResourceInstance(Class<T> cls) {
        RouteHandler handler = this.routes.get(cls.getName());
        return handler == null ? null : (T)cls.cast(handler);
    }

    @Override
    public void handle(HttpServerRequest request) {
        try {
            Method method = Method.valueOf(request.method());
            BindingContext ctx = this.findBinding(method, request.path());
            if (ctx != null) {
                this.logger.info("MATCH: %s\n", ((BindingContext)ctx).binding.handler);
                this.parseParams(ctx, request);
                ((BindingContext)ctx).binding.handler.handle(this, request);
                return;
            }
            if (this.noMatchHandler != null) {
                this.noMatchHandler.handle(request);
            } else {
                request.response().setStatusCode(404).setStatusMessage("No handler found").end();
            }
        }
        catch (Throwable t) {
            this.logger.info("ERROR: %s", t.getMessage());
            t.printStackTrace();
            request.response().setStatusCode(500).setStatusMessage("Error occurred during processing. See logs for more information.").end();
        }
    }

    protected void parseParams(BindingContext ctx, HttpServerRequest request) {
        HashMap<String, String> params = new HashMap<String, String>(ctx.matcher.groupCount());
        if (((BindingContext)ctx).binding.paramNames != null) {
            int i = 1;
            for (String param : ((BindingContext)ctx).binding.paramNames) {
                String v = ctx.matcher.group(i);
                if (v != null) {
                    this.logger.info("PARAM %s = %s", param, v);
                    params.put(param, v);
                }
                ++i;
            }
        } else {
            for (int i = 0; i < ctx.matcher.groupCount(); ++i) {
                String v = ctx.matcher.group(i + 1);
                if (v == null) continue;
                this.logger.info("PARAM param%s = %s", i, v);
                params.put("param" + i, v);
            }
        }
        request.params().set(params);
    }

    protected BindingContext findBinding(Method method, String path) {
        List<PatternBinding> bindings = this.bindings.get((Object)method);
        if (bindings != null) {
            for (PatternBinding binding : bindings) {
                Matcher m = binding.pattern.matcher(path);
                if (!m.matches()) continue;
                return new BindingContext(m, binding);
            }
        }
        return null;
    }

    public void bind(RouteBinding handler) {
        Method method = handler.getMethod();
        String path = handler.getPath();
        List<PatternBinding> b = this.bindings.get((Object)method);
        if (b == null) {
            b = new ArrayList<PatternBinding>();
            this.bindings.put(method, b);
        }
        this.logger.info("ADD Method: %s, Pattern: %s, Route: %s\n", new Object[]{method, path, handler});
        this.addPattern(path, handler, b);
    }

    public void noMatch(Handler<HttpServerRequest> handler) {
        this.noMatchHandler = handler;
    }

    private void addPattern(String input, RouteBinding handler, List<PatternBinding> bindings) {
        Matcher m = Pattern.compile(":(\\??[A-Za-z][A-Za-z0-9_]*)(=\\([^)]+\\))?").matcher(input);
        StringBuffer sb = new StringBuffer();
        ArrayList<String> groups = new ArrayList<String>();
        while (m.find()) {
            String pattern;
            String group = m.group(1);
            boolean optional = false;
            if (group.startsWith("?")) {
                group = group.substring(1);
                optional = true;
            }
            pattern = (pattern = m.group(2)) == null ? PATH_SEG_PATTERN : pattern.substring(1);
            if (optional) {
                pattern = pattern + "?";
            }
            if (groups.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m.appendReplacement(sb, pattern);
            groups.add(group);
        }
        m.appendTail(sb);
        String regex = sb.toString();
        PatternBinding binding = new PatternBinding(Pattern.compile(regex), groups, handler);
        bindings.add(binding);
    }

    private static class PatternBinding {
        final Pattern pattern;
        final RouteBinding handler;
        final List<String> paramNames;

        private PatternBinding(Pattern pattern, List<String> paramNames, RouteBinding handler) {
            this.pattern = pattern;
            this.paramNames = paramNames;
            this.handler = handler;
        }

        public String toString() {
            return String.format("Binding [pattern: %s, params: %s, handler: %s]", this.pattern, this.paramNames, this.handler);
        }
    }

    static class BindingContext {
        private final Matcher matcher;
        private final PatternBinding binding;

        private BindingContext(Matcher matcher, PatternBinding binding) {
            this.matcher = matcher;
            this.binding = binding;
        }
    }
}

