/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.egit.github.core.Download;
import org.eclipse.egit.github.core.DownloadResource;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.util.MultiPartUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadService
extends GitHubService {
    public static final String UPLOAD_KEY = "key";
    public static final String UPLOAD_ACL = "acl";
    public static final String UPLOAD_SUCCESS_ACTION_STATUS = "success_action_status";
    public static final String UPLOAD_FILENAME = "Filename";
    public static final String UPLOAD_AWS_ACCESS_KEY_ID = "AWSAccessKeyId";
    public static final String UPLOAD_POLICY = "Policy";
    public static final String UPLOAD_SIGNATURE = "Signature";
    public static final String UPLOAD_FILE = "file";
    public static final String UPLOAD_CONTENT_TYPE = "Content-Type";

    public DownloadService() {
    }

    public DownloadService(GitHubClient client) {
        super(client);
    }

    public Download getDownload(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/downloads");
        uri.append('/').append(id);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)Download.class));
        return (Download)this.client.get(request).getBody();
    }

    protected PagedRequest<Download> createDownloadsRequest(IRepositoryIdProvider repository, int start, int size) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/downloads");
        PagedRequest<Download> request = this.createPagedRequest(start, size);
        request.setType(new TypeToken<List<Download>>(){}.getType());
        request.setUri(uri);
        return request;
    }

    public List<Download> getDownloads(IRepositoryIdProvider repository) throws IOException {
        return this.getAll(this.pageDownloads(repository));
    }

    public PageIterator<Download> pageDownloads(IRepositoryIdProvider repository) {
        return this.pageDownloads(repository, 100);
    }

    public PageIterator<Download> pageDownloads(IRepositoryIdProvider repository, int size) {
        return this.pageDownloads(repository, 1, size);
    }

    public PageIterator<Download> pageDownloads(IRepositoryIdProvider repository, int start, int size) {
        PagedRequest<Download> request = this.createDownloadsRequest(repository, start, size);
        return this.createPageIterator(request);
    }

    public void deleteDownload(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/downloads");
        uri.append('/').append(id);
        this.client.delete(uri.toString());
    }

    public DownloadResource createResource(IRepositoryIdProvider repository, Download download) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/downloads");
        return (DownloadResource)this.client.post(uri.toString(), download, (Type)((Object)DownloadResource.class));
    }

    public void uploadResource(DownloadResource resource, InputStream content, long size) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("Download resource cannot be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Content input stream cannot be null");
        }
        LinkedHashMap<String, Object> parts = new LinkedHashMap<String, Object>();
        parts.put(UPLOAD_KEY, resource.getPath());
        parts.put(UPLOAD_ACL, resource.getAcl());
        parts.put(UPLOAD_SUCCESS_ACTION_STATUS, Integer.toString(201));
        parts.put(UPLOAD_FILENAME, resource.getName());
        parts.put(UPLOAD_AWS_ACCESS_KEY_ID, resource.getAccesskeyid());
        parts.put(UPLOAD_POLICY, resource.getPolicy());
        parts.put(UPLOAD_SIGNATURE, resource.getSignature());
        parts.put(UPLOAD_CONTENT_TYPE, resource.getMimeType());
        parts.put(UPLOAD_FILE, content);
        HttpURLConnection connection = MultiPartUtils.post(resource.getS3Url(), parts);
        int status = connection.getResponseCode();
        if (status != 201) {
            throw new IOException("Unexpected response status of " + status);
        }
    }

    public DownloadResource createDownload(IRepositoryIdProvider repository, Download download, InputStream content, long size) throws IOException {
        DownloadResource resource = this.createResource(repository, download);
        this.uploadResource(resource, content, size);
        return resource;
    }

    public DownloadResource createDownload(IRepositoryIdProvider repository, Download download, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        return this.createDownload(repository, download, new FileInputStream(file), file.length());
    }
}

