/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.rest;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.commonjava.freeki.data.TemplateController;
import org.commonjava.freeki.data.TemplateException;
import org.commonjava.freeki.rest.PathParameter;
import org.commonjava.vertx.vabr.Method;
import org.commonjava.vertx.vabr.RouteHandler;
import org.commonjava.vertx.vabr.anno.Route;
import org.commonjava.vertx.vabr.anno.Routes;
import org.commonjava.web.json.model.Listing;
import org.commonjava.web.json.ser.JsonSerializer;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.http.HttpServerRequest;

public class TemplateContentHandler
implements RouteHandler {
    private final TemplateController controller;
    private final JsonSerializer serializer;

    public TemplateContentHandler(TemplateController controller, JsonSerializer serializer) {
        this.controller = controller;
        this.serializer = serializer;
    }

    @Routes(value={@Route(path="/templates", method=Method.GET)})
    public void list(HttpServerRequest req) throws Exception {
        List<String> labels = this.controller.getTemplateLabels();
        String json = this.serializer.toString(new Listing<String>((Collection<String>)labels));
        req.response().setStatusCode(200).putHeader("Content-Length", Integer.toString(json.length())).write(json).end();
    }

    @Routes(value={@Route(path="/templates/:template", method=Method.GET)})
    public void get(HttpServerRequest req) throws Exception {
        String template = req.params().get(PathParameter.TEMPLATE.param());
        File html = this.controller.getTemplateHtml(template);
        if (!html.exists()) {
            req.response().setStatusCode(404).setStatusMessage("Not Found").end();
        } else {
            req.response().setStatusCode(200).sendFile(html.getAbsolutePath());
        }
    }

    @Routes(value={@Route(path="/templates/:template", method=Method.POST)})
    public void post(final HttpServerRequest req) throws Exception {
        req.expectMultiPart(true);
        req.endHandler(new VoidHandler(){

            @Override
            protected void handle() {
                String key;
                String template = req.params().get(PathParameter.TEMPLATE.param());
                HashMap<String, String> params = new HashMap<String, String>();
                for (Map.Entry entry : req.params()) {
                    key = (String)entry.getKey();
                    if (params.containsKey(key)) continue;
                    params.put(key, (String)entry.getValue());
                }
                for (Map.Entry entry : req.formAttributes()) {
                    key = (String)entry.getKey();
                    if (params.containsKey(key)) continue;
                    params.put(key, (String)entry.getValue());
                }
                try {
                    String location = TemplateContentHandler.this.controller.runTemplateAction(template, params);
                    if (location == null) {
                        req.response().setStatusCode(200).setStatusMessage("OK").end();
                    } else {
                        req.response().setStatusCode(302).putHeader("Location", location).end();
                    }
                }
                catch (TemplateException e) {
                    req.response().setStatusCode(500).setStatusMessage(e.getMessage()).end();
                }
            }
        });
    }
}

