/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.data;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.commonjava.freeki.conf.FreekiConfig;
import org.commonjava.freeki.data.GitManager;
import org.commonjava.freeki.model.ChildRef;
import org.commonjava.freeki.model.Group;
import org.commonjava.freeki.model.Page;
import org.commonjava.util.logging.Logger;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotLane;

public class FreekiStore {
    private static final CharSequence README = "This is a marker file for a freeki content group. You can add pages to this group through the UI.";
    private static final String COMMENT_BEGIN = "<!--";
    private static final String COMMENT_END = "-->";
    private static final String MD_TITLE = "TITLE";
    private static final String METADATA_WARNING = "Freeki metadata. Do not remove this section!";
    private static final String H1 = "# ";
    private static final String H1_ALT = "#";
    private static final String MD_CONTENT = "CONTENT";
    private final Logger logger = new Logger(this.getClass());
    private final FreekiConfig config;
    private final GitManager git;

    public FreekiStore(FreekiConfig config, GitManager git) throws IOException {
        this.config = config;
        this.git = git;
    }

    public boolean hasGroup(String group) {
        File root = this.config.getContentDir();
        File d = new File(root, group);
        return d.isDirectory();
    }

    public boolean hasPage(String group, String title) {
        File file = this.getFileByTitle(group, title);
        return file.isFile();
    }

    public SortedSet<ChildRef> listPages(String group) {
        SortedSet<ChildRef> refs = this.listChildren(group);
        Iterator it = refs.iterator();
        while (it.hasNext()) {
            ChildRef ref = (ChildRef)it.next();
            if (ChildRef.ChildType.GROUP != ref.getType()) continue;
            it.remove();
        }
        return refs;
    }

    public SortedSet<ChildRef> listChildren(String group) {
        File root = this.config.getContentDir();
        File d = new File(root, group);
        TreeSet<ChildRef> result = new TreeSet<ChildRef>();
        if (d.isDirectory()) {
            File[] files;
            for (File file : files = d.listFiles(new ValidChildrenFilenameFilter())) {
                String name = file.getName();
                if (name.startsWith(".")) continue;
                if (file.isDirectory()) {
                    result.add(new ChildRef(ChildRef.ChildType.GROUP, name, name));
                    continue;
                }
                try {
                    String fname = file.getName();
                    fname = fname.substring(0, fname.length() - 3);
                    String content = FileUtils.readFileToString(file);
                    Map<String, String> metadata = this.getMetadata(content, false);
                    String title = metadata.get(MD_TITLE);
                    if (title == null) {
                        title = fname;
                    }
                    result.add(new ChildRef(ChildRef.ChildType.PAGE, title, fname));
                }
                catch (Exception e) {
                    this.logger.error("Cannot read: '%s'. Reason: %s", e, file, e.getMessage());
                }
            }
        }
        return result;
    }

    public boolean storeGroup(Group group) throws IOException {
        File groupDir = this.getFile(group.getName());
        if (!groupDir.exists()) {
            groupDir.mkdirs();
            File readme = new File(groupDir, "README.txt");
            FileUtils.write(readme, README);
            this.git.addAndCommit("Adding new group: " + group.getName(), readme);
            return true;
        }
        return false;
    }

    public boolean storePage(Page page) throws IOException {
        File pageFile = this.getFile(page.getId() + ".md");
        File dir = pageFile.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory structure for page: " + dir.getAbsolutePath());
        }
        boolean update = pageFile.exists();
        if (page.getTitle() == null) {
            Map<String, String> existingMeta = page.getMetadata();
            Map<String, String> parsed = this.getMetadata(page.getContent(), false);
            parsed.putAll(existingMeta);
            page.setMetadata(parsed);
            page.setTitle(parsed.get(MD_TITLE));
        }
        String content = page.getContent();
        Map<String, String> meta = page.getMetadata();
        if (meta.get(MD_TITLE) == null) {
            meta.put(MD_TITLE, page.getTitle());
        }
        if (meta != null && !meta.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(COMMENT_BEGIN).append(" ").append(METADATA_WARNING);
            for (Map.Entry<String, String> entry : meta.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                sb.append('\n').append(key).append(": ").append(value);
            }
            sb.append('\n').append(COMMENT_END);
            sb.append('\n').append(content);
            content = sb.toString();
        }
        FileUtils.write(pageFile, content);
        this.git.addAndCommit((update ? "Updating: " : "Creating: ") + page.getTitle(), pageFile);
        return !update;
    }

    private File getFile(String id) {
        return this.getFileById(id, null);
    }

    private File getFileByTitle(String group, String title) {
        return this.getFileById(title == null ? group : Page.serverPathFor(group, title), null);
    }

    private File getFileById(String group, String id) {
        File root = this.config.getContentDir();
        File groupDir = group == null || group.length() < 1 || group.equals("/") ? root : new File(root, group);
        return id == null ? groupDir : new File(groupDir, id + ".md");
    }

    public Page getPage(String group, String id) throws IOException {
        PlotCommit<PlotLane> commit;
        File file = this.getFileById(group, id);
        if (!file.exists()) {
            return null;
        }
        String content = FileUtils.readFileToString(file);
        try {
            commit = this.git.getHeadCommit(file);
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed to read commit information for: %s. Reason: %s", file, e.getMessage()), e);
        }
        Map<String, String> metadata = this.getMetadata(content, true);
        content = metadata.remove(MD_CONTENT);
        String title = metadata.get(MD_TITLE);
        PersonIdent ai = commit.getAuthorIdent();
        return new Page(group, id, content, title, ai.getWhen().getTime(), ai.getName());
    }

    private Map<String, String> getMetadata(String content, boolean reformatContent) {
        LineIterator li = new LineIterator(new StringReader(content));
        HashMap<String, String> metadata = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        boolean startMetadata = false;
        boolean stopMetadata = false;
        boolean startContent = false;
        while (li.hasNext()) {
            String line = li.next();
            if (line.trim().startsWith(COMMENT_BEGIN)) {
                startMetadata = true;
            } else if (line.trim().endsWith(COMMENT_END)) {
                stopMetadata = true;
            } else if (startMetadata && !stopMetadata) {
                String[] parts = line.trim().split("\\s*:\\s*");
                if (parts.length == 2) {
                    metadata.put(parts[0], parts[1]);
                }
            } else if (stopMetadata && !startContent && line.trim().length() > 0) {
                startContent = true;
            }
            if (!startContent) continue;
            String title = (String)metadata.get(MD_TITLE);
            if (title == null && line.startsWith(H1)) {
                title = line.substring(H1.length());
                metadata.put(MD_TITLE, title);
            } else if (title == null && line.startsWith(H1_ALT) && !(title = line.substring(H1_ALT.length())).startsWith(H1_ALT)) {
                metadata.put(MD_TITLE, title);
            }
            if (!reformatContent && title != null) break;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(line);
        }
        if (sb.length() > 0) {
            metadata.put(MD_CONTENT, sb.toString());
        } else {
            metadata.put(MD_CONTENT, content);
        }
        return metadata;
    }

    public boolean deleteGroup(String group) throws IOException {
        return this.doDelete(group, null);
    }

    public boolean deletePage(String group, String id) throws IOException {
        return this.doDelete(group, id);
    }

    private boolean doDelete(String group, String id) throws IOException {
        File file = this.getFileById(group, id);
        if (file == null) {
            file = new File(this.config.getContentDir(), group);
        }
        HashSet<File> deleted = new HashSet<File>();
        if (file.isDirectory()) {
            FileUtils.forceDelete(file);
            deleted.add(file);
            file = file.getParentFile();
        } else if (file.exists()) {
            file.delete();
            deleted.add(file);
            file = file.getParentFile();
        }
        while (file.isDirectory() && !this.config.getContentDir().equals(file) && file.list().length < 1) {
            file.delete();
            deleted.add(file);
            file = file.getParentFile();
        }
        if (!deleted.isEmpty()) {
            this.git.deleteAndCommit("Removing page: " + id + " from group: " + group + ", and pruning empty directories.", deleted);
            return true;
        }
        return false;
    }

    public SortedSet<Group> listGroups(String subgroup) throws IOException {
        File root;
        File dir = root = this.config.getContentDir();
        if (subgroup != null) {
            dir = new File(dir, subgroup);
        }
        String[] names = dir.isDirectory() ? dir.list() : new String[]{};
        TreeSet<Group> groups = new TreeSet<Group>();
        for (String name : names) {
            File f = new File(dir, name);
            if (!f.isDirectory()) continue;
            String groupName = Group.nameFor(subgroup, name);
            SortedSet<ChildRef> pages = this.listChildren(groupName);
            groups.add(new Group(groupName, pages));
        }
        return groups;
    }

    public Group getGroup(String groupName) throws IOException {
        if (groupName == null || groupName.trim().length() < 1) {
            return null;
        }
        File groupDir = new File(this.config.getContentDir(), groupName);
        if (!groupDir.isDirectory()) {
            return null;
        }
        SortedSet<ChildRef> pages = this.listChildren(groupName);
        return new Group(groupName, pages);
    }

    public class ValidChildrenFilenameFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".md") || new File(dir, name).isDirectory();
        }
    }
}

