/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.util;

import java.io.File;

public final class PathUtils {
    private PathUtils() {
    }

    public static String buildPath(String basePath, String ... parts) {
        if (parts == null || parts.length < 1) {
            return basePath;
        }
        StringBuilder builder = new StringBuilder();
        if (!(basePath == null || basePath.length() <= 0 || "/".equals(basePath) || parts[0] != null && parts[0].startsWith(basePath))) {
            builder.append(basePath);
        }
        for (String part : parts) {
            if (part == null || part.trim().length() < 1) continue;
            if (part.startsWith(File.separator)) {
                part = part.substring(1);
            }
            if (builder.length() > 0 && builder.charAt(builder.length() - 1) != File.separatorChar) {
                builder.append(File.separator);
            }
            builder.append(part);
        }
        return builder.toString();
    }
}

