/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl.resolver;

import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.platform.impl.ModuleIdentifier;
import org.vertx.java.platform.impl.resolver.HttpResolution;

public class MavenResolution
extends HttpResolution {
    protected String contentRoot;
    protected ModuleIdentifier moduleIdentifier;
    protected String uriRoot;

    public MavenResolution(Vertx vertx, String repoHost, int repoPort, ModuleIdentifier moduleIdentifier, String filename, String contentRoot) {
        super(vertx, repoHost, repoPort, moduleIdentifier, filename);
        this.contentRoot = contentRoot;
        this.moduleIdentifier = moduleIdentifier;
        this.uriRoot = MavenResolution.getMavenURI(moduleIdentifier);
    }

    private void addOKHandler() {
        this.addHandler(200, new Handler<HttpClientResponse>(){

            @Override
            public void handle(HttpClientResponse resp) {
                MavenResolution.this.downloadToFile(MavenResolution.this.filename, resp);
            }
        });
    }

    @Override
    protected void getModule() {
        this.createClient(this.repoHost, this.repoPort);
        if (this.moduleIdentifier.getVersion().endsWith("-SNAPSHOT")) {
            this.addHandler(200, new Handler<HttpClientResponse>(){

                @Override
                public void handle(HttpClientResponse resp) {
                    resp.bodyHandler(new Handler<Buffer>(){

                        @Override
                        public void handle(Buffer metaData) {
                            final String data = metaData.toString();
                            String actualURI = MavenResolution.getResourceName(data, MavenResolution.this.contentRoot, MavenResolution.this.moduleIdentifier, MavenResolution.this.uriRoot, true);
                            MavenResolution.this.addOKHandler();
                            MavenResolution.this.addHandler(404, new Handler<HttpClientResponse>(){

                                @Override
                                public void handle(HttpClientResponse resp) {
                                    MavenResolution.this.addOKHandler();
                                    MavenResolution.this.removeHandler(404);
                                    String actualURI = MavenResolution.getResourceName(data, MavenResolution.this.contentRoot, MavenResolution.this.moduleIdentifier, MavenResolution.this.uriRoot, false);
                                    MavenResolution.this.makeRequest(MavenResolution.this.repoHost, MavenResolution.this.repoPort, actualURI);
                                }
                            });
                            MavenResolution.this.makeRequest(MavenResolution.this.repoHost, MavenResolution.this.repoPort, actualURI);
                        }
                    });
                }
            });
            this.addHandler(404, new Handler<HttpClientResponse>(){

                @Override
                public void handle(HttpClientResponse resp) {
                    MavenResolution.this.attemptDirectDownload();
                }
            });
            this.makeRequest(this.repoHost, this.repoPort, this.contentRoot + '/' + this.uriRoot + "maven-metadata.xml");
        } else {
            this.attemptDirectDownload();
        }
    }

    protected void attemptDirectDownload() {
        this.addOKHandler();
        this.addHandler(404, new Handler<HttpClientResponse>(){

            @Override
            public void handle(HttpClientResponse resp) {
                MavenResolution.this.addOKHandler();
                MavenResolution.this.removeHandler(404);
                MavenResolution.this.makeRequest(MavenResolution.this.repoHost, MavenResolution.this.repoPort, MavenResolution.getNonVersionedResourceName(MavenResolution.this.contentRoot, MavenResolution.this.moduleIdentifier, MavenResolution.this.uriRoot, false));
            }
        });
        this.makeRequest(this.repoHost, this.repoPort, MavenResolution.getNonVersionedResourceName(this.contentRoot, this.moduleIdentifier, this.uriRoot, true));
    }

    static String getResourceName(String data, String contentRoot, ModuleIdentifier identifier, String uriRoot, boolean modSuffix) {
        int pos2;
        int pos = data.indexOf("<snapshot>");
        String actualURI = null;
        if (pos != -1 && (pos2 = data.indexOf("<timestamp>", pos)) != -1) {
            String timestamp = data.substring(pos2 + 11, pos2 + 26);
            int pos3 = data.indexOf("<buildNumber>", pos);
            int pos4 = data.indexOf(60, pos3 + 12);
            String buildNumber = data.substring(pos3 + 13, pos4);
            actualURI = contentRoot + '/' + uriRoot + identifier.getName() + '-' + identifier.getVersion().substring(0, identifier.getVersion().length() - 9) + '-' + timestamp + '-' + buildNumber + (modSuffix ? "" : "-mod") + ".zip";
        }
        if (actualURI == null) {
            actualURI = MavenResolution.getNonVersionedResourceName(contentRoot, identifier, uriRoot, modSuffix);
        }
        return actualURI;
    }

    static String getMavenURI(ModuleIdentifier moduleIdentifier) {
        String[] groupParts;
        StringBuilder uri = new StringBuilder(47);
        for (String groupPart : groupParts = moduleIdentifier.getOwner().split("\\.")) {
            uri.append(groupPart).append('/');
        }
        uri.append(moduleIdentifier.getName()).append('/').append(moduleIdentifier.getVersion()).append('/');
        return uri.toString();
    }

    private static String getNonVersionedResourceName(String contentRoot, ModuleIdentifier identifier, String uriRoot, boolean modSuffix) {
        return contentRoot + '/' + uriRoot + identifier.getName() + '-' + identifier.getVersion() + (modSuffix ? "-mod" : "") + ".zip";
    }
}

